/*****************************************************************************/
/*                                                                           */
/*                           OCO SOURCE MATERIALS                            */
/*                             IBM CONFIDENTIAL                              */
/*                                    OR                                     */
/*                        IBM CONFIDENTIAL RESTRICTED                        */
/*            WHEN COMBINED WITH THE AGGREGATED OCO SOURCE MODULES           */
/*                           FOR THIS PROGRAM PRODUCT                        */
/*                                                                           */
/*    5622-585 VisualAge Generator Workgroup Services for OS/2 V2.2          */
/*    5622-587 VisualAge Generator Workgroup Services for AIX V2.2           */
/*    5639-A26 VisualAge Generator Workgroup Services for Windows NT V2.2    */
/*                     (C) COPYRIGHT IBM CORP. 1994,1996                     */
/*                                                                           */
/*****************************************************************************/
#ifndef FCWMSG_H
#  define FCWMSG_H

/*-------------------------------------------------------------------------*/
/*  Define the maximum message text length and number of inserts.          */
/*  Win32 does not seem to have any limits, so we will use OS/2's values.  */
/*-------------------------------------------------------------------------*/
const MSG_MAX_LENGTH = 256;
const MSG_MAX_INSERTS = 9;

/*-------------------------------------------------------------------------*/
/*  Refer to OS/2 CICS applicatin ELAERRA for operation requirement.       */
/*  The following structure maps directly to working storage, EZE7.        */
/*-------------------------------------------------------------------------*/
struct SCREENDATA {
     short      buffer_size;
     char       trans_id[8];
     short      err_count;
     char       nls_code[3];
     char       screen_size;
     char       last_err_pgm[8];
     char       last_err_date[13];
     char       last_err_time[11];
     char       cont_msg[78];
     char       exit_msg[78];
     struct
     {
       char     err_msg_prefix[9];
       char     err_msg_text[69];
     } err_msg [100];
} ;



/*-------------------------------------------------------------------------*/
/*  MsgBlock class...                                                      */
/*-------------------------------------------------------------------------*/
class MsgBlock {
  private:
    char                  msgBuf[MSG_MAX_LENGTH+2];
    unsigned long         msgLength;

    static SCREENDATA*    pScreenData;
    static short          Msg_count;

    int                   diagnosticFlag;
    char*                 errorFile;
    char*                 errorFunction;
    long                  errorLine;

    long                  msgNum;
    long                  numInserts;
    char*                 inserts[MSG_MAX_INSERTS];

    char*                 GetSpecialMessage();
    void                  AddMsgToErrScreen( char* pMsg );
    char*                 GetMessage();

    void*                 pImpData;

  public:
                          MsgBlock();
                          MsgBlock(MsgBlock const &);
                          ~MsgBlock();

    MsgBlock&             DisplayMessage();
    MsgBlock&             DisplayMessage( const long, Bool, ... );
    MsgBlock&             DisplayMessageToScreen();
    MsgBlock&             DisplayCSOMessage();
    MsgBlock&             SetDisplayMessage( const long, ... );

    void                  SetErrorFile( char* );
    void                  SetErrorLine( const long );
    void                  SetErrorFunction( char* );
    void                  SetDiagnostic();
    int                   DiagnosticOn();
    char*                 GetMsgText();
    char*                 GetScreenData() const;
    long                  GetMsgNum() const;
    void                  SetMsgNum( const long );
    void                  SetNumInserts( const long );
    void                  SetInserts( const int, char* );
};

#endif
