/*****************************************************************************/
/*                                                                           */
/*                           OCO SOURCE MATERIALS                            */
/*                             IBM CONFIDENTIAL                              */
/*                                    OR                                     */
/*                        IBM CONFIDENTIAL RESTRICTED                        */
/*            WHEN COMBINED WITH THE AGGREGATED OCO SOURCE MODULES           */
/*                           FOR THIS PROGRAM PRODUCT                        */
/*                                                                           */
/*    5622-585 VisualAge Generator Workgroup Services for OS/2 V2.2          */
/*    5622-587 VisualAge Generator Workgroup Services for AIX V2.2           */
/*    5639-A26 VisualAge Generator Workgroup Services for Windows NT V2.2    */
/*                     (C) COPYRIGHT IBM CORP. 1994,1996                     */
/*                                                                           */
/*****************************************************************************/
#ifndef FCWMAP_H
#define FCWMAP_H

#include <stdlib.h>
#include <string.h>
#include <memory.h>
#include <stdarg.h>
#include <stdio.h>

#define MAPPASSEDSAME 0
#define MAPPASSEDDIFF 1
#define NOMAPPASSED   2

//----------------------------------------------------------------------------
//  Declare forward references                                               -
//----------------------------------------------------------------------------
class FCWApp;
class iMap;
class quadnum;

//----------------------------------------------------------------------------
//  Map class definition...                                                  -
//----------------------------------------------------------------------------

class Map : public Parameter
{
   friend class MAPCHA;
   friend class MAPNUM;
   friend class MAPMIX;
   friend class MAPDBCS;

   private:
      iMap*             piMap;
      void*             pData;

   protected:

                        Map(char*, long);
      virtual           ~Map();
      FCWApp*           pApp();

   public:

      void              Setup(void* b=NULL);

      //-----------------------------------------------------------------------
      // SET statement functions                                              -
      //-----------------------------------------------------------------------
      void              SetClear();
      void              SetEmpty();
      void              SetAlarm();
      void              SetPage();

      //-----------------------------------------------------------------------
      // Process option functions                                             -
      //-----------------------------------------------------------------------
      void              Display();
      void              Converse();
      void              Close();

      //-----------------------------------------------------------------------
      // TEST functions                                                       -
      //-----------------------------------------------------------------------
      Bool              IsModified();
      Bool              TestModified();

      //-----------------------------------------------------------------------
      // other                                                                -
      //-----------------------------------------------------------------------
      virtual void      StatementGroupEdits() {};

      long              ParmSize();
      char*             ParmData();
      void              VerifyAndRetrieveFirstMap();
      FCWString const&  Name();

      // For RPC
      int&              fNumberOfRPCEntries();
      LIST(RPCParm*)&   RPCList();
      void              SetupRpc();
};

//----------------------------------------------------------------------------
//  Map item types...                                                        -
//----------------------------------------------------------------------------

class  iMapItem;                       /* forward reference                */

class MapItem
{
   public:

      // SET map-item methods
      void SetCursor()                          const;
      void SetNormal()                          const;
      void SetDefined()                         const;
      void SetAttribute( Color::enum_Color )    const;
      void SetAttribute( Hilite::enum_Hilite )  const;
      void SetAttribute( unsigned char )        const;

      // TEST map-item methods
      Bool HasCursor()                          const;
      Bool IsBlank()                            const;
      Bool IsNull()                             const;
      Bool HasData()                            const;
      Bool IsModified()                         const;
      Bool TestModified()                       const;
      int  InputLength()                        const;

      // others
      MapItem operator[] (quadnum)              const;

      MapItem(iMap* p, int occ, int off, int len);
      MapItem(MapItem const& mi, int index);
      virtual ~MapItem();

   protected:
      void               SetEmpty()             const;
      void               SetClear()             const;
      void               SetSelected()          const;

   private:
      iMapItem*          piMapItem;
      void*              pData;
};

inline Bool MapItem :: IsBlank()    const
{
   return (!InputLength());
}

inline Bool MapItem :: IsNull()     const
{
   return (!InputLength());
}

inline Bool MapItem :: HasData()    const
{
   return (InputLength() != 0);
}

//---------------------------------------------------------------------------
//  MAPCHA                                                                  -
//---------------------------------------------------------------------------

class MAPCHA : public CHA, public MapItem
{
  public:
    MAPCHA (Map& p, int occ, int off, int len);
    MAPCHA (const MAPCHA& mc, int index);
    virtual ~MAPCHA();

    MAPCHA operator[] (quadnum) const;

    virtual void SetEmpty() const;
    virtual void SetClear();
    Bool IsBlank();

    void operator = (const CHA& v);
    void operator = (const MAPCHA& v);
    void operator = (const HEX& v);
    void operator = (const MIX& v);
    void operator = (const NUM& v);
    void operator = (const char *v);
    void operator = (const quadnum& v );
    void operator = (const int v );

  private:
    void*     pData;
};

inline void MAPCHA :: SetEmpty () const
{
   CHA :: SetEmpty();
   MapItem :: SetEmpty();
}

inline void MAPCHA :: SetClear()
{
   SetEmpty();
   MapItem :: SetClear();
}

inline void MAPCHA :: operator = (const CHA& v)
{
   SetSelected();
   CHA :: operator  = (v);
}

inline void MAPCHA :: operator = (const MAPCHA& v)
{
   SetSelected();
   CHA :: operator  = (v);
}

inline void MAPCHA :: operator = (const HEX& v)
{
   SetSelected();
   CHA :: operator  = (v);
}

inline void MAPCHA :: operator = (const MIX& v)
{
   SetSelected();
   CHA :: operator  = (v);
}

inline void MAPCHA :: operator = (const NUM& v)
{
   SetSelected();
   CHA :: operator  = (v);
}

inline void MAPCHA :: operator = (const char *v)
{
   SetSelected();
   CHA :: operator  = (v);
}

inline void MAPCHA :: operator = (const quadnum& v )
{
   SetSelected();
   CHA :: operator  = (v);
}

inline void MAPCHA :: operator = (const int v )
{
   *this = quadnum(v);
}

inline Bool MAPCHA :: IsBlank()
{
   return MapItem :: IsBlank();
}

//---------------------------------------------------------------------------
// MAPNUM                                                                   -
//---------------------------------------------------------------------------

class MAPNUM : public NUM, public MapItem
{
  public:

    MAPNUM (Map& p, int occ, int off, int len, int dec=0);
    MAPNUM (const MAPNUM& mn, int index);
    virtual ~MAPNUM();

    virtual void SetEmpty() const;
    virtual void SetClear();

    MAPNUM operator [] (quadnum) const;

    void operator = (const NUM&);
    void operator = (const MAPNUM& v);
    void operator <<= (const NUM&);
    void operator = (const CHA& v);
    void operator = (const quadnum& v);
    void operator <<= (const quadnum& v);

  private:
    void*     pData;
};

inline void MAPNUM :: SetEmpty () const
{
   NUM :: SetEmpty();
   MapItem :: SetEmpty();
}

inline void MAPNUM :: SetClear()
{
   SetEmpty();
   MapItem :: SetClear();
}

inline void MAPNUM :: operator = (const NUM& v)
{
   SetSelected();
   NUM :: operator = ( v );
}

inline void MAPNUM :: operator = (const MAPNUM& v)
{
   SetSelected();
   NUM :: operator = ( v );
}

inline void MAPNUM :: operator <<= (const NUM& v)
{
   SetSelected();
   NUM :: operator <<= ( v );
}

inline void MAPNUM :: operator = (const CHA& v)
{
   SetSelected();
   NUM :: operator = ( v );
}

inline void MAPNUM :: operator = (const quadnum& v)
{
   SetSelected();
   NUM :: operator = ( v );
}

inline void MAPNUM :: operator <<= (const quadnum& v)
{
   SetSelected();
   NUM :: operator <<= ( v );
}

//---------------------------------------------------------------------------
// MAPMIX                                                                   -
//---------------------------------------------------------------------------

class MAPMIX : public MIX, public MapItem
{
  public:

    MAPMIX (Map& p, int occ, int off, int len);
    MAPMIX (const MAPMIX& mn, int index);
    virtual ~MAPMIX();

    virtual void SetEmpty() const;
    virtual void SetClear();

    MAPMIX operator [] (quadnum) const;

    void operator = (const MIX& v);
    void operator = (const MAPMIX& v);
    void operator = (const CHA& v);
    void operator = (const char *v);
    Bool IsBlank();

  private:
    void*     pData;
};

inline void MAPMIX :: SetEmpty () const
{
   MIX :: SetEmpty();
   MapItem :: SetEmpty();
}

inline void MAPMIX :: SetClear()
{
   SetEmpty();
   MapItem :: SetClear();
}

inline void MAPMIX :: operator = (const MIX& v)
{
   SetSelected();
   MIX :: operator = ( v );
}

inline void MAPMIX :: operator = (const MAPMIX& v)
{
   SetSelected();
   MIX :: operator = ( v );
}

inline void MAPMIX :: operator = (const CHA& v)
{
   SetSelected();
   MIX :: operator = ( v );
}

inline void MAPMIX :: operator = (const char *v)
{
   SetSelected();
   MIX :: operator = ( v );
}


inline Bool MAPMIX :: IsBlank ()
{
   return ( MapItem :: IsBlank() );
}


//---------------------------------------------------------------------------
// MAPDBCS                                                                  -
//---------------------------------------------------------------------------

class MAPDBCS : public DBCS, public MapItem
{
  public:

    MAPDBCS (Map& p, int occ, int off, int len);
    MAPDBCS (const MAPDBCS& mn, int index);
    virtual ~MAPDBCS();

    virtual void SetEmpty() const;
    virtual void SetClear();

    MAPDBCS operator [] (quadnum) const;

    void operator = (const DBCS& v);
    void operator = (const MAPDBCS& v);
    void operator = (const char *v);

    Bool IsBlank();

  private:
    void*     pData;
};

inline void MAPDBCS :: SetEmpty () const
{
   DBCS :: SetEmpty();
   MapItem :: SetEmpty();
}

inline void MAPDBCS :: SetClear()
{
   SetEmpty();
   MapItem :: SetClear();
}

inline void MAPDBCS :: operator = (const DBCS& v)
{
   SetSelected();
   DBCS :: operator = ( v );
}

inline void MAPDBCS :: operator = (const MAPDBCS& v)
{
   SetSelected();
   DBCS :: operator = ( v );
}

inline void MAPDBCS :: operator = (const char *v)
{
   SetSelected();
   DBCS :: operator = ( v );
}


inline Bool MAPDBCS :: IsBlank ()
{
   return ( MapItem :: IsBlank() );
}

#endif
