/*****************************************************************************/
/*                                                                           */
/*                           OCO SOURCE MATERIALS                            */
/*                             IBM CONFIDENTIAL                              */
/*                                    OR                                     */
/*                        IBM CONFIDENTIAL RESTRICTED                        */
/*            WHEN COMBINED WITH THE AGGREGATED OCO SOURCE MODULES           */
/*                           FOR THIS PROGRAM PRODUCT                        */
/*                                                                           */
/*    5622-585 VisualAge Generator Workgroup Services for OS/2 V2.2          */
/*    5622-587 VisualAge Generator Workgroup Services for AIX V2.2           */
/*    5639-A26 VisualAge Generator Workgroup Services for Windows NT V2.2    */
/*                     (C) COPYRIGHT IBM CORP. 1994,1996                     */
/*                                                                           */
/*****************************************************************************/
#ifndef FCWIO_H
#define FCWIO_H
//
// interface between FCW class library and file I/O class libraries
//

#include "cso2api.h"

#define statusOK   0x0000
#define statusEOF  0x0001
#define statusNRF  0x0002
#define statusLOK  0x0004
#define statusDUP  0x0008
#define statusUNQ  0x0010

#define statusFUL  0x0100
#define statusFMT  0x0200
#define statusFNF  0x0400
#define statusFNA  0x0800

#define statusERR  0xffff
#define statusHRD  (statusFUL | statusFMT | statusFNF | statusFNA)

// Forward references

class File;

// File IO Driver interface object

struct FileIODriver
{
  char name[30];

  void (*pInit)          (File&);
  void (*pDeInit)        (File&);

  void (*pClose)         (File&);
  void (*pCommit)        (File&);
  void (*pDelete)        (File&);
  void (*pOpenRead)      (File&);
  void (*pOpenReadWrite) (File&);
  void (*pOpenWrite)     (File&);
  void (*pRead)          (File&);
  void (*pReadNext)      (File&);
  void (*pReadPrev)      (File&);
  void (*pReplace)       (File&);
  void (*pRollBack)      (File&);
  void (*pSetScan)       (File&);
  void (*pUpdate)        (File&);
  void (*pWrite)         (File&);
};

struct FCWCallBlock;
struct FCWCallRPCBlock;

// RPC Driver interface object
class RPCDriver
{
public:
  RPCDriver() {};
  ~RPCDriver() {CloseRPC();};
  char name[32];

  long (*InitRPC)   ();
  long (*CloseRPC)  ();
  long (*CommitRPC) ();
  long (*AbortRPC)  ();
  long (*CallRPC)   (char *, CMCOD *, FCWCallBlock *, FCWCallRPCBlock *, int, char *,
                     char *);
  long (*ConvRPC)   (CMCVOD *, FCWCallBlock *, FCWCallRPCBlock *);
};

#endif
