/*****************************************************************************/
/*                                                                           */
/*                           OCO SOURCE MATERIALS                            */
/*                             IBM CONFIDENTIAL                              */
/*                                    OR                                     */
/*                        IBM CONFIDENTIAL RESTRICTED                        */
/*            WHEN COMBINED WITH THE AGGREGATED OCO SOURCE MODULES           */
/*                           FOR THIS PROGRAM PRODUCT                        */
/*                                                                           */
/*    5622-585 VisualAge Generator Workgroup Services for OS/2 V2.2          */
/*    5622-587 VisualAge Generator Workgroup Services for AIX V2.2           */
/*    5639-A26 VisualAge Generator Workgroup Services for Windows NT V2.2    */
/*                     (C) COPYRIGHT IBM CORP. 1994,1996                     */
/*                                                                           */
/*****************************************************************************/
#ifndef FCWFILE_H
#define FCWFILE_H

#define optReplace 0x0001
#define optAltIndx 0x0002
#define optDup     0x0004
#define optKeys    0x0008
#define optNoFF    0x0010
#define optText    0x0020

enum state { closed, openread, openwrite, openreadwrite };
enum orgType { serial='s', relative='r', indexed='i' };
enum format { fixed='f', variable='v' };
enum accMode { rw, ro };
enum shrMode { drw, dw, dr, dn };
enum fileOp {opClose, opCommit, opDelete, opFind, opOpen, opReadNext,
             opReadPrev, opReplace, opRollBack, opSetScan, opUpdate, opWrite};
enum CloseMode { logical, physical };                                 // V2.x

class FileDef;                        // forward reference

/*---------------------------------------------------------------------------*/
/* Base file class                                                           */
/*---------------------------------------------------------------------------*/

class File
{
  protected:

    FCWString fileName;                // Physical filename
    int useCount;                      // use count
    long recLength;                    // record length
    long bytesRead;                    // number of bytes read
    unsigned int status;               // file status/return code
    state fileState;                   // closed, openread, openwrite
    fileOp lastOp;                     // last I/O operation performed
    format recFormat;                  // record format (fixed, variable)
    char* ezeRT8;                      // EZERT8 value
    CloseMode closeMode;               // logical or physical close   *V2.x

  public:

    File(const FCWString&, int, format, const FCWString&, FileDef*);
    ~File();

    char * buffer;                     // Pointer to I/O buffer
    void * fileData;                   // Driver supplied block
    FileIODriver* pFD;                 // Pointer to File I/O Driver block
    FileDef* pFileDef;                 // FileDef object pointer

    void SetCloseMode( CloseMode m );                             // V2.x
    CloseMode GetCloseMode();                                     // V2.x

    void Get();
    int  GetUseCount();
    void Release();

    state GetFileState();
    void SetFileState(state f);

    format GetRecFormat();
    void SetRecFormat(format rf);

    FCWString& GetFileName();
    void SetFileName(const FCWString& n);

    long GetRecLength();
    void SetRecLength(int r);

    int  GetStatus();
    void SetStatus(int i);
    void ClrStatus();

    fileOp GetLastOp();
    void   SetLastOp(fileOp o);

    void SetRT8(char* rt8);
    char* GetRT8();

    long GetBytesRead();
    void SetBytesRead(long br);

    virtual int  GetKeyOffSet() {return 0;}
    virtual int  GetKeyLength() {return 0;}

    virtual long GetRelRecNum() {return 0;}
    virtual void SetRelRecNum( long rn ) {}

    virtual void SetKeyOffSet(int) {}
    virtual void SetKeyLength(int) {}
    virtual orgType GetOrg() = 0;

    int Err();
    int Hrd();
    int Eof();
    int Nrf();
    int Lok();
    int Dup();
    int Unq();
    int Ful();
    int Fmt();
    int Fnf();
    int Fna();
    int Ded();

    void Close();
    virtual void Commit();
    virtual void Delete(char*, int, int = 0, int = 0) {}
    virtual void Find(char*, int, int, int= 0) {}
    virtual void ReadNext(char*, int, int = 0, int = 0) = 0;
    virtual void ReadPrev(char*, int, int = 0, int = 0) {}
    virtual void Replace(char*, int, int = 0, int = 0) {}
    virtual void RollBack();
    virtual void SetScan(char*, int, int, int) {}
    virtual void Update(char*, int, int, int = 0) {}
    virtual void Write(char*, int, int = 0, int = 0) {}

    void EZEDEST(char* n);
    char* EZEDEST();
};

/*---------------------------------------------------------------------------*/
/* Serial file class                                                         */
/*---------------------------------------------------------------------------*/

class SerialFile : public File
{
  private:

  public:
    SerialFile(const FCWString& n, int rl, format rf,
               const FCWString& dn, FileDef* pfd) :
         File(n, rl, rf, dn, pfd) {};

    orgType GetOrg();

    void ReadNext(char*, int, int = 0, int = 0);
    void Write(char*, int, int = 0, int = 0);
};

/*---------------------------------------------------------------------------*/
/* Indexed file class                                                        */
/*---------------------------------------------------------------------------*/

class IndexedFile : public File
{
  private:
    int  keyOffSet;
    int  keyLength;

  public:
    IndexedFile(const FCWString& n, int rl, format rf,
                const FCWString& dn, FileDef* pfd) :
         File(n, rl, rf, dn, pfd) {keyOffSet = 0; keyLength = 0;}

    orgType GetOrg();
    int  GetKeyOffSet();
    int  GetKeyLength();
    void  SetKeyOffSet(int ko);
    void  SetKeyLength(int kl);

    void Delete(char*, int, int, int);
    void Find(char*, int, int, int);
    void ReadNext(char*, int, int, int);
    void ReadPrev(char*, int, int, int);
    void Replace(char*, int, int, int);
    void RollBack();
    void SetScan(char*, int, int, int);
    void Update(char*, int, int, int);
    void Write(char*, int, int, int);
};

/*---------------------------------------------------------------------------*/
/* Relative file class                                                       */
/*---------------------------------------------------------------------------*/

class RelativeFile : public File
{
  private:
    long relRecNum;                    // relative record number

  public:
    RelativeFile(const FCWString& n, int rl, format rf,
                 const FCWString& dn, FileDef* pfd) :
         File(n, rl, rf, dn, pfd) {};

    orgType GetOrg();
    long GetRelRecNum();
    void SetRelRecNum( long rn );

    void Delete(char*, int, int, int = 0);
    void Find(char*, int, int, int = 0);
    void ReadNext(char*, int, int, int = 0);
    void Replace(char*, int, int, int = 0);
    void Update(char*, int, int, int = 0);
    void Write(char*, int, int, int = 0);
};

/*---------------------------------------------------------------------------*/
/* File Definition class                                                     */
/*                                                                           */
/* A FileDef object is created for each entry in the Resource Association    */
/*  File.                                                                    */
/*---------------------------------------------------------------------------*/

class FileDef
{
  private:

    FCWString logicalFileName;
    FCWString physicalFileName;
    FCWString baseFileName;
    FCWString fileType;
    FCWString keyDefs;
    unsigned int options;

  public:

    FileDef() : options(0) {}
    FileDef( char* lfName, char* pfName, char* fType, int opt ) :
       logicalFileName( lfName ), physicalFileName( pfName ),
       fileType( fType ), options( opt ) {}                     /* V2.1 */
//  ~FileDef();

    FCWString& GetLogicalFileName();
    void SetLogicalFileName(char* ln);

    FCWString& GetPhysicalFileName();
    void SetPhysicalFileName(char* pn);

    FCWString& GetBaseFileName();
    void SetBaseFileName(char* bn);

    FCWString& GetFileType();
    void SetFileType(char* ft);

    FCWString& GetKeyDefs();
    void SetKeyDefs(char* kd);

    int GetReplaceOption();
    void SetReplaceOption();

    int GetAltIndxOption();
    void SetAltIndxOption();

    int GetDupOption();
    void SetDupOption();

    int GetKeysOption();
    void SetKeysOption();

    int GetNoFFOption();
    void SetNoFFOption();

    int GetTextOption();
    void SetTextOption();

};

#endif
