/*****************************************************************************/
/*                                                                           */
/*                           OCO SOURCE MATERIALS                            */
/*                             IBM CONFIDENTIAL                              */
/*                                    OR                                     */
/*                        IBM CONFIDENTIAL RESTRICTED                        */
/*            WHEN COMBINED WITH THE AGGREGATED OCO SOURCE MODULES           */
/*                           FOR THIS PROGRAM PRODUCT                        */
/*                                                                           */
/*    5622-585 VisualAge Generator Workgroup Services for OS/2 V2.2          */
/*    5622-587 VisualAge Generator Workgroup Services for AIX V2.2           */
/*    5639-A26 VisualAge Generator Workgroup Services for Windows NT V2.2    */
/*                     (C) COPYRIGHT IBM CORP. 1994,1996                     */
/*                                                                           */
/*****************************************************************************/

struct EntryStuff
{
   FCWString entryName;
   int       UseCount;
   PFV       entryAddr;
   EntryStuff() : entryAddr(0), UseCount(0) {};
};

struct LibStuff
{
   FCWString libName;
#if defined(FCW_OS2) || defined(FCW_NT)
   HMODULE         hMod;

#elif defined FCW_AIX
   APP_MODULE_TYPE hMod;
   DynaLinkLib lib;

#elif defined FCW_HP
   shl_t           hMod;
#endif

   LIST( EntryStuff* ) EntryList;
};

class DynaLinkMgr
{
   public:

      DynaLinkMgr ();
      ~DynaLinkMgr();
      PFV            find         ( FCWString&, FCWString&, int& );
      void           release      ( PFV pMod );
      int            getProcAddr  ( LibStuff*, EntryStuff* );
      int            loadModule   ( LibStuff* );
      static void    unloadModule ( LibStuff* );

   private:
      LIST( LibStuff* ) libList;
#if defined FCW_AIX || defined FCW_HP
      FCWString         libpath;
#endif
};
