/*****************************************************************************/
/*                                                                           */
/*                           OCO SOURCE MATERIALS                            */
/*                             IBM CONFIDENTIAL                              */
/*                                    OR                                     */
/*                        IBM CONFIDENTIAL RESTRICTED                        */
/*            WHEN COMBINED WITH THE AGGREGATED OCO SOURCE MODULES           */
/*                           FOR THIS PROGRAM PRODUCT                        */
/*                                                                           */
/*    5622-585 VisualAge Generator Workgroup Services for OS/2 V2.2          */
/*    5622-587 VisualAge Generator Workgroup Services for AIX V2.2           */
/*    5639-A26 VisualAge Generator Workgroup Services for Windows NT V2.2    */
/*                     (C) COPYRIGHT IBM CORP. 1994,1996                     */
/*                                                                           */
/*****************************************************************************/
#if defined FCW_HP
#include <dl.h>

  typedef unsigned long ulong;
#endif

class DynaLinkLib {
 private:
#if defined FCW_HP
   shl_t   mHandle;
#endif
   int     (*entryPoint)();
   int     loadedByUs;
   const   struct ldhdr* ldhdr;
   int     sndata;
   ulong   dataReloc;
   char*   ld_infoBuf;
   int     ld_infoBufSize;
   enum    SymbolType { data, function };
   void    clear();
   int     getLoadInfo();
   int     getDllInfo();
   int     queryAddr(const char* name, SymbolType symType, void** addr);
   struct  CDtors {
     void  (*ctor)();
     void  (*dtor)();
   };
   CDtors* cdArray;
   int     cdMilestone;
   int     findAndRunCtors();
   int findCtors();
  public:
   DynaLinkLib();
   ~DynaLinkLib();
   int     load(const char* name, const char* libpath);
   int     grab(void* addr);
   int     free();
   int     queryProcAddr(const char* name, void** addr);
   int     queryDataAddr(const char* name, void** addr);
#if defined FCW_AIX
   APP_MODULE_TYPE moduleHandle() { return entryPoint; }
#elif defined FCW_HP
   shl_t    moduleHandle() { return mHandle; }
#endif
   int     runCtors();
   void    runDtors();
};
