/*****************************************************************************/
/*                                                                           */
/*                           OCO SOURCE MATERIALS                            */
/*                             IBM CONFIDENTIAL                              */
/*                                    OR                                     */
/*                        IBM CONFIDENTIAL RESTRICTED                        */
/*            WHEN COMBINED WITH THE AGGREGATED OCO SOURCE MODULES           */
/*                           FOR THIS PROGRAM PRODUCT                        */
/*                                                                           */
/*    5622-585 VisualAge Generator Workgroup Services for OS/2 V2.2          */
/*    5622-587 VisualAge Generator Workgroup Services for AIX V2.2           */
/*    5639-A26 VisualAge Generator Workgroup Services for Windows NT V2.2    */
/*                     (C) COPYRIGHT IBM CORP. 1994,1996                     */
/*                                                                           */
/*****************************************************************************/
#ifndef FCWDRV_H
#define FCWDRV_H

class Map;                             /* forward reference                */
class eMap;                            /* forward reference                */
class iMap;                            /* forward reference                */
class Attribute;                       /* forward reference                */

//----------------------------------------------------------------------------
// DataStream object                                                         -
//----------------------------------------------------------------------------
// The DataStream object is a virtual class which defines the methods needed -
// to build a 3270 type data stream. It also contains information about the  -
// map's position (offset) on the screen.                                    -
//                                                                           -
// An environment specific driver should derive an environment specific      -
// object from DataStream. The derived class should override the virtual     -
// functions for the correct implementation.                                 -
//----------------------------------------------------------------------------
class DataStream
{
   public:
      DataStream(eMap*, Bool, int, int);
      DataStream() {};
      virtual ~DataStream() { };

      eMap*            Map();
      void             SetMap( eMap* );
      FCWString const& Name();
      Bool             isConstants();
      Bool             isFloatMap();
      Bool             hasbeenConversed();
      Bool             hasNeverbeenConversed();
      Bool             hasbeenProtected();
      int              mapStart();
      int              mapEnd();
      int              mapPrefix();
      int              mapSuffix();
      int              row();
      int              col();
      Bool             isHelpBuffer();
      void             isHelpBuffer( Bool );

      virtual long  size();
              void  Data( char* );
      virtual char* pData( ) { return NULL; };
      virtual void  restore( char* );

      virtual void reset();
      virtual void clear();
      virtual void setConversed(Bool v=True);
      virtual void setProtected(Bool v=True);

      virtual void setBufferAddress(int)                    = 0;
      virtual void startField(Attribute, int )              = 0;
      virtual void setText(FCWString const&)                = 0;
      virtual void setText(char*, int)                      = 0;
      virtual void setCursor(int)                           = 0;
      virtual void add(void *)                              = 0;
      virtual void protect()                                = 0;

   private:

      eMap*      ds_Map;
      FCWString  ds_MapName;
      struct ds_Data
      {
         Bool       ds_isConstants;
         Bool       ds_isFloatMap;
         Bool       ds_hasbeenConversed;
         Bool       ds_hasNotBeenUpdated;
         Bool       ds_hasbeenProtected;
         int        ds_MapStart;
         int        ds_MapEnd;
         int        ds_MapPrefix;
         int        ds_MapSuffix;
         int        ds_MapColumn;
         int        ds_MapRow;
         Bool       ds_isHelpBuffer;
      } _Data;
};

//----------------------------------------------------------------------------
// FieldData object                                                          -
//----------------------------------------------------------------------------
// The FieldData object represents the external view of the variable field   -
// data. In addition to the actual formatted data, the object contains the   -
// position of the field relative to the screen (the variable field defintion-
// has the position relative to the map), the field's modified attribute     -
// (defined attribute with application SETs applied), and indicators for     -
// field modification, edit error, and cursor positioning.                   -
//----------------------------------------------------------------------------
class EditField;                       /* forward reference                */

class FieldData
{
   public:
      FieldData(int addr, FCWString const & str, Attribute& attr, EditField* pField) :
         fd_addr(addr),
         fd_data(str),
         fd_attribute(attr),
         fd_pField(pField),
         fd_Modified(False),
         fd_cursor(False),
         fd_isInitCursorField(False),
         fd_error(0)
      {}
      FieldData( EditField* pField, char* p );

      int       Address();

      void              setModified(Bool value=True);
      void              setData(FCWString const& str);
      Bool              getModified();
      Bool              isUnprotected();
      Bool              isInError();
      int               error();
      void              setError(int error);
      Bool              hasCursor();
      void              setCursor(Bool cursor=False);
      void              setCursorField(Bool cursor=True);
      Bool              isCursorField();
      FCWString const&  getData();
      Attribute         attribute();
      int               col();
      int               row();
      int               size();
      EditField*        pEditField();
      int               fieldType();

      void              save( char* );
      void              restore( char* );
      long              Length();

   private:
      EditField* fd_pField;
      Bool       fd_Modified;
      Bool       fd_cursor;
      Bool       fd_isInitCursorField;
      int        fd_addr;
      int        fd_error;
      FCWString  fd_data;
      Attribute  fd_attribute;

};

//----------------------------------------------------------------------------
// DisplayIODriver                                                           -
//----------------------------------------------------------------------------
// The DisplayIODriver structure contains pointers the the appropriate       -
// environment specific function which does the desired service. This        -
// structure is initialized by the driver when it is loaded and called for   -
// initialization.                                                           -
//----------------------------------------------------------------------------
struct DisplayIODriver
{
  int         (*pElam01)         (FCWString const&);
  void        (*pConverseHelpB)  ();
  void        (*pConverseHelpA)  ();
  int         (*pConverseScreen) ();
  DataStream* (*pGetBuffer)      (eMap*, Bool, int);
  int         (*pReadModified)   (DisplayDriver&);
  int         (*pScreenRows)     ();
  int         (*pScreenCols)     ();
  void        (*pSetAlarm)       (Bool);
  void        (*pTerminate)      ();
  void        (*pUpdateScreen)   ();
  int         (*pCursorPosition) ();
  void        (*pSendScreen)     ();
  int         (*pReceiveScreen)  ();
  void        (*pSendElam01)     (FCWString const&);
  int         (*pReceiveElam01)  ();
  DataStream* (*pGetBuffer2)     ();
};


//----------------------------------------------------------------------------
// DisplayDriver                                                             -
//----------------------------------------------------------------------------
// The DisplayDriver object implements the high level concepts for CSP map   -
// services. This object takes care of the CSP specific characteristics of   -
// mapping such as when to clear the screen (buffer chaining), map positions -
// and variable field editing.                                               -
//----------------------------------------------------------------------------
class DisplayDriver
{
   public:
      DisplayDriver();
      ~DisplayDriver();

      void                Converse(iMap*, eMap*);
      void                Display (iMap*, eMap*);
      int                 Elam01(FCWString const&);
      void                SendElam01(FCWString const&);
      int                 ReceiveElam01();
      void                SetMessage(int, Bool, char* pInsert=NULL);
      void                setData(int, FCWString const&);

      long                size();
      char*               pBuffer();
      void                restore( char* );
      void                addDataStream( char* );

      Map*                GetMap() { return drv_pMap; }

   private:

      FieldData*          findData(eMap*, EditField*);
      FieldData*          findData(int const&);
      int                 usedRows();

      void                ConverseHelp(FCWString const&, iMap*, eMap*);
      DataStream*         getBuffer(eMap*, Bool bConstants = False);
      DataStream*         getBuffer();
      void                cleanup();
      void                protectPrevious();
      void                formatOutput(iMap*, eMap*);
      void                bufferChaining(iMap*, eMap*);

      void                converseHelpBefore();
      void                converseHelpAfter();
      int                 readModified();
      int                 cursorPosition();
      int                 converseScreen();
      void                SendScreen();
      int                 ReceiveScreen();
      void                updateScreen();
      int                 screenRows();
      int                 screenCols();
      void                terminate();

      void                floatChaining(eMap*);
      void                fixedChaining(eMap*);
      void                releaseAllMaps();
      void                releaseBuffers(eMap*);
      void                releaseMap(eMap*);
      void                releaseAllFloatMaps();
      void                releaseLastMapBuffer();
      int                 formatInput(iMap*, eMap*);
      void                buildBuffer(eMap*, DataStream*);
      void                rebuildBuffer(eMap*);
      void                showError(eMap*);
      void                setCursorPosition(iMap*);
      DataStream*         lastBuffer();
      void                setModified(iMap*);
      void                setAlarm(Bool);

      LIST(FieldData*)    drv_list_pFieldData;
      int                 drv_cursorpos;
      int                 drv_usedRows;
      int                 drv_ezemno;
      DisplayIODriver     drv_DD;

      long                drv_size;
      char*               drv_buffer;
      eMap*               drv_peMap;
      Map*                drv_pMap;
};

#endif
