/*****************************************************************************/
/*                                                                           */
/*                           OCO SOURCE MATERIALS                            */
/*                             IBM CONFIDENTIAL                              */
/*                                    OR                                     */
/*                        IBM CONFIDENTIAL RESTRICTED                        */
/*            WHEN COMBINED WITH THE AGGREGATED OCO SOURCE MODULES           */
/*                           FOR THIS PROGRAM PRODUCT                        */
/*                                                                           */
/*    5622-585 VisualAge Generator Workgroup Services for OS/2 V2.2          */
/*    5622-587 VisualAge Generator Workgroup Services for AIX V2.2           */
/*    5639-A26 VisualAge Generator Workgroup Services for Windows NT V2.2    */
/*                     (C) COPYRIGHT IBM CORP. 1994,1996                     */
/*                                                                           */
/*****************************************************************************/
#ifndef  FCWDB2_H
#define  FCWDB2_H

#include <fcwcmndb.h>

// ******************************************************************
//   OS/2 Bind file for CG/2 SQL runtime service routine
// ******************************************************************
#define FCW_BIND_FILE   "FCWDB2.BND"


// ******************************************************************
//   Maximum number of concurrently open cursors allowed for an
//   application process
// ******************************************************************
const  int  NUMRECS = 20;


// --------------------------------------------------------------------
//  Macro for SQL datatype, using ANSI type of numbering
// --------------------------------------------------------------------
#define   SQL_CHAR                 1
#define   SQL_NUMERIC              2
#define   SQL_DECIMAL              3
#define   SQL_INTEGER              4
#define   SQL_SMALLINT             5
#define   SQL_FLOAT                6
#define   SQL_REAL                 7
#define   SQL_DOUBLE               8
#define   SQL_VARCHAR              9
#define   SQL_LONGVARCHAR         10

const   short  SQL_INI_HOST_VARS = 32;       // initial number of host vars


// --------------------------------------------------------------------
//  Macro for FCW datatype to SQL datatype mapping  *** SQL Types ***
// --------------------------------------------------------------------
#define   FCW_CHAR           SQL_CHAR      /* CHAR, VARCHAR, DECIMAL, NUMERIC */
#define   FCW_BIN4           SQL_INTEGER   /* INTEGER                 */
#define   FCW_BIN2           SQL_SMALLINT  /* SMALLINT                */
#define   FCW_PACK           SQL_DECIMAL   /* PACK                    */
#define   FCW_HEX            SQL_CHAR      /* ???                     */
#define   FCW_DBCS           SQL_CHAR      /* ???                     */

// --------------------------------------------------------------------
//         SQL statement handle : to be replaced by ODBC HSTMT ...
// --------------------------------------------------------------------
typedef struct _STMTHANDLE {
    short           CurrOpr;               // Current record operation
    short           CursorID;              // index to active cursor
    short           CursorIsOpen;          // switch for cursor state
    void*           pInDA;                 // ptr to statement input DA
    void*           pOutDA;                // ptr to statement output DA
} STMTHANDLE, *PSTMTHANDLE;


// ------------------------------------------------------------------
//              System dependent calls
// ------------------------------------------------------------------

int  SQLAllocStmt( PSTMTHANDLE* );
int  SQLGetCursorName( PSTMTHANDLE, unsigned char *, short, short * );
int  SQLFreeStmt( PSTMTHANDLE, char );
int  SQLPrepare( PSTMTHANDLE, unsigned char * );
int  SQLExecDirect( PSTMTHANDLE, unsigned char * );
int  SQLExecute( PSTMTHANDLE );
int  SQLFetch( PSTMTHANDLE );
int  SQLSetParm( PSTMTHANDLE pStmt, unsigned short ParmNum, short FCWType,
                 short SQLType, short Precision, short Scale,
                 unsigned char *pData, short *pNullInd );
int  SQLBindCol( PSTMTHANDLE phStmt, unsigned short ParmNum, short FCWType,
                 void *pData, short DataLen, short *pNullInd );
int  SQLStart( );
int  SQLConnect( unsigned char* dbname, unsigned char* result );
int  SQLTransact( char );

void  SetDBIOStatus( int, unsigned short * );
void  CopySQLCA( void* );

#endif
