/*****************************************************************************/
/*                                                                           */
/*                           OCO SOURCE MATERIALS                            */
/*                             IBM CONFIDENTIAL                              */
/*                                    OR                                     */
/*                        IBM CONFIDENTIAL RESTRICTED                        */
/*            WHEN COMBINED WITH THE AGGREGATED OCO SOURCE MODULES           */
/*                           FOR THIS PROGRAM PRODUCT                        */
/*                                                                           */
/*    5622-585 VisualAge Generator Workgroup Services for OS/2 V2.2          */
/*    5622-587 VisualAge Generator Workgroup Services for AIX V2.2           */
/*    5639-A26 VisualAge Generator Workgroup Services for Windows NT V2.2    */
/*                     (C) COPYRIGHT IBM CORP. 1994,1996                     */
/*                                                                           */
/*****************************************************************************/
#ifdef FCW_AIX || defined FCW_HP

#ifdef FCW_AIX
#include <cur00.h>
#include <cur01.h>
#include <cur02.h>

#elif defined FCW_HP
#include <curses.h>
#endif

//
// The following #undefs attempt to clean up the terrible name space
// pollution generated by the curses #include files.  These macros
// have no notion of scope so they clash with class members, etc.
//

#undef clear
#undef erase

extern "C" {
  endwin();
  wmove(WINDOW*, int, int);
  xstandend(WINDOW*);
  xstandout(WINDOW*, int);
  waddch(WINDOW*, int);
  wrefresh(WINDOW*);
  wclrtobot(WINDOW*);
  keypad(int);
  extended(int);
  wgetch(WINDOW*);
  bell(int);
}

#endif // end of AIX section

#if defined(FCW_OS2) || defined(FCW_NT)

#define ERR 0
#define OK  1

typedef int ATTR;

typedef struct {
  int cursor_row;
  int cursor_col;
  ATTR cursor_attr;
  int rows;
  int cols;
  char* text;
  ATTR* attr;
  int changes;
  int changed_row;
  int changed_col;
  int flags;
  FILE* tty;
} WINDOW;

extern WINDOW* stdscr;
extern WINDOW* curscr;
extern int LINES;
extern int COLS;

int colorend();
int colorout(int);
int move(int, int);
int clearok(WINDOW*, BOOL);
int addch(int);
int addstr(char* s);
int refresh();
int getch();
void keypad(BOOL);
void extended(BOOL);
void noecho();
void crmode();
void leaveok(WINDOW*, BOOL);
WINDOW* initscr();
void endwin();
void beep();

#define NORMAL       0x00000000
#define REVERSE      0x00000001
#define BOLD         0x00000002
#define UNDERSCORE   0x00000004
#define BLINK        0x00000008
#define TOPLINE      0x00000010
#define BOTTOMLINE   0x00000020
#define RIGHTLINE    0x00000040
#define LEFTLINE     0x00000080
#define F_BLACK      0x00000100
#define F_RED        0x00000200
#define F_GREEN      0x00000300
#define F_BROWN      0x00000400
#define F_BLUE       0x00000500
#define F_MAGENTA    0x00000600
#define F_CYAN       0x00000700
#define F_WHITE      0x00000800
#define B_BLACK      0x00001000
#define B_RED        0x00002000
#define B_GREEN      0x00003000
#define B_BROWN      0x00004000
#define B_BLUE       0x00005000
#define B_MAGENTA    0x00006000
#define B_CYAN       0x00007000
#define B_WHITE      0x00008000

#define KEY_NOKEY       -2      /* no keyboard data, nodelay on */
#define KEY_BAD         -1      /* error return in place of key */
#define KEY_BREAK       0x101   /* break - unreliable           */
#define KEY_DOWN        0x102   /* cursor down                  */
#define KEY_UP          0x103   /* cursor up                    */
#define KEY_LEFT        0x104   /* cursor left                  */
#define KEY_RIGHT       0x105   /* cursor right                 */
#define KEY_HOME        0x106   /* home - top left              */
#define KEY_BACKSPACE   0x107   /* backspace - unreliable       */
#define KEY_DL          0x108   /* delete line                  */
#define KEY_IL          0x109   /* insert line                  */
#define KEY_DC          0x10a   /* delete character             */
#define KEY_IC          0x10b   /* insert character mode start  */
#define KEY_EIC         0x10c   /* exit insert character mode   */
#define KEY_CLEAR       0x10d   /* clear screen                 */
#define KEY_EOS         0x10e   /* clear to end of screen       */
#define KEY_EOL         0x10f   /* clear to end of line         */
#define KEY_SF          0x110   /* scroll forward toward end    */
#define KEY_SR          0x111   /* scroll backward toward start */
#define KEY_NPAGE       0x112   /* next page                    */
#define KEY_PPAGE       0x113   /* previous page                */
#define KEY_STAB        0x114   /* set tab stop                 */
#define KEY_CTAB        0x115   /* clear tab stop               */
#define KEY_CATAB       0x116   /* clear all tab stops          */
#define KEY_ENTER       0x117   /* enter key - unreliable       */
#define KEY_SRESET      0x118   /* soft reset key - unreliable  */
#define KEY_RESET       0x119   /* hard reset key - unreliable  */
#define KEY_PRINT       0x11a   /* print or copy                */
#define KEY_LL          0x11b   /* lower left (last line)       */
#define KEY_A1          0x11c   /* pad upper left               */
#define KEY_A3          0x11d   /* pad upper right              */
#define KEY_B2          0x11e   /* pad center                   */
#define KEY_C1          0x11f   /* pad lower left               */
#define KEY_C3          0x120   /* pad lower right              */
#define KEY_DO          0x121   /* DO key                       */
#define KEY_QUIT        0x122   /* QUIT key                     */
#define KEY_CMD         0x123   /* Command key                  */
#define KEY_PCMD        0x124   /* Previous command key         */
#define KEY_NPN         0x125   /* Next pane key                */
#define KEY_PPN         0x126   /* previous pane key            */
#define KEY_CPN         0x127   /* command pane key             */
#define KEY_END         0x128   /* end key                      */
#define KEY_HLP         0x129   /* help key                     */
#define KEY_SEL         0x12a   /* select key                   */
#define KEY_SCR         0x12b   /* scroll right key             */
#define KEY_SCL         0x12c   /* scroll left key              */
#define KEY_TAB         0x12d   /* tab key                      */
#define KEY_BTAB        0x12e   /* back tab key                 */
#define KEY_NEWL        0x12f   /* new line key                 */
#define KEY_ACT         0x130   /* action key                   */

#define KEY_F0          0x180   /* function key -               */
#define KEY_F(n)        (KEY_F0+(n))/*    reserve 128 values        */

#define KEY_SF1         (KEY_F0+64)/* Special function key 1       */
#define KEY_SF2         (KEY_F0+65)/* Special function key 2       */
#define KEY_SF3         (KEY_F0+66)/* Special function key 3       */
#define KEY_SF4         (KEY_F0+67)/* Special function key 4       */
#define KEY_SF5         (KEY_F0+68)/* Special function key 5       */
#define KEY_SF6         (KEY_F0+69)/* Special function key 6       */
#define KEY_SF7         (KEY_F0+70)/* Special function key 7       */
#define KEY_SF8         (KEY_F0+71)/* Special function key 8       */
#define KEY_SF9         (KEY_F0+72)/* Special function key 9       */
#define KEY_SF10        (KEY_F0+73)/* Special function key 10      */

#endif // end of OS/2 section
