/*****************************************************************************/
/*                                                                           */
/*                           OCO SOURCE MATERIALS                            */
/*                             IBM CONFIDENTIAL                              */
/*                                    OR                                     */
/*                        IBM CONFIDENTIAL RESTRICTED                        */
/*            WHEN COMBINED WITH THE AGGREGATED OCO SOURCE MODULES           */
/*                           FOR THIS PROGRAM PRODUCT                        */
/*                                                                           */
/*    5622-585 VisualAge Generator Workgroup Services for OS/2 V2.2          */
/*    5622-587 VisualAge Generator Workgroup Services for AIX V2.2           */
/*    5639-A26 VisualAge Generator Workgroup Services for Windows NT V2.2    */
/*                     (C) COPYRIGHT IBM CORP. 1994,1996                     */
/*                                                                           */
/*****************************************************************************/
#ifndef FCWCURS_H
#define FCWCURS_H
//#include <fcwv3270.h>

#include <fstream.h>

class eMap;      // forward reference

class CursesNode
{
   public:
      virtual ~CursesNode() { };
      virtual void add(Virtual3270*) = 0;
      virtual void protect() {};
};

class SbaNode : public CursesNode
{
   public:
      SbaNode(int n) : sba_offset(n) {};

      virtual void add(Virtual3270*);

   private:
      int   sba_offset;
};

class StartFieldNode : public CursesNode
{
   public:
      StartFieldNode(Attribute& attr, Field::Field_Type);

      virtual void add(Virtual3270*);
      virtual void protect();

   public:
      Attribute              sf_attribute;
      Attr3270::Protection   sf_protection;
      Attr3270::Modification sf_modification;
      Attr3270::Color        sf_color;
      Attr3270::Hilite       sf_hilite;
      Attr3270::Intensity    sf_intensity;
      int                    sf_outline;
      Attr3270::CharWidth    sf_charwidth;
};

class TextNode : public CursesNode
{
   public:
      TextNode(char* str, int len);
      ~TextNode();

      virtual void add(Virtual3270*);

   private:
      char* t_string;
      int   t_length;
};

class CursorNode : public CursesNode
{
   public:
      CursorNode(int pos) : c_pos(pos) {};

      virtual void add(Virtual3270*);

   private:
      int   c_pos;
};

class CursesBuffer : public DataStream
{
   public:
      CursesBuffer(eMap* peMap, Bool b, int u, int c) :
         DataStream(peMap, b, u, c) {};
      ~CursesBuffer();

      virtual void clear();
      virtual void setBufferAddress(int);
      virtual void startField(Attribute, int);
      virtual void setText(FCWString const&);
      virtual void setText(char*, int);
      virtual void setCursor(int);
      virtual void add(void *);
      virtual void protect();

   private:
      LIST(CursesNode*)  buf_list_pNode;
};

#endif
