/*****************************************************************************/
/*                                                                           */
/*                           OCO SOURCE MATERIALS                            */
/*                             IBM CONFIDENTIAL                              */
/*                                    OR                                     */
/*                        IBM CONFIDENTIAL RESTRICTED                        */
/*            WHEN COMBINED WITH THE AGGREGATED OCO SOURCE MODULES           */
/*                           FOR THIS PROGRAM PRODUCT                        */
/*                                                                           */
/*    5622-585 VisualAge Generator Workgroup Services for OS/2 V2.2          */
/*    5622-587 VisualAge Generator Workgroup Services for AIX V2.2           */
/*    5639-A26 VisualAge Generator Workgroup Services for Windows NT V2.2    */
/*                     (C) COPYRIGHT IBM CORP. 1994,1996                     */
/*                                                                           */
/*****************************************************************************/
#ifndef  FCWCSQL_H
#define  FCWCSQL_H

#include <fcwcmndb.h>
#include <fcwcmn.h>

#define   AHVPTR     void**

enum { opt_blank=1, opt_reset=2, opt_server=3 };     // SQL connect option

// ------------------------------------------------------------------
//              System dependent calls
// ------------------------------------------------------------------
class CmnSQLItf {

  public:
    int   virtual SQLStart() = 0;
    int   virtual SQLConnect( short opt, unsigned char* dbname, void* pCA ) = 0;

    int   virtual SQLSetDBIOStatus( void *, unsigned short * ) = 0;
    void  virtual SQLGetDBMessage( void *, char*, int ) = 0;

    void  virtual SQLCopyRsCAToApp( void*, void* ) = 0;
    void  virtual SQLBackupCA( void**, void* ) = 0;
    void  virtual SQLRestoreCA( void*, void* ) = 0;
    int   virtual SQLTransact( char ) = 0;
    int   virtual SQLBind( unsigned char* plan, unsigned char* dbname, void* pCA ) = 0;

    FCWString virtual SQLGetProduct( void* pCA ) = 0;
    FCWString virtual SQLGetRelease( void* pCA ) = 0;
    Bool  virtual SQLTypeIsVarLenChar( short ) = 0;
};

typedef CmnSQLItf* (*PFItf)();
typedef CmnSQLItf*   HSQLDRV;

#endif
