/*****************************************************************************/
/*                                                                           */
/*                           OCO SOURCE MATERIALS                            */
/*                             IBM CONFIDENTIAL                              */
/*                                    OR                                     */
/*                        IBM CONFIDENTIAL RESTRICTED                        */
/*            WHEN COMBINED WITH THE AGGREGATED OCO SOURCE MODULES           */
/*                           FOR THIS PROGRAM PRODUCT                        */
/*                                                                           */
/*    5622-585 VisualAge Generator Workgroup Services for OS/2 V2.2          */
/*    5622-587 VisualAge Generator Workgroup Services for AIX V2.2           */
/*    5639-A26 VisualAge Generator Workgroup Services for Windows NT V2.2    */
/*                     (C) COPYRIGHT IBM CORP. 1994,1996                     */
/*                                                                           */
/*****************************************************************************/
#ifndef FCWATTR_H
#define FCWATTR_H

//-----------------------------------------------------------------------------
// Color class                                                                -
//-----------------------------------------------------------------------------
// The Color class is used to define the enumerations that are used to set    -
// and query the field color.                                                 -
//-----------------------------------------------------------------------------
class Color
{
   public:
      enum enum_Color
      {
         Defined = 0x00,
         Mono    = 0x01,
         Blue    = 0x02,
         Pink    = 0x04,
         Yellow  = 0x08,
         Turq    = 0x10,
         Red     = 0x20,
         Green   = 0x40,
         White   = 0x80
      };
};

//-----------------------------------------------------------------------------
// Hilite class                                                               -
//-----------------------------------------------------------------------------
// The Hilite class is used to define the enumerations that are used to set   -
// and query the field's hilite attribute.                                    -
//-----------------------------------------------------------------------------
class Hilite
{
   public:
      enum enum_Hilite
      {
         Defined  = 0x00,
         NoHilite = 0x01,
         Blink    = 0x02,
         RVideo   = 0x04,
         UScore   = 0x08
      };
};

//-----------------------------------------------------------------------------
// Outline class                                                              -
//-----------------------------------------------------------------------------
// The Outline class is used to define the enumerations that are used to set  -
// and query the field's outline attribute.                                   -
//-----------------------------------------------------------------------------
class Outline
{
   public:
      enum enum_Outline
      {
         NOutline       = 0x00,
         Under          = 0x01,
         Right          = 0x02,
         Over           = 0x04,
         Left           = 0x08,
         Box            = Left  | Right | Over | Under,
         LeftRight      = Left  | Right,
         LeftOver       = Left  | Over,
         LeftUnder      = Left  | Under,
         RightOver      = Right | Over,
         RightUnder     = Right | Under,
         OverUnder      = Over  | Under,
         RightOverUnder = Right | Over  | Under,
         LeftRightOver  = Left  | Right | Over,
         LeftRightUnder = Left  | Right | Under,
         LeftOverUnder  = Left  | Over  | Under
      };
};

//-----------------------------------------------------------------------------
// Attribute class                                                            -
//-----------------------------------------------------------------------------
// The Attribute class is used to define the fields attributes.               -
//-----------------------------------------------------------------------------
struct Attribute_Data;

class Attribute
{
   public:
      enum enum_Attribute
      {
         Defined     = 0x00,
         Normal      = 0x00,
         Full        = 0x80,
         AutoSkip    = 0x40,
         Protect     = 0x20,
         Numeric     = 0x10,
         Unprotect   = 0x00,
         Bright      = 0x08,
         Dark        = 0x02,
         Modified    = 0x01
      };
      Attribute (Attribute const&);
      Attribute (unsigned char         base   = AutoSkip,
                 Color::enum_Color     color  = Color::Mono,
                 Hilite::enum_Hilite   hilite = Hilite::NoHilite,
                 unsigned char         outline= Outline::NOutline);
      ~Attribute();


      enum_Attribute        base();
      Color::enum_Color     color();
      Hilite::enum_Hilite   hilite();
      Outline::enum_Outline outline();
      Bool                  isDark();
      Bool                  isBright();
      Bool                  isProtected();
      Bool                  isAutoSkip();
      Bool                  isModified();
      Bool                  isNumeric();
      Bool                  hasColor();
      Bool                  hasHilite();
      void                  setBright();
      void                  setModified();

      Attribute*            Data();
      long                  Length();
      void                  operator=(Attribute const &);

   private:
      Attribute::enum_Attribute  attr_base;
      Color::enum_Color          attr_color;
      Hilite::enum_Hilite        attr_hilite;
      Outline::enum_Outline      attr_outline;
      void*                      pData;
};

#endif
