/*********************************************************************/
/*********************************************************************/
/*                                                                   */
/*   VisualGen C++ Workgroup Services                                */
/*                                                                   */
/*   Licensed Materials -  Property of IBM                           */
/*   5648-096 (C) Copyright IBM Corp. 1994, 1995                     */
/*   All Rights Reserved                                             */
/*                                                                   */
/*   US Government Users Restricted Rights                           */
/*   -- Use, duplication, or disclosure restricted                   */
/*   by GSA ADP Schedule Contract with IBM Corp.                     */
/*                                                                   */
/*********************************************************************/
/*********************************************************************/

#ifndef FCW_H
#define FCW_H

#if defined FCW_OS2
#include <os2.h>
#endif

#include <stdlib.h>
#include <string.h>
#include <memory.h>
#include <stdarg.h>
#include <stdio.h>

/*-------------------------------------------------------------------------*/
/*  Transfer type information                                              */
/*-------------------------------------------------------------------------*/

enum TransType { dxfr, xfer, creatx };

struct TransInfo
{
  TransType       Type;
  FCWString       Appname;
  int             Options;
  char*           pBlock;
  TransInfo() :   pBlock(NULL), pMapBlock(NULL), pMapName(NULL) {};
  char*           pMapBlock;
  char*           pMapName;
  FILE_MAP_HANDLE pBlockHandle;
};

/*-------------------------------------------------------------------------*/
/*  AppUsage structure                                                     */
/*-------------------------------------------------------------------------*/
struct AppUsage
{
  FCWString        name;
  FCWString        qual;
  FCWString        proc;
  PMAINAPP         pProc;
};

/*-------------------------------------------------------------------------*/
/*  forward references                                                     */
/*-------------------------------------------------------------------------*/
class DisplayDriver;
class PrintDriver;
class Map;
class FCWApp;
class Record;
class TraceFile;
class MDBOBJ;
class MsgBlock;
class ShareTblList;
class RPCDriver;
class FileIODriver;
class File;
class FileRecord;
class FileDef;
class FCWMsgTable;

enum RunMode { normal, terminate, transfer, abend, segment, dxfer, xferwmap };
enum StartCode { FromCall, FromMain, FromRPC, FromCICS };          /* D4299*/

/*-------------------------------------------------------------------------*/
/*  FCWRunUnit class definition                                            */
/*-------------------------------------------------------------------------*/
class FCWRunUnit
{
  private:

    enum TOKTYPE    {Unknown,  Assoc,  Filename, Filetype,  Pcbno,     Sysname,
                     Basename, Sysnum, System,   EndOfFile, NoReplace, Replace,
                     Keys,     Dup,    NoFF,     Text };

    FCWString        RAFname;
    Bool             bRAFInit;
    void             GetRAFfromFCWRSC();
    unsigned int     GetnlsIDfromEZERNLS();
    Bool             IsValidnlsID( char* );
    Bool             bParmInit;

    unsigned int     rcode;
    RunMode          mode;
    STACK (FCWApp*)  appstack;
    TransInfo        ti;
    FCWMsgTable*     pMsgTable;

    char*            GetToken( FILE* fh, char* buffer, int* buflen,
                               TOKTYPE* tokType );
    void             TransferApp();
    LIST( File*    ) LFiles;
    LIST( FileDef* ) LFileDefs;
    LIST( AppUsage*) LApps;

    DisplayDriver*   ru_pDisplayDriver;
    PrintDriver*     ru_pPrinterDriver;
    FCWString        ru_currency;
    char             ru_separator;
    char             ru_decimal;

    char             nlsID[4];

    enum             { prcTrace=1, callTrace=2, sqlTrace=4, fileTrace=8,
                       sysTrace=16, timeTrace=32, DsTrace=64 };
    int              TraceOpt;
    enum             { EofOption=1, ErraOption=2, SendOnDisplay=4, BeepOnNumErrOpt=8,
                       UpDownIsTabOpt=16   };
    int              RunOptions;
    TraceFile*       pTrace;                          /* trace file control*/
    MsgBlock*        pMsgObj;                             /* message object*/
    MDBOBJ*          pDbObj;                         /* ptr database object*/
    ShareTblList*    pSharedTables;
    int              sysCode;          /* CICS SYSCODE Gen Option          */

    StartCode        stCode;           /* App startup code    <D4299>      */
    CMLONG           connHandle;       /* CSO connection handle <DUOW>     */

    FCWString        SEGTR;            /* Saved EZESEGTR                   */
    short            WrkqRecCnt;       /* Work queue record count          */
    short            MsgqRecCnt;       /* Message queue record count       */
    char             SSMStatus;
    FCWString        SSMName;
    FCWApp*          InitialApp;
    segType          SegmentType;

  public:

    FCWRunUnit ();
    ~FCWRunUnit ();

    LIST( FileIODriver* ) LIODrivers;
    FileIODriver*         RegisterDriver(char*name);

    unsigned int ParmInit(int argc, char* argv[]);
    unsigned int EnvInit();
    void         InitFileDefList();
    void         RegisterFile(File*);
    FileDef*     findFileDef(char*);
    File*        AttachFileC( FileRecord* );
    File*        AttachFile ( FileRecord* );
    void         DetachFile(File*);

    void         RunApp(char*);
    void         transferCICS(TransType, char*);
    void         transferCICSApp();
    void         CallApp(char*, char*, char*, FCWCallBlock*);
    void         CallApp(char*, FCWCICSLinkage*, void*);

    void         Terminate()          { mode = terminate; }
    Bool         isTerminate()        { return (mode == terminate); }
    void         Abend()              { mode = abend;     }
    RunMode      GetMode()            { return mode; }
    void         SetMode( RunMode m ) { mode = m; }
    TransInfo&   GetTransInfo()       { return ti; }

    void         CreatxSetup(Record*, int);
    unsigned int CreatxExec();
    void         CreatxExec(FCWCICSLinkage* , int , char*);

    void         SetupTransfer (TransType, char*, int, Record*, Map*);
    void         SetupCTransfer (TransType, char*, int, Record*, Map*);
    void         RetrieveData (char*, long);

    void         RUControl(int argc, char* argv[]);
    void         SetRCode( int rc ) { rcode = rc;}
    int          RCode() { return rcode; }

    void         AppPush(FCWApp*);
    void         AppPop ();
    FCWApp*      AppPeek();
    STACK(FCWApp*)& AppStack();

    enum         { FreeModIfCountEq1 = 0, DecrementCountOnly = 1 };
    PMAINAPP     LoadApp( char* appName, char* qualName, char* procName,
                          int callFlag );
    void         FreeApp( char* name, short opt = FreeModIfCountEq1  );

    void         LoadMsgTable();
    void         RetrieveMsg( int, char*, int );
    int          CommitRollbackFileChanges(int);

    int          Commit( int option = OPT_NOREPLY );   /* DUOW             */
    int          RollBack( int option = OPT_NOREPLY ); /* DUOW             */

    Bool         GetRAFInit() { return bRAFInit; }
    void         SetRAFInit(Bool f) { bRAFInit = f; }

    DisplayDriver* pDisplayDriver();
    PrintDriver*   pPrinterDriver();
    FCWString&     CurrencySymbol()  { return ru_currency; }
    char           SeparatorSymbol() { return ru_separator; }
    char           DecimalSymbol()   { return ru_decimal; }

    int          PrcTraceOn()   { return TraceOpt   & prcTrace;      }
    int          CallTraceOn()  { return TraceOpt   & callTrace;     }
    int          SQLTraceOn()   { return TraceOpt   & sqlTrace;      }
    int          FileTraceOn()  { return TraceOpt   & fileTrace;     }
    int          SysTraceOn()   { return TraceOpt   & sysTrace;      }
    int          TimeTraceOn()  { return TraceOpt   & timeTrace;     }
    int          DsTraceOn()    { return TraceOpt   & DsTrace;       }

    int          EofOptionOn()  { return RunOptions & EofOption;       }
    int          ErraOptionOn() { return RunOptions & ErraOption;      }
    int          SODOptionOn()  { return RunOptions & SendOnDisplay;   }
    int          BeepOnNumErr() { return RunOptions & BeepOnNumErrOpt; }
    int          UpDownIsTab()  { return RunOptions & UpDownIsTabOpt;  }
    Bool         AuxQOptionOn();

    TraceFile&     Trace();
    MsgBlock&      MsgObj()       { return *pMsgObj; }
    MDBOBJ&        DbmObj()       { return *pDbObj; }
    ShareTblList&  shareTblList() { return *pSharedTables; }

    void         ReturnTransfMapInfo(FCWString&, char *&);
    char*        NLSId()         { return nlsID; }

    LIST( RPCDriver* ) LRPCDrivers;
    RPCDriver*   RegisterRPCDriver(char*name);

    char         startcode;
    Bool         terminalAttached;

    int              SysCodeON()        { return sysCode; }
    void             SysCodeON( int n ) { sysCode = n; }
    void             SetStartCode( StartCode c ) { stCode = c; };/* <D4299>*/
    StartCode        GetStartCode( )             { return stCode; };

    CMLONG           GetConnHandle();  /* <DUOW>                           */
    CMLONG           FreeConnHandle(); /* <DUOW>                           */

    // psuedo
    void             deleteWorkQ();
    void             setSEGTR( FCWString s )  { SEGTR = s; };
    FCWString&       getSEGTR( )              { return SEGTR; };
    short            getWrkRecCnt()           { return WrkqRecCnt; };
    short            getMsgRecCnt()           { return MsgqRecCnt; };
    void             setWrkRecCnt( short n )  { WrkqRecCnt = n; };
    void             setMsgRecCnt( short n )  { MsgqRecCnt = n; };
    char             getSSMStatus()           { return SSMStatus; };
    void             setSSMStatus( char s )   { SSMStatus = s; };
    FCWString const& getSSMName()             { return SSMName; };
    void             setSSMName( char* s )    { SSMName = s; };
    segType          getSegType()             { return SegmentType; };
    void             setSegType( segType t )  { SegmentType = t; };

};

#if defined( FCW_APPLICATION ) && defined ( FCW_NT )
   __declspec( dllimport ) FCWRunUnit* pRU;
   __declspec( dllimport ) Timer*      WgsTimer;
#else
   extern FCWRunUnit* pRU;
   extern Timer* WgsTimer;
#endif

/*-------------------------------------------------------------------------*/
/*  FCWRunUnit inlines                                                     */
/*-------------------------------------------------------------------------*/
inline
FCWApp* FCWRunUnit::AppPeek()
{
   FCWApp* pApp=NULL;
   appstack.peek(pApp);
   return pApp;
}

/*-------------------------------------------------------------------------*/
/*  exception handler for the new function                                 */
/*-------------------------------------------------------------------------*/
extern void freeStorageException();

/*-------------------------------------------------------------------------*/
/*  EZECOMIT and EZEROLLB STUFF                                            */
/*-------------------------------------------------------------------------*/
#define COMMIT_FLAG   1
#define ROLLBACK_FLAG 2

extern int  CallEntryPoint(PCALLAPP, char*, FCWCallBlock*);

#endif
