/*****************************************************************************/
/*                                                                           */
/*                           OCO SOURCE MATERIALS                            */
/*                             IBM CONFIDENTIAL                              */
/*                                    OR                                     */
/*                        IBM CONFIDENTIAL RESTRICTED                        */
/*            WHEN COMBINED WITH THE AGGREGATED OCO SOURCE MODULES           */
/*                           FOR THIS PROGRAM PRODUCT                        */
/*                                                                           */
/*    5622-580 VisualAge Generator Developer                                 */
/*    5622-585 VisualAge Generator Workgroup Services for OS/2 V2.2          */
/*    5622-587 VisualAge Generator Workgroup Services for AIX V2.2           */
/*    5639-A26 VisualAge Generator Workgroup Services for Windows NT V2.2    */
/*                     (C) COPYRIGHT IBM CORP. 1994,1996                     */
/*                                                                           */
/*****************************************************************************/
/*********************************************************************/
/*  File Name: cso2api.h                                             */
/*********************************************************************/
/*  Type    Date    Userid    Description of problem                 */
/*                                                                   */
/*  A1     9/20/95  JSnyder   F3502 - BIDI Attribute Conversion      */
/*  B1     2/06/96  SRobin    F4346 - DUOW Support                   */
/*  B2     3/01/96  JSnyder   F4449 - Changes for C++ WGS compiles   */
/*                                    under Windows.  Changed EXPORT */
/*                                    define to CSOEXPORT.           */
/*  B3     3/07/96  JSnyder   F4060 - DCE/NT Line Item               */
/*  B4     3/28/96  JSnyder   F4472 - DCE/NT Line Item               */
/*  B5     4/14/96  JSnyder   F4702 - DCE/NT Line Item               */
/*  B6     4/15/96  JSnyder   F4702 - Add lines for IBMCPPW per Rob  */
/*  B7     6/19/96  CIPRIANO  D5250 - CMGETERROR intial code         */
/*                                                                   */
/*********************************************************************/

#ifndef CSO2API_H
#define CSO2API_H

/* Types */
typedef char    CMCHAR;       /* character                     */
typedef CMCHAR  CMNAME;       /* name (null terminated string) */
typedef CMCHAR  CMCHAR2[2];   /* Two character field           */
typedef CMCHAR2 CMRCHAR;      /* DBCS replacement character    */
typedef CMCHAR  CMCHAR4[4];   /* Four character field          */
typedef CMCHAR  CMCHAR8[8];   /* Eight character field         */
typedef CMCHAR  CMCHAR18[18]; /* Eighteen character field      */
typedef CMCHAR  CMEMSG[72];   /* Error message                 */
typedef CMCHAR  CMMSG;        /* null terminated error str  @B7*/
typedef CMCHAR  CMSBT[256];   /* Single byte conversion array  */
typedef CMCHAR *CMDBT[256];   /* Double byte conversion array  */
typedef CMCHAR  CMPARM;       /* parameter - format unknown    */
typedef CMPARM *PCMPARM;      /* parameter pointer             */
typedef CMCHAR  CMDESC;       /* parameter buffer description  */
typedef CMDESC *PCMDESC;      /* description pointer           */
typedef long    CMLONG;       /* long integer                  */
typedef short   CMSHORT;      /* short integer                 */
typedef CMLONG  CMCC;         /* completion code               */
typedef void*   CMSQLCA;      /* completion code            @B1*/

/* Constant Values */
#define CMCTNAMEL 8           /* Conversion table name length  */
#define CMRCHARL  2           /* DBCS replacement char length  */

/* Constant Values for TRUE and FALSE */
#define TRUE       1
#define FALSE      0

/* Constant Values for Completion Code */
#define CMCC_OK    0
#define CMCC_SQLWARN  2                                            /*@B1*/
#define CMCC_WARN  4
#define CMCC_ERROR 8
#define CMCC_12BYTE_ERROR 12
#define CMCC_SECURITY 16

/* Constant values for Connect Type */
#define  CMCONCT_IMPLICIT     1
#define  CMCONCT_EZECONCT     2

/* Constant values for Unit of Work Options */                  /*@B1*/
#define CMCONCT_RUOW    "R"                                     /*@B1*/
#define CMCONCT_D1E       "D1E"                                 /*@B1*/
#define CMCONCT_D1C       "D1C"                                 /*@B1*/
#define CMCONCT_D1A       "D1A"                                 /*@B1*/
#define CMCONCT_D2E       "D2E"                                 /*@B1*/
#define CMCONCT_D2C       "D2C"                                 /*@B1*/
#define CMCONCT_D2A      "D2A"                                  /*@B1*/
#define CMCONCT_DISC        "DISC"                              /*@B1*/
#define CMCONCT_DALL        "DALL"                              /*@B1*/
#define CMCONCT_DCURRENT    "DCUR"                              /*@B1*/
#define CMCONCT_SET         "SET"                               /*@B1*/

/* Constant values for Servername Type */
#define CMCONCT_BLANKS        1
#define CMCONCT_RESET          2

/* Constant values for Connect Type */
#define CMCONCT_SQL_PROCESS  1
#define CMCONCT_EZECONCT     2

/* Constant value for Number Connect Settings  */
#define NUMSETTINGS       3

/* Linkage Table Structure */
#define MAX_APPLNAME    9
#define MAX_LIBRARY     20
#define MAX_EXTNAME     40
#define MAX_CONTABLE    9     /* 8 chars + 1 for NULL */
#define MAX_LOCATION    20
#define MAX_SERVERID    20
#define MAX_LINKTBLNAME 80

typedef struct
{
  CMCHAR4 StrucId;                           /* Structure identifier "COD" */
  CMLONG  Version;                           /* Structure version number   */
  CMLONG  Protocol;                          /* Communications protocol    */
  CMLONG  LuwType;                           /* Logical unit of work type  */
  CMLONG  AppType;                           /* Remote application type    */
  CMLONG  Parmform;                          /* Parameter format           */
  CMNAME  ConversionTable[MAX_CONTABLE];     /* Conversion table name      */
  CMNAME  Location[MAX_LOCATION];            /* Server system name         */
  CMNAME  ServerId[MAX_SERVERID];            /* Server channel id          */
  CMNAME  LinkageTableName[MAX_LINKTBLNAME]; /* Linkage table name         */
  CMNAME  Library[MAX_LIBRARY];              /* Library name               */
  CMNAME  ExtName[MAX_EXTNAME];              /* External name              */
} CMCOD;

/* Constant values for StrucId */
#define CMCOD_STRUC_ID "COD"

/* Constant values for Version */
#define CMCOD_VERSION_1 1

/* Constant values for communications protocol */
#define CMST_RUNTIME_BIND  0
#define CMST_ROUTING_TABLE 1
#define CMST_DNA_ECI_C2    2
#define CMST_DNA_LU2       3
#define CMST_DNA_LU62      4
#define CMST_DNA_TCPIP     5
#define CMST_DNA_NPIPES    6
#define CMST_ECI_C2        7  /* CICS  OS/2  */
#define CMST_ECI_CM        8  /* CICSCLIENT  */
#define CMST_CA400         9
#define CMST_DBSP          10
#define CMST_APPC_IMS      11
#define CMST_CMCONCT       12             /* @B1 */
#define CMST_DCE           13  /* DCE        @B3 */
#define CMST_DCE_SECURE    14  /* DCE_SECURE @B4 */

/* Constant Values for Logical Unit of Work Type */
#define CMLUW_CLIENT 0
#define CMLUW_SERVER 1

/* Constant Values for Remote Application Type */
#define CMLUW_VG    0
#define CMLUW_NONVG 1

/* Constant Values for Parameter Format    */
#define CMPF_COMMPTR  0
#define CMPF_COMMDATA 1

/* Constant Values for Conversion Table Name */
#define CMCT_NO_CONVERSION  0
#define CMCT_DEFAULT_NLS    1
#define CMCT_DEFAULT_SYSTEM 2
#define CMCT_DNA_CONVERSION 3

/* Constant Values for Server System Name */
#define CMLO_NO_LOCATION 0

/* Constant Values for Server Channel Id */
#define CMSE_NO_SERVER_ID 0

/* CMCVOD - Convert Options Descriptor  */
typedef struct
{
  CMCHAR4  StrucId;                         /* Structure identifier "CVOD" */
  CMLONG   Version;                         /* Structure version number    */
  CMLONG   Direction;                       /* Direction                   */
  CMNAME   ConversionTable[MAX_CONTABLE];   /* Conversion Table Name       */
} CMCVOD;


/* Constant values for Structure identifier "CVOD"                   */
#define CMCVOD_STRUC_ID          "CVOD"


/* Constant values for Structure version number                      */
#define CMCVOD_VERSION_1         1


/* Constant values for Direction                                     */
#define CMCD_LOCAL_TO_REMOTE     1
#define CMCD_REMOTE_TO_LOCAL     2

typedef struct
{
  CMCC   CompCode;      /* Completion code                    */
  CMLONG Reason;        /* Reason code (Error message number) */
  CMLONG EmsgCount;     /* Error insert count                 */
  CMEMSG Emsg[10];      /* Error insert array                 */
} CMCOMP;

/* Prototypes */
#if defined __OS2__ || defined _AIX

  #define CSOEXPORT                        /* @B2 */
  #undef FAR                               /* @B2 */
  #define FAR                              /* @B2 */

  #if defined __OS2__
    #define SYSTEM _System
  #else
    #define SYSTEM
  #endif

  #if defined __IBMCPP__ || defined __cplusplus
    extern "C" {
  #endif

  /* Client access initialization */
  CMCC SYSTEM CMINIT(
             CMLONG *Hconn,         /* Connection handle (output)            */
             CMCOMP *Cmcomp,        /* Completion status (output)            */
             void   *winHandle,     /* Window handle used by Windows (input) */
             CMLONG *forceNewHandle /* Returns new handle (input)            */
             );

  /* Client access server call */
  CMCC SYSTEM CMCALL(
             CMLONG Hconn,         /* Connection handle (input)              */
             CMNAME *Applname,     /* Server application name (input)        */
             CMLONG ParmCount,     /* Parameter count (input)                */
             CMPARM **Parameter,   /* Parameter pointer array (input/output) */
             CMDESC **Description, /* Desc pointer array (input)             */
             CMCOD  *Cmcod,        /* Call options descriptor (input)        */
             CMCOMP *Cmcomp        /* Completion status (output)             */
             );

  /* Client access close */
  CMCC SYSTEM CMCLOSE(
             CMLONG Hconn,         /* Connection handle (input)  */
             CMCOMP *Cmcomp        /* Completion status (output) */
             );

  /* Client access commit */
  CMCC SYSTEM CMCOMMIT(
             CMLONG Hconn,         /* Connection handle (input)  */
             CMCOMP *Cmcomp        /* Completion status (output) */
             );

  /* Client access rollback */
  CMCC SYSTEM CMROLLBK(
             CMLONG Hconn,         /* Connection handle (input)  */
             CMCOMP *Cmcomp        /* Completion status (output) */
             );

  /* Client access convert */
  CMCC SYSTEM CMCONV(
             CMLONG Hconn,         /* Client access handle (input)       */
             CMCVOD *Cmcvod,       /* Convert options descriptor (input) */
             CMPARM *Parameter,    /* Parameter (input/output)           */
             CMDESC *Description,  /* Parameter Description (input)      */
             CMCOMP *Cmcomp        /* Completion status (output)         */
             );

  /* Client access get error */
  CMCC SYSTEM CMGETERROR(                                          /*@B7 */
             CMCOMP *Cmcomp,       /* Completion status (input)          */
             CMLONG *errStrBufLen, /* error string buffer length (i/o)   */
             CMMSG  *errStrBuf     /* error string buffer (output)       */
             );

  /* Client access Common Set Current Communication Handle */     /*@B1*/
  CMCC SYSTEM CMSetCurrentHandle(
             CMLONG    *Hconn,                                         /*@B1*/
             CMCOMP   *Cmcomp                                       /*@B1*/
             );

  /* Client access Common Get Database Version  */               /*@B1*/
  CMCC SYSTEM CMGetDBVersion(
             CMLONG    Hconn,                                           /*@B1*/
             short *Version,                                             /* @B1 */
             CMCOMP   *Cmcomp                                       /*@B1*/
             );


  /* Client access Common connect  */                                   /*@B1*/
  CMCC SYSTEM CMCONCT(                                                  /*@B1*/
             CMLONG    Hconn,                                           /*@B1*/
             CMLONG    *ConnectReason,                                  /*@B1*/
             CMCHAR8   *pUserid,                                        /*@B1*/
             CMCHAR8   *pPassword,                                      /*@B1*/
             CMCHAR18   *pServerName,                                   /*@B1*/
             CMCHAR8   *pProduct,                                       /*@B1*/
             CMCHAR8   *pRelease,                                       /*@B1*/
             CMCHAR8   *pUow,                                           /*@B1*/
             CMSQLCA   *pSQLCA,                                         /*@B1*/
             CMCOMP   *Cmcomp
             );
  #if defined __IBMCPP__ || defined __cplusplus
    }
  #endif

#else

  #define CSOEXPORT _export
  #define SYSTEM

  #if defined CSOWIN32
     #undef CSOEXPORT                                                    /*@B2*/
     #if defined __IBMCPP__                                              /*@B6*/
              #define CSOEXPORT __cdecl                                       /*@B6*/
     #else                                                               /*@B6*/
              #define CSOEXPORT _declspec(dllexport)                          /*@B2*/
     #endif                                                              /*@B6*/
     #undef FAR                                                          /*@B5*/
     #define FAR                                                         /*@B5*/
  #endif

  #ifdef __cplusplus
    extern "C" {            /* Assume C declarations for C++ */
  #endif                    /* __cplusplus */

  /* Client access initialization */
  CMCC FAR CSOEXPORT CMINIT(CMLONG *, CMCOMP *, void *, CMLONG *);      /*@B2*/

  /* Client access server call */
  CMCC FAR CSOEXPORT CMCALL(CMLONG, CMNAME *, CMLONG, CMPARM **, CMDESC **, /*@B2*/
                         CMCOD *, CMCOMP *);

  /* Client access close */
  CMCC FAR CSOEXPORT CMCLOSE(CMLONG, CMCOMP *);                         /*@B2*/

  /* Client access commit */
  CMCC FAR CSOEXPORT CMCOMMIT(CMLONG, CMCOMP *);                        /*@B2*/

  /* Client access rollback */
  CMCC FAR CSOEXPORT CMROLLBK(CMLONG, CMCOMP *);                        /*@B2*/

  /* Client access convert */
  CMCC FAR CSOEXPORT CMCONV(CMLONG, CMCVOD *, CMPARM *, CMDESC *, CMCOMP *); /*@B2*/

  /* Client access get error */
  CMCC FAR CSOEXPORT CMGETERROR(                                   /*@B7 */
             CMCOMP *Cmcomp,       /* Completion status (input)          */
             CMLONG *errStrBufLen, /* error string buffer length (i/o)   */
             CMMSG  *errStrBuf     /* error string buffer (output)       */
             );

  /* Client access Common Set Current Communication Handle */     /*@B1*/
  CMCC FAR CSOEXPORT CMSetCurrentHandle(CMLONG  *, CMCOMP *);      /*@B1*/

  /* Client access Common Get Database Version  */               /*@B1*/
  CMCC FAR CSOEXPORT CMGetDBVersion(CMLONG, short *,  CMCOMP *);   /*@B1*/

  /* Client access Common connect  */
  CMCC FAR CSOEXPORT CMCONCT(CMLONG, CMLONG *, CMCHAR8 *, CMCHAR8 *, CMCHAR18 *, /*@B2*/
                                                                  CMCHAR8 *, CMCHAR8 *, CMCHAR8 *, CMSQLCA *, CMCOMP *);

  #ifdef __cplusplus
    }                       /* Assume C declarations for C++ */
  #endif                    /* __cplusplus */

#endif


/* Entry Points Structure */
struct entryPoints
{
  CMCC (*CMDV_INIT)(void **, CMCOMP *, void *);
  CMCC (*CMDV_CALL)(void *, CMNAME *, CMLONG, CMPARM **, CMDESC **, CMCOD *,
                    CMCOMP *);
  CMCC (*CMDV_CLOSE)(void *, CMCOMP *);
  CMCC (*CMDV_COMMIT)(void *, CMCOMP *);
  CMCC (*CMDV_ROLLBK)(void *, CMCOMP *);
  CMCC (*CMDV_CONV)();
  CMCC (*CMDV_CONCT)(void *, CMLONG, CMCHAR8 , CMCHAR8 , CMCHAR18 , CMCHAR8,
                     CMCHAR8, CMSQLCA, CMCOMP *);                       /*@B1*/
};


/* DB2 Entry Points Structure */                                        /*@B1*/
struct db2entryPoints                                                   /*@B1*/
{                                                                       /*@B1*/
  CMCC (*CMCONCT_CONNECT)(void *, CMLONG   *, CMCHAR8,  CMCHAR8,  CMCHAR18 *, /*@B1*/
                    CMCHAR8  *,  CMCHAR8  *, CMCHAR8  *, CMSQLCA  *, CMCOMP  *, int); /*@B1*/
  CMCC (*CMCONCT_COMMIT)(void *, CMCOMP *);                             /*@B1*/
  CMCC (*CMCONCT_ROLLBACK)(void *, CMCOMP *);                           /*@B1*/
};                                                                      /*@B1*/


/* VG data format description headers */
#define SKIP_BIDI_ATTRIB_CONV  0xF2             /* flag for skipping BIDI @A1 */
                                                /*  attribute conversion  @A1 */
#define CONV_MAX_LENGTH  0xF3
#define RET_LEN_DATA     0xF4
#define DLI_SEH_DATA_LEN 0xF5
#define MAP_REC_IND      0xF6
#define SQL_REC_IND      0xF7
#define WORK_AREA        0xF8
#define INT_DATA_LEN     0xF9
#define EXT_DATA_LEN     0xFA
#define NUM_OCC_FLD_IND  0xFB
#define VAR_OCC_STR      0xFC
#define OCC_STR          0xFD
#define REC_NAME         0xFE
#define END_DESC         0xFF
#define DATA_NO_CONV     0x00
#define DATA_BIN         0x01
#define DATA_CHA         0x02
#define DATA_DBCS        0x03
#define DATA_HEX         0x04
#define DATA_MIX         0x05
#define DATA_NUM         0x06
#define DATA_NUMC        0x07
#define DATA_PACK        0x08
#define DATA_PACKF       0x09

#define MAX_VALUE_1_BYTE 0xFF

#endif
