/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/****************************************************************************/
/*                                                                          */
/*      DISCLAIMER OF WARRANTIES.  The following [enclosed] code is         */
/*      sample code created by IBM Corporation. This sample code is not     */
/*      part of any standard or IBM product and is provided to you solely   */
/*      for  the purpose of assisting you in the development of your        */
/*      presentation drivers.  The code is provided "AS IS", without        */
/*      warranty of any kind.  IBM shall not be liable for any damages      */
/*      arising out of your use of the sample code, even if they have been  */
/*      advised of the possibility of such damages.                         */
/*                                                                          */
/****************************************************************************/
/****************************************************************************/
/* PROGRAM NAME   : Sample BIDI protocol Converter                          */
/* AUTHOR         : Pat D                                                   */
/* FILENAME       : protcnv1.h                                              */
/* DATE WRITTEN   : 11-03-93                                                */
/* DESCRIPTION    : Additional structures for the sample protocol converter */
/*                                                                          */
/****************************************************************************/

#pragma pack(1)                           // Change to Byte alignment

//
// Include this private version of the public header pmsplb.h
//   only if pmsplb.h is not in the current headers
//
#ifndef PMSPLB_INCLUDED
 #include "pmsplnew.h"
#endif

typedef struct _QINTERPRETER {
   ULONG     cTotal;
   ULONG     cReturned;
   PRTINTERP prtInterpreter[1];
} QINTERPRETER;
typedef QINTERPRETER *PQINTERPRETER;

typedef struct _QINPUTBINS {
   ULONG     cTotal;
   ULONG     cReturned;
   PRTINPUTS prtInputs[1];
} QINPUTBINS;
typedef QINPUTBINS *PQINPUTBINS;

typedef struct _QOUTPUTBINS {
   ULONG      cTotal;
   ULONG      cReturned;
   PRTOUTPUTS prtOutputs[1];
} QOUTPUTBINS;
typedef QOUTPUTBINS *PQOUTPUTBINS;

typedef struct _QOPTIONS {
   ULONG      cTotal;
   ULONG      cReturned;
   ULONG      ulpszOptions[1];
} QOPTIONS;
typedef QOPTIONS *PQOPTIONS;

typedef struct _QFONTSINPUT {
   ULONG     ulInterpreterID;
   ULONG     ulStorageType;
   ULONG     ulFontID;
} QFONTSINPUT;
typedef QFONTSINPUT *PQFONTSINPUT;

typedef struct _QFONTS {
   ULONG     cTotal;
   ULONG     cReturned;
   PRTFONTS  prtFonts[1];
} QFONTS;
typedef QFONTS *PQFONTS;

typedef struct _QINPUTDATA {
   ULONG     ulInterpreterID;
   ULONG     ulJobID;
   ULONG     ulMaxJobs;
} QINPUTDATA;
typedef QINPUTDATA *PQINPUTDATA;

typedef struct _QJOBSCOMP {
   ULONG      cTotal;
   ULONG      cReturned;
   PRTJOBS    prtJobs[1];
} QJOBSCOMP;
typedef QJOBSCOMP *PQJOBSCOMP;

typedef struct _QJOBSQUEUED {
   ULONG      cTotal;
   ULONG      cReturned;
   PRTJOBS    prtJobs[1];
} QJOBSQUEUED;
typedef QJOBSQUEUED *PQJOBSQUEUED;

typedef struct _QSTATUS1 {
   BYTE       Id;
   BYTE       Status;
} QSTATUS1;
typedef QSTATUS1 *PQSTATUS1;

typedef struct _JAMALERTS {
   BYTE       JamLocationCode;
   BYTE       JamLocationID;
} JAMALERTS;
typedef JAMALERTS *PJAMALERTS;

typedef struct _ALERTMSG {
   BYTE       cAlerts;
   BYTE       AlertCode;
   BYTE       lAlertMsg;
   CHAR       AlertMsg[1];
} ALERTMSG;
typedef ALERTMSG *PALERTMSG;

typedef struct _QJOBID {
   ULONG      interpreterID;
   ULONG      ulPrinterJobID;
} QJOBID;
typedef QJOBID *PQJOBID;

typedef struct _BIDIDATA {
   ULONG      ulCommand;
   BYTE       Data[1];
} BIDIDATA;
typedef BIDIDATA *PBIDIDATA;

typedef struct _CMDSTRUCT {
   ULONG      cb;
   BYTE       Cmd[1];
} CMDSTRUCT;
typedef CMDSTRUCT *PCMDSTRUCT;

typedef struct _MULTICMD {
   ULONG      cb;
   ULONG      cCmdStructs;
   CMDSTRUCT  CmdStructs[1];
} MULTICMD;
typedef MULTICMD *PMULTICMD;

typedef struct _RESPPKT {
   ULONG      cb;
   ULONG      ulType;
   ULONG      cbData;
   BYTE       Data[1];
} RESPPKT;
typedef RESPPKT *PRESPPKT;

typedef struct _PRTPORT1 {
 ULONG ulBidiFlags;
 ULONG ulBidiType;
 ULONG ulPortType;
 PSZ   pszProtocol;
 PSZ   pszDeviceID;
 ULONG ulBidiLevel;
 ULONG ulPrinterStatus;
 ULONG ulAdapterLevel;
 ULONG ulMaxSendSize;
 ULONG ulMaxReceiveSize;
 ULONG ulMaxHeldResponses;
 } PRTPORT1;
typedef PRTPORT1 FAR *PPRTPORT1;

typedef struct _PRTDEVCHAR1 {
 USHORT majorRev;
 USHORT minorRev;
 USHORT cLogicalConnections;
 USHORT cPhysicalConnections;
 USHORT cActiveConnections;
 USHORT usReserved;
 USHORT extensionRev;
 USHORT maxJobsComplete;
 BYTE markingTech;
 BYTE colorCaps;
 USHORT colorlevels;
 BYTE duplexCaps;
 BYTE lengthUnits;
 USHORT horizRes;
 USHORT vertRes;
 USHORT speed;
 BYTE speedUnits;
 BYTE counterUnits;
 BYTE interpreters;
 BYTE inputs;
 BYTE outputs;
 BYTE options;
 BYTE msgLanguage;
 BYTE ubReserved;
 ULONG maxReceivePacketSize;
 USHORT maxOutstandingCmds;
 USHORT usReserved1;
 ULONG memory;
 PSZ   pszPrinterName;
 PSZ   pszRevision;
 PSZ   pszSerialNo;
 } PRTDEVCHAR1;
typedef PRTDEVCHAR1 FAR *PPRTDEVCHAR1;

typedef struct _PRTINTERP1 {
 BYTE logicalUnit;
 BYTE bReserved;
 USHORT usReserved;
 ULONG features;
 ULONG memory;
 USHORT fontcount;
 BYTE inputs;
 BYTE outputs;
 USHORT horizRes;
 USHORT vertRes;
 PSZ   pszInterpreter;
 } PRTINTERP1;
typedef PRTINTERP1 FAR *PPRTINTERP1;

typedef struct _PRTINPUTS1 {
 BYTE inputID;
 BYTE feedType;
 BYTE formChar;
 BYTE formSize;
 ULONG maxCapacity;
 USHORT maxCrossFormSize;
 USHORT maxFeedFormSize;
 USHORT curCrossFormSize;
 USHORT curFeedFormSize;
 USHORT topMargin;
 USHORT botMargin;
 USHORT leftMargin;
 USHORT rightMargin;
 PSZ   pszInput;
 PSZ   pszForm;
 } PRTINPUTS1;
typedef PRTINPUTS1 FAR *PPRTINPUTS1;

typedef struct _PRTOUTPUTS1 {
 BYTE outputID;
 BYTE positions;
 BYTE features1;
 BYTE features2;
 ULONG maxCapacity;
 PSZ   pszOutput;
 } PRTOUTPUTS1;
typedef PRTOUTPUTS1 FAR *PPRTOUTPUTS1;

typedef struct _PRTFONTS1 {
 BYTE interpreterID;
 BYTE bReserved;
 USHORT storageTypeID;
 ULONG storageType;
 ULONG fontID;
 PSZ   pszFontDescription;
 } PRTFONTS1;
typedef PRTFONTS1 FAR *PPRTFONTS1;

typedef struct _PRTALERT1 {
 PSZ   pszPortName;
 USHORT alertFlags;
 USHORT alertSeverity;
 ULONG alertCode;
 ULONG alertValue;
 BYTE interpreterID;
 BYTE bReserved;
 USHORT usPrinterJobID;
 PSZ   pszAlertMsg;
 } PRTALERT1;
typedef PRTALERT1 FAR *PPRTALERT1;

typedef struct _CNVSEND {
    ULONG       signature;      /* signature word for validating memory  */
    ULONG       cb;             /* number of bytes allocated             */
    PFN         pfnPdSendCmd;   /* Port Driver send routine address      */
    PSZ         pszPortName;    /* The name of port to send the commands */
    ULONG       ulType;         /* Type of query and options             */
    ULONG       ulCommand;      /* Generic command Code                  */
    PMULTICMD   pMultiCmd;      /* Structure containing the commands to  */
                                /*    send.                              */
} CNVSEND;
typedef CNVSEND *PCNVSEND;

#define CS_SIGNATURE    0x53564E43  /* "CNVS" is the signature value */

#pragma pack()                            // Change back to default alignment

#define  RESP_SEND_PASSTHRU        0x01
#define  RESP_STARTJOB             0x02
#define  RESP_ENDJOB               0x03
#define  RESP_HOLDJOB              0x04
#define  RESP_RELEASEJOB           0x05
#define  RESP_CANCELJOB            0x06
#define  RESP_SETALERT_LEVEL       0x07
#define  RESP_INIT_PORTDRV         0x08
#define  RESP_RESET                0x09
#define  RESP_SHUTDOWN             0x0A
#define  RESP_INIT                 0x0B
#define  RESP_TERM                 0x0C
#define  RESP_RESPONSE_FMT         0x0D
#define  RESP_PACKET_SIZE          0x0E
#define  RESP_INIT_PROTCNV         0x0F
#define  RESP_SET_SW               0x10
#define  RESP_SET_PORTDRV          0x19
#define  RESP_START_PASSTHRU       0x1A
#define  RESP_END_PASSTHRU         0x1B
#define  RESP_END_ALERTSESSION     0x1C

#define  RESP_READ_PASSTHRU        0x8001
#define  RESP_Q_ALERT_LEVEL        0x8007
#define  RESP_Q_PORT               0x800B
#define  RESP_Q_SW                 0x800C
#define  RESP_Q_DEVICE             0x800D
#define  RESP_Q_INTERPRETER        0x800E
#define  RESP_Q_INPUTBINS          0x800F
#define  RESP_Q_OUTPUTBINS         0x8010
#define  RESP_Q_OPTIONS            0x8011
#define  RESP_Q_FONTS              0x8012
#define  RESP_Q_JOBS_COMPLETE      0x8013
#define  RESP_Q_JOBS_QUEUED        0x8014
#define  RESP_Q_STATUS             0x8015
#define  RESP_WAIT_ALERT           0x8016
#define  RESP_Q_JOBID              0x8017
#define  RESP_Q_RESPONSE_FMT       0x8018
#define  RESP_Q_PORTDRV            0x8019
#define  RESP_Q_DEVICEID           0x801A
#define  RESP_Q_DRVLEVEL           0x801B
#define  RESP_START_ALERTSESSION   0x801C
#define  RESP_READ_ALERTSESSION    0x801D

#define  REQ_READ_PASSTHRU         0x00000001
#define  REQ_Q_ALERT_LEVEL         0x00000001
#define  REQ_Q_PORT                0x00000001
#define  REQ_Q_SW                  0x00000001
#define  REQ_Q_DEVICE              0x0000000F
#define  REQ_Q_INTERPRETER         0x00000001
#define  REQ_Q_INPUTBINS           0X00000001
#define  REQ_Q_OUTPUTBINS          0x00000001
#define  REQ_Q_OPTIONS             0x00000001
#define  REQ_Q_FONTS               0x00000001
#define  REQ_Q_JOBS_COMPLETE       0x00000001
#define  REQ_Q_JOBS_QUEUED         0x00000001
#define  REQ_Q_STATUS              0x00000001
#define  REQ_WAIT_ALERT            0x00000001
#define  REQ_Q_JOBID               0x00000001
#define  REQ_Q_RESPONSE_FMT        0x00000001
#define  REQ_Q_PORTDRV             0x00000001
#define  REQ_Q_DEVICEID            0x00000001
#define  REQ_Q_DRVLEVEL            0x00000001
#define  REQ_READ_ALERTSESSION     0x00000001

#ifndef OFFSETOFLONG
#define OFFSETOFLONG(p)         (((PULONG)&(p))[0])
#endif

/* change the pointer to an offset to the beginning of the job structure */
#ifndef PTRTOOFFSET
#define PTRTOOFFSET(p, pbase) OFFSETOFLONG(pbase->p) -= (ULONG)pbase
#endif

#ifndef PTRTOOFFSET1
#define PTRTOOFFSET1(p, pbase,pbuf) OFFSETOFLONG(pbase->p) -= (ULONG)pbuf
#endif


/* change the offset from the beginning of the job structure to a pointer */

#ifndef OFFSETTOPTR
#define OFFSETTOPTR(p, pbase) pbase->p = (PVOID)(OFFSETOFLONG(pbase->p) ? \
                             ((PBYTE)pbase + OFFSETOFLONG(pbase->p)) : (PBYTE)NULL)
#endif

#ifndef OFFSETTOPTR1
#define OFFSETTOPTR1(p, pbase,pbuf) pbase->p = (PVOID)(OFFSETOFLONG(pbase->p) ? \
                         ((PBYTE)pbuf + OFFSETOFLONG(pbase->p)) : (PBYTE)NULL)
#endif

#ifndef GETPTRFROMOFFSET
#define GETPTRFROMOFFSET(p, pbase) (PVOID)(OFFSETOFLONG(pbase->p) ? \
                                   ((PBYTE)pbase + OFFSETOFLONG(pbase->p)) : (PBYTE)NULL)
#endif

#ifndef GETPTRFROMOFFSET1
#define GETPTRFROMOFFSET1(p, pbase, pbuf) \
                       (PVOID)(OFFSETOFLONG(pbase->p) ? \
                       ((PBYTE)pbuf + OFFSETOFLONG(pbase->p)) : (PBYTE)NULL)
#endif

