/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/****************************************************************************/
/*                                                                          */
/*      DISCLAIMER OF WARRANTIES.  The following [enclosed] code is         */
/*      sample code created by IBM Corporation. This sample code is not     */
/*      part of any standard or IBM product and is provided to you solely   */
/*      for  the purpose of assisting you in the development of your        */
/*      presentation drivers.  The code is provided "AS IS", without        */
/*      warranty of any kind.  IBM shall not be liable for any damages      */
/*      arising out of your use of the sample code, even if they have been  */
/*      advised of the possibility of such damages.                         */
/*                                                                          */
/****************************************************************************/
/****************************************************************************/
/* PROGRAM NAME   : Sample BIDI Protocol Converter                          */
/* AUTHOR         : Pat D                                                   */
/* FILENAME       : proctype.c                                              */
/* DATE WRITTEN   : 03-02-94                                                */
/* DESCRIPTION    : Routines to process the ulType parameter and call the   */
/*                  appropriate routines.                                   */
/*                                                                          */
/****************************************************************************/
/****************************************************************************/
/*                           Routines In File                               */
/*                      ProcTypeQAlertlevel()                               */
/*                      ProcTypeQDevice()                                   */
/*                      ProcTypeQInterpreter()                              */
/*                      ProcTypeQInputbins()                                */
/*                      ProcTypeQOutputbins()                               */
/*                      ProcTypeQOptions()                                  */
/*                      ProcTypeQFonts()                                    */
/*                      ProcTypeQJobscomp()                                 */
/*                      ProcTypeQJobsqueued()                               */
/*                      ProcTypeQStatus()                                   */
/****************************************************************************/

#define INCL_BASE
#define INCL_SPL
#define INCL_SPLBIDI
#define INCL_SPLERRORS
#define INCL_SPLFSE
#define INCL_SPLDOSPRINT
#include <os2.h>
#include <string.h>
#include "protcnv.h"
#include "protcnv1.h"
#include "cnvproto.h"

/****************************************************************************
 *
 * FUNCTION NAME = ProcTypeQAlertLevel
 *
 * DESCRIPTION   = Process the ulType for the Query Alert Level command
 *
 * INPUT         = pszPortName  - The name of the port to send the commands
 *               = ulType       - Type of set/query and options
 *               = pOutData     - Return buffer
 *               = pcbOutData   - Points to length of output buffer
 *               = pfGotResp    - Pointer to boolean value indicating whether
 *                                response was obtained
 *               = pfNeedResp   - Pointer to boolean value indicating whether
 *                                to wait for a response
 *               = prc          - Pointer to second return code for
 *                                   TYPE_CACHE_UPDATE
 *               = pMultiCmd    - Structure containing the commands to send
 *
 * OUTPUT        = None
 *
 * RETURN-NORMAL = 0(Successful)
 *
 * RETURN-ERROR  = rc(Failure, unable to build command)
 *
 ****************************************************************************/

ULONG APIENTRY ProcTypeQAlertlevel ( PSZ pszPortName, ULONG ulType,
                                     PVOID pOutData, PULONG pcbOutData,
                                     PBOOL pfGotResp, PBOOL pfNeedResp,
                                     PULONG prc, PMULTICMD *ppMultiCmd ) {

    ULONG rc = 0;
    BOOL  fGotResp = FALSE;
    BOOL  fNeedResp = 0;

    switch (ulType) {
    case TYPE_CACHE_ONLY:
      /*
       * Check for cached data
       */
      rc = GetQAlertlevelCmd ( pszPortName, pOutData, pcbOutData, &fGotResp );
      /*
       * If no error and no response received, set correct error
       */
      if (!rc && !fGotResp) {
          *pcbOutData = 0;
          rc = ERROR_INFO_NOT_AVAIL;
      }
      break;
    /*
     * For sample, consider Long and Short commands to be the same
     *  Actual converters may create different commands to be sent
     */
    case TYPE_SHORT_WAIT:
    case TYPE_LONG_WAIT:
      fNeedResp = REQ_Q_ALERT_LEVEL;
      rc = BuildQAlertlevelCmd ( pszPortName, ppMultiCmd );
      break;
    case TYPE_CACHE_UPDATE:
      /*
       * Check for cached data
       */
      rc = GetQAlertlevelCmd ( pszPortName, pOutData, pcbOutData, &fGotResp );
      /*
       * If no error and no response received, set correct error
       */
      if (!rc && !fGotResp) {
          *pcbOutData = 0;
          rc = ERROR_INFO_NOT_AVAIL;
      }
      /*
       * Build command needed to update cache
       *   Thread to update cache will be started in SplProtSendCmd
       *   Return code will indicate whether Build...Cmd was successful
       */
      *prc = BuildQAlertlevelCmd ( pszPortName, ppMultiCmd );
      break;
    default:
      rc = ERROR_INVALID_PARAMETER;
      break;
    }

    *pfGotResp = fGotResp;
    *pfNeedResp = fNeedResp;
    return(rc);

}

/****************************************************************************
 *
 * FUNCTION NAME = ProcTypeQDevice
 *
 * DESCRIPTION   = Process the ulType for the Query Device command
 *
 * INPUT         = pszPortName  - The name of the port to send the commands
 *               = ulType       - Type of set/query and options
 *               = pOutData     - Return buffer
 *               = pcbOutData   - Points to length of output buffer
 *               = pfGotResp    - Pointer to boolean value indicating whether
 *                                response was obtained
 *               = pfNeedResp   - Pointer to boolean value indicating whether
 *                                to wait for a response
 *               = prc          - Pointer to second return code for
 *                                   TYPE_CACHE_UPDATE
 *               = pMultiCmd    - Structure containing the commands to send
 *
 * OUTPUT        = None
 *
 * RETURN-NORMAL = 0(Successful)
 *
 * RETURN-ERROR  = rc(Failure, unable to build command)
 *
 ****************************************************************************/

ULONG APIENTRY ProcTypeQDevice ( PSZ pszPortName, ULONG ulType, PVOID pOutData,
                                 PULONG pcbOutData, PBOOL pfGotResp,
                                 PBOOL pfNeedResp, PULONG prc,
                                 PMULTICMD *ppMultiCmd ) {

    ULONG rc = 0;
    BOOL  fGotResp = FALSE;
    BOOL  fNeedResp = 0;

    switch (ulType) {
    case TYPE_CACHE_ONLY:
      /*
       * Check for cached data
       */
      rc = GetQDeviceCmd ( pszPortName, pOutData, pcbOutData, &fGotResp );
      /*
       * If no error and no response received, set correct error
       */
      if (!rc && !fGotResp) {
          *pcbOutData = 0;
          rc = ERROR_INFO_NOT_AVAIL;
      }
      break;
    /*
     * For sample, consider Long and Short commands to be the same
     *  Actual converters may create different commands to be sent
     */
    case TYPE_SHORT_WAIT:
    case TYPE_LONG_WAIT:
      fNeedResp = REQ_Q_DEVICE;
      rc = BuildQDeviceCmd ( pszPortName, ppMultiCmd );
      break;
    case TYPE_CACHE_UPDATE:
      /*
       * Check for cached data
       */
      rc = GetQDeviceCmd ( pszPortName, pOutData, pcbOutData, &fGotResp );
      /*
       * If no error and no response received, set correct error
       */
      if (!rc && !fGotResp) {
          *pcbOutData = 0;
          rc = ERROR_INFO_NOT_AVAIL;
      }
      /*
       * Build command needed to update cache
       *   Thread to update cache will be started in SplProtSendCmd
       *   Return code will indicate whether Build...Cmd was successful
       */
      *prc = BuildQDeviceCmd ( pszPortName, ppMultiCmd );
      break;
    default:
      rc = ERROR_INVALID_PARAMETER;
      break;
    }

    *pfGotResp = fGotResp;
    *pfNeedResp = fNeedResp;
    return(rc);

}

/****************************************************************************
 *
 * FUNCTION NAME = ProcTypeQInterpreter
 *
 * DESCRIPTION   = Process the ulType for the Query Interpreter command
 *
 * INPUT         = pszPortName  - The name of the port to send the commands
 *               = ulType       - Type of set/query and options
 *               = pInData      - Information required by the command
 *               = cbInData     - Length in bytes of data in pInData
 *               = pOutData     - Return buffer
 *               = pcbOutData   - Points to length of output buffer
 *               = pfGotResp    - Pointer to boolean value indicating whether
 *                                response was obtained
 *               = pfNeedResp   - Pointer to boolean value indicating whether
 *                                to wait for a response
 *               = prc          - Pointer to second return code for
 *                                   TYPE_CACHE_UPDATE
 *               = pMultiCmd    - Structure containing the commands to send
 *
 * OUTPUT        = None
 *
 * RETURN-NORMAL = 0(Successful)
 *
 * RETURN-ERROR  = rc(Failure, unable to build command)
 *
 ****************************************************************************/

ULONG APIENTRY ProcTypeQInterpreter ( PSZ pszPortName, ULONG ulType,
                                      PVOID pInData, ULONG cbInData,
                                      PVOID pOutData, PULONG pcbOutData,
                                      PBOOL pfGotResp, PBOOL pfNeedResp,
                                      PULONG prc, PMULTICMD *ppMultiCmd ) {

    ULONG rc = 0;
    BOOL  fGotResp = FALSE;
    BOOL  fNeedResp = 0;

    switch (ulType) {
    case TYPE_CACHE_ONLY:
      /*
       * Check for cached data
       */
      rc = GetQInterpreterCmd ( pszPortName, pOutData, pcbOutData, &fGotResp );
      /*
       * If no error and no response received, set correct error
       */
      if (!rc && !fGotResp) {
          *pcbOutData = 0;
          rc = ERROR_INFO_NOT_AVAIL;
      }
      break;
    /*
     * For sample, consider Long and Short commands to be the same
     *  Actual converters may create different commands to be sent
     */
    case TYPE_SHORT_WAIT:
    case TYPE_LONG_WAIT:
      fNeedResp = REQ_Q_INTERPRETER;
      rc = BuildQInterpreterCmd ( pszPortName, pInData, cbInData, ppMultiCmd );
      break;
    case TYPE_CACHE_UPDATE:
      /*
       * Check for cached data
       */
      rc = GetQInterpreterCmd ( pszPortName, pOutData, pcbOutData, &fGotResp );
      /*
       * If no error and no response received, set correct error
       */
      if (!rc && !fGotResp) {
          *pcbOutData = 0;
          rc = ERROR_INFO_NOT_AVAIL;
      }
      /*
       * Build command needed to update cache
       *   Thread to update cache will be started in SplProtSendCmd
       *   Return code will indicate whether Build...Cmd was successful
       */
      *prc = BuildQInterpreterCmd ( pszPortName, pInData, cbInData,
                                    ppMultiCmd );
      break;
    default:
      rc = ERROR_INVALID_PARAMETER;
      break;
    }

    *pfGotResp = fGotResp;
    *pfNeedResp = fNeedResp;
    return(rc);

}

/****************************************************************************
 *
 * FUNCTION NAME = ProcTypeQInputbins
 *
 * DESCRIPTION   = Process the ulType for the Query Input bins command
 *
 * INPUT         = pszPortName  - The name of the port to send the commands
 *               = ulType       - Type of set/query and options
 *               = pInData      - Information required by the command
 *               = cbInData     - Length in bytes of data in pInData
 *               = pOutData     - Return buffer
 *               = pcbOutData   - Points to length of output buffer
 *               = pfGotResp    - Pointer to boolean value indicating whether
 *                                response was obtained
 *               = pfNeedResp   - Pointer to boolean value indicating whether
 *                                to wait for a response
 *               = prc          - Pointer to second return code for
 *                                   TYPE_CACHE_UPDATE
 *               = pMultiCmd    - Structure containing the commands to send
 *
 * OUTPUT        = None
 *
 * RETURN-NORMAL = 0(Successful)
 *
 * RETURN-ERROR  = rc(Failure, unable to build command)
 *
 ****************************************************************************/

ULONG APIENTRY ProcTypeQInputbins ( PSZ pszPortName, ULONG ulType,
                                    PVOID pInData, ULONG cbInData,
                                    PVOID pOutData, PULONG pcbOutData,
                                    PBOOL pfGotResp, PBOOL pfNeedResp,
                                    PULONG prc, PMULTICMD *ppMultiCmd ) {

    ULONG rc = 0;
    BOOL  fGotResp = FALSE;
    BOOL  fNeedResp = 0;

    switch (ulType) {
    case TYPE_CACHE_ONLY:
      /*
       * Check for cached data
       */
      rc = GetQInputbinsCmd ( pszPortName, pOutData, pcbOutData, &fGotResp );
      /*
       * If no error and no response received, set correct error
       */
      if (!rc && !fGotResp) {
          *pcbOutData = 0;
          rc = ERROR_INFO_NOT_AVAIL;
      }
      break;
    /*
     * For sample, consider Long and Short commands to be the same
     *  Actual converters may create different commands to be sent
     */
    case TYPE_SHORT_WAIT:
    case TYPE_LONG_WAIT:
      fNeedResp = REQ_Q_INPUTBINS;
      rc = BuildQInputbinsCmd ( pszPortName, pInData, cbInData, ppMultiCmd );
      break;
    case TYPE_CACHE_UPDATE:
      /*
       * Check for cached data
       */
      rc = GetQInputbinsCmd ( pszPortName, pOutData, pcbOutData, &fGotResp );
      /*
       * If no error and no response received, set correct error
       */
      if (!rc && !fGotResp) {
          *pcbOutData = 0;
          rc = ERROR_INFO_NOT_AVAIL;
      }
      /*
       * Build command needed to update cache
       *   Thread to update cache will be started in SplProtSendCmd
       *   Return code will indicate whether Build...Cmd was successful
       */
      *prc = BuildQInputbinsCmd ( pszPortName, pInData, cbInData,
                                  ppMultiCmd );
      break;
    default:
      rc = ERROR_INVALID_PARAMETER;
      break;
    }

    *pfGotResp = fGotResp;
    *pfNeedResp = fNeedResp;
    return(rc);

}

/****************************************************************************
 *
 * FUNCTION NAME = ProcTypeQOutputbins
 *
 * DESCRIPTION   = Process the ulType for the Query Output bins command
 *
 * INPUT         = pszPortName  - The name of the port to send the commands
 *               = ulType       - Type of set/query and options
 *               = pInData      - Information required by the command
 *               = cbInData     - Length in bytes of data in pInData
 *               = pOutData     - Return buffer
 *               = pcbOutData   - Points to length of output buffer
 *               = pfGotResp    - Pointer to boolean value indicating whether
 *                                response was obtained
 *               = pfNeedResp   - Pointer to boolean value indicating whether
 *                                to wait for a response
 *               = prc          - Pointer to second return code for
 *                                   TYPE_CACHE_UPDATE
 *               = pMultiCmd    - Structure containing the commands to send
 *
 * OUTPUT        = None
 *
 * RETURN-NORMAL = 0(Successful)
 *
 * RETURN-ERROR  = rc(Failure, unable to build command)
 *
 ****************************************************************************/

ULONG APIENTRY ProcTypeQOutputbins ( PSZ pszPortName, ULONG ulType,
                                     PVOID pInData, ULONG cbInData,
                                     PVOID pOutData, PULONG pcbOutData,
                                     PBOOL pfGotResp, PBOOL pfNeedResp,
                                     PULONG prc, PMULTICMD *ppMultiCmd ) {

    ULONG rc = 0;
    BOOL  fGotResp = FALSE;
    BOOL  fNeedResp = 0;

    switch (ulType) {
    case TYPE_CACHE_ONLY:
      /*
       * Check for cached data
       */
      rc = GetQOutputbinsCmd ( pszPortName, pOutData, pcbOutData, &fGotResp );
      /*
       * If no error and no response received, set correct error
       */
      if (!rc && !fGotResp) {
          *pcbOutData = 0;
          rc = ERROR_INFO_NOT_AVAIL;
      }
      break;
    /*
     * For sample, consider Long and Short commands to be the same
     *  Actual converters may create different commands to be sent
     */
    case TYPE_SHORT_WAIT:
    case TYPE_LONG_WAIT:
      fNeedResp = REQ_Q_OUTPUTBINS;
      rc = BuildQOutputbinsCmd ( pszPortName, pInData, cbInData, ppMultiCmd );
      break;
    case TYPE_CACHE_UPDATE:
      /*
       * Check for cached data
       */
      rc = GetQOutputbinsCmd ( pszPortName, pOutData, pcbOutData, &fGotResp );
      /*
       * If no error and no response received, set correct error
       */
      if (!rc && !fGotResp) {
          *pcbOutData = 0;
          rc = ERROR_INFO_NOT_AVAIL;
      }
      /*
       * Build command needed to update cache
       *   Thread to update cache will be started in SplProtSendCmd
       *   Return code will indicate whether Build...Cmd was successful
       */
      *prc = BuildQOutputbinsCmd ( pszPortName, pInData, cbInData,
                                  ppMultiCmd );
      break;
    default:
      rc = ERROR_INVALID_PARAMETER;
      break;
    }

    *pfGotResp = fGotResp;
    *pfNeedResp = fNeedResp;
    return(rc);

}

/****************************************************************************
 *
 * FUNCTION NAME = ProcTypeQOptions
 *
 * DESCRIPTION   = Process the ulType for the Query Options command
 *
 * INPUT         = pszPortName  - The name of the port to send the commands
 *               = ulType       - Type of set/query and options
 *               = pOutData     - Return buffer
 *               = pcbOutData   - Points to length of output buffer
 *               = pfGotResp    - Pointer to boolean value indicating whether
 *                                response was obtained
 *               = pfNeedResp   - Pointer to boolean value indicating whether
 *                                to wait for a response
 *               = prc          - Pointer to second return code for
 *                                   TYPE_CACHE_UPDATE
 *               = pMultiCmd    - Structure containing the commands to send
 *
 * OUTPUT        = None
 *
 * RETURN-NORMAL = 0(Successful)
 *
 * RETURN-ERROR  = rc(Failure, unable to build command)
 *
 ****************************************************************************/

ULONG APIENTRY ProcTypeQOptions ( PSZ pszPortName, ULONG ulType,
                                  PVOID pOutData, PULONG pcbOutData,
                                  PBOOL pfGotResp, PBOOL pfNeedResp,
                                  PULONG prc, PMULTICMD *ppMultiCmd ) {

    ULONG rc = 0;
    BOOL  fGotResp = FALSE;
    BOOL  fNeedResp = 0;

    switch (ulType) {
    case TYPE_CACHE_ONLY:
      /*
       * Check for cached data
       */
      rc = GetQOptionsCmd ( pszPortName, pOutData, pcbOutData, &fGotResp );
      /*
       * If no error and no response received, set correct error
       */
      if (!rc && !fGotResp) {
          *pcbOutData = 0;
          rc = ERROR_INFO_NOT_AVAIL;
      }
      break;
    /*
     * For sample, consider Long and Short commands to be the same
     *  Actual converters may create different commands to be sent
     */
    case TYPE_SHORT_WAIT:
    case TYPE_LONG_WAIT:
      fNeedResp = REQ_Q_OPTIONS;
      rc = BuildQOptionsCmd ( pszPortName, ppMultiCmd );
      break;
    case TYPE_CACHE_UPDATE:
      /*
       * Check for cached data
       */
      rc = GetQOptionsCmd ( pszPortName, pOutData, pcbOutData, &fGotResp );
      /*
       * If no error and no response received, set correct error
       */
      if (!rc && !fGotResp) {
          *pcbOutData = 0;
          rc = ERROR_INFO_NOT_AVAIL;
      }
      /*
       * Build command needed to update cache
       *   Thread to update cache will be started in SplProtSendCmd
       *   Return code will indicate whether Build...Cmd was successful
       */
      *prc = BuildQOptionsCmd ( pszPortName, ppMultiCmd );
      break;
    default:
      rc = ERROR_INVALID_PARAMETER;
      break;
    }

    *pfGotResp = fGotResp;
    *pfNeedResp = fNeedResp;
    return(rc);

}

/****************************************************************************
 *
 * FUNCTION NAME = ProcTypeQFonts
 *
 * DESCRIPTION   = Process the ulType for the Query Fonts command
 *
 * INPUT         = pszPortName  - The name of the port to send the commands
 *               = ulType       - Type of set/query and options
 *               = pInData      - Information required by the command
 *               = cbInData     - Length in bytes of data in pInData
 *               = pOutData     - Return buffer
 *               = pcbOutData   - Points to length of output buffer
 *               = pfGotResp    - Pointer to boolean value indicating whether
 *                                response was obtained
 *               = pfNeedResp   - Pointer to boolean value indicating whether
 *                                to wait for a response
 *               = prc          - Pointer to second return code for
 *                                   TYPE_CACHE_UPDATE
 *               = pMultiCmd    - Structure containing the commands to send
 *
 * OUTPUT        = None
 *
 * RETURN-NORMAL = 0(Successful)
 *
 * RETURN-ERROR  = rc(Failure, unable to build command)
 *
 ****************************************************************************/

ULONG APIENTRY ProcTypeQFonts ( PSZ pszPortName, ULONG ulType, PVOID pInData,
                                ULONG cbInData, PVOID pOutData,
                                PULONG pcbOutData, PBOOL pfGotResp,
                                PBOOL pfNeedResp, PULONG prc,
                                PMULTICMD *ppMultiCmd ) {

    ULONG rc = 0;
    BOOL  fGotResp = FALSE;
    BOOL  fNeedResp = 0;

    switch (ulType) {
    case TYPE_CACHE_ONLY:
      /*
       * Check for cached data
       */
      rc = GetQFontsCmd ( pszPortName, pOutData, pcbOutData, &fGotResp );
      /*
       * If no error and no response received, set correct error
       */
      if (!rc && !fGotResp) {
          *pcbOutData = 0;
          rc = ERROR_INFO_NOT_AVAIL;
      }
      break;
    /*
     * For sample, consider Long and Short commands to be the same
     *  Actual converters may create different commands to be sent
     */
    case TYPE_SHORT_WAIT:
    case TYPE_LONG_WAIT:
      fNeedResp = REQ_Q_FONTS;
      rc = BuildQFontsCmd ( pszPortName, pInData, cbInData, ppMultiCmd );
      break;
    case TYPE_CACHE_UPDATE:
      /*
       * Check for cached data
       */
      rc = GetQFontsCmd ( pszPortName, pOutData, pcbOutData, &fGotResp );
      /*
       * If no error and no response received, set correct error
       */
      if (!rc && !fGotResp) {
          *pcbOutData = 0;
          rc = ERROR_INFO_NOT_AVAIL;
      }
      /*
       * Build command needed to update cache
       *   Thread to update cache will be started in SplProtSendCmd
       *   Return code will indicate whether Build...Cmd was successful
       */
      *prc = BuildQFontsCmd ( pszPortName, pInData, cbInData, ppMultiCmd );
      break;
    default:
      rc = ERROR_INVALID_PARAMETER;
      break;
    }

    *pfGotResp = fGotResp;
    *pfNeedResp = fNeedResp;
    return(rc);

}

/****************************************************************************
 *
 * FUNCTION NAME = ProcTypeQJobscomp
 *
 * DESCRIPTION   = Process the ulType for the Query Jobs Complete command
 *
 * INPUT         = pszPortName  - The name of the port to send the commands
 *               = ulType       - Type of set/query and options
 *               = pInData      - Information required by the command
 *               = cbInData     - Length in bytes of data in pInData
 *               = pOutData     - Return buffer
 *               = pcbOutData   - Points to length of output buffer
 *               = pfGotResp    - Pointer to boolean value indicating whether
 *                                response was obtained
 *               = pfNeedResp   - Pointer to boolean value indicating whether
 *                                to wait for a response
 *               = prc          - Pointer to second return code for
 *                                   TYPE_CACHE_UPDATE
 *               = pMultiCmd    - Structure containing the commands to send
 *
 * OUTPUT        = None
 *
 * RETURN-NORMAL = 0(Successful)
 *
 * RETURN-ERROR  = rc(Failure, unable to build command)
 *
 ****************************************************************************/

ULONG APIENTRY ProcTypeQJobscomp ( PSZ pszPortName, ULONG ulType,
                                   PVOID pInData, ULONG cbInData,
                                   PVOID pOutData, PULONG pcbOutData,
                                   PBOOL pfGotResp, PBOOL pfNeedResp,
                                   PULONG prc, PMULTICMD *ppMultiCmd ) {

    ULONG rc = 0;
    BOOL  fGotResp = FALSE;
    BOOL  fNeedResp = 0;

    switch (ulType) {
    case TYPE_CACHE_ONLY:
      /*
       * Check for cached data
       */
      rc = GetQJobscompCmd ( pszPortName, pOutData, pcbOutData, &fGotResp );
      /*
       * If no error and no response received, set correct error
       */
      if (!rc && !fGotResp) {
          *pcbOutData = 0;
          rc = ERROR_INFO_NOT_AVAIL;
      }
      break;
    /*
     * For sample, consider Long and Short commands to be the same
     *  Actual converters may create different commands to be sent
     */
    case TYPE_SHORT_WAIT:
    case TYPE_LONG_WAIT:
      fNeedResp = REQ_Q_JOBS_COMPLETE;
      rc = BuildQJobscompCmd ( pszPortName, pInData, cbInData, ppMultiCmd );
      break;
    case TYPE_CACHE_UPDATE:
      /*
       * Check for cached data
       */
      rc = GetQJobscompCmd ( pszPortName, pOutData, pcbOutData, &fGotResp );
      /*
       * If no error and no response received, set correct error
       */
      if (!rc && !fGotResp) {
          *pcbOutData = 0;
          rc = ERROR_INFO_NOT_AVAIL;
      }
      /*
       * Build command needed to update cache
       *   Thread to update cache will be started in SplProtSendCmd
       *   Return code will indicate whether Build...Cmd was successful
       */
      *prc = BuildQJobscompCmd ( pszPortName, pInData, cbInData, ppMultiCmd );
      break;
    default:
      rc = ERROR_INVALID_PARAMETER;
      break;
    }

    *pfGotResp = fGotResp;
    *pfNeedResp = fNeedResp;
    return(rc);

}

/****************************************************************************
 *
 * FUNCTION NAME = ProcTypeQJobsqueued
 *
 * DESCRIPTION   = Process the ulType for the Query Jobs Queued command
 *
 * INPUT         = pszPortName  - The name of the port to send the commands
 *               = ulType       - Type of set/query and options
 *               = pInData      - Information required by the command
 *               = cbInData     - Length in bytes of data in pInData
 *               = pOutData     - Return buffer
 *               = pcbOutData   - Points to length of output buffer
 *               = pfGotResp    - Pointer to boolean value indicating whether
 *                                response was obtained
 *               = pfNeedResp   - Pointer to boolean value indicating whether
 *                                to wait for a response
 *               = prc          - Pointer to second return code for
 *                                   TYPE_CACHE_UPDATE
 *               = pMultiCmd    - Structure containing the commands to send
 *
 * OUTPUT        = None
 *
 * RETURN-NORMAL = 0(Successful)
 *
 * RETURN-ERROR  = rc(Failure, unable to build command)
 *
 ****************************************************************************/

ULONG APIENTRY ProcTypeQJobsqueued ( PSZ pszPortName, ULONG ulType,
                                     PVOID pInData, ULONG cbInData,
                                     PVOID pOutData, PULONG pcbOutData,
                                     PBOOL pfGotResp, PBOOL pfNeedResp,
                                     PULONG prc, PMULTICMD *ppMultiCmd ) {

    ULONG rc = 0;
    BOOL  fGotResp = FALSE;
    BOOL  fNeedResp = 0;

    switch (ulType) {
    case TYPE_CACHE_ONLY:
      /*
       * Check for cached data
       */
      rc = GetQJobsqueuedCmd ( pszPortName, pOutData, pcbOutData, &fGotResp );
      /*
       * If no error and no response received, set correct error
       */
      if (!rc && !fGotResp) {
          *pcbOutData = 0;
          rc = ERROR_INFO_NOT_AVAIL;
      }
      break;
    /*
     * For sample, consider Long and Short commands to be the same
     *  Actual converters may create different commands to be sent
     */
    case TYPE_SHORT_WAIT:
    case TYPE_LONG_WAIT:
      fNeedResp = REQ_Q_JOBS_QUEUED;
      rc = BuildQJobsqueuedCmd ( pszPortName, pInData, cbInData, ppMultiCmd );
      break;
    case TYPE_CACHE_UPDATE:
      /*
       * Check for cached data
       */
      rc = GetQJobsqueuedCmd ( pszPortName, pOutData, pcbOutData, &fGotResp );
      /*
       * If no error and no response received, set correct error
       */
      if (!rc && !fGotResp) {
          *pcbOutData = 0;
          rc = ERROR_INFO_NOT_AVAIL;
      }
      /*
       * Build command needed to update cache
       *   Thread to update cache will be started in SplProtSendCmd
       *   Return code will indicate whether Build...Cmd was successful
       */
      *prc = BuildQJobsqueuedCmd ( pszPortName, pInData, cbInData,
                                  ppMultiCmd );
      break;
    default:
      rc = ERROR_INVALID_PARAMETER;
      break;
    }

    *pfGotResp = fGotResp;
    *pfNeedResp = fNeedResp;
    return(rc);

}

/****************************************************************************
 *
 * FUNCTION NAME = ProcTypeQStatus
 *
 * DESCRIPTION   = Process the ulType for the Query Status command
 *
 * INPUT         = pszPortName  - The name of the port to send the commands
 *               = ulType       - Type of set/query and options
 *               = pInData      - Information required by the command
 *               = cbInData     - Length in bytes of data in pInData
 *               = pOutData     - Return buffer
 *               = pcbOutData   - Points to length of output buffer
 *               = pfGotResp    - Pointer to boolean value indicating whether
 *                                response was obtained
 *               = pfNeedResp   - Pointer to boolean value indicating whether
 *                                to wait for a response
 *               = prc          - Pointer to second return code for
 *                                   TYPE_CACHE_UPDATE
 *               = pMultiCmd    - Structure containing the commands to send
 *
 * OUTPUT        = None
 *
 * RETURN-NORMAL = 0(Successful)
 *
 * RETURN-ERROR  = rc(Failure, unable to build command)
 *
 ****************************************************************************/

ULONG APIENTRY ProcTypeQStatus ( PSZ pszPortName, ULONG ulType,
                                 PVOID pInData, ULONG cbInData,
                                 PVOID pOutData, PULONG pcbOutData,
                                 PBOOL pfGotResp, PBOOL pfNeedResp,
                                 PULONG prc, PMULTICMD *ppMultiCmd ) {

    ULONG rc = 0;
    BOOL  fGotResp = FALSE;
    BOOL  fNeedResp = 0;

    switch (ulType) {
    case TYPE_CACHE_ONLY:
      /*
       * Check for cached data
       */
      rc = GetQStatusCmd ( pszPortName, pOutData, pcbOutData, &fGotResp );
      /*
       * If no error and no response received, set correct error
       */
      if (!rc && !fGotResp) {
          *pcbOutData = 0;
          rc = ERROR_INFO_NOT_AVAIL;
      }
      break;
    /*
     * For sample, consider Long and Short commands to be the same
     *  Actual converters may create different commands to be sent
     */
    case TYPE_SHORT_WAIT:
    case TYPE_LONG_WAIT:
      fNeedResp = REQ_Q_INPUTBINS;
      rc = BuildQStatusCmd ( pszPortName, pInData, cbInData, ppMultiCmd );
      break;
    case TYPE_CACHE_UPDATE:
      /*
       * Check for cached data
       */
      rc = GetQStatusCmd ( pszPortName, pOutData, pcbOutData, &fGotResp );
      /*
       * If no error and no response received, set correct error
       */
      if (!rc && !fGotResp) {
          *pcbOutData = 0;
          rc = ERROR_INFO_NOT_AVAIL;
      }
      /*
       * Build command needed to update cache
       *   Thread to update cache will be started in SplProtSendCmd
       *   Return code will indicate whether Build...Cmd was successful
       */
      *prc = BuildQStatusCmd ( pszPortName, pInData, cbInData, ppMultiCmd );
      break;
    default:
      rc = ERROR_INVALID_PARAMETER;
      break;
    }

    *pfGotResp = fGotResp;
    *pfNeedResp = fNeedResp;
    return(rc);

}

