/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/****************************************************************************/
/*                                                                          */
/*      DISCLAIMER OF WARRANTIES.  The following [enclosed] code is         */
/*      sample code created by IBM Corporation. This sample code is not     */
/*      part of any standard or IBM product and is provided to you solely   */
/*      for  the purpose of assisting you in the development of your        */
/*      presentation drivers.  The code is provided "AS IS", without        */
/*      warranty of any kind.  IBM shall not be liable for any damages      */
/*      arising out of your use of the sample code, even if they have been  */
/*      advised of the possibility of such damages.                         */
/*                                                                          */
/****************************************************************************/
/****************************************************************************/
/* PROGRAM NAME   : Sample BIDI Protocol Converter                          */
/* AUTHOR         : Pat D                                                   */
/* FILENAME       : buildcmd.c                                              */
/* DATE WRITTEN   : 02-03-94                                                */
/* DESCRIPTION    : Routines to build commands to send to the printer       */
/*                                                                          */
/****************************************************************************/

#define INCL_BASE
#define INCL_DOS
#define INCL_SPL
#define INCL_SPLBIDI
#define INCL_SPLERRORS
#include <os2.h>
#include <string.h>
#include <stdlib.h>
#include "protcnv.h"
#include "protcnv1.h"
#include "cnvproto.h"

/*
 * Local data
 */
UCHAR AlertLevelCmd[] = "Alert Level Command to Send to Printer";

UCHAR *DeviceCmd[] = { "Device Command #1",
                       "Device Command #2",
                       "Device Command #3",
                       "Device Command #4" };
#define NUMDEVICECMD 4

UCHAR InterpreterCmd[] =
               "Interpreter Command to send to printer for Interpreter ID " ;

UCHAR *InputbinsCmd[] = {
               "Input Bins Command to send to printer for Interpreter ID ",
               " and Input Bin " };

UCHAR *OutputbinsCmd[] = {
               "Output Bins Command to send to printer for Interpreter ID ",
               " and Output Bin " };

UCHAR OptionsCmd[] = "Options Command to Send to Printer";

UCHAR *FontsCmd[] = {
               "Fonts Command to send to printer for Interpreter ID ",
               ", Storage Type ",
               ", and Font ID "};

UCHAR *JobscompleteCmd[] = {
               "Job Complete Command to send to printer for Interpreter ID ",
               ", Job ID ",
               ", and Max Jobs = "};

UCHAR *JobsqueuedCmd[] = {
               "Job Queued Command to send to printer for Interpreter ID ",
               ", Job ID ",
               ", and Max Jobs = "};

UCHAR StatusCmd[] =
               "Status Command to send to printer with flags " ;

UCHAR *SetAlertlevelCmd[] = { "Set Alert Level command Job Flags = ",
                              "Set Alert Level command Interpreter Flags = ",
                              "Set Alert Level command Device Flags = ",
                              "Set Alert Level command ulTimed = " };
#define NUMSETALERTLEVELCMD 4

/****************************************************************************
 *
 * FUNCTION NAME = BuildQAlertlevelCmd
 *
 * DESCRIPTION   = Build the query alert level command for the printer
 *
 * INPUT         = pszPortName - The name of the port to send the commands
 *               = ppMultiCmd    - Structure containing the commands to send
 *
 * OUTPUT        = None
 *
 * RETURN-NORMAL = 0(Successful)
 *
 * RETURN-ERROR  = rc(Failure, Unable to build command)
 *
 ****************************************************************************/

ULONG BuildQAlertlevelCmd ( PSZ pszPortName, PMULTICMD *ppMultiCmd ) {

    ULONG rc = 0;
    ULONG cb = 0;
    ULONG cbCmd = 0;
    PMULTICMD pMultiCmd = NULL;

    cbCmd = strlen (AlertLevelCmd) + 1;
    cb += (cbCmd + sizeof(MULTICMD));
  EnterCnvSem();
    /*
     * Check for valid port name
     */
    if (!FindPort( pszPortName )) {
      LeaveCnvSem();
        return(ERROR_FILE_NOT_FOUND);
    }

    pMultiCmd = (PMULTICMD) AllocCnvMem ( cb );
  LeaveCnvSem();
    /*
     * If memory is available, create command structure
     */
    if (pMultiCmd) {
        pMultiCmd->cb = cb;
        pMultiCmd->cCmdStructs = 1;
        pMultiCmd->CmdStructs[0].cb = cbCmd;
        memcpy ( &(pMultiCmd->CmdStructs[0].Cmd) , AlertLevelCmd, cbCmd );
    } else {
        *ppMultiCmd = NULL;
        rc = ERROR_NOT_ENOUGH_MEMORY;
    }
    *ppMultiCmd = pMultiCmd;

    return(rc);

}

/****************************************************************************
 *
 * FUNCTION NAME = BuildQDeviceCmd
 *
 * DESCRIPTION   = Build the query device command for the printer
 *
 * INPUT         = pszPortName - The name of the port to send the commands
 *               = ppMultiCmd    - Structure containing the commands to send
 *
 * OUTPUT        = None
 *
 * RETURN-NORMAL = 0(Successful)
 *
 * RETURN-ERROR  = rc(Failure, Unable to build command)
 *
 ****************************************************************************/

ULONG BuildQDeviceCmd ( PSZ pszPortName, PMULTICMD *ppMultiCmd ) {

    ULONG cb = 0;
    ULONG cbCmd[NUMDEVICECMD];
    ULONG i;
    PMULTICMD pMultiCmd = NULL;
    PCMDSTRUCT pCmdStruct = NULL;

    /*
     * Check for valid port name
     */
    if (!CheckPort( pszPortName )) {
        return(ERROR_FILE_NOT_FOUND);
    }

    /*
     * Setup size of commands to send
     */
    for (i = 0; i < NUMDEVICECMD; i++) {
        cbCmd[i] = strlen (DeviceCmd[i]) + 1;
        cb += cbCmd[i] + sizeof(ULONG);
    }
    /*
     * First CMDSTRUCT size already calculated in loop
     */
    cb += sizeof (MULTICMD) - sizeof(CMDSTRUCT);
  EnterCnvSem();
    pMultiCmd = (PMULTICMD) AllocCnvMem ( cb );
  LeaveCnvSem();
    /*
     * Check for valid memory allocation
     */
    if (pMultiCmd) {
        pMultiCmd->cb = cb;
        pMultiCmd->cCmdStructs = NUMDEVICECMD;
        pCmdStruct = &(pMultiCmd->CmdStructs[0]);
        /*
         * Build the commands to send to the printer
         */
        for (i = 0; i < NUMDEVICECMD; i++) {
            pCmdStruct->cb = cbCmd[i];
            memcpy ( &(pCmdStruct->Cmd) , DeviceCmd[i], cbCmd[i] );
            pCmdStruct = (PCMDSTRUCT)((PBYTE)pCmdStruct + cbCmd[i] +
                                      sizeof(ULONG));
        }
    } else {
        *ppMultiCmd = NULL;
        return ( ERROR_NOT_ENOUGH_MEMORY );
    }
    *ppMultiCmd = pMultiCmd;

    return(0);

}

/****************************************************************************
 *
 * FUNCTION NAME = BuildQInterpreterCmd
 *
 * DESCRIPTION   = Build the query interpreter command for the printer
 *
 * INPUT         = pszPortName - The name of the port to send the commands
 *               = pInData     - Information required by the command
 *               = cbInData    - Length in bytes of data in pInData
 *               = ppMultiCmd    - Structure containing the commands to send
 *
 * OUTPUT        = None
 *
 * RETURN-NORMAL = 0(Successful)
 *
 * RETURN-ERROR  = rc(Failure, Unable to build command)
 *
 ****************************************************************************/

ULONG BuildQInterpreterCmd ( PSZ pszPortName, PVOID pInData, ULONG cbInData,
                             PMULTICMD *ppMultiCmd ) {

    ULONG  rc = 0;
    ULONG cbCmd = 0;
    ULONG cb = 0;
    PMULTICMD pMultiCmd = NULL;
    CHAR   szOutData[256];
    CHAR   szInterpreter[16];
    PULONG pulInData = (PULONG) pInData;

    /*
     * Check input for validity
     */
    if (!pInData || cbInData < sizeof(ULONG)) {
        return(ERROR_INVALID_PARAMETER);
    }
    /*
     * Find port instance data
     */
    if (!CheckPort( pszPortName )) {
        return(ERROR_FILE_NOT_FOUND);
    }
    /*
     * Build command to send
     */
    szOutData[0] = '\0';
    strcat ( szOutData, InterpreterCmd );
    _ltoa ( *pulInData, szInterpreter, 16 );
    strcat ( szOutData, szInterpreter );
    cbCmd = strlen(szOutData) + 1;
    cb += (cbCmd + sizeof(MULTICMD));
  EnterCnvSem();
    pMultiCmd = (PMULTICMD) AllocCnvMem ( cb );
  LeaveCnvSem();
    /*
     * If memory is available, create command structure
     */
    if (pMultiCmd) {
        pMultiCmd->cb = cb;
        pMultiCmd->cCmdStructs = 1;
        pMultiCmd->CmdStructs[0].cb = cbCmd;
        memcpy ( &(pMultiCmd->CmdStructs[0].Cmd) , szOutData, cbCmd );
    } else {
        pMultiCmd = NULL;
        rc = ERROR_NOT_ENOUGH_MEMORY;
    }
    *ppMultiCmd = pMultiCmd;

    return(rc);

}

/****************************************************************************
 *
 * FUNCTION NAME = BuildQInputbinsCmd
 *
 * DESCRIPTION   = Build the query input bins command for the printer
 *
 * INPUT         = pszPortName - The name of the port to send the commands
 *               = pInData     - Information required by the command
 *               = cbInData    - Length in bytes of data in pInData
 *               = ppMultiCmd    - Structure containing the commands to send
 *
 * OUTPUT        = None
 *
 * RETURN-NORMAL = 0(Successful)
 *
 * RETURN-ERROR  = rc(Failure, Unable to build command)
 *
 ****************************************************************************/

ULONG BuildQInputbinsCmd ( PSZ pszPortName, PVOID pInData, ULONG cbInData,
                           PMULTICMD *ppMultiCmd ) {

    ULONG  rc = 0;
    ULONG cbCmd = 0;
    ULONG cb = 0;
    PMULTICMD pMultiCmd = NULL;
    CHAR   szOutData[256];
    CHAR   szInData[16];
    PULONG pulInData = (PULONG) pInData;

    /*
     * Check input for validity
     */
    if (!pInData || cbInData < 2*sizeof(ULONG)) {
        return(ERROR_INVALID_PARAMETER);
    }
    /*
     * Find port instance data
     */
    if (!CheckPort( pszPortName )) {
        return(ERROR_FILE_NOT_FOUND);
    }
    /*
     * Build command to send
     */
    szOutData[0] = '\0';
    strcat ( szOutData, InputbinsCmd[0] );
    _ltoa ( *pulInData, szInData, 16 );
    strcat ( szOutData, szInData );
    strcat ( szOutData, InputbinsCmd[1] );
    pulInData++;
    _ltoa ( *pulInData, szInData, 16 );
    strcat ( szOutData, szInData );

    cbCmd = strlen(szOutData) + 1;
    cb += (cbCmd + sizeof(MULTICMD));
  EnterCnvSem();
    pMultiCmd = (PMULTICMD) AllocCnvMem ( cb );
  LeaveCnvSem();
    /*
     * If memory is available, create command structure
     */
    if (pMultiCmd) {
        pMultiCmd->cb = cb;
        pMultiCmd->cCmdStructs = 1;
        pMultiCmd->CmdStructs[0].cb = cbCmd;
        memcpy ( &(pMultiCmd->CmdStructs[0].Cmd) , szOutData, cbCmd );
    } else {
        pMultiCmd = NULL;
        rc = ERROR_NOT_ENOUGH_MEMORY;
    }
    *ppMultiCmd = pMultiCmd;

    return(rc);

}

/****************************************************************************
 *
 * FUNCTION NAME = BuildQOutputbinsCmd
 *
 * DESCRIPTION   = Build the query output bins command for the printer
 *
 * INPUT         = pszPortName - The name of the port to send the commands
 *               = pInData     - Information required by the command
 *               = cbInData    - Length in bytes of data in pInData
 *               = ppMultiCmd    - Structure containing the commands to send
 *
 * OUTPUT        = None
 *
 * RETURN-NORMAL = 0(Successful)
 *
 * RETURN-ERROR  = rc(Failure, Unable to build command)
 *
 ****************************************************************************/

ULONG BuildQOutputbinsCmd ( PSZ pszPortName, PVOID pInData, ULONG cbInData,
                            PMULTICMD *ppMultiCmd ) {

    ULONG  rc = 0;
    ULONG cbCmd = 0;
    ULONG cb = 0;
    PMULTICMD pMultiCmd = NULL;
    CHAR   szOutData[256];
    CHAR   szInData[16];
    PULONG pulInData = (PULONG) pInData;

    /*
     * Check input for validity
     */
    if (!pInData || cbInData < 2*sizeof(ULONG)) {
        return(ERROR_INVALID_PARAMETER);
    }
    /*
     * Find port instance data
     */
    if (!CheckPort( pszPortName )) {
        return(ERROR_FILE_NOT_FOUND);
    }
    /*
     * Build command to send
     */
    szOutData[0] = '\0';
    strcat ( szOutData, OutputbinsCmd[0] );
    _ltoa ( *pulInData, szInData, 16 );
    strcat ( szOutData, szInData );
    strcat ( szOutData, OutputbinsCmd[1] );
    pulInData++;
    _ltoa ( *pulInData, szInData, 16 );
    strcat ( szOutData, szInData );

    cbCmd = strlen(szOutData) + 1;
    cb += (cbCmd + sizeof(MULTICMD));
  EnterCnvSem();
    pMultiCmd = (PMULTICMD) AllocCnvMem ( cb );
  LeaveCnvSem();
    /*
     * If memory is available, create command structure
     */
    if (pMultiCmd) {
        pMultiCmd->cb = cb;
        pMultiCmd->cCmdStructs = 1;
        pMultiCmd->CmdStructs[0].cb = cbCmd;
        memcpy ( &(pMultiCmd->CmdStructs[0].Cmd) , szOutData, cbCmd );
    } else {
        pMultiCmd = NULL;
        rc = ERROR_NOT_ENOUGH_MEMORY;
    }
    *ppMultiCmd = pMultiCmd;

    return(rc);

}

/****************************************************************************
 *
 * FUNCTION NAME = BuildQOptionsCmd
 *
 * DESCRIPTION   = Build the query options command for the printer
 *
 * INPUT         = pszPortName - The name of the port to send the commands
 *               = ppMultiCmd    - Structure containing the commands to send
 *
 * OUTPUT        = None
 *
 * RETURN-NORMAL = 0(Successful)
 *
 * RETURN-ERROR  = rc(Failure, Unable to build command)
 *
 ****************************************************************************/

ULONG BuildQOptionsCmd ( PSZ pszPortName, PMULTICMD *ppMultiCmd ) {

    ULONG rc = 0;
    ULONG cb = 0;
    ULONG cbCmd = 0;
    PMULTICMD pMultiCmd = NULL;

    cbCmd = strlen (OptionsCmd) + 1;
    cb += (cbCmd + sizeof(MULTICMD));
  EnterCnvSem();
    /*
     * Check for valid port name
     */
    if (!FindPort( pszPortName )) {
      LeaveCnvSem();
        return(ERROR_FILE_NOT_FOUND);
    }

    pMultiCmd = (PMULTICMD) AllocCnvMem ( cb );
  LeaveCnvSem();
    /*
     * If memory is available, create command structure
     */
    if (pMultiCmd) {
        pMultiCmd->cb = cb;
        pMultiCmd->cCmdStructs = 1;
        pMultiCmd->CmdStructs[0].cb = cbCmd;
        memcpy ( &(pMultiCmd->CmdStructs[0].Cmd) , AlertLevelCmd, cbCmd );
    } else {
        pMultiCmd = NULL;
        rc = ERROR_NOT_ENOUGH_MEMORY;
    }
    *ppMultiCmd = pMultiCmd;

    return(rc);

}

/****************************************************************************
 *
 * FUNCTION NAME = BuildQFontsCmd
 *
 * DESCRIPTION   = Build the query fonts command for the printer
 *
 * INPUT         = pszPortName - The name of the port to send the commands
 *               = pInData     - Information required by the command
 *               = cbInData    - Length in bytes of data in pInData
 *               = ppMultiCmd    - Structure containing the commands to send
 *
 * OUTPUT        = None
 *
 * RETURN-NORMAL = 0(Successful)
 *
 * RETURN-ERROR  = rc(Failure, Unable to build command)
 *
 ****************************************************************************/

ULONG BuildQFontsCmd ( PSZ pszPortName, PVOID pInData, ULONG cbInData,
                       PMULTICMD *ppMultiCmd ) {

    ULONG  rc = 0;
    ULONG cbCmd = 0;
    ULONG cb = 0;
    PMULTICMD pMultiCmd = NULL;
    CHAR   szOutData[256];
    CHAR   szInData[16];
    PULONG pulInData = (PULONG) pInData;

    /*
     * Check input for validity
     */
    if (!pInData || cbInData < 3*sizeof(ULONG)) {
        return(ERROR_INVALID_PARAMETER);
    }
    /*
     * Find port instance data
     */
    if (!CheckPort( pszPortName )) {
        return(ERROR_FILE_NOT_FOUND);
    }
    /*
     * Build command to send
     */
    szOutData[0] = '\0';
    strcat ( szOutData, FontsCmd[0] );
    _ltoa ( *pulInData, szInData, 16 );
    strcat ( szOutData, szInData );
    strcat ( szOutData, FontsCmd[1] );
    pulInData++;
    _ltoa ( *pulInData, szInData, 16 );
    strcat ( szOutData, szInData );
    strcat ( szOutData, FontsCmd[2] );
    pulInData++;
    _ltoa ( *pulInData, szInData, 16 );
    strcat ( szOutData, szInData );

    cbCmd = strlen(szOutData) + 1;
    cb += (cbCmd + sizeof(MULTICMD));
  EnterCnvSem();
    pMultiCmd = (PMULTICMD) AllocCnvMem ( cb );
  LeaveCnvSem();
    /*
     * If memory is available, create command structure
     */
    if (pMultiCmd) {
        pMultiCmd->cb = cb;
        pMultiCmd->cCmdStructs = 1;
        pMultiCmd->CmdStructs[0].cb = cbCmd;
        memcpy ( &(pMultiCmd->CmdStructs[0].Cmd) , szOutData, cbCmd );
    } else {
        pMultiCmd = NULL;
        rc = ERROR_NOT_ENOUGH_MEMORY;
    }
    *ppMultiCmd = pMultiCmd;

    return(rc);

}

/****************************************************************************
 *
 * FUNCTION NAME = BuildQJobscompCmd
 *
 * DESCRIPTION   = Build the query jobs complete command for the printer
 *
 * INPUT         = pszPortName - The name of the port to send the commands
 *               = pInData     - Information required by the command
 *               = cbInData    - Length in bytes of data in pInData
 *               = ppMultiCmd    - Structure containing the commands to send
 *
 * OUTPUT        = None
 *
 * RETURN-NORMAL = 0(Successful)
 *
 * RETURN-ERROR  = rc(Failure, Unable to build command)
 *
 ****************************************************************************/

ULONG BuildQJobscompCmd ( PSZ pszPortName, PVOID pInData, ULONG cbInData,
                          PMULTICMD *ppMultiCmd ) {

    ULONG  rc = 0;
    ULONG cbCmd = 0;
    ULONG cb = 0;
    PMULTICMD pMultiCmd = NULL;
    CHAR   szOutData[256];
    CHAR   szInData[16];
    PULONG pulInData = (PULONG) pInData;

    /*
     * Check input for validity
     */
    if (!pInData || cbInData < 3*sizeof(ULONG)) {
        return(ERROR_INVALID_PARAMETER);
    }
    /*
     * Find port instance data
     */
    if (!CheckPort( pszPortName )) {
        return(ERROR_FILE_NOT_FOUND);
    }
    /*
     * Build command to send
     */
    szOutData[0] = '\0';
    strcat ( szOutData, JobscompleteCmd[0] );
    _ltoa ( *pulInData, szInData, 16 );
    strcat ( szOutData, szInData );
    strcat ( szOutData, JobscompleteCmd[1] );
    pulInData++;
    _ltoa ( *pulInData, szInData, 16 );
    strcat ( szOutData, szInData );
    strcat ( szOutData, JobscompleteCmd[2] );
    pulInData++;
    _ltoa ( *pulInData, szInData, 16 );
    strcat ( szOutData, szInData );

    cbCmd = strlen(szOutData) + 1;
    cb += (cbCmd + sizeof(MULTICMD));
  EnterCnvSem();
    pMultiCmd = (PMULTICMD) AllocCnvMem ( cb );
  LeaveCnvSem();
    /*
     * If memory is available, create command structure
     */
    if (pMultiCmd) {
        pMultiCmd->cb = cb;
        pMultiCmd->cCmdStructs = 1;
        pMultiCmd->CmdStructs[0].cb = cbCmd;
        memcpy ( &(pMultiCmd->CmdStructs[0].Cmd) , szOutData, cbCmd );
    } else {
        pMultiCmd = NULL;
        rc = ERROR_NOT_ENOUGH_MEMORY;
    }
    *ppMultiCmd = pMultiCmd;

    return(rc);

}

/****************************************************************************
 *
 * FUNCTION NAME = BuildQJobsqueuedCmd
 *
 * DESCRIPTION   = Build the query jobs queued command for the printer
 *
 * INPUT         = pszPortName - The name of the port to send the commands
 *               = pInData     - Information required by the command
 *               = cbInData    - Length in bytes of data in pInData
 *               = ppMultiCmd    - Structure containing the commands to send
 *
 * OUTPUT        = None
 *
 * RETURN-NORMAL = 0(Successful)
 *
 * RETURN-ERROR  = rc(Failure, Unable to build command)
 *
 ****************************************************************************/

ULONG BuildQJobsqueuedCmd ( PSZ pszPortName, PVOID pInData, ULONG cbInData,
                            PMULTICMD *ppMultiCmd ) {

    ULONG  rc = 0;
    ULONG cbCmd = 0;
    ULONG cb = 0;
    PMULTICMD pMultiCmd = NULL;
    CHAR   szOutData[256];
    CHAR   szInData[16];
    PULONG pulInData = (PULONG) pInData;

    /*
     * Check input for validity
     */
    if (!pInData || cbInData < 3*sizeof(ULONG)) {
        return(ERROR_INVALID_PARAMETER);
    }
    /*
     * Find port instance data
     */
    if (!CheckPort( pszPortName )) {
        return(ERROR_FILE_NOT_FOUND);
    }
    /*
     * Build command to send
     */
    szOutData[0] = '\0';
    strcat ( szOutData, JobsqueuedCmd[0] );
    _ltoa ( *pulInData, szInData, 16 );
    strcat ( szOutData, szInData );
    strcat ( szOutData, JobsqueuedCmd[1] );
    pulInData++;
    _ltoa ( *pulInData, szInData, 16 );
    strcat ( szOutData, szInData );
    strcat ( szOutData, JobsqueuedCmd[2] );
    pulInData++;
    _ltoa ( *pulInData, szInData, 16 );
    strcat ( szOutData, szInData );

    cbCmd = strlen(szOutData) + 1;
    cb += (cbCmd + sizeof(MULTICMD));
  EnterCnvSem();
    pMultiCmd = (PMULTICMD) AllocCnvMem ( cb );
  LeaveCnvSem();
    /*
     * If memory is available, create command structure
     */
    if (pMultiCmd) {
        pMultiCmd->cb = cb;
        pMultiCmd->cCmdStructs = 1;
        pMultiCmd->CmdStructs[0].cb = cbCmd;
        memcpy ( &(pMultiCmd->CmdStructs[0].Cmd) , szOutData, cbCmd );
    } else {
        pMultiCmd = NULL;
        rc = ERROR_NOT_ENOUGH_MEMORY;
    }
    *ppMultiCmd = pMultiCmd;

    return(rc);

}

/****************************************************************************
 *
 * FUNCTION NAME = BuildQStatusCmd
 *
 * DESCRIPTION   = Build the query status command for the printer
 *
 * INPUT         = pszPortName - The name of the port to send the commands
 *               = pInData     - Information required by the command
 *               = cbInData    - Length in bytes of data in pInData
 *               = ppMultiCmd    - Structure containing the commands to send
 *
 * OUTPUT        = None
 *
 * RETURN-NORMAL = 1(Successful)
 *
 * RETURN-ERROR  = rc(Failure, Unable to build command)
 *
 ****************************************************************************/

ULONG BuildQStatusCmd ( PSZ pszPortName, PVOID pInData, ULONG cbInData,
                        PMULTICMD *ppMultiCmd ) {

    ULONG  rc = 0;
    ULONG cbCmd = 0;
    ULONG cb = 0;
    PMULTICMD pMultiCmd = NULL;
    CHAR   szOutData[256];
    CHAR   szInterpreter[16];
    PULONG pulInData = (PULONG) pInData;

    /*
     * Check input for validity
     */
    if (!pInData || cbInData < sizeof(ULONG)) {
        return(ERROR_INVALID_PARAMETER);
    }
    /*
     * Find port instance data
     */
    if (!CheckPort( pszPortName )) {
        return(ERROR_FILE_NOT_FOUND);
    }
    /*
     * Build command to send
     */
    szOutData[0] = '\0';
    strcat ( szOutData, StatusCmd );
    _ltoa ( *pulInData, szInterpreter, 16 );
    strcat ( szOutData, szInterpreter );
    cbCmd = strlen(szOutData) + 1;
    cb += (cbCmd + sizeof(MULTICMD));
  EnterCnvSem();
    pMultiCmd = (PMULTICMD) AllocCnvMem ( cb );
  LeaveCnvSem();
    /*
     * If memory is available, create command structure
     */
    if (pMultiCmd) {
        pMultiCmd->cb = cb;
        pMultiCmd->cCmdStructs = 1;
        pMultiCmd->CmdStructs[0].cb = cbCmd;
        memcpy ( &(pMultiCmd->CmdStructs[0].Cmd) , szOutData, cbCmd );
    } else {
        pMultiCmd = NULL;
        rc = ERROR_NOT_ENOUGH_MEMORY;
    }
    *ppMultiCmd = pMultiCmd;

    return(rc);

}

/****************************************************************************
 *
 * FUNCTION NAME = BuildQJobidCmd
 *
 * DESCRIPTION   = Build the query job ID command for the printer
 *
 * INPUT         = pszPortName  - The name of the port to send the commands
 *               = pOutData     - Information required by the command
 *               = pcbOutData   - Length in bytes of data in pOutData
 *               = ppMultiCmd    - Structure containing the commands to send
 *
 * OUTPUT        = None
 *
 * RETURN-NORMAL = 0(Successful)
 *
 * RETURN-ERROR  = rc(Failure, Unable to build command)
 *
 ****************************************************************************/

ULONG BuildQJobidCmd ( PSZ pszPortName, PVOID pOutData, PULONG pcbOutData,
                       PMULTICMD *ppMultiCmd ) {

    PPORTINST pPortInst = NULL;
    PULONG pulOutData = (PULONG) pOutData;

  EnterCnvSem();
    /*
     * Find port instance data
     */
    if (!(pPortInst = FindPort( pszPortName ))) {
      LeaveCnvSem();
        return(ERROR_FILE_NOT_FOUND);
    }
    /*
     * Check for valid job id (assumes no job ID can be 0)
     */
    if (pPortInst->ulJobSending == 0) {
      LeaveCnvSem();
        return(PMERR_SPL_INV_JOB_ID);
    }
    /*
     * For sample, just return stored job and interpreter ids
     */
    *pulOutData = pPortInst->ulJobInterpreter;
    pulOutData++;
    *pulOutData = pPortInst->ulJobSending;
  LeaveCnvSem();
    *pcbOutData = 2*sizeof(ULONG);
    /*
     * For sample, no commands need to be sent to the printer
     */
    *ppMultiCmd = NULL;

    return(0);

}

/****************************************************************************
 *
 * FUNCTION NAME = BuildQRespfmtCmd
 *
 * DESCRIPTION   = Build the query response format command for the printer
 *
 * INPUT         = pOutData     - Information required by the command
 *               = pcbOutData   - Length in bytes of data in pOutData
 *
 * OUTPUT        = None
 *
 * RETURN-NORMAL = 0(Successful)
 *
 * RETURN-ERROR  = rc(Failure, Unable to build command)
 *
 ****************************************************************************/

ULONG BuildQRespfmtCmd ( PVOID pOutData, PULONG pcbOutData ) {

    /*
     * For sample protocol converter, just zero out entire structure
     *   The port driver will not be called for this command.
     */
    memset ( pOutData, 0, sizeof(PRTRESPONSE));
    *pcbOutData = sizeof(PRTRESPONSE);

    return(0);

}

/****************************************************************************
 *
 * FUNCTION NAME = BuildSetStartJobCmd
 *
 * DESCRIPTION   = Build the set start job command for the printer
 *
 * INPUT         = pszPortName - The name of the port to send the commands
 *               = pInData     - Information required by the command
 *               = cbInData    - Length in bytes of data in pInData
 *               = ppMultiCmd    - Structure containing the commands to send
 *
 * OUTPUT        = None
 *
 * RETURN-NORMAL = 0(Successful)
 *
 * RETURN-ERROR  = rc(Failure, Unable to build command)
 *
 ****************************************************************************/

ULONG BuildSetStartjobCmd ( PSZ pszPortName, PVOID pInData, ULONG cbInData,
                            PMULTICMD *ppMultiCmd ) {

    PPORTINST pPortInst = NULL;
    PULONG pulInData = (PULONG) pInData;
    ULONG  rc = 0;

    /*
     * Check input for validity
     */
    if (!pInData || cbInData < 2*sizeof(ULONG)) {
        return(ERROR_INVALID_PARAMETER);
    }
  EnterCnvSem();
    /*
     * Find port instance data
     */
    if (!(pPortInst = FindPort( pszPortName ))) {
      LeaveCnvSem();
        return(ERROR_FILE_NOT_FOUND);
    }
    pPortInst->ulJobPrinting = *pulInData;
    /*
     * For sample, printer id is equal to the spooler id
     */
    pPortInst->ulJobSending = *pulInData;
    pulInData++;
    pPortInst->ulJobInterpreter = *pulInData;
    /*
     * For sample, no commands need to be send to the printer
     */
    *ppMultiCmd = NULL;
  LeaveCnvSem();

    return(rc);

}

/****************************************************************************
 *
 * FUNCTION NAME = BuildSetEndjobCmd
 *
 * DESCRIPTION   = Build the command to end a job in the printer
 *
 * INPUT         = pszPortName - The name of the port to send the commands
 *               = pInData     - Information required by the command
 *               = cbInData    - Length in bytes of data in pInData
 *               = ppMultiCmd    - Structure containing the commands to send
 *
 * OUTPUT        = None
 *
 * RETURN-NORMAL = 0(Successful)
 *
 * RETURN-ERROR  = rc(Failure, Unable to build command)
 *
 ****************************************************************************/

ULONG BuildSetEndjobCmd ( PSZ pszPortName, PVOID pInData, ULONG cbInData,
                          PMULTICMD *ppMultiCmd ) {

    PPORTINST pPortInst = NULL;
    PULONG pulInData = (PULONG) pInData;
    ULONG  rc = 0;

    /*
     * Check input for validity
     */
    if (!pInData || cbInData < 2*sizeof(ULONG)) {
        return(ERROR_INVALID_PARAMETER);
    }
  EnterCnvSem();
    /*
     * Find port instance data
     */
    if (!(pPortInst = FindPort( pszPortName ))) {
      LeaveCnvSem();
        return(ERROR_FILE_NOT_FOUND);
    }
    /*
     * Check for valid job id
     */
    if (pPortInst->ulJobSending == 0) {
      LeaveCnvSem();
        return(PMERR_SPL_INV_JOB_ID);
    }
    /*
     * Check to make sure interpreter and job ids are valid
     *   For now, just log error and allow command to continue
     */
    if ((*pulInData++ != pPortInst->ulJobInterpreter) ||
        (*pulInData != pPortInst->ulJobSending)) {
        CnvPanic ( 2, 1 );
    }
    /*
     * For sample, just zero out ids in port data
     */
    pPortInst->ulJobPrinting = 0;
    pPortInst->ulJobSending = 0;
    pPortInst->ulJobInterpreter = 0;
    /*
     * For sample, no commands need to be send to the printer
     */
    *ppMultiCmd = NULL;
  LeaveCnvSem();

    return(rc);

}

/****************************************************************************
 *
 * FUNCTION NAME = BuildSetHoldjobCmd
 *
 * DESCRIPTION   = Build the command to hold a job in the printer
 *
 * INPUT         = pszPortName - The name of the port to send the commands
 *               = pInData     - Information required by the command
 *               = cbInData    - Length in bytes of data in pInData
 *               = ppMultiCmd    - Structure containing the commands to send
 *
 * OUTPUT        = None
 *
 * RETURN-NORMAL = 0(Successful)
 *
 * RETURN-ERROR  = rc(Failure, Unable to build command)
 *
 ****************************************************************************/

ULONG BuildSetHoldjobCmd ( PSZ pszPortName, PVOID pInData, ULONG cbInData,
                           PMULTICMD *ppMultiCmd ) {

    /*
     * For sample, command is not supported
     */
    return(ERROR_INVALID_FUNCTION);

}

/****************************************************************************
 *
 * FUNCTION NAME = BuildSetReleasejobCmd
 *
 * DESCRIPTION   = Build the command to release a job in the printer
 *
 * INPUT         = pszPortName - The name of the port to send the commands
 *               = pInData     - Information required by the command
 *               = cbInData    - Length in bytes of data in pInData
 *               = ppMultiCmd    - Structure containing the commands to send
 *
 * OUTPUT        = None
 *
 * RETURN-NORMAL = 0(Successful)
 *
 * RETURN-ERROR  = rc(Failure, Unable to build command)
 *
 ****************************************************************************/

ULONG BuildSetReleasejobCmd ( PSZ pszPortName, PVOID pInData, ULONG cbInData,
                              PMULTICMD *ppMultiCmd ) {

    /*
     * For sample, command is not supported
     */
    return(ERROR_INVALID_FUNCTION);

}

/****************************************************************************
 *
 * FUNCTION NAME = BuildSetCanceljobCmd
 *
 * DESCRIPTION   = Build the command to cancel a job in the printer
 *
 * INPUT         = pszPortName - The name of the port to send the commands
 *               = pInData     - Information required by the command
 *               = cbInData    - Length in bytes of data in pInData
 *               = ppMultiCmd    - Structure containing the commands to send
 *
 * OUTPUT        = None
 *
 * RETURN-NORMAL = 0(Successful)
 *
 * RETURN-ERROR  = rc(Failure, Unable to build command)
 *
 ****************************************************************************/

ULONG BuildSetCanceljobCmd ( PSZ pszPortName, PVOID pInData, ULONG cbInData,
                             PMULTICMD *ppMultiCmd ) {

    /*
     * For sample, command is not supported
     */
    return(ERROR_INVALID_FUNCTION);

}

/****************************************************************************
 *
 * FUNCTION NAME = BuildSetResetCmd
 *
 * DESCRIPTION   = Build command to reset the printer
 *
 * INPUT         = pszPortName - The name of the port to send the commands
 *               = pInData     - Information required by the command
 *               = cbInData    - Length in bytes of data in pInData
 *               = ppMultiCmd    - Structure containing the commands to send
 *
 * OUTPUT        = None
 *
 * RETURN-NORMAL = 0(Successful)
 *
 * RETURN-ERROR  = rc(Failure, Unable to build command)
 *
 ****************************************************************************/

ULONG BuildSetResetCmd ( PSZ pszPortName, PVOID pInData, ULONG cbInData,
                         PMULTICMD *ppMultiCmd ) {

    /*
     * For sample, command is not supported
     */
    return(ERROR_INVALID_FUNCTION);

}

/****************************************************************************
 *
 * FUNCTION NAME = BuildSetTermCmd
 *
 * DESCRIPTION   = Build commands to set the printer in BIDI mode.
 *
 * INPUT         = pszPortName - The name of the port to send the commands
 *               = pInData     - Information required by the command
 *               = cbInData    - Length in bytes of data in pInData
 *               = pMultiCmd    - Structure containing the commands to send
 *
 * OUTPUT        = None
 *
 * RETURN-NORMAL = 0(Successful)
 *
 * RETURN-ERROR  = rc(Failure, Unable to build command)
 *
 ****************************************************************************/

ULONG BuildSetTermCmd ( PSZ pszPortName, PVOID pInData, ULONG cbInData,
                        PMULTICMD *ppMultiCmd ) {

    /*
     * For sample, command is not supported
     */
    return(ERROR_INVALID_FUNCTION);

}

/****************************************************************************
 *
 * FUNCTION NAME = BuildSetPacketsizeCmd
 *
 * DESCRIPTION   = Build commands to set the printer packet size
 *
 * INPUT         = pszPortName - The name of the port to send the commands
 *               = pInData     - Information required by the command
 *               = cbInData    - Length in bytes of data in pInData
 *               = ppMultiCmd    - Structure containing the commands to send
 *
 * OUTPUT        = None
 *
 * RETURN-NORMAL = 0(Successful)
 *
 * RETURN-ERROR  = rc(Failure, Unable to build command)
 *
 ****************************************************************************/

ULONG BuildSetPacketsizeCmd ( PSZ pszPortName, PVOID pInData, ULONG cbInData,
                              PMULTICMD *ppMultiCmd ) {

    /*
     * For sample, command is not supported
     */
    return(ERROR_INVALID_FUNCTION);

}

