/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT (C) Microsoft Corporation, 1989                                 */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *
 * SOURCE FILE NAME = PMPRINT.H
 *
 * DESCRIPTIVE NAME = PM Print Queue Processor
 *
 *
 * VERSION = V2.0
 *
 * DATE
 *
 * DESCRIPTION
 *
 * Private include file for the sources used to build the 32-bit PM print queue
 * processor (PMPRINT.QPR)
 *
 * FUNCTIONS
 *
 * ENTRY POINTS:
 *
 * DEPENDENCIES:
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/

#define  INCL_DOSSEMAPHORES
#define  INCL_DOSPROCESS
#define  INCL_WINSEI
#define  INCL_NOCOMMON
#define  INCL_DOS
#define  INCL_DOSERRORS
#define  INCL_DOSINFOSEG
#define  INCL_DOSDEVICES
#define  INCL_DOSMONITORS
#define  INCL_SPL
#define  INCL_SPLERRORS
#define  INCL_SPLDOSPRINT
#define  INCL_WINHEAP
#define  INCL_WINSHELLDATA
#define  INCL_WINMESSAGEMGR
#define  INCL_WINPOINTERS
#define  INCL_WINP_MISC
#define  INCL_DOSEXCEPTIONS
#include <os2.h>

#ifndef  RC_INVOKED
 #include <string.h>
 #include <setjmp.h>
#endif

/*
** Constants for PMPRINT
*/

/*
** NULL file handle
*/
#define  NULL_HFILE    (HFILE)0xFFFFFFFF
/*
** Bogus hab for API calls
*/
#define  HABX          (HAB)-1L

/*
** ChkMem defines
*/
#define CHK_READ        0
#define CHK_WRITE       1

/*
** OpenQPOutputDC PS flags
*/
#define  NOASSOC       0
#define  ASSOCIATE     1
/*
** String IDs in .rc file
*/
#define  SPL_ID_QP_PMPRINT_TITLE          0
#define  SPL_ID_QP_DATATYPE_ERROR         1
#define  SPL_ID_QP_INVALID_PARAMETER      2
#define  SPL_ID_QP_MEM_ERROR              3
#define  SPL_ID_QP_FILE_NOT_FOUND         4
#define  SPL_ID_QP_OPENDC_ERROR           5
#define  SPL_ID_INSTALL_MSG               6
#define  SPL_ID_INSTALL_CAPTION           7
#define  SPL_ID_QP_DRIVER_FAILED          8
#define  SPL_ID_QP_INVALID_METAFILE       9
#define  SPL_ID_BEGIN_DOC                10
#define  SPL_ID_END_DOC                  11
#define  SPL_ID_DATA_CONVERSION          12

#define  SPL_MAX_STRING_ID               12
#define  SPL_MIN_STRING_ID               0


/*
** Don't include typedefs if just compiling resource file
*/
#ifndef  RC_INVOKED

/*
** Typedefs for PMPRINT
**
*/

/*
 * Big Exception Registration structure:
 *   the registers to restore are in jmp_buf structure
 */
typedef struct _BIGXRR2 {
    PEXCEPTIONREGISTRATIONRECORD     pXRR ;
    PFN      Handler;         /* ->ExceptRoutine for exceptions      */
    jmp_buf  JBuf;            /* stores threads registers            */
    PTIB     pTib ;           /* saved callers thread info block ptr */
    PVOID    pExceptChain;    /* caller's exception chain on entry   */
}  BIGXRR2;
typedef BIGXRR2 *PBIGXRR2 ;



/*
** structure to return a list of parsed strings
*/
typedef struct _KEYDATA
{
  USHORT cb;
  USHORT cTokens;
  PSZ pTokens[1];
} KEYDATA;

typedef KEYDATA *PKEYDATA;

/*
** structure to call Dev32PostEscape for dynamic job properties
*/
typedef struct _DevPostEscapeBlock {
   PSZ       pszDriverName;
   PSZ       pszDeviceName;
   PSZ       pszQueueName;
   PSZ       pszSplPrinterName;
} DEVPOSTESCAPEBLOCK, *PDEVPOSTESCAPEBLOCK;


/*
** structure for handling ARE and FIT percentages
*/
typedef struct _QPPOINT
{                                      /* qpt                                */
  union
  {                                    /* Expressed as a percentage of page
                                          size                               */
    CHAR chLeft;
    CHAR chWidth;
  } x;

  union
  {                                    /* Expressed as a percentage of page
                                          size                               */
    CHAR chTop;
    CHAR chDepth;
  } y;

} QPPOINT;

/*
** structure for handling Queue Processor parameters
** Currently supported parameters are:
**   COP=n           -> set number of copies to n
**   XFM=0 | 1       -> override ARE and FIT parameters
**   COL=M | C       -> specify Color or Monochrome output
**   MAP=N | A       -> determine how neutral colors are printed
**   ARE=C | w,h,l,t -> determine size and position of output area
**   FIT=S | C | l,t -> determines which part of picture to print
**   XLT=0 | 1       -> set tranlation
**   CDP=cp          -> set printer codepage
**   TXT=0 | 1 | 9   -> text format option (i.e., RAW to GpiCharString) @IBMJ-RAW_TXT
*/

#ifdef    RAW_TXT                      //@IBMJ-RAW_TXT
 // definition for uFormat             //@IBMJ-RAW_TXT
 #define FORMAT_TXT_OFF             0  //@IBMJ-RAW_TXT
 #define FORMAT_TXT_ON              1  //@IBMJ-RAW_TXT
 #define FORMAT_TXT_AUTO_DETECT     9  //@IBMJ-RAW_TXT
#endif // RAW_TXT                      //@IBMJ-RAW_TXT

typedef struct _QPPARMS
{                                      /* qpp                                */
  ULONG cCopies;                       /* Number of copies to print "COP=n"  */
  BOOL fTransform;                     /* FALSE => XFM=0 TRUE => XFM=1       */
  BOOL fTranslate;                     /* FALSE => XLT=0 TRUE => XLT=1       */
  BOOL fColor;                         /* FALSE => COL=M TRUE => COL=C       */
  BOOL fMapColors;                     /* FALSE => MAP=N TRUE => MAP=A       */
  BOOL fArea;                          /* FALSE => ARE=C TRUE => ARE=w,d,l,t */
  QPPOINT ptAreaSize;                  /* w,d => width and depth(height) of
                                          output area                        */
  QPPOINT ptAreaOrigin;                /* l,t => offsets of the upper-left
                                          corner of the output area from the
                                          left(l) and from the top(t) of the
                                          max output area                    */
  BOOL fFit;                           /* FALSE => FIT=S or C TRUE =>
                                          FIT=l,t                            */
  ULONG uFit;                          /* 0 => S (scale bottom left)
                                          1 => C (scale centre)              */
  QPPOINT ptFit;                       /* l,t => FIT percentages             */
  ULONG uCodePage;                     /* Code page Number (0 == Not
                                          defined)                           */
#ifdef    RAW_TXT                      /*                              @IBMJ-RAW_TXT*/
  ULONG uFormat;                       /* 0 => OFF, 1 => ON, 9 => AUTO @IBMJ-RAW_TXT*/
#endif // RAW_TXT                      /*                              @IBMJ-RAW_TXT*/
} QPPARMS;

typedef QPPARMS *PQPPARMS;

/*
** structure whose pointer is returned by SplQpOpen
** Stores all information relative to job being printed
*/
typedef struct _QPROCINST
{                                      /* qpi                                */
  USHORT signature;                    /* signature word for validating
                                          HPROC                              */
  USHORT cb;                           /* number of bytes allocated          */
  struct _QPROCINST *pNext;            /* pointer to next struct in list     */
  PID uPid;                            /* Process that created this QProc
                                          inst                               */
  USHORT fsStatus;                     /* Status bits (see below)            */
  USHORT uType;                        /* Type of job to print(QP_TYPE_
                                          below)                             */
  ULONG uJobId;                        /* Job ID being printed               */
  QPPARMS qparms;                      /* Parsed Queue Processor parameters  */
  HFILE hFile;                         /* OS/2 file handle for Rawfile to
                                          print                              */
  ULONG ulFilePos;                     /* current read position in hFile     */
  ULONG cbFile;                        /* Total size of file                 */
  PVOID pRawBuf;                       /* -> buffer to read from RAW file    */
  HEV semPaused;                       /* Handle to an event semaphore
                                          that is set when user pauses a
                                          printing job                       */
  BOOL fHdcOpened;                     /* TRUE when OD_DIRECT DC open        */
  BOOL fSepDrivDataUpdated;            /* TRUE when pSepDriverData set w/DJP */
  HDC hdc;                             /* OD_DIRECT DC handle for this
                                          QpOpen                             */
  HPS hps;                             /* PS handle for PM_Q_STD print job   */
  HMF hmf;                             /* Metafile handle for STD job        */
  HRGN region;                         /* Region handle for STD job          */
  CHAR szFileName[260];                /* Filename to print                  */

  /*
  ** NOTE: following fields are pointers to variable length data
  **       Each field points to memory allocated inside the
  **        QPROCINST memory block.
  **       These fields are freed when the QPROCINST memory
  **        is freed(ie: their length is included in cb above)
  */
  PSZ pszPortName;                     /* Port Name i.e. "LPT1"              */
  PSZ pszDriverName;                   /* Driver Name i.e. "IBM42XX"         */
  PDRIVDATA pDriverData;               /* -> PM Device driver data to use    */
  PDRIVDATA pSepDriverData;            /* -> driverdata to use for sep page  */
  PSZ pszDataType;                     /* -> data type("PM_Q_STD" or
                                          "PM_Q_RAW")                        */
  PSZ pszDocument;                     /* -> document name                   */
  PSZ pszComment;                      /* -> comment string                  */
  PSZ pszSpoolerParams;                /* -> spooler parameters(ex: "FORM=") */
  PSZ pszQName;                        /* -> queue name                      */
} QPROCINST;

typedef QPROCINST *PQPROCINST;
   #define  QP_SIGNATURE  0x5051       /* 'QP' is the signature value        */

/*
** Define flags for fsStatus field
*/
/*
** set when job aborted by user
*/
#define     QP_ABORTED    0x0001

/*
** set when job paused by user
*/
#define     QP_PAUSED     0x0002

/*
** set when ENDDOC completes
*/
#define     QP_ENDDOC_COMPLETE 0x0004
   #define  QP_RESERVED   0xFFF8

/*
** Define values for uType field
*/
#define     QP_TYPE_STD   0
#define     QP_TYPE_RAW   1
/*
** Data types supported
*/
#define  DT_STD        "PM_Q_STD"
#define  DT_RAW        "PM_Q_RAW"

/*
** Count of Types supported(currently only "PM_Q_STD" and "PM_Q_RAW")
*/
#define     QP_TYPE_COUNT 2

/*
** Macros
*/
#define     min(a,        b) ((a) < (b) ? (a) : (b))

/*
 * Per process variables
*/
HMTX semPMPRINT;                       /* Handle to 32bit semaphore to
                                          serialize access to all of the per
                                          process data that follows.         */
BOOL fInitDone;                        /* TRUE if DllInit has completed
                                          for current process                */

BOOL fQprDoingInit;                    /* TRUE if still in DLLInit routine
                                          for this process. Other threads
                                          in process must wait for DLLInit
                                          to complete                        */
PQPROCINST pQprocInstHead;             /* -> head of QPROCINST list for this
                                          process                            */
                                       /* Each instance created by SplQpOpen()*/
HMODULE hModPMPrint;                   /* module handle of PMPRINT.QPR       */
PPIB pPIB;                             /* -> process information block       */
PTIB pTIB;                             /* -> thread information block        */

/*
** Internal function prototypes for PMPRINT
*/
/*
** Utility functions defined in QPINIT.C
*/
VOID APIENTRY ExitListProc(ULONG uExitType);
BOOL EXPENTRY InitResources(VOID);

/*
** Queue Processor functions defined in QPAPI.C
*/
PQPROCINST CreateQProcInst(PDEVOPENSTRUC pQProcData,USHORT uJobId,PSZ pszQName,
                                                                PSZ pszDocName);

PQPROCINST DestroyQProcInst(PQPROCINST pQProc);
PQPROCINST ValidateQProcInst(HPROC hQProc);
BOOL ParseQProcParms(PSZ pszParms,PQPPARMS pqp);
BOOL ParseQProcParm(PSZ pszParm,PQPPARMS pqp);
PSZ ParseQProcPercentList(PSZ pszList,PBYTE pResult,USHORT cListElem);
BOOL OpenQPInputFile(PQPROCINST pQProc,PSZ pszFileName,BOOL fOpen);
BOOL CloseQPInputFile(PQPROCINST pQProc);
BOOL OpenQPOutputDC(PQPROCINST pQProc, PDRIVDATA pDD,
                    BOOL fAssociate, BOOL fNewFrameWithProps );
BOOL CloseQPOutputDC(PQPROCINST pQProc,BOOL fEndDoc);

/*
** Queue Processor functions defined in QPMSG.C
*/
USHORT SplQpMessage(PSZ pszPort,USHORT uErrId,USHORT uErrCode);

/*
** Queue Processor functions defined in QPSTD.C
*/
BOOL SplQpStdPrintFile(PQPROCINST pQProc,PSZ pszFileName);
BOOL SetViewMatrix(PQPROCINST pQProc);
BOOL ApplyTranslation(HPS hps);

/*
** Queue Processor functions defined in QPRAW.C
*/
BOOL SplQpRawPrintFile(PQPROCINST pQProc,PSZ pszFileName);


/*
** Dynamic job properties override function in QPDJP.C
*/
ULONG UpdateSepDrivdata( PDRIVDATA pSepDriverData,
                         PDEVPOSTESCAPEBLOCK pDevPostBlock );


/*
** Utility functions in QPUTIL.C
*/
VOID EnterSem(VOID);
VOID LeaveSem(VOID);
VOID ExitSem(VOID);
USHORT AsciiToInt(PSZ psz);
PKEYDATA ParseKeyData(PSZ pszKeyData,UCHAR chSep,USHORT cbKeyData,PKEYDATA
                       pTempKeyBuf,USHORT cbTempBuf);
PSZ EndStrcpy(PSZ,PSZ);
int SafeStrlen(PSZ psz);
PSZ SafeStrcpy(PSZ pszDest,PSZ pszSrc);
BOOL ChkMem ( PVOID pMem, USHORT usMemSize, USHORT usFlags );
BOOL ChkStr ( PSZ psz );

INT APIENTRY ExceptRoutine(PEXCEPTIONREPORTRECORD,
                         PEXCEPTIONREGISTRATIONRECORD,
                         PCONTEXTRECORD,
                         PVOID);

/*
** Macros for outputting error messages
**
** For debug version of PMPRINT, define routines
*/
#define LogError( err ) WinSetErrorInfo( \
        MAKEERRORID( SEVERITY_ERROR, err ), \
        SEI_REGISTERS | SEI_STACKTRACE)

   #define  Warning(      msg, arg1, arg2 )
   #define  Error(        msg, arg1, arg2 )
   #define  Panic(        msg, arg1, arg2 )


/*
** functions in QPTXT.C
*/
ULONG VerifyRawFileMode     (PQPROCINST pQProc, PSZ pszFileName);
BOOL  SplQpRawPrintTextFile (PQPROCINST pQProc, PSZ pszFileName);

#endif
