/**************************************************************************
 *
 * SOURCE FILE NAME = PDRTYPES.H
 *
 * DESCRIPTIVE NAME = Type definitions for port driver
 *
 * Copyright : COPYRIGHT IBM CORPORATION, 1991, 1992
 *             LICENSED MATERIAL - PROGRAM PROPERTY OF IBM
 *             REFER TO COPYRIGHT INSTRUCTION FORM#G120-2083
 *             RESTRICTED MATERIALS OF IBM
 *             IBM CONFIDENTIAL
 *
 * VERSION = V2.0
 *
 * DATE
 *
 * DESCRIPTION
 *
 *
 * FUNCTIONS
 *
 * ENTRY POINTS:
 *
 * DEPENDENCIES:
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
 * CHANGE ACTIVITY =
 *  DATE      FLAG        APAR   CHANGE DESCRIPTION
 *  --------  ----------  -----  --------------------------------------
 *  mm/dd/yy  @Vr.mpppxx  xxxxx  xxxxxxx
 *
 ****************************************************************************/

#define LINT_ARGS                      /* argument checking enabled         */

#define  INCL_DOS
#define  INCL_GPI
#undef   INCL_GPI
#define  INCL_DEV
#define  INCL_ERRORS
#define  INCL_DOSMEMMGR                /* Include standard OS/2 support     */
#define  INCL_DOSMODULEMGR             /* For DosLoadModule                 */
#define  INCL_DOSPROCESS
#define  INCL_GPILCIDS
#define  INCL_WINCOMMON                /* Include Window Management support */
#define  INCL_WINDOWMGR
#define  INCL_WINSWITCHLIST
#define  INCL_WINPROGRAMLIST
#define  INCL_WINMENUS
#define  INCL_WINWINDOWMGR
#define  INCL_WINMESSAGEMGR
#define  INCL_WINDIALOGS
#define  INCL_WINSTATICS
#define  INCL_WINLISTBOXES
#define  INCL_WINMENUS
#define  INCL_WINSYS
#define  INCL_WINFRAMEMGR
#define  INCL_INCLWINACCELERATORS
#define  INCL_WINPOINTERS
#define  INCL_WINERRORS
#define  INCL_WINSHELLDATA

#define  INCL_WINTYPES
#define  INCL_WINACCELERATORS
#define  INCL_WINBUTTONS
#define  INCL_WINENTRYFIELDS
#define  INCL_WINRECTANGLES
#define  INCL_WINTIMER
#define  INCL_WINSCROLLBARS
#define  INCL_WINHEAP
#define  INCL_SHLERRORS
#define  INCL_WININPUT
#define  INCL_WINHELP
#define  INCL_WINSTDSPIN

#define  INCL_SPL
#define  INCL_SPLP
#define  INCL_SPLBIDI
#define  INCL_SPLERRORS
#define  INCL_SHLERRORS
#define  INCL_DOSERRORS
#define  INCL_WINHOOKS
#define  INCL_DOSEXCEPTIONS

#include <os2.h>
#include <stdlib.h>
#include <stdio.h>
#ifndef  RC_INVOKED
 #include <string.h>
 #include <setjmp.h>
#endif

//
// Include this private version of the public header pmsplb.h
//   only if pmsplb.h is not in the current headers
//
#ifndef PMSPLB_INCLUDED
 #include "pmsplnew.h"
#endif

//
// Earlier versions of pmsplb.h might not have the following defined:
//
#ifndef PRTPORT_CAPS_CMD_CHANNEL_AVAIL
 #define PRTPORT_CAPS_CMD_CHANNEL_AVAIL    0x00000008
#endif

/*
** MACROS
*/
#define  ABS(Value)    ((Value) > 0 ? (Value) : (-(Value)))
#define  WITHIN(value,lower,upper) ((value) >= (lower) && (value) <= (upper))
#define  MIN(a,b)      ((a) > (b) ? (b) : (a))
#define  MAX(a,b)      ((a) > (b) ? (a) : (b))

#ifndef OFFSETOFLONG
#define OFFSETOFLONG(p)         (((PULONG)&(p))[0])
#endif

/* change the pointer to an offset to the beginning of the structure */
#ifndef PTRTOOFFSET
#define PTRTOOFFSET(p, pbase) OFFSETOFLONG(pbase->p) -= (ULONG)pbase
#endif

/* change the offset from the beginning of the structure to a pointer */

#ifndef OFFSETTOPTR
#define OFFSETTOPTR(p, pbase) pbase->p = (PVOID)(OFFSETOFLONG(pbase->p) ? \
                             ((PBYTE)pbase + OFFSETOFLONG(pbase->p)) : (PBYTE)NULL)
#endif


/* Generate a pointer from a structure/offset pair */

#ifndef GETPTRFROMOFFSET
#define GETPTRFROMOFFSET(p, pbase) pbase->p ? ((PSZ)pbase + pbase->p) : NULL
#endif

/*
** Big Exception Registration structure:
**   the registers to restore are in jmp_buf structure
*/
typedef struct _BIGXRR2 {
    PEXCEPTIONREGISTRATIONRECORD     pXRR ;
    PFN      Handler;         /* ->ExceptRoutine for exceptions      */
    jmp_buf  JBuf;            /* stores threads registers            */
    PTIB     pTib ;           /* saved callers thread info block ptr */
    PVOID    pExceptChain;    /* caller's exception chain on entry   */
}  BIGXRR2;
typedef BIGXRR2 *PBIGXRR2 ;

/*
** Structure for setting timeouts for PAR1284.SYS
**
** The ReadIdleTimeOut is the max amount of time a Read request
**   will wait before returning to the caller, even if there is
**   more data waiting to be read.  The timer starts when
**   the channel is reversed, and the timer runs as data is read.
** The ReadIntTimeOut is the max amount of time to wait for an
**   interrupt indicating that data has been transferred from
**   the peripheral to the host.  This timer starts when the
**   channel is reversed, and is reset after each transfer
**   from the peripheral.
**
** The WriteIdleTimeOut is the max amount of time a Write request
**   will wait before returning to the caller, even if there is
**   more data waiting to be written.  The timer starts when
**   the first byte is strobed, and the timer runs as data
**   is sent to the peripheral.
** The WriteIntTimeOut is the max amount of time to wait for an
**   interrupt indicating that data has been transferred from
**   the host to the peripheral.  This timer starts when the
**   first byte is strobed, and is reset after each successful
**   transfer to the peripheral.  This is the same as the
**   Catagory 5 Function 53 IOCTL.
**
** The Idle timeouts now limit the amount of time a single
**   request will be attempted.  It does not guarantee the
**   max amount of time the caller of DosRead or DosWrite
**   will take before returning because the request might
**   be queued behind other read/write/IOCTL requests.
**   Once the read or write request has begun being processed,
**   then the Idle timeout begins.
** This port driver will assume that bidi capable printers
**   can accept data at a reasonable rate, so the WriteIdle
**   timeout will default to a small value(like 15 seconds).
**   The actual WriteTimeout specified by the user can
**   be larger, and our PdWrite API will handle retrying
**   requests that do not complete.  However, we will always
**   have a ParReadThread for each bidi port, and this read
**   will typically be queued up after the write.
**   When a write completes(even if only partial buffer was sent),
**   the queued read request will reverse the channel and check
**   for data coming from the printer.  This read must not
**   take a long time(to avoid performance degradation for writes).
**   We set a small ReadInterrupt timeout( about 200 ms default )
**   so that if no data is waiting to be read, the read request
**   returns and lets the write request be processed.
** We set a longer ReadIdle timeout( 1000 ms ) to attempt to
**   get the entire buffer from the peripheral if there is data
**   waiting to be sent to the host.
**
** For now, we set the WriteIdle and WriteInterrupt timeouts
**   to be the same.  This means we will always return within
**   the WriteIdle timeout value specified.
*/
typedef struct _PPTIMEOUTCHANNEL{
    ULONG   ulReadIdleTimeOut;  // millisecs DD has to complete entire Read
    ULONG   ulReadIntTimeOut;   // millisecs DD waits for Read interrupt
    ULONG   ulWriteIdleTimeOut; // millisecs DD has to complete entire Write
    ULONG   ulWriteIntTimeOut;  // millisecs DD waits for Write interrupt
    ULONG   ulLogChannel;   // 1=use data channel, 2=use address channel
  } PPTIMEOUTCHANNEL, *PPPTIMEOUTCHANNEL;

/*
** Structure whose pointer is returned by SplPdOpen.
** Stores all information relative to job being printed.
*/
typedef struct _PDOPENINST
{
  USHORT signature;                    /* signature word for validation      */
  USHORT usDummy;                      /* DWORD aligns this structure        */
  ULONG  cb;                           /* number of bytes allocated          */
  struct _PDOPENINST    *pNext;        /* pointer to next struct in list     */
  PID uPid;                            /* Process that created this          */
                                       /*   PdOpenInstance                   */
  struct _PORTINST *pPortInst;         /* ->port instance for handle         */
  ULONG   uJobId;                      /* Job ID being printed               */
  /*
  ** NOTE: following fields are pointers to variable length data
  **       Each field points to memory allocated inside the
  **        PDOPENINST memory block.
  **       These fields are freed when the PDOPENINST memory
  **        is freed(ie: their length is included in cb above)
  */
  PSZ pszPortName;                     /* Port Name i.e. "LPT1"              */
} PDOPENINST, *PPDOPENINST;

#define  PD_SIGNATURE  0x4450          /* 'PD' is the signature value        */

/*
** Structure which stores all information about a supported port
*/
typedef struct _PORTINST
{
  USHORT signature;                    /* signature word for validation      */
  USHORT usDummy;                      /* DWORD align structure              */
  ULONG  cb;                           /* number of bytes allocated          */
  struct _PORTINST    *pNext;          /* pointer to next struct in list     */
  PSZ    pszPortName;                  /* ->name of port at end of PORTINST  */
                                       /*  0x0010 offset                     */
  ULONG  flStatus;                     /* status flags - see PF_ below       */
  TID    tidReadThread;                /* thread ID that issues DosRead(LPTx)*/
  ULONG  flBidiCapabilities;           /* PRTPORT.flBidiCapabilities _CAPS_  */
  ULONG  flBidiProtocol;               /* PRTPORT.flBidiProtocol _TYPE_      */
                                       /*  0x0020 offset                     */
  ULONG  flJob;                        /* PRTSW.flJob flags                  */
  ULONG  flDevice;                     /* PRTSW.flDevice flags               */
  ULONG  ulJobPrinting;                /* see PDR_ values below              */
  ULONG  ulModeSelected;               /* Mode selected by user(see PARMODE_)*/
                                       /*  0x0030 offset                     */
  ULONG  ulCurrentMode;                /* Current mode of port(see CURMODE_) */
  BOOL   fShareAccess;                 /* Share port with DOS/Windows        */
  BOOL   fMoreCmds;                    /* Set when Job should wait due to    */
                                       /*    more query cmds coming          */
  HFILE  hFile;                        /* Dos FileHandle to port             */
                                       /*  0x0040 offset                     */
  HMTX   hPortSem;                     /* serialize access to this port      */
  HEV    hevReadThread;                /* wakeup ParReadThread when posted   */
  ULONG  rc;                           /* asynch error code from port        */
  PBYTE  pPassthruBuf;                 /* -> buffer to store passthru data   */
                                       /*    Separately allocated only when  */
                                       /*    a passthru session is active    */
                                       /*  0x0050 offset                     */
  ULONG  ulcbPassthruBuf;              /* size in bytes of pPassthruBuf      */
  ULONG  ulcbPassthruData;             /* amount of passthru data stored     */
  ULONG  ulTimeLastCmd;                /* Time(seconds) of last cmd for port */
  ULONG  ulTimeLastJob;                /* Time(seconds) of last PdClose      */
                                       /*  0x0060 offset                     */
  ULONG  ulPrintTimeOut;               /* Seconds to continue to retry job   */
                                       /*  write request in SplPdWrite().    */
                                       /*  Default: 45 seconds               */
  ULONG  ulNoQueryTimeOut;             /* Seconds from last query until      */
                                       /*  port drops printer connection     */
                                       /*  Default: 180 seconds              */
  ULONG  ulNoJobTimeOut;               /* Seconds from last job sent until   */
                                       /*  port drops printer connection     */
                                       /*  NOTE: Connection can be dropped   */
                                       /*        sooner if PDR receives      */
                                       /*        BIDI_NOTIFY_ENDJOBCONNECT   */
                                       /*        This is used if we lose     */
                                       /*        a job acknowledgement so    */
                                       /*        that other Apps can use the */
                                       /*        infrared port.              */
                                       /*  Default: 300 seconds              */
  PPTIMEOUTCHANNEL TimeOut;            /* Read and Write timeouts            */
                                       /*  0x0070 offset                     */
  PBYTE   pbWriteBuf;                  /* Non-heap Buffer for DosWrite call  */
  CHAR    szDeviceID[512];             /* Device ID string from printer      */

} PORTINST, *PPORTINST;

#define  PT_SIGNATURE  0x5450       /* 'PT' is the signature value        */

         // PORTINST->flStatus flags

#define  PF_Q_PORT_CALLED    0x00000001  /* BIDI_Q_PORT issued for port   */
#define  PF_SETMODE_CALLED   0x00000002  /* Set after 1st attempt at bidi */
#define  PF_CONNECTED_QUEUE  0x00000004  /* Port connected to print queue */
#define  PF_PORT_OPEN        0x00000008  /* Port already open             */
#define  PF_OPEN_IN_PROGRESS 0x00000010  /* Port open in progress         */
#define  PF_PROCESS_PDOPEN   0x00000020  /* SplPdOpen being processed     */
#define  PF_PROCESS_PDCLOSE  0x00000040  /* SplPdClose being processed    */
#define  PF_PD_MOREALERTS    0x00000080  /* XlateCmd has more alerts left */
#define  PF_COMM_STAT_CHANGE 0x00000100  /* New printer or powered off    */
#define  PF_BIDI_CHECKED     0x00000200  /* Set when deviceId was checked */
                                         /*   after first good write to a */
                                         /*   unidirectional printer.     */
#define  PF_CMD_CHNL_ACTIVE  0x00000400  /* Set when last write was sent  */
                                         /*   using ECP mode cmd channel. */
#define  PF_BIDI_WAS_ACTIVE  0x00000800  /* Set when printer put in bidi  */
                                         /*   mode and DeviceID received. */
#define  PF_COMALERT_POSTED  0x00001000  /* Set when CommStatChange alert */
                                         /*   was posted to spooler.      */
                                         /*   Cleared after BIDI_Q_PORT   */

         // PORTINST->ulModeSelected values

#define PARMODE_AUTODETECT               0
#define PARMODE_DISABLE_BIDI             1
#define PARMODE_NIBBLE                   2
#define PARMODE_BYTE                     3
#define PARMODE_ECP                      4
#define PARMODE_ECP_RLE                  5

         // PORTINST->ulCurrentMode values

#define CURMODE_COMPATIBLE               1
#define CURMODE_NIBBLE                   2
#define CURMODE_BYTE                     3
#define CURMODE_ECP                      4
#define CURMODE_ECP_RLE                  5

         // PORTINST->ulJobPrinting values

#define  PDR_NOT_PRINTING    0
#define  PDR_PRINTING        1
#define  PDR_ABORTED         2

/*
** Structure that holds data sent by the printer.
**   An array of these structures is stored in the WAITALERTBUF.
*/
typedef struct _ALERTBUF
{
  PSZ    pszAlertPortName;             /* ->name of port alert received on   */
  ULONG  cbData;                       /* length, in bytes, of data sent by  */
                                       /*   the printer that follows this    */
                                       /*   cbData field.                    */
                                       /* NOTE: if this field is 0, the      */
                                       /*   WaitAlertThread should check     */
                                       /*   the PortInst structure to see if */
                                       /*   a communications alert should    */
                                       /*   be sent to the spooler.          */
                                       /*                                    */
} ALERTBUF, *PALERTBUF;

/*
** Buffer that holds multiple data packets sent by the printer.
**   This is used by the thread processing BIDI_WAIT_ALERT command.
*/
typedef struct _WAITALERTBUF
{
  ULONG  cbBufSize;                    /* total length of this structure     */
  ULONG  cbBufUsed;                    /* bytes used in buffer so far        */
  ULONG  cAlertsRemaining;             /* number of unprocessed alerts left  */
  BOOL   fPdMoreAlerts;                /* TRUE if ProtXlateCmd must be called*/
                                       /*   again with a NULL buffer because */
                                       /*   the last buffer had multiple     */
                                       /*   alerts in it                     */
  PALERTBUF pLastStored;               /* ->last ALERTBUF stored in this buf.*/
                                       /*   This is NULL if no alerts have   */
                                       /*   been stored in this buffer.      */
  PALERTBUF pLastProcessed;            /* ->last ALERTBUF sent to ProtXlate  */
                                       /*   This is NULL if no alerts from   */
                                       /*   this buffer have been sent to    */
                                       /*   ProtXlateCmd yet                 */
  ALERTBUF  FirstAlertBuf;             /* First ALERTBUF stored, followed    */
                                       /*   by its variable length data.     */
                                       /*                                    */
} WAITALERTBUF, *PWAITALERTBUF;

/*
** Structure which stores information needed to handle data
**   coming from multiple printers.
** This is used to handle BIDI_WAIT_ALERT command by keeping a
**   single list of alerts from any port.
** There is only 1 of these structures, and it is allocated as a
**   variable, not dynamically allocated.  The variable is PdrWaitAlert.
*/
typedef struct _PDRWAITALERT
{
  PWAITALERTBUF pCurrBuf;              /* Current WAITALERTBUF we are using  */
                                       /*   to store alert data received     */
                                       /*   from printers                    */
  PWAITALERTBUF pXlateBuf;             /* WAITALERTBUF being processed by    */
                                       /*   the BIDI_WAIT_ALERT thread       */
  HEV    hevWaitAlert;                 /* EventSem for thread processing     */
                                       /*   the BIDI_WAIT_ALERT command.     */
} PDRWAITALERT, *PPDRWAITALERT;

/*
** Structure to get/set configuration of a port.
** Used when a Bidi spooler is installed that
**   exports PrtQuery and PrtSet.
** The port driver gets these using
**   PrtQuery( BIDI_Q_PORTDRV)
** and changes the port's settings using
**   PrtSet( BIDI_SET_PORTDRV
*/

typedef struct _PORTSETTINGS
{
   ULONG   signature;           /* Must be PAR12_SIGNATURE               */
   ULONG   ulVersion;           /* Version of structure is 1             */
   ULONG   flStatus;            /* status flags - see PF_ above          */
                                /*  If PF_Q_PORT_CALLED set then the     */
                                /*   Bidi spooler is enabled.            */
   ULONG   flBidiCapabilities;  /* PRTPORT.flBidiCapabilities _CAPS_     */
   ULONG   flBidiProtocol;      /* PRTPORT.flBidiProtocol _TYPE_         */
   ULONG   flJob;               /* PRTSW.flJob flags                     */
   ULONG   flDevice;            /* PRTSW.flDevice flags                  */
   ULONG   ulModeSelected;      /* Mode selected by user(see PARMODE_)   */
   ULONG   ulCurrentMode;       /* Current mode of port(see CURMODE_)    */
   BOOL    fShareAccess;        /* Share port with DOS/Windows           */
   ULONG   ulPrintTimeOut;      /* Seconds to continue to retry job      */
                                /*  write request in SplPdWrite().       */
                                /*  Default: 45 seconds                  */
   ULONG   ulNoQueryTimeOut;    /* Seconds from last query until         */
                                /*  port drops printer connection        */
                                /*  Default: 180 seconds                 */
   ULONG   ulNoJobTimeOut;      /* Seconds from last job sent until      */
                                /*  port drops printer connection        */
                                /*  NOTE: Connection can be dropped      */
                                /*        sooner if PDR receives         */
                                /*        BIDI_NOTIFY_ENDJOBCONNECT      */
                                /*        This is used if we lose        */
                                /*        a job acknowledgement so       */
                                /*        that other Apps can use the    */
                                /*        infrared port.                 */
                                /*  Default: 300 seconds                 */
                                /*                                       */
   PPTIMEOUTCHANNEL TimeOut;    /* Read and Write timeouts               */
                                /*                                       */
                                /*                                       */
                                /* The following ulpsz fields are        */
                                /*  offsets from the beginning of        */
                                /*  this PORTSETTINGS structure to       */
                                /*  the variable length strings.         */
                                /* This allows us to pass the buffer     */
                                /*  intact to PrtQuery and PrtSet,       */
                                /*  even across the network.             */
                                /* All strings are packed immediately    */
                                /*  after the fixed-length PORTSETTINGS  */
                                /*  structure.                           */
                                /*                                       */
                                /* An offset of 0 means no string        */
                                /*                                       */
   ULONG   ulpszPortName;       /* -> name of port info is for           */
   ULONG   ulpszDeviceID;       /* -> 1284 deviceID for printer on port  */
} PORTSETTINGS, *PPORTSETTINGS;
#define PAR12_SIGNATURE 0x52464E49       /* Signature is 'INFR' */

/*
** Structure used by SplPdSetPort and SplPdRemoteSetPort for displaying
**  and changing the InfraRed port's connection parameters
*/
typedef struct _PORTDLGSTRUCT
{
   ULONG   signature;           /* Must be PDLG_SIGNATURE                */
   struct _PORTDLGSTRUCT *pNext;/* Next port dlg struct                  */
   HMTX    hMtxDlg;             /* serialize access to this dialog struct*/
   HAB     hAB;                 /* Anchor block                          */
   HWND    hwndDlg;             /* hwnd settings dialog box              */
   HWND    hwndAdvanced;        /* hwnd advanced settings dialog         */
   HMODULE hModule;             /* hMod port driver                      */
   HMODULE hModLMDLL;           /* hMod LMDLL.DLL                        */
   ULONG   flModified;          /* TRUE if settings modified             */
   ULONG   cbPortSettings;      /* Size of pPortSettings in bytes        */
   PPORTSETTINGS pPortSettings; /* ->separately allocated PORTSETTINGS   */
                                /*   buffer.  This must be freed when    */
                                /*   the dialog is dismissed             */
                                /*   by using DosFreeMem()               */
   PSZ     pszComputerName;     /* ->computer settings dialog is for     */
                                /*   NULL for local settings             */
   PSZ     pszPortName;         /* ->port name on pszComputer that the   */
                                /*   settings are being displayed        */
                                /*                                       */
                                /* The original values for the following */
                                /*  fields are in pPortSettings:         */
                                /*                                       */
   ULONG   ulPrintTimeOut;      /* Updated seconds to continue to retry  */
                                /*  job write request in SplPdWrite().   */
                                /*  Default: 45 seconds                  */
   ULONG   ulNoQueryTimeOut;    /* Updated seconds from last query until */
                                /*  port drops printer connection        */
                                /*  Default: 60 seconds                  */
   ULONG   ulNoJobTimeOut;      /* Updated seconds from last job sent    */
                                /*  until port drops printer connection  */
                                /*  NOTE: Connection can be dropped      */
                                /*        sooner if PDR receives         */
                                /*        BIDI_NOTIFY_ENDJOBCONNECT      */
                                /*        This is used if we lose        */
                                /*        a job acknowledgement so       */
                                /*        that other Apps can use the    */
                                /*        infrared port.                 */
                                /*  Default: 300 seconds                 */
                                /*                                       */
} PORTDLGSTRUCT, *PPORTDLGSTRUCT;
#define PDLG_SIGNATURE 0x474C4450       /* Signature is 'PDLG' */



typedef struct _FREEMEM {
    USHORT      signature;      /* signature word for validating memory */
    USHORT usDummy;
    ULONG  cb;                           /* number of bytes allocated   */
    struct _FREEMEM *pNext;
} FREEMEM;
typedef FREEMEM *PFREEMEM;

#define FR_SIGNATURE    0x5246  /* "FR" is the signature value */


/*
** Assert routine macro defines
*/
#ifdef DEBUG_ALERT
  #define ASSERTT(exp)  {if (exp)  { sprintf( logbuf, "AssertFailed rc=%d in %s line %d\r\n", exp,__FILE__,__LINE__); LogCall(logbuf);}}
  #define ASSERTF(exp)  {if (!(exp))  { sprintf( logbuf, "AssertFailed %s in %s line %d\r\n", (PSZ)#exp,__FILE__,__LINE__); LogCall(logbuf);}}
  #define DBPRINTF(list) {sprintf list ; strcat( logbuf, "\r\n"); LogCall(logbuf); }
#else
  #define ASSERTT(x)
  #define ASSERTF(x)
  #define DBPRINTF(str)
#endif /* DEBUG_ALERT */

/*
** Defines to change level of debug output sent to the
** debug terminal(when config.sys PMDD.SYS /C2 set)
** Change global variable flChangeDebugLog for each define wanted.
*/
#define FL_PDRDB_ENABLE_SPLPDWRITE    0x00000001 /* Set to enable logging SplPdWrite   */
#define FL_PDRDB_DISABLE_SPLPDSENDCMD 0x00000002 /* Set to disable logging SplPdSendcmd   */
#define FL_PDRDB_DISABLE_SPLPDOPEN    0x00000004 /* Set to disable logging SplPdOpen/Close */
#define FL_PDRDB_DISABLE_SPLPDABORT   0x00000008 /* Set to disable logging SplPdAbortDoc   */
#define FL_PDRDB_DISABLE_SPLPDQUERY   0x00000010 /* Set to disable logging SplPdQuery      */
#define FL_PDRDB_DISABLE_SPLPDSET     0x00000020 /* Set to disable logging SplPdSet        */
#define FL_PDRDB_DISABLE_PDOPEN       0x00000040 /* Set to disable logging internal PdOpen/PdClose */
#define FL_PDRDB_ENABLE_PDWRITE       0x00000080 /* Set to enable logging internal PdWrite */
#define FL_PDRDB_DISABLE_Q_PORT       0x00000100 /* Set to disable logging HandleQPort */
#define FL_PDRDB_DISABLE_GETDEVICEID  0x00000200 /* Set to disable logging GetDeviceID */
#define FL_PDRDB_DISABLE_SETMODE      0x00000400 /* Set to disable logging SetMode     */
#define FL_PDRDB_ENABLE_WAITALERT     0x00000800 /* Set to enable logging internal HandleWaitAlert */
#define FL_PDRDB_DISABLE_DIALOG       0x00001000 /* Set to disable logging OpenPar1284PortDlg */
#define FL_PDRDB_DISABLE_QPORTDRV     0x00002000 /* Set to disable logging HandleQPortDRV */
#define FL_PDRDB_DISABLE_CONTROLTHRD  0x00004000 /* Set to disable logging ControlThread */
#define FL_PDRDB_ENABLE_READTHREAD    0x00008000 /* Set to enable logging internal ParReadThread */
#define FL_PDRDB_ENABLE_READWAIT      0x00010000 /* Set to enable logging ParReadThread WaitEvents */
#define FL_PDRDB_ENABLE_PDRSEMS       0x00020000 /* Set to enable logging EnterPdrSem/LeavePdrSem */
#define FL_PDRDB_ENABLE_WRITE_DUMP    0x00040000 /* Set to enable dumping data on PdWrite */
#define FL_PDRDB_DISABLE_PASSTHRU     0x00080000 /* Set to disable logging Passthru functions */


/*
** The following typedefs are for functions only exported by
**   the bidi spooler(PMSPL.DLL) available in a fixpak.
** These functions are not exported by the original Warp spooler,
**   so we try DosQueryProcAddr() to determine if the bidi spooler
**   is installed.  This way our port driver runs on the
**   original Warp system without requiring a fixpak.
**
** Typedefs for PrtQuery and PrtSet exported by PMSPL.DLL:
*/
typedef ULONG (APIENTRY FNPRTQUERY) ( PSZ, PSZ, ULONG, ULONG, PVOID,
                                      ULONG, PVOID, PULONG );
typedef FNPRTQUERY *PFNPRTQUERY;

typedef ULONG (APIENTRY FNPRTSET) ( PSZ, PSZ, ULONG, ULONG, PVOID,
                                    ULONG );
typedef FNPRTSET *PFNPRTSET;


/*
** Typedefs for protocol converter APIs SplProtSendCmd and SplProtXlateCmd
** A port driver actually calls PMSPL.DLL at these entry points
**  and the spooler calls the correct protocol conveter for the port.
*/

typedef ULONG (APIENTRY FNPROTSEND) ( PSZ, ULONG, ULONG, PFN, PFN, PVOID,
                                      ULONG, PVOID, PULONG );
typedef FNPROTSEND *PFNPROTSEND;

typedef ULONG (APIENTRY FNPROTXLAT) ( PSZ, PFN, PVOID, ULONG, PVOID,
                                      PVOID, PULONG );
typedef FNPROTXLAT *PFNPROTXLAT;


#ifdef MAINPORTDRV
 HWND hwndHelp = NULLHANDLE;
 BOOL HelpStubHookIsSet = FALSE;
 BOOL HelpAlreadyInitialized = FALSE;
 PVOID pHeapBase = NULL;
 HMTX semPortDrv = NULLHANDLE;
 HEV  hevControl = NULLHANDLE;
 PDRWAITALERT PdrWaitAlert;
 TID   tidControlThread = 0;
 BOOL  fShutdownInProgress   = FALSE;
 BOOL  fControlWakeupPending = FALSE;
 HMODULE hPdrMod = NULLHANDLE;
 PPDOPENINST pPdOpenInstList = NULL;
 PPORTINST pPortInstList = NULL;
 BOOL         fLoadedPMSPL    = FALSE;
 PFNPROTSEND  pfnProtSendCmd  = NULL;
 PFNPROTXLAT  pfnProtXlateCmd = NULL;
 PFNPRTQUERY  pfnPrtQuery     = NULL;
 PFNPRTSET    pfnPrtSet       = NULL;
 PPORTDLGSTRUCT pOpenDlgList  = NULL;
 ULONG       flChangeDebugLog;  /* Change what debug logs(see FL_PDRDB_ above) */
#else
 extern
 HWND hwndHelp ;
 extern
 BOOL HelpStubHookIsSet;
 extern
 BOOL HelpAlreadyInitialized;
 extern
 PVOID pHeapBase;
 extern
 HMTX semPortDrv;
 extern
 HEV  hevControl;
 extern
 PDRWAITALERT PdrWaitAlert;
 extern
 TID   tidControlThread;
 extern
 BOOL  fShutdownInProgress;
 extern
 BOOL  fControlWakeupPending;
 extern
 HMODULE hPdrMod;
 extern
 PPDOPENINST pPdOpenInstList;
 extern
 PPORTINST pPortInstList;
 extern
 BOOL         fLoadedPMSPL;
 extern
 PFNPROTSEND  pfnProtSendCmd;
 extern
 PFNPROTXLAT  pfnProtXlateCmd;
 extern
 PFNPRTQUERY  pfnPrtQuery;
 extern
 PFNPRTSET    pfnPrtSet;
 extern
 PPORTDLGSTRUCT pOpenDlgList;
 extern
 ULONG       flChangeDebugLog;

#endif
