/**************************************************************************
 *
 * SOURCE FILE NAME = PDRPROTO.H
 *
 * DESCRIPTIVE NAME = Function prototypes for port driver
 *
 * Copyright : COPYRIGHT IBM CORPORATION, 1991, 1992
 *             LICENSED MATERIAL - PROGRAM PROPERTY OF IBM
 *             REFER TO COPYRIGHT INSTRUCTION FORM#G120-2083
 *             RESTRICTED MATERIALS OF IBM
 *             IBM CONFIDENTIAL
 *
 * VERSION = V2.0
 *
 * DATE
 *
 * DESCRIPTION
 *
 *
 * FUNCTIONS
 *
 * ENTRY POINTS:
 *
 * DEPENDENCIES:
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
 * CHANGE ACTIVITY =
 *  DATE      FLAG        APAR   CHANGE DESCRIPTION
 *  --------  ----------  -----  --------------------------------------
 *  mm/dd/yy  @Vr.mpppxx  xxxxx  xxxxxxx
 *
 ****************************************************************************/
/*
 * util.c
 */
PVOID          AllocPdrMem ( ULONG cb );
ULONG          FreePdrMem ( PVOID pMem, ULONG cb );
ULONG          EnterPdrSem ( VOID );
ULONG          LeavePdrSem ( VOID );
ULONG          EnterDlgSem ( PPORTDLGSTRUCT pPortDlgStruct );
ULONG          LeaveDlgSem ( PPORTDLGSTRUCT pPortDlgStruct );
ULONG          AddPdOpenInst ( PPDOPENINST pPdOpenInst );
ULONG          RemovePdOpenInst ( PPDOPENINST pPdOpenInst );
PPORTINST      AddPortInst ( PSZ pszPortName );
PPORTINST      NewPortInst ( PSZ pszPortName );
PPORTINST      FindPortInst ( PSZ pszPortName );
ULONG          RemovePortInst ( PSZ pszPortName );
ULONG          FreePortInst ( PPORTINST pPortInst );
ULONG          FreeAllPortInst ( VOID );
PPDOPENINST    ValidatePdOpenInst ( PPDOPENINST pPdOpenInst );
BOOL           AddPortDlgStruct ( PPORTDLGSTRUCT pPortDlgStruct );
BOOL           RemovePortDlgStruct ( PPORTDLGSTRUCT pPortDlgStruct );
PPORTDLGSTRUCT FindPortDlgStruct ( PPORTDLGSTRUCT pPortDlgStruct );
PPORTDLGSTRUCT ValidatePortDlg(PPORTDLGSTRUCT pPortDlgStruct);
ULONG          InitWaitAlertBufs( VOID );
VOID           PdrError ( ULONG ulCode, ULONG ulFile );
VOID           PdrPanic ( ULONG ulCode, ULONG ulFile );
VOID           PdrWarning ( ULONG ulCode, ULONG ulFile );
USHORT         DisplayError ( HWND hwndOwner,
                              USHORT usStringID,
                              USHORT usWinStyle );
ULONG          CalcBufLength ( HAB hab );
ULONG          CalcStructLength ( HAB hab,
                                  USHORT usID );
ULONG          NumPortsCanFit ( HAB hab,
                                ULONG cbBuf );
VOID           CopyNPorts ( HAB hab,
                            PCH pBuf,
                            ULONG ulReturned );
VOID           CopyStruct ( HAB hab,
                            USHORT usID,
                            PCH pBuf,
                            PULONG pulBeginStruct,
                            PULONG pulBeginText );
BOOL           GetPortDescription ( HAB hab,
                                    PSZ pszPortName,
                                    PSZ pszPortDesc );
BOOL           GetTimeOuts( PSZ pszPort, PPORTINST pPortInst );
VOID           RemoveLeadTrailBlanks ( PCH pTarget,
                                       PCH pSource );
VOID           DumpHex ( PBYTE pbHexChars, ULONG cb );
VOID           LogCall( PSZ pszMsg );
ULONG          time ( VOID );
BOOL           GenerateUniquePortName( PSZ pszPortName );
VOID           LoadPMSPL( VOID );
BOOL           ChkMem ( PVOID pMem, USHORT usMemSize, USHORT usFlags );
BOOL           ChkStr ( PSZ psz );
INT   APIENTRY ExceptRoutine(PEXCEPTIONREPORTRECORD pReportRec ,
                           PEXCEPTIONREGISTRATIONRECORD pLocalXRR,
                           PCONTEXTRECORD pContext,
                           PVOID pVoid);

ULONG          MyPrtQuery ( PSZ    pszComputerName,
                            PSZ    pszDeviceName,
                            ULONG  ulType,
                            ULONG  ulCommand,
                            PVOID  pInData,
                            ULONG  cbInData,
                            PVOID  pOutData,
                            PULONG pcbOutData );

ULONG          MyPrtSet   ( PSZ    pszComputerName,
                            PSZ    pszDeviceName,
                            ULONG  ulType,
                            ULONG  ulCommand,
                            PVOID  pInData,
                            ULONG  cbInData );

ULONG          MySplProtSendCmd( PSZ    pszPortName,
                                 ULONG  ulType,
                                 ULONG  ulCommand,
                                 PFN    pfnPdSendCmd,
                                 PFN    pfnBaseProtSendCmd,
                                 PVOID  pInData,
                                 ULONG  cbInData,
                                 PVOID  pOutData,
                                 PULONG pcbOutData );

ULONG          MySplProtXlateCmd( PSZ    pszPortName,
                                  PFN    pfnBaseProtXlateCmd,
                                  PVOID  pInData,
                                  ULONG  cbInData,
                                  PVOID  pAlertInfo,
                                  PVOID  pOutData,
                                  PULONG pcbOutData );


/*
 * In help.c
 */
BOOL APIENTRY CALLAssociateHelpInstance (HWND hwndHelpInstance, HWND hwndApp);
BOOL APIENTRY CALLDestroyHelpInstance(HWND hwndHelpInstance);
HWND APIENTRY CALLCreateHelpInstance(HAB hab,PHELPINIT phinitHMInitStructure);
HWND APIENTRY CALLQueryHelpInstance(HWND hwndApp);
VOID EXPENTRY InitializeHelp(VOID);
BOOL EXPENTRY SetHelpStubHook(VOID);
VOID EXPENTRY ReleaseHelpStubHook(VOID);
INT  EXPENTRY HelpStubHook( HAB AppHAB, USHORT Context, USHORT IdTopic,
                            USHORT IdSubTopic, PRECTL RectLPtr );

/*
 * par1284.c
 */
ULONG   PdOpen( PPORTINST pPortInst );
ULONG   PdWrite(PPORTINST pPortInst, PVOID pchData,
                          ULONG cbData, PULONG pcbWritten);
ULONG   PdClose( PPORTINST pPortInst );
ULONG   HandleQPort( PSZ    pszDeviceName,
                     ULONG  ulFlags,
                     PVOID  pOutData,
                     PULONG pcbOutData );
ULONG   HandleWaitAlert( PSZ    pszDeviceName,
                         ULONG  ulFlags,
                         ULONG  ulCommand,
                         PVOID  pInData,
                         ULONG  cbInData,
                         PVOID  pOutData,
                         PULONG pcbOutData );
ULONG   HandleQPortDRV( PSZ           pszPortName,
                        PPORTSETTINGS pPortSettings,
                        PULONG        pcbPortSettings );
ULONG   HandleSetPortDRV ( PSZ           pszPortName,
                           PPORTSETTINGS pPortSettings,
                           ULONG         cbPortSettings );
ULONG StartPassthru( PSZ    pszDeviceName,
                       ULONG  ulFlags,
                       ULONG  ulCommand,
                       PULONG pulPassthruWait,
                       ULONG  cbInData );
ULONG SendPassthru( PSZ    pszDeviceName,
                       ULONG  ulFlags,
                       ULONG  ulCommand,
                       PBYTE  pBuf,
                       ULONG  cbInData );
ULONG EndPassthru( PSZ    pszDeviceName,
                   ULONG  ulFlags,
                   ULONG  ulCommand,
                   PULONG pulPassthruWait,
                   ULONG  cbInData );
ULONG ReadPassthru( PSZ    pszDeviceName,
                       ULONG  ulFlags,
                       ULONG  ulCommand,
                       PVOID  pInData,
                       ULONG  cbInData,
                       PBYTE  pOutBuf,
                       PULONG pcbOutBuf );
TID     CreateControlThread( VOID );
VOID    EXPENTRY RecheckDevID( PPORTINST pPortInst );

/*
 * dialogs.c
 */
ULONG OpenPar1284PortDlg ( HAB hab, PPORTDLGSTRUCT pPortDlgStruct );
