/***************************************************************************
 *                                                                         *
 *     C O M M O N   D E F I N I T I O N S  (Header)                       *
 *                                                                         *
 *     Commonly used types and constants.                                  *
 *                                                                         *
 *     $Author:   TFW  $   $Date:   06 Aug 1994 21:31:18  $                                                   *
 *                                                                         *
 *     (C) IBM Corp. 1993, All Rights Reserved.                            *
 *                                                                         *
 ***************************************************************************/
#ifndef common_h
#define common_h

#ifndef  cmntypes_h
#include "cmntypes.h"
#endif

#ifdef __cplusplus
   extern "C" {
#endif


typedef S16           STATUS, *P_STATUS, LMPTR *LP_STATUS;

#define TIMEOUT 32767

// ===>FPN These routines are OS dependent
//          They should go into a separate file and be macrod

#define  INTR_FLAG      0x0200

#if defined(OS2PDD)

   #define  EnterCritical( s ) _asm           \
          {                                   \
            _asm pushf                        \
            _asm cli                          \
            _asm pop ax                       \
            _asm mov   WORD PTR s,ax          \
          }
   #define ExitCritical( s )                  \
         if (s & INTR_FLAG) _asm sti;

#elif defined(OS2VDD)

   #define EnterCritical(s)   DISABLE()
   #define ExitCritical(s)    ENABLE()

#elif defined(OS2DLL)

   #define EnterCritical(s)   DosEnterCritSec()
   #define ExitCritical(s)    DosExitCritSec()

#elif defined(_VXD_)

/*---------------------------------------------------------------------------
     Watcom Compiler Dependent Definitions
---------------------------------------------------------------------------*/
void INT1 ( void );
#pragma aux INT1 = 0xcd 0x01;

void CLI ( void );
#pragma aux CLI = 0xFA;

void STI ( void );
#pragma aux STI = 0xFB;

void CLD ( void );
#pragma aux CLD = 0xFC;

void EnterCritical (unsigned int s) ;
#pragma aux EnterCritical   =          \
         "pushf",                      \
         "cli",                        \
         "pop ax",                     \
         parm [ ax ]                   \
         modify [ ax ];

#define  ExitCritical( s )             \
         if (s & INTR_FLAG )  STI;


#else

   #define  EnterCritical( s )         \
   asm {                               \
         pushf ;                       \
         cli   ;                       \
         pop ax;                       \
         mov   WORD PTR s,ax ;         \
       }
   #define  ExitCritical( s )          \
         if (s & INTR_FLAG) asm sti;

#endif

typedef  U16      LMSEM;
#define  LMSEM_INIT(hsem)  {hsem = 0;}
#define  LMSEM_SET(hsem)   {++hsem;}
#define  LMSEM_CLOSE(hsem) {hsem = 0;}

#ifdef   OS2PDD
   // #define  YIELD             Yield()
   #define  YIELD
#elif defined(_WINDOWS_)
   #include <windows.h>
   #define  YIELD       { MSG Msg; PeekMessage(&Msg,NULL,0,0,PM_NOREMOVE);}
//   #define YIELD
#else
   #define  YIELD
#endif

#define  LMSEM_WAIT(hsem)  {while( hsem != 0) YIELD ;}
#define  LMSEM_CLEAR(hsem) {if (hsem>0) --hsem; }



#if defined(_WINDOWS_)

   #define OS_EOI(irqHandle)        \
   {                                \
      if ((U8)irqHandle > 7)        \
         outportb(0xA0, 0x20);      \
      outportb (0x20, 0x20);        \
   }

#elif defined(OS2PDD)

   #define  OS_EOI(irqHandle)       \
   {                                \
      EOI((U16)irqHandle);          \
   }

#elif defined(_VXD_)

   #define  OS_EOI(irqHandle)       \
   {                                \
      vpicdPhysEOI(irqHandle);      \
   }

#else

   #define OS_EOI(irqHandle)        \
   {                                \
      if ((U8)irqHandle > 7)        \
         outportb(0xA0, 0x20);      \
      outportb (0x20, 0x20);        \
   }

#endif




#ifdef __cplusplus
   }
#endif

#endif /* common_h */
