#----------------------------------------------------------------------------
# Setup parameters for build output type.  We have to account for the following
# potential build output types:
#
#        Target     Target  Target    Target     Build
#        Processor  OS      MK        Obj Fmt    Type
#        ---------------------------------------------
#        386        os2    ppci415      lx       debug
#        ppc        aix    integration  elf/elf+ retail
#         .         osf                  .       private
#         .          .                   .         .
#
# Change History:
# Defect#  Modified By    Description
# 102637   David Hoffman  Changes to allow for coexistence of ppci415 and
#                         integration MK.  Also allowed for makefile names
#                         other than "makefile".
# 147354   Alan Auerbach  Visual Age C++ changes (VACPP_VER=)
# 153161   Brad Fraley    Add DEKKO build
# 159832   C Burkett      Add support for VACPP_VER=v304
#----------------------------------------------------------------------------

retos2c:
       $(MAKE) $(MAKE_OPTS) -f $(MAKEFILE_NAME) OPT=$@  all

dbgos2c:
       $(MAKE) $(MAKE_OPTS) -f $(MAKEFILE_NAME) OPT=$@  all

dekos2c:
       $(MAKE) $(MAKE_OPTS) -f $(MAKEFILE_NAME) OPT=$@  all

privos2c:
       $(MAKE) $(MAKE_OPTS) -f $(MAKEFILE_NAME) OPT=$@  all

proos2c:
       $(MAKE) $(MAKE_OPTS) -f $(MAKEFILE_NAME) OPT=$@  all

retppc:
       $(MAKE) $(MAKE_OPTS) -f $(MAKEFILE_NAME) OPT=$@  all

retppc415:
       $(MAKE) $(MAKE_OPTS) -f $(MAKEFILE_NAME) OPT=$@  all

ret386lx:
       $(MAKE) $(MAKE_OPTS) -f $(MAKEFILE_NAME) OPT=$@  all

dbg386lx:
       $(MAKE) $(MAKE_OPTS) -f $(MAKEFILE_NAME) OPT=$@  all

priv386lx:
       $(MAKE) $(MAKE_OPTS) -f $(MAKEFILE_NAME) OPT=$@  all

deb386elf:
       $(MAKE) $(MAKE_OPTS) -f $(MAKEFILE_NAME) OPT=$@  all

ret386elf:
       $(MAKE) $(MAKE_OPTS) -f $(MAKEFILE_NAME) OPT=$@  all

priv386elf:
       $(MAKE) $(MAKE_OPTS) -f $(MAKEFILE_NAME) OPT=$@  all

dbgppc415:
       $(MAKE) $(MAKE_OPTS) -f $(MAKEFILE_NAME) OPT=$@  all

privppc415:
       $(MAKE) $(MAKE_OPTS) -f $(MAKEFILE_NAME) OPT=$@  all

dbgppc:
       $(MAKE) $(MAKE_OPTS) -f $(MAKEFILE_NAME) OPT=$@  all

privppc:
       $(MAKE) $(MAKE_OPTS) -f $(MAKEFILE_NAME) OPT=$@  all

!if "$(OPT)" == "dbg386lx"
BLD_TYPE=debug
TARGET_PROC=386
TARGET_PROD=386
EXE_FMT=lx
SOM_VER=21
!endif

!if "$(OPT)" == "ret386lx"
BLD_TYPE=retail
TARGET_PROC=386
TARGET_PROD=386
EXE_FMT=lx
SOM_VER=21
!endif

!if "$(OPT)" == "dbgos2c"
BLD_TYPE=debug
TARGET_PROC=386
TARGET_PROD=os2c
EXE_FMT=lx
SOM_VER=21
!if "$(VACPP_VER)" != "v304"
VACPP_VER=v3
!endif
!endif

!if "$(OPT)" == "retos2c"
BLD_TYPE=retail
TARGET_PROC=386
TARGET_PROD=os2c
EXE_FMT=lx
SOM_VER=21
!if "$(VACPP_VER)" != "v304"
VACPP_VER=v3
!endif
!endif

!if "$(OPT)" == "dekos2c"
BLD_TYPE=dekko
TARGET_PROC=386
TARGET_PROD=os2c
EXE_FMT=lx
SOM_VER=21
!if "$(VACPP_VER)" != "v304"
VACPP_VER=v3
!endif
!endif

!if "$(OPT)" == "privos2c"
BLD_TYPE=private
TARGET_PROC=386
TARGET_PROD=os2c
EXE_FMT=lx
SOM_VER=21
!if "$(VACPP_VER)" != "v304"
VACPP_VER=v3
!endif
!endif

!if "$(OPT)" == "proos2c"
BLD_TYPE=profile
TARGET_PROC=386
TARGET_PROD=os2c
EXE_FMT=lx
SOM_VER=21
!if "$(VACPP_VER)" != "v304"
VACPP_VER=v3
!endif
!endif


!if "$(OPT)" == "priv386lx"
BLD_TYPE=private
TARGET_PROC=386
TARGET_PROD=386
EXE_FMT=lx
SOM_VER=21
!endif


!if "$(OPT)" == "dbg386elf"
BLD_TYPE=debug
TARGET_PROC=386
TARGET_PROD=386
EXE_FMT=elf
SOM_VER=21
!endif

!if "$(OPT)" == "ret386elf"
BLD_TYPE=retail
TARGET_PROC=386
TARGET_PROD=386
EXE_FMT=elf
SOM_VER=21
!endif


!if "$(OPT)" == "priv386elf"
BLD_TYPE=private
TARGET_PROC=386
TARGET_PROD=386
EXE_FMT=elf
SOM_VER=21
!endif


!if "$(OPT)" == "dbgppc"
BLD_TYPE=debug
TARGET_PROC=ppc
TARGET_PROD=ppc
EXE_FMT=elf
SOM_VER=21
!endif

!if "$(OPT)" == "retppc"
BLD_TYPE=retail
TARGET_PROC=ppc
TARGET_PROD=ppc
EXE_FMT=elf
SOM_VER=21
!endif


!if "$(OPT)" == "privppc"
BLD_TYPE=private
TARGET_PROC=ppc
TARGET_PROD=ppc
EXE_FMT=elf
SOM_VER=21
!endif

!if "$(OPT)" == "dbgppc415"
BLD_TYPE=debug
TARGET_PROC=ppc
TARGET_PROD=ppc415
EXE_FMT=elf
SOM_VER=21
!endif

!if "$(OPT)" == "retppc415"
BLD_TYPE=retail
TARGET_PROC=ppc
TARGET_PROD=ppc415
EXE_FMT=elf
SOM_VER=21
!endif


!if "$(OPT)" == "privppc415"
BLD_TYPE=private
TARGET_PROC=ppc
TARGET_PROD=ppc415
EXE_FMT=elf
SOM_VER=21
!endif

