/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.ddnssgui.common;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;

public class TraceServerFile {
    private static final String cStmt1 = "(c) Copyright IBM Corp 1997. All rights reserved.\n";
    public static final int MAX_TRACE_FILE_SIZE = 1000000;
    private static final boolean NO_AUTO_FLUSH = false;
    private static final boolean AUTO_FLUSH = true;
    private static final String TRACE_EXTENSION = ".trc";
    private static final String BACKUP_EXTENSION = ".bak";
    private PrintWriter out;
    private FileOutputStream fileOut;
    private File traceFile;
    private String traceFileName;
    private File backupFile;
    private String backupFileName;
    private int maxTraceFileSize = 1000000;
    private int numBytesWritten;

    public TraceServerFile(String string, int n) {
        if (string != null && string.length() > 0) {
            this.traceFileName = String.valueOf(string) + TRACE_EXTENSION;
            this.backupFileName = String.valueOf(string) + BACKUP_EXTENSION;
            this.traceFile = new File(this.traceFileName);
            this.backupFile = new File(this.backupFileName);
            if (this.traceFile.exists() && this.traceFile.length() > 0L) {
                if (this.backupFile.exists()) {
                    this.backupFile.delete();
                }
                this.traceFile.renameTo(this.backupFile);
            }
            if (n > 0 && n <= 1000000) {
                this.maxTraceFileSize = n;
            }
            if (!this.traceFile.exists()) {
                String string2 = this.traceFile.getParent();
                File file = new File(string2);
                file.mkdirs();
            }
            try {
                this.fileOut = new FileOutputStream(this.traceFileName);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            this.out = new PrintWriter(this.fileOut, true);
            return;
        }
        System.err.println("Error in TraceServerFile:  unable to trace to file:  " + string);
        System.err.flush();
    }

    public String getFileName() {
        return this.traceFileName;
    }

    public synchronized void println(String string) {
        this.checkLength(string);
        this.out.println(string);
    }

    public void flush() {
        this.out.flush();
        try {
            this.fileOut.flush();
            return;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return;
        }
    }

    public void close() {
        this.out.close();
        try {
            this.fileOut.close();
            return;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return;
        }
    }

    private void checkLength(String string) {
        int n = 0;
        if (string != null) {
            n = string.length();
        }
        if (this.numBytesWritten + n >= this.maxTraceFileSize) {
            this.copyTraceToBackup();
            this.numBytesWritten = 0;
        }
        this.numBytesWritten += n;
    }

    private void copyTraceToBackup() {
        if (this.traceFile.exists()) {
            if (this.backupFile.exists()) {
                this.backupFile.delete();
            }
            this.flush();
            this.close();
            this.traceFile.renameTo(this.backupFile);
            this.traceFile.delete();
            try {
                this.fileOut = new FileOutputStream(this.traceFileName);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            this.out = new PrintWriter(this.fileOut, true);
        }
    }
}

