/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.ddnssgui.common;

import COM.ibm.raleigh.ddnssgui.common.ConfigurationManager;
import COM.ibm.raleigh.ddnssgui.common.DDNSfile;
import COM.ibm.raleigh.ddnssgui.common.NameServerObject;
import COM.ibm.raleigh.ddnssgui.common.ParsedObject;
import COM.ibm.raleigh.ddnssgui.common.SyslogFileEntry;
import COM.ibm.raleigh.ddnssgui.common.TraceClient;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.ResourceBundle;

public class TheSyslogFile
extends DDNSfile {
    private static final String cStmt1 = "(c) Copyright IBM Corp 1997. All rights reserved.\n";
    private static final String COMMENT_DELIMITER = "#";
    private static final String syslogFileName = "syslog.cnf";
    ConfigurationManager theMgr;
    String myFileName;
    TraceClient theTraceClient;

    public TheSyslogFile(ConfigurationManager configurationManager, TraceClient traceClient, ResourceBundle resourceBundle) {
        super(resourceBundle);
        this.theMgr = configurationManager;
        this.setTrace(traceClient, "TheSyslogFile");
        this.theTraceClient = traceClient;
    }

    public void setETCvariable(String string) {
        this.myFileName = new String(String.valueOf(string) + File.separator + "namedb" + File.separator + syslogFileName);
    }

    public String getFileName() {
        return this.myFileName;
    }

    public boolean readFile(String string) {
        boolean bl = false;
        this.myFileName = new String(String.valueOf(string) + File.separator + "namedb" + File.separator + syslogFileName);
        NameServerObject nameServerObject = this.theMgr.getFirstNameServer();
        if (nameServerObject == null) {
            return false;
        }
        BufferedReader bufferedReader = this.setInputFile(this.myFileName);
        if (bufferedReader != null) {
            String string2 = this.getNextLine(bufferedReader);
            while (string2 != null) {
                if (string2.startsWith(COMMENT_DELIMITER + this.theStrings.getString("COMMENT_BLOCK_LINE")) || string2.startsWith(COMMENT_DELIMITER + this.theStrings.getString("FILE_HEADER"), 20)) {
                    string2 = this.getNextLine(bufferedReader);
                    bl = true;
                    continue;
                }
                try {
                    SyslogFileEntry syslogFileEntry = new SyslogFileEntry(string2, this.theStrings);
                    this.addToFile(syslogFileEntry.getRecType(), syslogFileEntry);
                    if (!syslogFileEntry.getRecType().equals("CMT") && !syslogFileEntry.getRecType().equals("ERR_ENTRY")) {
                        if (syslogFileEntry.getRecType().equals("numLogFiles")) {
                            nameServerObject.setLogFileNum(this.getIntValue(syslogFileEntry));
                        } else if (syslogFileEntry.getRecType().equals("logFileSize")) {
                            nameServerObject.setSizeOfLogFile(this.getIntValue(syslogFileEntry));
                        } else if (syslogFileEntry.getRecType().equals("logFileName")) {
                            String string3 = syslogFileEntry.getRecordData();
                            if (string3.endsWith(".")) {
                                nameServerObject.setNameOfLogFile(string3.substring(0, string3.length() - 1));
                            } else {
                                nameServerObject.setNameOfLogFile(string3);
                            }
                        } else if (syslogFileEntry.getRecType().equals("logItem") && nameServerObject != null && syslogFileEntry.getRecordData().equals("LOG_DEBUG")) {
                            nameServerObject.setDebugLevel(true);
                        }
                    }
                }
                catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                    this.theTraceClient.traceTime(" config file array error");
                    return bl;
                }
                string2 = this.getNextLine(bufferedReader);
                bl = true;
            }
            this.closeInput();
        }
        return bl;
    }

    public boolean writeFile() {
        Enumeration enumeration = this.theFileData.elements();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        NameServerObject nameServerObject = this.theMgr.getFirstNameServer();
        boolean bl4 = false;
        BufferedWriter bufferedWriter = this.setOutputFile(this.myFileName);
        if (nameServerObject != null && bufferedWriter != null) {
            this.writeOutput(bufferedWriter, COMMENT_DELIMITER + this.theStrings.getString("COMMENT_BLOCK_LINE"));
            Object[] objectArray = new Object[]{new Date()};
            this.writeOutput(bufferedWriter, COMMENT_DELIMITER + MessageFormat.format(this.theStrings.getString("FILE_HEADER"), objectArray));
            this.writeOutput(bufferedWriter, COMMENT_DELIMITER + this.theStrings.getString("COMMENT_BLOCK_LINE"));
            while (enumeration.hasMoreElements()) {
                ParsedObject parsedObject = (ParsedObject)enumeration.nextElement();
                SyslogFileEntry syslogFileEntry = (SyslogFileEntry)parsedObject.getValue();
                if (syslogFileEntry.getRecType().equals("CMT")) {
                    this.writeOutput(bufferedWriter, syslogFileEntry.getRecordData());
                    continue;
                }
                if (syslogFileEntry.getRecType().equals("numLogFiles")) {
                    this.writeOutput(bufferedWriter, "numLogFiles " + nameServerObject.getLogFileNum());
                    bl = true;
                    continue;
                }
                if (syslogFileEntry.getRecType().equals("logFileSize")) {
                    this.writeOutput(bufferedWriter, "logFileSize " + nameServerObject.getSizeOfLogFile());
                    bl2 = true;
                    continue;
                }
                if (syslogFileEntry.getRecType().equals("logFileName")) {
                    this.writeOutput(bufferedWriter, "logFileName " + nameServerObject.getNameOfLogFile());
                    bl3 = true;
                    continue;
                }
                if (!syslogFileEntry.getRecType().equals("logItem") || syslogFileEntry.getRecordData().equals("LOG_DEBUG")) continue;
                this.writeOutput(bufferedWriter, "logItem " + syslogFileEntry.getRecordData());
            }
            if (!bl) {
                this.writeOutput(bufferedWriter, "numLogFiles " + nameServerObject.getLogFileNum());
            }
            if (!bl2) {
                this.writeOutput(bufferedWriter, "logFileSize " + nameServerObject.getSizeOfLogFile());
            }
            if (!bl3) {
                this.writeOutput(bufferedWriter, "logFileName " + nameServerObject.getNameOfLogFile());
            }
            if (nameServerObject.getDebugLevel()) {
                this.writeOutput(bufferedWriter, "logItem LOG_DEBUG");
            }
            this.closeOutput();
        }
        return bl4;
    }

    private int getIntValue(SyslogFileEntry syslogFileEntry) {
        if (syslogFileEntry.getRecordData() != null) {
            Integer n = Integer.valueOf(syslogFileEntry.getRecordData());
            return n;
        }
        return 0;
    }
}

