/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.ddnssgui.common;

import COM.ibm.raleigh.ddnssgui.common.ConfigFileEntry;
import COM.ibm.raleigh.ddnssgui.common.ConfigurationManager;
import COM.ibm.raleigh.ddnssgui.common.DDNSfile;
import COM.ibm.raleigh.ddnssgui.common.DomainObject;
import COM.ibm.raleigh.ddnssgui.common.GuiUserSettings;
import COM.ibm.raleigh.ddnssgui.common.NameAndIpAddress;
import COM.ibm.raleigh.ddnssgui.common.NameAndIpAddressList;
import COM.ibm.raleigh.ddnssgui.common.ParsedObject;
import COM.ibm.raleigh.ddnssgui.common.PrimaryDomain;
import COM.ibm.raleigh.ddnssgui.common.TheDomainFile;
import COM.ibm.raleigh.ddnssgui.common.TraceClient;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.ResourceBundle;

public class TheConfigFile
extends DDNSfile {
    private static final String cStmt1 = "(c) Copyright IBM Corp 1997. All rights reserved.\n";
    public static final String configFileName = "dnsext.cfg";
    String theCurrentName;
    Object theCurrentObject;
    String theDomain;
    boolean isIncludeFile;
    TheDomainFile parent;
    ConfigurationManager theMgr;
    String myFileName;
    TraceClient theTraceClient;

    public TheConfigFile(ConfigurationManager configurationManager, TraceClient traceClient, ResourceBundle resourceBundle) {
        super(resourceBundle);
        this.theMgr = configurationManager;
        this.setTrace(traceClient, "TheConfigFile");
        this.theTraceClient = traceClient;
    }

    public void setETCvariable(String string) {
        this.myFileName = new String(String.valueOf(string) + File.separator + "namedb" + File.separator + configFileName);
    }

    public String getFileName() {
        return this.myFileName;
    }

    public boolean readFile(String string) {
        boolean bl = false;
        this.myFileName = new String(String.valueOf(string) + File.separator + "namedb" + File.separator + configFileName);
        DomainObject domainObject = null;
        GuiUserSettings guiUserSettings = null;
        BufferedReader bufferedReader = this.setInputFile(this.myFileName);
        if (bufferedReader != null) {
            String string2 = this.getNextLine(bufferedReader);
            while (string2 != null) {
                if (string2.startsWith(String.valueOf(DDNSfile.COMMENT_DELIMITER) + this.theStrings.getString("COMMENT_BLOCK_LINE")) || string2.startsWith(String.valueOf(DDNSfile.COMMENT_DELIMITER) + this.theStrings.getString("FILE_HEADER"), 20)) {
                    string2 = this.getNextLine(bufferedReader);
                    bl = true;
                    continue;
                }
                try {
                    ConfigFileEntry configFileEntry = new ConfigFileEntry(string2, this.theStrings);
                    this.addToFile(configFileEntry.getRecType(), configFileEntry);
                    if (!configFileEntry.getRecType().equals("CMT") && !configFileEntry.getRecType().equals("ERR_ENTRY")) {
                        int n;
                        Object object;
                        Object object2;
                        if (configFileEntry.getRecType().equals("DOM_ENTRY")) {
                            domainObject = this.theMgr.getADomain(configFileEntry.getRecordData());
                            if (domainObject == null) {
                                this.makeIgnored(configFileEntry);
                            } else {
                                object2 = domainObject.getNameServerSetforDomain();
                                if (object2 != null) {
                                    object = ((NameAndIpAddressList)object2).elements();
                                    while (object.hasMoreElements()) {
                                        NameAndIpAddress nameAndIpAddress = (NameAndIpAddress)object.nextElement();
                                        if (nameAndIpAddress.getIpAddress().equals("-")) continue;
                                        domainObject.addToNotifyList(nameAndIpAddress.getIpAddress());
                                    }
                                }
                            }
                        } else if (configFileEntry.getRecType().equals("GUI_ENTRY")) {
                            guiUserSettings = new GuiUserSettings();
                        } else if (configFileEntry.getRecType().equals("DOM_END")) {
                            domainObject = null;
                            if (guiUserSettings != null) {
                                this.theMgr.setUserSettings(guiUserSettings);
                                guiUserSettings = null;
                            }
                        } else if (configFileEntry.getRecType().equals("timeSync")) {
                            if (domainObject != null) {
                                if (domainObject instanceof PrimaryDomain) {
                                    ((PrimaryDomain)domainObject).setTimeSync(this.getBooleanValue(configFileEntry));
                                } else {
                                    this.makeIgnored(configFileEntry);
                                }
                            } else {
                                this.makeIgnored(configFileEntry);
                            }
                        } else if (configFileEntry.getRecType().equals("ReInitHostKey")) {
                            if (domainObject != null) {
                                if (domainObject instanceof PrimaryDomain) {
                                    ((PrimaryDomain)domainObject).setHostKey(configFileEntry.getRecordData());
                                } else {
                                    this.makeIgnored(configFileEntry);
                                }
                            } else {
                                this.makeIgnored(configFileEntry);
                            }
                        } else if (configFileEntry.getRecType().equals("timeSync.toSecondaries")) {
                            if (domainObject != null) {
                                if (domainObject instanceof PrimaryDomain) {
                                    ((PrimaryDomain)domainObject).setForwardTime(this.getBooleanValue(configFileEntry));
                                } else {
                                    this.makeIgnored(configFileEntry);
                                }
                            } else {
                                this.makeIgnored(configFileEntry);
                            }
                        } else if (configFileEntry.getRecType().equals("notify")) {
                            if (domainObject != null) {
                                domainObject.setNotify(this.getBooleanValue(configFileEntry));
                            } else {
                                this.makeIgnored(configFileEntry);
                            }
                        } else if (configFileEntry.getRecType().equals("notify.add")) {
                            if (domainObject != null) {
                                if (configFileEntry.getRecordData() != null) {
                                    domainObject.addToNotifyList(configFileEntry.getRecordData());
                                } else {
                                    this.makeIgnored(configFileEntry);
                                }
                            } else {
                                this.makeIgnored(configFileEntry);
                            }
                        } else if (configFileEntry.getRecType().equals("notify.remove")) {
                            if (domainObject != null) {
                                if (configFileEntry.getRecordData() != null) {
                                    domainObject.removeFromNotifyList(configFileEntry.getRecordData());
                                } else {
                                    this.makeIgnored(configFileEntry);
                                }
                            } else {
                                this.makeIgnored(configFileEntry);
                            }
                        } else if (configFileEntry.getRecType().equals("notify.delayTime")) {
                            if (domainObject != null) {
                                n = this.getIntValue(configFileEntry);
                                if (n < 0) {
                                    this.makeIgnored(configFileEntry);
                                } else {
                                    domainObject.setNotifyDelayTime(n);
                                }
                            } else {
                                this.makeIgnored(configFileEntry);
                            }
                        } else if (configFileEntry.getRecType().equals("notify.retryTime")) {
                            if (domainObject != null) {
                                n = this.getIntValue(configFileEntry);
                                if (n < 0) {
                                    this.makeIgnored(configFileEntry);
                                } else {
                                    domainObject.setNotifyRetryTime(n);
                                }
                            } else {
                                this.makeIgnored(configFileEntry);
                            }
                        } else if (configFileEntry.getRecType().equals("notify.retryNumber")) {
                            if (domainObject != null) {
                                n = this.getIntValue(configFileEntry);
                                if (n < 0) {
                                    this.makeIgnored(configFileEntry);
                                } else {
                                    domainObject.setNotifyRetryNum(n);
                                }
                            } else {
                                this.makeIgnored(configFileEntry);
                            }
                        } else if (configFileEntry.getRecType().equals("safeWrite")) {
                            if (domainObject != null) {
                                if (domainObject instanceof PrimaryDomain) {
                                    ((PrimaryDomain)domainObject).setBackupData(this.getBooleanValue(configFileEntry));
                                } else {
                                    this.makeIgnored(configFileEntry);
                                }
                            } else {
                                this.makeIgnored(configFileEntry);
                            }
                        } else if (configFileEntry.getRecType().equals("sigDel")) {
                            if (domainObject != null) {
                                if (domainObject instanceof PrimaryDomain) {
                                    ((PrimaryDomain)domainObject).setDeleteSigs(this.getBooleanValue(configFileEntry));
                                } else {
                                    this.makeIgnored(configFileEntry);
                                }
                            } else {
                                this.makeIgnored(configFileEntry);
                            }
                        } else if (configFileEntry.getRecType().equals("sigDel.time")) {
                            if (domainObject != null) {
                                if (domainObject instanceof PrimaryDomain) {
                                    n = this.getIntValue(configFileEntry);
                                    if (n < 0 || n > 23) {
                                        this.makeIgnored(configFileEntry);
                                    } else {
                                        ((PrimaryDomain)domainObject).setSigDeletionTime(n);
                                    }
                                } else {
                                    this.makeIgnored(configFileEntry);
                                }
                            } else {
                                this.makeIgnored(configFileEntry);
                            }
                        } else if (configFileEntry.getRecType().equals("ttlSet")) {
                            if (domainObject != null) {
                                if (domainObject instanceof PrimaryDomain) {
                                    ((PrimaryDomain)domainObject).setOverwriteTTL(this.getBooleanValue(configFileEntry));
                                } else {
                                    this.makeIgnored(configFileEntry);
                                }
                            } else {
                                this.makeIgnored(configFileEntry);
                            }
                        } else if (configFileEntry.getRecType().equals("ttlSet.value")) {
                            if (domainObject != null) {
                                if (domainObject instanceof PrimaryDomain) {
                                    n = this.getIntValue(configFileEntry);
                                    if (n < 0 || n > Integer.MAX_VALUE) {
                                        this.makeIgnored(configFileEntry);
                                    } else {
                                        ((PrimaryDomain)domainObject).setTTLOverwriteValue(n);
                                    }
                                } else {
                                    this.makeIgnored(configFileEntry);
                                }
                            } else {
                                this.makeIgnored(configFileEntry);
                            }
                        } else if (configFileEntry.getRecType().equals("deferUpdCnt")) {
                            if (domainObject != null) {
                                if (domainObject instanceof PrimaryDomain) {
                                    n = this.getIntValue(configFileEntry);
                                    if (n < 0 || n > Integer.MAX_VALUE) {
                                        this.makeIgnored(configFileEntry);
                                    } else {
                                        ((PrimaryDomain)domainObject).setNoOfUpds(n);
                                    }
                                } else {
                                    this.makeIgnored(configFileEntry);
                                }
                            } else {
                                this.makeIgnored(configFileEntry);
                            }
                        } else if (configFileEntry.getRecType().equals("incrTime")) {
                            if (domainObject != null) {
                                if (domainObject instanceof PrimaryDomain) {
                                    n = this.getIntValue(configFileEntry);
                                    if (n < 0 || n > Integer.MAX_VALUE) {
                                        this.makeIgnored(configFileEntry);
                                    } else {
                                        ((PrimaryDomain)domainObject).setUpdateTime(n);
                                    }
                                } else {
                                    this.makeIgnored(configFileEntry);
                                }
                            } else {
                                this.makeIgnored(configFileEntry);
                            }
                        } else if (configFileEntry.getRecType().equals("keyToSec")) {
                            if (domainObject != null) {
                                if (domainObject instanceof PrimaryDomain) {
                                    ((PrimaryDomain)domainObject).setSendKeyToSec(this.getBooleanValue(configFileEntry));
                                } else {
                                    this.makeIgnored(configFileEntry);
                                }
                            } else {
                                this.makeIgnored(configFileEntry);
                            }
                        } else if (configFileEntry.getRecType().equals("sepDynStatic")) {
                            if (domainObject != null) {
                                if (domainObject instanceof PrimaryDomain) {
                                    if (this.getBooleanValue(configFileEntry)) {
                                        object2 = ((PrimaryDomain)domainObject).getStoredFile();
                                        object = ((TheDomainFile)object2).getStaticIncludeFileName();
                                        if (object == null || ((String)object).equals("")) {
                                            ((PrimaryDomain)domainObject).setSeparateDynStatData(false);
                                        } else {
                                            ((PrimaryDomain)domainObject).setStaticFileName((String)object);
                                            ((PrimaryDomain)domainObject).setSeparateDynStatData(true);
                                        }
                                    } else {
                                        ((PrimaryDomain)domainObject).setSeparateDynStatData(false);
                                    }
                                } else {
                                    this.makeIgnored(configFileEntry);
                                }
                            } else {
                                this.makeIgnored(configFileEntry);
                            }
                        } else if (configFileEntry.getRecType().equals("reverseMapping")) {
                            if (domainObject != null) {
                                if (domainObject instanceof PrimaryDomain) {
                                    ((PrimaryDomain)domainObject).setReverseMappingState(this.getBooleanValue(configFileEntry));
                                } else {
                                    this.makeIgnored(configFileEntry);
                                }
                            } else {
                                this.makeIgnored(configFileEntry);
                            }
                        } else if (configFileEntry.getRecType().equals("gui.warn")) {
                            if (guiUserSettings != null) {
                                guiUserSettings.setWarnBeforeOverwrite(this.getBooleanValue(configFileEntry));
                            } else {
                                this.makeIgnored(configFileEntry);
                            }
                        } else if (configFileEntry.getRecType().equals("gui.write")) {
                            if (guiUserSettings != null) {
                                guiUserSettings.setWriteErrorsToFile(this.getBooleanValue(configFileEntry));
                            } else {
                                this.makeIgnored(configFileEntry);
                            }
                        } else if (configFileEntry.getRecType().equals("gui.reinit")) {
                            if (guiUserSettings != null) {
                                n = this.getIntValue(configFileEntry);
                                if (n < 1 || n > 3) {
                                    this.makeIgnored(configFileEntry);
                                } else {
                                    guiUserSettings.setReinitServer(n);
                                }
                            } else {
                                this.makeIgnored(configFileEntry);
                            }
                        } else if (configFileEntry.getRecType().equals("gui.sepdata")) {
                            if (guiUserSettings != null) {
                                n = this.getIntValue(configFileEntry);
                                if (n < 1 || n > 3) {
                                    this.makeIgnored(configFileEntry);
                                } else {
                                    guiUserSettings.setSepData(n);
                                }
                            } else {
                                this.makeIgnored(configFileEntry);
                            }
                        } else if (configFileEntry.getRecType().equals("gui.num")) {
                            if (guiUserSettings != null) {
                                n = this.getIntValue(configFileEntry);
                                if (n < 0 || n > Integer.MAX_VALUE) {
                                    this.makeIgnored(configFileEntry);
                                } else {
                                    guiUserSettings.setNumberToShow(n);
                                }
                            } else {
                                this.makeIgnored(configFileEntry);
                            }
                        } else if (configFileEntry.getRecType().equals("gui.lease")) {
                            if (guiUserSettings != null) {
                                n = this.getIntValue(configFileEntry);
                                if (n < 0 || n > Integer.MAX_VALUE) {
                                    this.makeIgnored(configFileEntry);
                                } else {
                                    guiUserSettings.setSigLease(n);
                                }
                            } else {
                                this.makeIgnored(configFileEntry);
                            }
                        } else if (configFileEntry.getRecType().equals("gui.pad")) {
                            if (guiUserSettings != null) {
                                n = this.getIntValue(configFileEntry);
                                if (n < 0 || n > Integer.MAX_VALUE) {
                                    this.makeIgnored(configFileEntry);
                                } else {
                                    guiUserSettings.setSigPad(n);
                                }
                            } else {
                                this.makeIgnored(configFileEntry);
                            }
                        } else {
                            this.makeIgnored(configFileEntry);
                        }
                    }
                }
                catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                    this.theTraceClient.traceTime(" config file array error");
                    return bl;
                }
                string2 = this.getNextLine(bufferedReader);
                bl = true;
            }
            this.closeInput();
        }
        return bl;
    }

    public boolean writeFile() {
        String[] stringArray = this.theMgr.getListOfDomains();
        Enumeration enumeration = this.theFileData.elements();
        DomainObject domainObject = null;
        boolean bl = false;
        boolean bl2 = false;
        BufferedWriter bufferedWriter = this.setOutputFile(this.myFileName);
        if (bufferedWriter != null) {
            this.writeOutput(bufferedWriter, String.valueOf(DDNSfile.COMMENT_DELIMITER) + this.theStrings.getString("COMMENT_BLOCK_LINE"));
            Object[] objectArray = new Object[]{new Date()};
            this.writeOutput(bufferedWriter, String.valueOf(DDNSfile.COMMENT_DELIMITER) + MessageFormat.format(this.theStrings.getString("FILE_HEADER"), objectArray));
            this.writeOutput(bufferedWriter, String.valueOf(DDNSfile.COMMENT_DELIMITER) + this.theStrings.getString("COMMENT_BLOCK_LINE"));
            while (enumeration.hasMoreElements()) {
                ParsedObject parsedObject = (ParsedObject)enumeration.nextElement();
                ConfigFileEntry configFileEntry = (ConfigFileEntry)parsedObject.getValue();
                if (configFileEntry.getRecType().equals("CMT") && !bl) {
                    this.writeOutput(bufferedWriter, configFileEntry.getRecordData());
                    continue;
                }
                if (configFileEntry.getRecType().equals("IGN_ENTRY") && !bl) continue;
                if (configFileEntry.getRecType().equals("DOM_END")) {
                    if (!bl) continue;
                    bl = false;
                    continue;
                }
                if (!configFileEntry.getRecType().equals("DOM_ENTRY")) continue;
                domainObject = this.theMgr.getADomain(configFileEntry.getRecordData());
                if (domainObject == null) {
                    bl = true;
                    continue;
                }
                this.writeDomainOutput(bufferedWriter, configFileEntry, enumeration, domainObject);
                this.removeDomain(configFileEntry.getRecordData(), stringArray);
            }
            this.handleRemainingDomains(stringArray, bufferedWriter);
            this.handleUserSettings(this.theMgr, bufferedWriter);
            this.closeOutput();
        }
        return bl2;
    }

    private void writeDomainOutput(BufferedWriter bufferedWriter, ConfigFileEntry configFileEntry, Enumeration enumeration, DomainObject domainObject) {
        this.writeOutput(bufferedWriter, String.valueOf(domainObject.getDomName()) + " (");
        String[] stringArray = null;
        if (domainObject.getNotify()) {
            int n;
            this.writeOutput(bufferedWriter, "notify=yes");
            String[] stringArray2 = domainObject.getNonSecondaryAddrsAddedToNotifyList();
            if (stringArray2 != null) {
                n = 0;
                while (n < stringArray2.length) {
                    this.writeOutput(bufferedWriter, "notify.add=" + stringArray2[n]);
                    ++n;
                }
            }
            if ((stringArray2 = domainObject.getSecondaryAddrsRemovedFromNotifyList()) != null) {
                n = 0;
                while (n < stringArray2.length) {
                    if (!stringArray2[n].equals("-")) {
                        this.writeOutput(bufferedWriter, "notify.remove=" + stringArray2[n]);
                    }
                    ++n;
                }
            }
            this.writeOutput(bufferedWriter, "notify.delayTime=" + domainObject.getNotifyDelayTime());
            this.writeOutput(bufferedWriter, "notify.retryTime=" + domainObject.getNotifyRetryTime());
            this.writeOutput(bufferedWriter, "notify.retryNumber=" + domainObject.getNotifyRetryNum());
        } else {
            this.writeOutput(bufferedWriter, "notify=no");
        }
        if (domainObject instanceof PrimaryDomain) {
            if (((PrimaryDomain)domainObject).getTimeSync()) {
                this.writeOutput(bufferedWriter, "timeSync=yes");
                if (((PrimaryDomain)domainObject).getForwardTime()) {
                    this.writeOutput(bufferedWriter, "timeSync.toSecondaries=yes");
                } else {
                    this.writeOutput(bufferedWriter, "timeSync.toSecondaries=no");
                }
            } else {
                this.writeOutput(bufferedWriter, "timeSync=no");
            }
            if (((PrimaryDomain)domainObject).getBackupData()) {
                this.writeOutput(bufferedWriter, "safeWrite=yes");
            } else {
                this.writeOutput(bufferedWriter, "safeWrite=no");
            }
            if (((PrimaryDomain)domainObject).getDeleteSigs()) {
                this.writeOutput(bufferedWriter, "sigDel=yes");
                this.writeOutput(bufferedWriter, "sigDel.time=" + ((PrimaryDomain)domainObject).getSigDeletionTime());
            } else {
                this.writeOutput(bufferedWriter, "sigDel=no");
            }
            if (((PrimaryDomain)domainObject).getOverwriteTTL()) {
                this.writeOutput(bufferedWriter, "ttlSet=yes");
                this.writeOutput(bufferedWriter, "ttlSet.value=" + ((PrimaryDomain)domainObject).getTTLOverwriteValue());
            } else {
                this.writeOutput(bufferedWriter, "ttlSet=no");
            }
            this.writeOutput(bufferedWriter, "deferUpdCnt=" + ((PrimaryDomain)domainObject).getNoOfUpds());
            this.writeOutput(bufferedWriter, "incrTime=" + ((PrimaryDomain)domainObject).getUpdateTime());
            if (((PrimaryDomain)domainObject).getSendKeyToSec()) {
                this.writeOutput(bufferedWriter, "keyToSec=yes");
            } else {
                this.writeOutput(bufferedWriter, "keyToSec=no");
            }
            if (((PrimaryDomain)domainObject).getSeparateDynStatData()) {
                this.writeOutput(bufferedWriter, "sepDynStatic=yes");
            } else {
                this.writeOutput(bufferedWriter, "sepDynStatic=no");
            }
            if (((PrimaryDomain)domainObject).getReverseMappingState()) {
                this.writeOutput(bufferedWriter, "reverseMapping=yes");
            } else {
                this.writeOutput(bufferedWriter, "reverseMapping=no");
            }
            stringArray = ((PrimaryDomain)domainObject).getHostKeys();
            if (stringArray != null) {
                int n = 0;
                while (n < stringArray.length) {
                    this.writeOutput(bufferedWriter, "ReInitHostKey=" + stringArray[n]);
                    ++n;
                }
            }
        }
        if (enumeration != null) {
            while (enumeration.hasMoreElements() && !configFileEntry.getRecType().equals("DOM_END")) {
                ParsedObject parsedObject = (ParsedObject)enumeration.nextElement();
                configFileEntry = (ConfigFileEntry)parsedObject.getValue();
                if (!configFileEntry.getRecType().equals("IGN_ENTRY") && !configFileEntry.getRecType().equals("CMT")) continue;
                this.writeOutput(bufferedWriter, configFileEntry.getRecordData());
            }
        }
        this.writeOutput(bufferedWriter, ")");
    }

    private void removeDomain(String string, String[] stringArray) {
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                if (stringArray[n] != null && !stringArray[n].equals("") && stringArray[n].equalsIgnoreCase(string)) {
                    stringArray[n] = new String("");
                    return;
                }
                ++n;
            }
        }
    }

    private void handleRemainingDomains(String[] stringArray, BufferedWriter bufferedWriter) {
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                DomainObject domainObject;
                if (stringArray[n] != null && !stringArray[n].equals("") && (domainObject = this.theMgr.getADomain(stringArray[n])) != null) {
                    this.writeDomainOutput(bufferedWriter, null, null, domainObject);
                }
                ++n;
            }
        }
    }

    private void handleUserSettings(ConfigurationManager configurationManager, BufferedWriter bufferedWriter) {
        GuiUserSettings guiUserSettings = configurationManager.getUserSettings();
        if (guiUserSettings != null) {
            this.writeOutput(bufferedWriter, "DDNSAdministratorClient (");
            if (guiUserSettings.getWarnBeforeOverwrite()) {
                this.writeOutput(bufferedWriter, "gui.warn=yes");
            } else {
                this.writeOutput(bufferedWriter, "gui.warn=no");
            }
            if (guiUserSettings.getWriteErrorsToFile()) {
                this.writeOutput(bufferedWriter, "gui.write=yes");
            } else {
                this.writeOutput(bufferedWriter, "gui.write=no");
            }
            this.writeOutput(bufferedWriter, "gui.num=" + guiUserSettings.getNumberToShow());
            this.writeOutput(bufferedWriter, "gui.lease=" + guiUserSettings.getSigLease());
            this.writeOutput(bufferedWriter, "gui.pad=" + guiUserSettings.getSigPad());
            this.writeOutput(bufferedWriter, "gui.reinit=" + guiUserSettings.getReinitServer());
            this.writeOutput(bufferedWriter, "gui.sepdata=" + guiUserSettings.getSepData());
            this.writeOutput(bufferedWriter, " )");
        }
    }

    private void makeIgnored(ConfigFileEntry configFileEntry) {
        configFileEntry.reSetRecordData();
        configFileEntry.setRecType("IGN_ENTRY");
    }

    private boolean getBooleanValue(ConfigFileEntry configFileEntry) {
        if (configFileEntry.getRecordData().equalsIgnoreCase("yes")) {
            return true;
        }
        if (configFileEntry.getRecordData().equalsIgnoreCase("no")) {
            return false;
        }
        this.makeIgnored(configFileEntry);
        return false;
    }

    private int getIntValue(ConfigFileEntry configFileEntry) {
        if (configFileEntry.getRecordData() != null) {
            Integer n = Integer.valueOf(configFileEntry.getRecordData());
            return n;
        }
        this.makeIgnored(configFileEntry);
        return -1;
    }
}

