/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.ddnssgui.common;

import COM.ibm.raleigh.ddnssgui.common.BootFileEntry;
import COM.ibm.raleigh.ddnssgui.common.ConfigurationManager;
import COM.ibm.raleigh.ddnssgui.common.DDNSUtility;
import COM.ibm.raleigh.ddnssgui.common.DDNSfile;
import COM.ibm.raleigh.ddnssgui.common.DomainObject;
import COM.ibm.raleigh.ddnssgui.common.NameServerObject;
import COM.ibm.raleigh.ddnssgui.common.ParsedObject;
import COM.ibm.raleigh.ddnssgui.common.PrimaryDomain;
import COM.ibm.raleigh.ddnssgui.common.SecondaryDomain;
import COM.ibm.raleigh.ddnssgui.common.TraceClient;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;

public class TheBootFile
extends DDNSfile {
    private static final String cStmt1 = "(c) Copyright IBM Corp 1997. All rights reserved.\n";
    private static final String COMMENT_DELIMITER = ";";
    private TraceClient theTrace;
    Vector errorLines = new Vector();
    ConfigurationManager theMgr;

    public TheBootFile(TraceClient traceClient, ResourceBundle resourceBundle) {
        super(resourceBundle);
        this.theTrace = traceClient;
        this.setTrace(traceClient, "TheBootFile");
    }

    public boolean readFile(String string, ConfigurationManager configurationManager) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        this.theMgr = configurationManager;
        NameServerObject nameServerObject = new NameServerObject(this.theMgr.getETCpath());
        boolean bl = false;
        String string2 = null;
        try {
            object4 = InetAddress.getLocalHost();
            object3 = ((InetAddress)object4).getHostAddress();
            object2 = InetAddress.getAllByName((String)object3);
            int n = 0;
            while (n < ((InetAddress[])object2).length) {
                object = new StringTokenizer(object2[n].toString(), "/");
                String string3 = ((StringTokenizer)object).nextToken();
                String string4 = ((StringTokenizer)object).nextToken();
                nameServerObject.addFQName(string3, string4);
                ++n;
            }
        }
        catch (UnknownHostException unknownHostException) {
            this.theTrace.traceTime("unknown host");
            return false;
        }
        object4 = this.setInputFile(string);
        if (object4 != null) {
            this.theMgr.giveANameServer(nameServerObject);
            nameServerObject.setBootFileName(DDNSUtility.stripFileName(string));
            String string5 = this.getNextLine((BufferedReader)object4);
            while (string5 != null) {
                if (string5.startsWith(COMMENT_DELIMITER + this.theStrings.getString("COMMENT_BLOCK_LINE")) || string5.startsWith(COMMENT_DELIMITER + this.theStrings.getString("FILE_HEADER"), 20) || string5.equals("")) {
                    string5 = this.getNextLine((BufferedReader)object4);
                    bl = true;
                    continue;
                }
                try {
                    object3 = new BootFileEntry(string5, this.theStrings);
                    if (((BootFileEntry)object3).getRecType().equals("PRI")) {
                        object2 = this.theMgr.getADomain(((BootFileEntry)object3).getDomainName());
                        if (object2 == null) {
                            object = this.makeNewPrimaryDomain((BootFileEntry)object3, string2);
                            this.theMgr.giveADomain((DomainObject)object, "from file");
                            this.theMgr.linkDomain((DomainObject)object, nameServerObject, this);
                        } else {
                            ((BootFileEntry)object3).setRecType("IGN");
                            this.errorLines.addElement(COMMENT_DELIMITER + this.theStrings.getString("FILE_IGNORED") + ((BootFileEntry)object3).getRecordData());
                        }
                    } else if (((BootFileEntry)object3).getRecType().equals("SEC")) {
                        object2 = this.theMgr.getADomain(((BootFileEntry)object3).getDomainName());
                        if (object2 == null) {
                            object = this.makeNewSecondaryDomain((BootFileEntry)object3, string2);
                            this.theMgr.giveADomain((DomainObject)object);
                            this.theMgr.linkDomain((DomainObject)object, nameServerObject, this);
                        } else {
                            ((BootFileEntry)object3).setRecType("IGN");
                            this.errorLines.addElement(COMMENT_DELIMITER + this.theStrings.getString("FILE_IGNORED") + ((BootFileEntry)object3).getRecordData());
                        }
                    } else if (((BootFileEntry)object3).getRecType().equals("FOR")) {
                        this.readForwarders((BootFileEntry)object3, nameServerObject);
                    } else if (((BootFileEntry)object3).getRecType().equals("CAC")) {
                        this.readCache((BootFileEntry)object3, nameServerObject, string2);
                    } else if (((BootFileEntry)object3).getRecType().equals("SLA")) {
                        nameServerObject.setSlaveNameServer(true);
                    } else if (((BootFileEntry)object3).getRecType().equals("DIR")) {
                        string2 = ((BootFileEntry)object3).getPathName();
                    } else if (((BootFileEntry)object3).getRecType().equals("ERR")) {
                        this.errorLines.addElement(COMMENT_DELIMITER + this.theStrings.getString("FILE_ERROR") + ((BootFileEntry)object3).getRecordData());
                    } else if (((BootFileEntry)object3).getRecType().equals("IGN")) {
                        this.errorLines.addElement(COMMENT_DELIMITER + this.theStrings.getString("FILE_IGNORED") + ((BootFileEntry)object3).getRecordData());
                    }
                    this.addToFile(((BootFileEntry)object3).getRecType(), object3);
                }
                catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                    this.theTrace.traceTime("TheBootFile", String.valueOf(this.theStrings.getString("BOOT_FILE_ARRAY_ERROR")) + string);
                    return bl;
                }
                string5 = this.getNextLine((BufferedReader)object4);
                bl = true;
            }
            this.closeInput();
        }
        return bl;
    }

    public String[] getInvalidLines() {
        if (this.errorLines.isEmpty()) {
            String[] stringArray = new String[]{this.theStrings.getString("BOOT_FILE_NO_ERROR")};
            return stringArray;
        }
        Object[] objectArray = new String[this.errorLines.size()];
        this.errorLines.copyInto(objectArray);
        return objectArray;
    }

    public boolean writeFile(ConfigurationManager configurationManager, NameServerObject nameServerObject, boolean bl) {
        this.theMgr = configurationManager;
        int n = 0;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        BufferedWriter bufferedWriter = this.setOutputFile(nameServerObject.getBootFileName());
        if (nameServerObject != null && bufferedWriter != null) {
            this.writeOutput(bufferedWriter, COMMENT_DELIMITER + this.theStrings.getString("COMMENT_BLOCK_LINE"));
            Object[] objectArray = new Object[]{new Date()};
            this.writeOutput(bufferedWriter, COMMENT_DELIMITER + MessageFormat.format(this.theStrings.getString("FILE_HEADER"), objectArray));
            this.writeOutput(bufferedWriter, COMMENT_DELIMITER + this.theStrings.getString("COMMENT_BLOCK_LINE"));
            String[] stringArray = this.theFileData.getKeys();
            if (stringArray == null) {
                this.writeBootFileData(nameServerObject, bufferedWriter, bl4, bl3, bl5);
                this.closeOutput();
            } else {
                n = 0;
                while (n < stringArray.length) {
                    Object object;
                    ParsedObject parsedObject = this.theFileData.get(n);
                    String string = parsedObject.getKey();
                    if (string.equals("PDOM") || string.equals("SDOM")) {
                        object = this.theMgr.getADomain((String)parsedObject.getValue());
                        if (object != null) {
                            if (object instanceof PrimaryDomain) {
                                this.writeOutput(bufferedWriter, this.makePrimaryBootFileEntry((PrimaryDomain)object));
                            } else if (object instanceof SecondaryDomain) {
                                this.writeOutput(bufferedWriter, this.makeSecondaryBootFileEntry((SecondaryDomain)object));
                            }
                        }
                    } else if (string.equals("CMT")) {
                        this.writeOutput(bufferedWriter, ((BootFileEntry)parsedObject.getValue()).getRecordData());
                    } else if (string.equals("PRI")) {
                        this.writeOutput(bufferedWriter, this.makePrimaryBootFileEntry((BootFileEntry)parsedObject.getValue()));
                    } else if (string.equals("SEC")) {
                        this.writeOutput(bufferedWriter, this.makeSecondaryBootFileEntry((BootFileEntry)parsedObject.getValue()));
                    } else if (string.equals("SOR")) {
                        this.writeOutput(bufferedWriter, ((BootFileEntry)parsedObject.getValue()).getRecordData());
                    } else if (string.equals("INC")) {
                        this.writeOutput(bufferedWriter, ((BootFileEntry)parsedObject.getValue()).getRecordData());
                    } else if (string.equals("STU")) {
                        this.writeOutput(bufferedWriter, ((BootFileEntry)parsedObject.getValue()).getRecordData());
                    } else if (string.equals("OPT")) {
                        this.writeOutput(bufferedWriter, ((BootFileEntry)parsedObject.getValue()).getRecordData());
                    } else if (string.equals("LIM")) {
                        this.writeOutput(bufferedWriter, ((BootFileEntry)parsedObject.getValue()).getRecordData());
                    } else if (string.equals("XRF")) {
                        this.writeOutput(bufferedWriter, ((BootFileEntry)parsedObject.getValue()).getRecordData());
                    } else if (string.equals("BOG")) {
                        this.writeOutput(bufferedWriter, ((BootFileEntry)parsedObject.getValue()).getRecordData());
                    } else if (string.equals("CHE")) {
                        this.writeOutput(bufferedWriter, ((BootFileEntry)parsedObject.getValue()).getRecordData());
                    } else if (string.equals("CAC")) {
                        this.writeOutput(bufferedWriter, this.makeCacheBootFileEntry((BootFileEntry)parsedObject.getValue(), nameServerObject));
                        bl5 = true;
                    } else if (string.equals("FOR")) {
                        object = this.makeForwardersBootFileEntry((BootFileEntry)parsedObject.getValue(), nameServerObject);
                        if (object != null) {
                            this.writeOutput(bufferedWriter, (String)object);
                        }
                        bl4 = true;
                    } else if (string.equals("SLA")) {
                        this.writeOutput(bufferedWriter, this.makeSlaveBootFileEntry((BootFileEntry)parsedObject.getValue(), nameServerObject));
                        bl3 = true;
                    } else if ((string.equals("ERR") || string.equals("IGN")) && bl) {
                        this.writeOutput(bufferedWriter, this.makeErrBootFileEntry((BootFileEntry)parsedObject.getValue()));
                    }
                    ++n;
                }
                this.writeBootFileData(nameServerObject, bufferedWriter, bl4, bl3, bl5);
                this.closeOutput();
            }
        } else {
            this.theTrace.traceTime("TheBootFile", this.theStrings.getString("BOOT_FILE_NS_NOT_FOUND_ERROR"));
        }
        return bl2;
    }

    public String[] writeFileToDisplay(ConfigurationManager configurationManager, NameServerObject nameServerObject) {
        int n = 0;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        Vector<Object> vector = new Vector<Object>();
        Object[] objectArray = null;
        if (nameServerObject != null) {
            String[] stringArray = this.theFileData.getKeys();
            if (stringArray == null) {
                return this.getBootFileData(nameServerObject, false, false, false);
            }
            n = 0;
            while (n < stringArray.length) {
                Object object;
                ParsedObject parsedObject = this.theFileData.get(n);
                String string = parsedObject.getKey();
                if (string.equals("PDOM") || string.equals("SDOM")) {
                    object = configurationManager.getADomain((String)parsedObject.getValue());
                    if (object != null) {
                        if (object instanceof PrimaryDomain) {
                            vector.addElement(this.makePrimaryBootFileEntry((PrimaryDomain)object));
                        } else if (object instanceof SecondaryDomain) {
                            vector.addElement(this.makeSecondaryBootFileEntry((SecondaryDomain)object));
                        }
                    }
                } else if (string.equals("PRI")) {
                    vector.addElement(this.makePrimaryBootFileEntry((BootFileEntry)parsedObject.getValue()));
                } else if (string.equals("SEC")) {
                    vector.addElement(this.makeSecondaryBootFileEntry((BootFileEntry)parsedObject.getValue()));
                } else if (string.equals("CAC")) {
                    vector.addElement(this.makeCacheBootFileEntry((BootFileEntry)parsedObject.getValue(), nameServerObject));
                    bl3 = true;
                } else if (string.equals("FOR")) {
                    object = this.makeForwardersBootFileEntry((BootFileEntry)parsedObject.getValue(), nameServerObject);
                    if (object != null) {
                        vector.addElement(object);
                    }
                    bl2 = true;
                } else if (string.equals("SLA")) {
                    vector.addElement(this.makeSlaveBootFileEntry((BootFileEntry)parsedObject.getValue(), nameServerObject));
                    bl = true;
                } else if (string.equals("SOR")) {
                    vector.addElement(((BootFileEntry)parsedObject.getValue()).getRecordData());
                } else if (string.equals("INC")) {
                    vector.addElement(((BootFileEntry)parsedObject.getValue()).getRecordData());
                } else if (string.equals("STU")) {
                    vector.addElement(((BootFileEntry)parsedObject.getValue()).getRecordData());
                } else if (string.equals("OPT")) {
                    vector.addElement(((BootFileEntry)parsedObject.getValue()).getRecordData());
                } else if (string.equals("LIM")) {
                    vector.addElement(((BootFileEntry)parsedObject.getValue()).getRecordData());
                } else if (string.equals("XRF")) {
                    vector.addElement(((BootFileEntry)parsedObject.getValue()).getRecordData());
                } else if (string.equals("BOG")) {
                    vector.addElement(((BootFileEntry)parsedObject.getValue()).getRecordData());
                } else if (string.equals("CHE")) {
                    vector.addElement(((BootFileEntry)parsedObject.getValue()).getRecordData());
                }
                ++n;
            }
            String[] stringArray2 = this.getBootFileData(nameServerObject, bl2, bl, bl3);
            int n2 = vector.size();
            if (stringArray2 != null) {
                n2 += stringArray2.length;
            }
            objectArray = new String[n2];
            vector.copyInto(objectArray);
            int n3 = 0;
            n = vector.size();
            while (n < n2) {
                objectArray[n] = stringArray2[n3++];
                ++n;
            }
        }
        return objectArray;
    }

    private PrimaryDomain makeNewPrimaryDomain(BootFileEntry bootFileEntry, String string) {
        PrimaryDomain primaryDomain = new PrimaryDomain();
        primaryDomain.setDomName(bootFileEntry.getDomainName());
        if (string != null) {
            primaryDomain.setDataFileName(String.valueOf(DDNSUtility.stripFileName(string)) + File.separator + bootFileEntry.getFileName());
        } else {
            primaryDomain.setDataFileName(bootFileEntry.getFileName());
        }
        if (bootFileEntry.isDomainDynamic()) {
            primaryDomain.makeDynamic();
            if (bootFileEntry.isDomainPresecured()) {
                primaryDomain.setPresecured();
            } else {
                primaryDomain.setSecured();
            }
        } else {
            primaryDomain.makeStatic();
        }
        return primaryDomain;
    }

    public SecondaryDomain makeNewSecondaryDomain(BootFileEntry bootFileEntry, String string) {
        SecondaryDomain secondaryDomain = new SecondaryDomain();
        secondaryDomain.setDomName(bootFileEntry.getDomainName());
        String[] stringArray = bootFileEntry.getDataList();
        if (stringArray != null) {
            secondaryDomain.setMasterServersforDomain(stringArray);
        }
        if (string != null) {
            secondaryDomain.setDataFileName(String.valueOf(DDNSUtility.stripFileName(string)) + File.separator + bootFileEntry.getFileName());
        } else {
            secondaryDomain.setDataFileName(bootFileEntry.getFileName());
        }
        return secondaryDomain;
    }

    public void writeBootFileData(NameServerObject nameServerObject, BufferedWriter bufferedWriter, boolean bl, boolean bl2, boolean bl3) {
        String[] stringArray = this.getBootFileData(nameServerObject, bl, bl2, bl3);
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                this.writeOutput(bufferedWriter, stringArray[n]);
                ++n;
            }
        }
    }

    public String[] getBootFileData(NameServerObject nameServerObject, boolean bl, boolean bl2, boolean bl3) {
        Vector<String> vector = new Vector<String>();
        Object[] objectArray = null;
        String[] stringArray = null;
        if (!bl3) {
            String string = new String("cache . " + DDNSUtility.padFileName(nameServerObject.getCacheFileName()));
            vector.addElement(string);
        }
        if (!bl && (stringArray = nameServerObject.getForwardIp()) != null && stringArray.length > 0) {
            StringBuffer stringBuffer = new StringBuffer("forwarders ");
            int n = 0;
            while (n < stringArray.length) {
                stringBuffer.append(String.valueOf(stringArray[n]) + " ");
                ++n;
            }
            vector.addElement(stringBuffer.toString());
        }
        if (!bl2 && nameServerObject.getSlaveNameServer()) {
            vector.addElement("slave\n");
        }
        if (vector.isEmpty()) {
            return null;
        }
        objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public String makePrimaryBootFileEntry(PrimaryDomain primaryDomain) {
        String[] stringArray;
        StringBuffer stringBuffer = new StringBuffer("primary   " + primaryDomain.getDomName() + " " + DDNSUtility.padFileName(primaryDomain.getDataFileName()));
        if (primaryDomain.isDynamic()) {
            if (primaryDomain.isPresecured()) {
                stringBuffer.append("  dynamic presecured");
            } else {
                stringBuffer.append("  dynamic secured");
            }
        }
        if ((stringArray = primaryDomain.getBootComments()) != null) {
            stringBuffer.append(" " + stringArray[0]);
        }
        return stringBuffer.toString();
    }

    public String makePrimaryBootFileEntry(BootFileEntry bootFileEntry) {
        String[] stringArray;
        DomainObject domainObject = this.theMgr.getADomain(bootFileEntry.getDomainName());
        if (domainObject != null) {
            if (domainObject instanceof PrimaryDomain) {
                return this.makePrimaryBootFileEntry((PrimaryDomain)domainObject);
            }
            return this.makeSecondaryBootFileEntry((SecondaryDomain)domainObject);
        }
        StringBuffer stringBuffer = new StringBuffer("primary   " + bootFileEntry.getDomainName() + " " + DDNSUtility.padFileName(bootFileEntry.getFileName()));
        if (bootFileEntry.isDomainDynamic()) {
            if (bootFileEntry.isDomainPresecured()) {
                stringBuffer.append("  dynamic presecured");
            } else {
                stringBuffer.append("  dynamic secured");
            }
        }
        if ((stringArray = bootFileEntry.getComments()) != null) {
            stringBuffer.append(" " + stringArray[0]);
        }
        return stringBuffer.toString();
    }

    public String makeErrBootFileEntry(BootFileEntry bootFileEntry) {
        StringBuffer stringBuffer = bootFileEntry.getRecType().equals("IGN") ? new StringBuffer(COMMENT_DELIMITER + this.theStrings.getString("FILE_IGNORED") + bootFileEntry.getRecordData()) : new StringBuffer(COMMENT_DELIMITER + this.theStrings.getString("FILE_ERROR") + bootFileEntry.getRecordData());
        return stringBuffer.toString();
    }

    public String makeSecondaryBootFileEntry(SecondaryDomain secondaryDomain) {
        StringBuffer stringBuffer = new StringBuffer("secondary " + secondaryDomain.getDomName() + " ");
        if (secondaryDomain.areMasterServers()) {
            String[] stringArray = secondaryDomain.getMasterServersforDomain();
            int n = 0;
            while (n < stringArray.length) {
                stringBuffer.append(String.valueOf(stringArray[n]) + " ");
                ++n;
            }
        }
        stringBuffer.append(DDNSUtility.padFileName(secondaryDomain.getDataFileName()));
        String[] stringArray = secondaryDomain.getBootComments();
        if (stringArray != null) {
            stringBuffer.append(" " + stringArray[0]);
        }
        return stringBuffer.toString();
    }

    public String makeSecondaryBootFileEntry(BootFileEntry bootFileEntry) {
        DomainObject domainObject = this.theMgr.getADomain(bootFileEntry.getDomainName());
        if (domainObject != null) {
            if (domainObject instanceof PrimaryDomain) {
                return this.makePrimaryBootFileEntry((PrimaryDomain)domainObject);
            }
            return this.makeSecondaryBootFileEntry((SecondaryDomain)domainObject);
        }
        StringBuffer stringBuffer = new StringBuffer("secondary " + bootFileEntry.getDomainName() + " ");
        String[] stringArray = bootFileEntry.getDataList();
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                stringBuffer.append(String.valueOf(stringArray[n]) + " ");
                ++n;
            }
        }
        stringBuffer.append(DDNSUtility.padFileName(bootFileEntry.getFileName()));
        String[] stringArray2 = bootFileEntry.getComments();
        if (stringArray2 != null) {
            stringBuffer.append(" " + stringArray2[0]);
        }
        return stringBuffer.toString();
    }

    public String makeCacheBootFileEntry(BootFileEntry bootFileEntry, NameServerObject nameServerObject) {
        StringBuffer stringBuffer = new StringBuffer("cache . " + DDNSUtility.padFileName(nameServerObject.getCacheFileName()));
        String[] stringArray = bootFileEntry.getComments();
        if (stringArray != null) {
            stringBuffer.append(" " + stringArray[0]);
        }
        return stringBuffer.toString();
    }

    public String makeSlaveBootFileEntry(BootFileEntry bootFileEntry, NameServerObject nameServerObject) {
        if (nameServerObject.getSlaveNameServer()) {
            StringBuffer stringBuffer = new StringBuffer("slave");
            String[] stringArray = bootFileEntry.getComments();
            if (stringArray != null) {
                stringBuffer.append(" " + stringArray[0]);
            }
            return stringBuffer.toString();
        }
        return null;
    }

    public String makeForwardersBootFileEntry(BootFileEntry bootFileEntry, NameServerObject nameServerObject) {
        StringBuffer stringBuffer = new StringBuffer("forwarders ");
        String[] stringArray = nameServerObject.getForwardIp();
        if (stringArray == null) {
            return null;
        }
        int n = 0;
        while (n < stringArray.length) {
            stringBuffer.append(String.valueOf(stringArray[n]) + " ");
            ++n;
        }
        String[] stringArray2 = bootFileEntry.getComments();
        if (stringArray2 != null) {
            stringBuffer.append(" " + stringArray2[0]);
        }
        return stringBuffer.toString();
    }

    public void readForwarders(BootFileEntry bootFileEntry, NameServerObject nameServerObject) {
        String[] stringArray = bootFileEntry.getDataList();
        if (stringArray != null) {
            nameServerObject.setForwardIp(stringArray);
        }
    }

    public void readCache(BootFileEntry bootFileEntry, NameServerObject nameServerObject, String string) {
        if (string != null) {
            nameServerObject.setCacheFileName(DDNSUtility.stripFileName(String.valueOf(string) + File.separator + bootFileEntry.getFileName()));
            return;
        }
        nameServerObject.setCacheFileName(DDNSUtility.stripFileName(bootFileEntry.getFileName()));
    }

    public void removeDomainFromFile(String string) {
        Enumeration enumeration = this.theFileData.elements();
        boolean bl = false;
        ParsedObject parsedObject = null;
        while (enumeration.hasMoreElements() && !bl) {
            BootFileEntry bootFileEntry;
            ParsedObject parsedObject2 = (ParsedObject)enumeration.nextElement();
            if ((parsedObject2.getKey().equals("PDOM") || parsedObject2.getKey().equals("SDOM")) && string.equalsIgnoreCase((String)parsedObject2.getValue())) {
                bl = true;
                parsedObject = parsedObject2;
            }
            if (!parsedObject2.getKey().equals("PRI") && !parsedObject2.getKey().equals("SEC") || !string.equalsIgnoreCase((bootFileEntry = (BootFileEntry)parsedObject2.getValue()).getDomainName())) continue;
            bl = true;
            parsedObject = parsedObject2;
        }
        if (bl) {
            this.theFileData.removeElement(parsedObject);
        }
    }
}

