/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.ddnssgui.common;

import COM.ibm.raleigh.ddnssgui.common.ConfigurationManager;
import COM.ibm.raleigh.ddnssgui.common.HostOrAlias;
import COM.ibm.raleigh.ddnssgui.common.ParsedObject;
import COM.ibm.raleigh.ddnssgui.common.ParsedVector;
import java.util.StringTokenizer;
import java.util.Vector;

public class ReverseHost
extends HostOrAlias {
    private static final String cStmt1 = "(c) Copyright IBM Corp 1997. All rights reserved.\n";
    public static final String REVH_tag = new String("REVH");
    public static final String EREVH_tag = new String("EREVH");
    private static final String base_tag = new String("super");
    private static final String pTTL_tag = new String("PTTL");
    private static final String pTRData_tag = new String("PTRData");
    private int pTRrecTTL;
    private String pTRData;

    public static String handleRevHostActions(ParsedVector parsedVector, ParsedObject parsedObject, String string, ConfigurationManager configurationManager) {
        StringBuffer stringBuffer = new StringBuffer(string);
        boolean bl = false;
        ParsedObject parsedObject2 = parsedVector.getElement("dname");
        String string2 = parsedObject2 != null ? new String((String)parsedObject2.getValue()) : new String("");
        if (parsedObject.getValue().equals("ADD")) {
            ReverseHost reverseHost = new ReverseHost(parsedVector);
            bl = configurationManager.giveAHost(reverseHost, string2);
        } else if (parsedObject.getValue().equals("MOD")) {
            ReverseHost reverseHost = new ReverseHost(parsedVector);
            bl = configurationManager.updateAHost(reverseHost, string2, parsedVector);
        } else if (parsedObject.getValue().equals("DEL")) {
            parsedObject = parsedVector.getElement("name");
            if (parsedObject != null) {
                bl = configurationManager.deleteAHost((String)parsedObject.getValue(), string2);
            }
        } else if (parsedObject.getValue().equals("LNK")) {
            ReverseHost reverseHost = new ReverseHost(parsedVector);
            HostOrAlias hostOrAlias = (HostOrAlias)configurationManager.getAHost(reverseHost.getHostName(), string2);
            if (hostOrAlias != null) {
                configurationManager.linkHost(hostOrAlias, string2);
            }
            bl = true;
        } else if (parsedObject.getValue().equals("GET")) {
            ReverseHost reverseHost;
            parsedObject = parsedVector.getElement("name");
            if (parsedObject != null && (reverseHost = (ReverseHost)configurationManager.getAHost((String)parsedObject.getValue(), string2)) != null) {
                stringBuffer = new StringBuffer(reverseHost.toString("GET"));
                bl = true;
            }
        } else if (parsedObject.getValue().equals("MAP")) {
            String string3;
            String string4 = null;
            String string5 = null;
            int n = 9;
            String string6 = null;
            int n2 = -1;
            parsedObject = parsedVector.getElement("name");
            if (parsedObject != null) {
                string5 = new String((String)parsedObject.getValue());
            }
            if ((parsedObject = parsedVector.getElement("addr")) != null) {
                string4 = new String((String)parsedObject.getValue());
            }
            if ((parsedObject = parsedVector.getElement("ptrttl")) != null && (string3 = (String)parsedObject.getValue()) != null) {
                n2 = Integer.valueOf(string3);
            }
            if ((parsedObject = parsedVector.getElement("state")) != null && (string3 = (String)parsedObject.getValue()) != null) {
                Integer n3 = Integer.valueOf(string3);
                n = n3;
            }
            if (string4 != null && string5 != null && n != 9 && (string6 = !string2.equals(".") ? configurationManager.addReverseMapping(string4, String.valueOf(string5) + "." + string2, n, string2, n2) : configurationManager.addReverseMapping(string4, string5, n, string2, n2)) != null) {
                stringBuffer = new StringBuffer(String.valueOf(REVH_tag) + "=MAP," + "addr=" + string4 + "," + "name=" + string5 + "," + "state=" + n + "," + "dname=" + string6 + "," + "ptrttl=" + n2 + "," + EREVH_tag + ",");
            }
            bl = string6 != null;
        }
        if (bl) {
            try {
                stringBuffer.insert(0, "RC=ACK,");
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {}
        } else {
            try {
                stringBuffer.insert(0, "RC=NACK,");
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {}
        }
        return stringBuffer.toString();
    }

    public static String reverseAddr(String string, String string2) {
        String[] stringArray = new String[4];
        String string3 = "";
        int n = 3;
        int n2 = ReverseHost.numAddrSegments(string2);
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".", false);
        if (stringTokenizer.hasMoreTokens()) {
            String string4 = stringTokenizer.nextToken();
            while (string4 != null && n >= 0) {
                stringArray[n] = new String(string4);
                if (!stringTokenizer.hasMoreTokens()) break;
                string4 = stringTokenizer.nextToken();
                --n;
            }
        }
        if (n2 == 3) {
            string3 = new String(stringArray[0]);
        } else if (n2 == 2) {
            string3 = new String(String.valueOf(stringArray[0]) + "." + stringArray[1]);
        } else if (n2 == 1) {
            string3 = new String(String.valueOf(stringArray[0]) + "." + stringArray[1] + "." + stringArray[2]);
        }
        return string3;
    }

    public static String getAddressFromHostName(String string, String string2) {
        String[] stringArray = new String[4];
        String string3 = "";
        int n = 3;
        int n2 = ReverseHost.numAddrSegments(string2);
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".", false);
        if (stringTokenizer.hasMoreTokens()) {
            String string4 = stringTokenizer.nextToken();
            n -= n2;
            while (string4 != null && n >= 0) {
                stringArray[n] = new String(string4);
                if (!stringTokenizer.hasMoreTokens()) break;
                string4 = stringTokenizer.nextToken();
                --n;
            }
        }
        String string5 = ReverseHost.addrFromReverseDom(string2);
        if (n2 == 3) {
            string3 = new String(String.valueOf(string5) + "." + stringArray[0]);
        } else if (n2 == 2) {
            string3 = new String(String.valueOf(string5) + "." + stringArray[0] + "." + stringArray[1]);
        } else if (n2 == 1) {
            string3 = new String(String.valueOf(string5) + "." + stringArray[0] + "." + stringArray[1] + "." + stringArray[2]);
        }
        return string3;
    }

    public static String reverseDomainFromAddrClassC(String string) {
        String[] stringArray = new String[3];
        String string2 = "";
        int n = 2;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".", false);
        if (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            while (string3 != null && n >= 0) {
                stringArray[n] = new String(string3);
                if (!stringTokenizer.hasMoreTokens()) break;
                string3 = stringTokenizer.nextToken();
                --n;
            }
        }
        if (n < 0) {
            string2 = new String(String.valueOf(stringArray[0]) + "." + stringArray[1] + "." + stringArray[2] + ".in-addr.arpa");
        }
        return string2;
    }

    public static String reverseDomainFromAddrClassB(String string) {
        String[] stringArray = new String[2];
        String string2 = "";
        int n = 1;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".", false);
        if (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            while (string3 != null && n >= 0) {
                stringArray[n] = new String(string3);
                if (!stringTokenizer.hasMoreTokens()) break;
                string3 = stringTokenizer.nextToken();
                --n;
            }
        }
        if (n < 0) {
            string2 = new String(String.valueOf(stringArray[0]) + "." + stringArray[1] + ".in-addr.arpa");
        }
        return string2;
    }

    public static String reverseDomainFromAddrClassA(String string) {
        String[] stringArray = new String[1];
        String string2 = "";
        int n = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".", false);
        if (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            while (string3 != null && n >= 0) {
                stringArray[n] = new String(string3);
                if (!stringTokenizer.hasMoreTokens()) break;
                string3 = stringTokenizer.nextToken();
                --n;
            }
        }
        if (n < 0) {
            string2 = new String(String.valueOf(stringArray[0]) + ".in-addr.arpa");
        }
        return string2;
    }

    public static String addrFromReverseDom(String string) {
        String string2;
        StringTokenizer stringTokenizer;
        String[] stringArray = null;
        String string3 = "";
        int n = -1;
        Vector<String> vector = new Vector<String>();
        n = string.toLowerCase().indexOf(".in-addr.arpa");
        if (n > 0 && (stringTokenizer = new StringTokenizer(string2 = new String(string.substring(0, n)), ".", false)).hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
            while (string2 != null) {
                vector.addElement(new String(string2));
                string2 = !stringTokenizer.hasMoreTokens() ? null : stringTokenizer.nextToken();
            }
            stringArray = new String[vector.size()];
            int n2 = vector.size() - 1;
            int n3 = 0;
            while (n2 >= 0) {
                stringArray[n2--] = (String)vector.elementAt(n3++);
            }
        }
        if (vector.size() == 3) {
            string3 = new String(String.valueOf(stringArray[0]) + "." + (String)stringArray[1] + "." + (String)stringArray[2]);
        } else if (vector.size() == 2) {
            string3 = new String(String.valueOf(stringArray[0]) + "." + (String)stringArray[1]);
        } else if (vector.size() == 1) {
            string3 = new String((String)stringArray[0]);
        }
        return string3;
    }

    public static int numAddrSegments(String string) {
        String string2;
        StringTokenizer stringTokenizer;
        String[] stringArray = null;
        int n = -1;
        Vector<String> vector = new Vector<String>();
        n = string.toLowerCase().indexOf(".in-addr.arpa");
        if (n > 0 && (stringTokenizer = new StringTokenizer(string2 = new String(string.substring(0, n)), ".", false)).hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
            while (string2 != null) {
                vector.addElement(new String(string2));
                string2 = !stringTokenizer.hasMoreTokens() ? null : stringTokenizer.nextToken();
            }
            stringArray = new String[vector.size()];
            int n2 = vector.size() - 1;
            int n3 = 0;
            while (n2 >= 0) {
                stringArray[n2--] = (String)vector.elementAt(n3++);
            }
        }
        return vector.size();
    }

    public ReverseHost(String string, String string2, String string3) {
        this.setHostName(ReverseHost.reverseAddr(string, string3));
        this.pTRrecTTL = -1;
        this.pTRData = string2;
    }

    public ReverseHost() {
        this.pTRrecTTL = -1;
        this.pTRData = "";
    }

    public ReverseHost(ParsedVector parsedVector) {
        this.pTRrecTTL = -1;
        this.fromString(parsedVector);
    }

    public int getPTRttl() {
        return this.pTRrecTTL;
    }

    public void setPTRttl(int n) {
        this.pTRrecTTL = n;
    }

    public void setGreaterPTRttl(int n) {
        if (this.pTRrecTTL < n) {
            this.pTRrecTTL = n;
        }
    }

    public String getPTRhostname() {
        return this.pTRData;
    }

    public void setPTRhostname(String string) {
        this.pTRData = string;
    }

    public String[] writeDataRecords() {
        String string;
        int n;
        Vector<String> vector = new Vector<String>();
        if (this.pTRrecTTL >= 0) {
            vector.addElement(new String(String.valueOf(this.hostName) + " " + String.valueOf(this.pTRrecTTL) + " IN    PTR   " + this.pTRData + "."));
        } else {
            vector.addElement(new String(String.valueOf(this.hostName) + " IN    PTR   " + this.pTRData + "."));
        }
        if (!this.sIGRecords.isEmpty()) {
            n = 0;
            while (n < this.sIGRecords.size()) {
                string = new String();
                try {
                    string = (String)this.sIGRecords.elementAt(n);
                    vector.addElement("      " + string);
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    break;
                }
                ++n;
            }
        }
        if (!this.kEYRecords.isEmpty()) {
            n = 0;
            while (n < this.kEYRecords.size()) {
                string = new String();
                try {
                    string = (String)this.kEYRecords.elementAt(n);
                    vector.addElement("      " + string);
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    break;
                }
                ++n;
            }
        }
        if (vector.isEmpty()) {
            return null;
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public String toString(String string) {
        StringBuffer stringBuffer = new StringBuffer(String.valueOf(REVH_tag) + "=" + string);
        stringBuffer.append(this.buildRestOfString());
        return stringBuffer.toString();
    }

    public String toString(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer(String.valueOf(REVH_tag) + "=" + string + "," + string2);
        stringBuffer.append(this.buildRestOfString());
        return stringBuffer.toString();
    }

    private String buildRestOfString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("," + base_tag + "," + super.toString());
        stringBuffer.append("," + pTTL_tag + "=" + String.valueOf(this.pTRrecTTL));
        stringBuffer.append("," + pTRData_tag + "=" + this.pTRData);
        stringBuffer.append("," + EREVH_tag + ",");
        return stringBuffer.toString();
    }

    public void fromString(ParsedVector parsedVector) {
        String[] stringArray = parsedVector.getKeys();
        int n = 0;
        while (n < stringArray.length) {
            String string;
            ParsedObject parsedObject;
            if (stringArray[n].equals(base_tag)) {
                parsedObject = parsedVector.getElement(base_tag);
                ParsedVector parsedVector2 = (ParsedVector)parsedObject.getValue();
                if (parsedVector2 != null) {
                    super.fromString(parsedVector2);
                }
            } else if (stringArray[n].equals(pTTL_tag)) {
                parsedObject = parsedVector.getElement(pTTL_tag);
                string = (String)parsedObject.getValue();
                if (string != null) {
                    Integer n2 = Integer.valueOf(string);
                    this.pTRrecTTL = n2;
                }
            } else if (stringArray[n].equals(pTRData_tag)) {
                parsedObject = parsedVector.getElement(pTRData_tag);
                string = (String)parsedObject.getValue();
                this.pTRData = string != null ? new String(string) : new String("");
            }
            ++n;
        }
    }
}

