/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.ddnssgui.common;

import COM.ibm.raleigh.ddnssgui.common.BusyWaitFrame;
import COM.ibm.raleigh.ddnssgui.common.ConfigurationManager;
import COM.ibm.raleigh.ddnssgui.common.DDNSNetworkStringParser;
import COM.ibm.raleigh.ddnssgui.common.NameServerObject;
import COM.ibm.raleigh.ddnssgui.common.NetworkHandler;
import COM.ibm.raleigh.ddnssgui.common.ParsedObject;
import COM.ibm.raleigh.ddnssgui.common.ParsedVector;
import COM.ibm.raleigh.ddnssgui.common.TreeNode;
import java.util.Enumeration;
import java.util.ResourceBundle;
import java.util.Vector;

public class RequestList {
    private static final String cStmt1 = "(c) Copyright IBM Corp 1997. All rights reserved.\n";
    public static final String REQLIST_tag = "REQLIST";
    public static final String EREQLIST_tag = "EREQLLIST";
    public static final String reqNum_tag = "ReqNum";
    public static final int rl_AllPriDoms = 1;
    public static final int rl_AllSecDoms = 2;
    public static final int rl_AllForPriDoms = 3;
    public static final int rl_HostsForDomain = 4;
    public static final int rl_NameServerNames = 5;
    public static final int rl_StaticHostNamesForDomain = 6;
    public static final int rl_DynamicHostNamesForDomain = 7;
    public static final int rl_ReservedNamesForDomain = 8;
    public static final int rl_BootFileErrors = 9;
    public static final int rl_CacheFileErrors = 10;
    public static final int rl_FileErrorsForDomain = 11;
    public static final int rl_NextData = 12;
    public static final int rl_FilesOverwritten = 13;
    public static final int rl_DynamicPrimaryDomains = 14;
    public static final int rl_importedFromCacheFile = 15;
    public static final int rl_DynamicNonSepDomains = 16;
    public static final int rl_BootFileData = 17;
    private static final String numStrs_tag = "NumStr";
    private static final String aStr_tag = "AStr";
    private static final String name_tag = "name";
    private static final String more_tag = "More";
    private static String[] theCurrentList;
    private static int nextIndexToSend;
    private int requestNum;
    private String name;
    private boolean moreDataAvailable;
    Vector aVectorOfTheStuff;

    public static String getResponse(ParsedVector parsedVector, ParsedObject parsedObject, String string, ConfigurationManager configurationManager) {
        String string2;
        int n = 0;
        String[] stringArray = null;
        ParsedObject parsedObject2 = parsedVector.getElement(reqNum_tag);
        if (parsedObject2 != null && (string2 = (String)parsedObject2.getValue()) != null) {
            Integer n2 = Integer.valueOf(string2);
            n = n2;
        }
        RequestList requestList = new RequestList(n);
        if (n != 0) {
            switch (n) {
                case 12: {
                    if (theCurrentList == null) {
                        requestList.haveMoreData(false);
                        return requestList.toString(0);
                    }
                    if (nextIndexToSend + 200 > theCurrentList.length) {
                        int n3 = theCurrentList.length - nextIndexToSend;
                        String[] stringArray2 = new String[n3];
                        int n4 = 0;
                        while (n4 < n3) {
                            stringArray2[n4] = theCurrentList[nextIndexToSend + n4];
                            ++n4;
                        }
                        requestList.haveMoreData(false);
                        return requestList.toString(stringArray2);
                    }
                    String[] stringArray3 = new String[200];
                    int n5 = 0;
                    while (n5 < 200) {
                        stringArray3[n5] = theCurrentList[nextIndexToSend + n5];
                        ++n5;
                    }
                    requestList.haveMoreData(true);
                    nextIndexToSend += 200;
                    return requestList.toString(stringArray3);
                }
                case 1: {
                    stringArray = configurationManager.getAllPrimaryDomainNames();
                    break;
                }
                case 2: {
                    stringArray = configurationManager.getAllSecondaryDomainNames();
                    break;
                }
                case 3: {
                    stringArray = configurationManager.getAllForwardPrimaryDomainNames();
                    break;
                }
                case 9: {
                    stringArray = configurationManager.getBootFileErrors();
                    break;
                }
                case 10: {
                    stringArray = configurationManager.getCacheFileErrors();
                    break;
                }
                case 13: {
                    stringArray = configurationManager.getListOfFiles();
                    break;
                }
                case 14: {
                    stringArray = configurationManager.getAllDynamicPrimaryDomainNames();
                    break;
                }
                case 17: {
                    stringArray = configurationManager.getBootFileData();
                    break;
                }
                case 4: {
                    Vector vector;
                    parsedObject2 = parsedVector.getElement(name_tag);
                    if (parsedObject2 != null && (string2 = (String)parsedObject2.getValue()) != null && !(vector = configurationManager.getHostsForDomain(string2)).isEmpty()) {
                        StringBuffer stringBuffer = new StringBuffer("HLIST,numNodes=" + vector.size());
                        Enumeration enumeration = vector.elements();
                        while (enumeration.hasMoreElements()) {
                            TreeNode treeNode = (TreeNode)enumeration.nextElement();
                            stringBuffer.append(",node=" + treeNode.toNetString());
                        }
                        stringBuffer.append(",ELIST,");
                        return stringBuffer.toString();
                    }
                    StringBuffer stringBuffer = new StringBuffer("HLIST,numNodes=0,EHLIST,");
                    return stringBuffer.toString();
                }
                case 5: {
                    NameServerObject nameServerObject = configurationManager.getFirstNameServer();
                    requestList = new RequestList(5, nameServerObject.firstName());
                    return requestList.toString();
                }
                case 6: {
                    parsedObject2 = parsedVector.getElement(name_tag);
                    if (parsedObject2 == null || (string2 = (String)parsedObject2.getValue()) == null) break;
                    stringArray = configurationManager.getAllStaticHostNamesForDomain(string2);
                    break;
                }
                case 7: {
                    parsedObject2 = parsedVector.getElement(name_tag);
                    if (parsedObject2 == null || (string2 = (String)parsedObject2.getValue()) == null) break;
                    stringArray = configurationManager.getAllDynamicHostNamesForDomain(string2);
                    break;
                }
                case 8: {
                    parsedObject2 = parsedVector.getElement(name_tag);
                    if (parsedObject2 == null || (string2 = (String)parsedObject2.getValue()) == null) break;
                    stringArray = configurationManager.getAllReservedNamesForDomain(string2);
                    break;
                }
                case 11: {
                    parsedObject2 = parsedVector.getElement(name_tag);
                    if (parsedObject2 == null || (string2 = (String)parsedObject2.getValue()) == null) break;
                    stringArray = configurationManager.getFileErrorsForDomain(string2);
                    break;
                }
                case 15: {
                    parsedObject2 = parsedVector.getElement(name_tag);
                    if (parsedObject2 == null || (string2 = (String)parsedObject2.getValue()) == null) break;
                    stringArray = configurationManager.importCacheFile(string2);
                    break;
                }
                case 16: {
                    stringArray = configurationManager.getUnseparatedDynamicDomains();
                    break;
                }
            }
        }
        if (stringArray != null && stringArray.length > 0) {
            if (stringArray.length > 200) {
                String[] stringArray4 = new String[200];
                int n6 = 0;
                while (n6 < 200) {
                    stringArray4[n6] = stringArray[n6];
                    ++n6;
                }
                theCurrentList = stringArray;
                nextIndexToSend = 200;
                requestList.haveMoreData(true);
                return requestList.toString(stringArray4);
            }
            return requestList.toString(stringArray);
        }
        return requestList.toString(0);
    }

    public RequestList(int n) {
        this.requestNum = n;
        this.name = null;
        this.moreDataAvailable = false;
    }

    public RequestList(int n, String string) {
        this.requestNum = n;
        this.name = new String(string);
        this.moreDataAvailable = false;
    }

    public void haveMoreData(boolean bl) {
        this.moreDataAvailable = bl;
    }

    public boolean isMoreDataAvailable() {
        return this.moreDataAvailable;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(REQLIST_tag);
        stringBuffer.append(",ReqNum=" + String.valueOf(this.requestNum));
        if (this.name != null) {
            stringBuffer.append(",name=" + this.name);
        }
        stringBuffer.append(",EREQLLIST,");
        return stringBuffer.toString();
    }

    public String toString(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer(REQLIST_tag);
        stringBuffer.append(",ReqNum=" + String.valueOf(this.requestNum));
        if (stringArray != null) {
            stringBuffer.append(",NumStr=" + String.valueOf(stringArray.length));
            int n = 0;
            while (n < stringArray.length) {
                stringBuffer.append(",AStr=" + stringArray[n]);
                ++n;
            }
        } else {
            stringBuffer.append(",NumStr=0");
        }
        if (this.moreDataAvailable) {
            stringBuffer.append(",More=t");
        } else {
            stringBuffer.append(",More=f");
        }
        stringBuffer.append(",EREQLLIST,");
        return stringBuffer.toString();
    }

    public String toString(int n) {
        StringBuffer stringBuffer = new StringBuffer(REQLIST_tag);
        stringBuffer.append(",ReqNum=" + String.valueOf(this.requestNum));
        stringBuffer.append(",NumStr=" + String.valueOf(n));
        if (this.moreDataAvailable) {
            stringBuffer.append(",More=t");
        }
        stringBuffer.append(",EREQLLIST,");
        return stringBuffer.toString();
    }

    public void fromString(ParsedVector parsedVector) {
        Integer n;
        int n2;
        ParsedObject parsedObject = parsedVector.getElement(numStrs_tag);
        String string = (String)parsedObject.getValue();
        if (string != null && (n2 = (n = Integer.valueOf(string)).intValue()) == 0) {
            return;
        }
        String[] stringArray = parsedVector.getKeys();
        int n3 = 0;
        while (n3 < stringArray.length) {
            if (stringArray[n3].equals(aStr_tag)) {
                parsedObject = parsedVector.get(n3);
                string = (String)parsedObject.getValue();
                if (string != null) {
                    this.aVectorOfTheStuff.addElement(string);
                }
            } else if (stringArray[n3].equals(more_tag) && (string = (String)(parsedObject = parsedVector.get(n3)).getValue()) != null) {
                this.moreDataAvailable = string.equals("t");
            }
            ++n3;
        }
    }

    public void fromString(ParsedVector parsedVector, Vector vector) {
        Integer n;
        int n2;
        ParsedObject parsedObject = parsedVector.getElement(numStrs_tag);
        String string = (String)parsedObject.getValue();
        if (string != null && (n2 = (n = Integer.valueOf(string)).intValue()) == 0) {
            return;
        }
        String[] stringArray = parsedVector.getKeys();
        int n3 = 0;
        while (n3 < stringArray.length) {
            if (stringArray[n3].equals(aStr_tag)) {
                parsedObject = parsedVector.get(n3);
                string = (String)parsedObject.getValue();
                if (string != null) {
                    vector.addElement(string);
                }
            } else if (stringArray[n3].equals(more_tag) && (string = (String)(parsedObject = parsedVector.get(n3)).getValue()) != null) {
                this.moreDataAvailable = string.equals("t");
            }
            ++n3;
        }
    }

    public String getName(ParsedVector parsedVector) {
        ParsedObject parsedObject = parsedVector.getElement(name_tag);
        String string = (String)parsedObject.getValue();
        if (string != null) {
            return new String(string);
        }
        return null;
    }

    public String[] getReturnedList(ResourceBundle resourceBundle, NetworkHandler networkHandler) {
        Object[] objectArray;
        this.aVectorOfTheStuff = new Vector();
        networkHandler.sendToServer(this.toString());
        DDNSNetworkStringParser dDNSNetworkStringParser = networkHandler.receiveFromServer();
        this.fromString(dDNSNetworkStringParser.getParsed());
        if (this.isMoreDataAvailable()) {
            objectArray = new BusyWaitFrame(resourceBundle, "Please wait while the server is contacted ...");
            objectArray.setSize(300, 75);
            objectArray.doLayout();
            objectArray.show();
            objectArray.repaint();
            boolean bl = false;
            while (!bl) {
                RequestList requestList = new RequestList(12);
                networkHandler.sendToServer(requestList.toString());
                dDNSNetworkStringParser = networkHandler.receiveFromServer();
                requestList.fromString(dDNSNetworkStringParser.getParsed(), this.aVectorOfTheStuff);
                boolean bl2 = bl = !requestList.isMoreDataAvailable();
            }
            objectArray.dispose();
        }
        if (!this.aVectorOfTheStuff.isEmpty()) {
            objectArray = new String[this.aVectorOfTheStuff.size()];
            this.aVectorOfTheStuff.copyInto(objectArray);
            return objectArray;
        }
        return null;
    }
}

