/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.ddnssgui.common;

import COM.ibm.raleigh.ddnssgui.common.ParsedVector;
import com.ibm.eNetwork.onDemand.common.remoteFile.api.FTPFilename;
import com.ibm.eNetwork.onDemand.common.remoteFile.api.FileInfo;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class RemoteFileList {
    public static final String RFILELIST_tag = "RFileList";
    public static final String ERFILELIST_tag = "eRFileList";
    public static final String FLISTLEN_tag = "FListLen";
    public static final String FILEITEM_tag = "FileItem";
    public static final String ISDIR_tag = "IsDir";
    public static final String FLENGTH_tag = "FLength";
    public static final String LASTMODIFIED_tag = "LastMod";
    private FileInfo[] theFileInfo;
    private String[] theFileList;
    private boolean[] theIsDirectory;
    private Long[] theFileLength;
    private Long[] theLastModified;

    public RemoteFileList(File file) {
        this.fillFromFile(file);
    }

    public RemoteFileList(ParsedVector parsedVector, String string) {
        this.fromString(parsedVector);
        this.fillFileInfo(string);
    }

    public String[] getList() {
        return this.theFileList;
    }

    public FileInfo[] getFileInfo() {
        return this.theFileInfo;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(RFILELIST_tag);
        if (this.theFileList != null) {
            stringBuffer.append(",FListLen=" + String.valueOf(this.theFileList.length));
            int n = 0;
            while (n < this.theFileList.length) {
                stringBuffer.append(",FileItem=" + this.theFileList[n]);
                if (this.theIsDirectory[n]) {
                    stringBuffer.append(",IsDir=t");
                } else {
                    stringBuffer.append(",IsDir=f");
                }
                stringBuffer.append(",FLength=" + this.theFileLength[n].toString());
                stringBuffer.append(",LastMod=" + this.theLastModified[n].toString());
                ++n;
            }
        }
        stringBuffer.append(",eRFileList");
        return stringBuffer.toString();
    }

    private void fromString(ParsedVector parsedVector) {
        int n = 0;
        String[] stringArray = parsedVector.getKeys();
        Object[] objectArray = parsedVector.getValues();
        int n2 = 0;
        while (n2 < stringArray.length) {
            String string;
            if (stringArray[n2].equals(FLISTLEN_tag)) {
                string = (String)objectArray[n2];
                if (string != null) {
                    Integer n3 = Integer.valueOf(string);
                    int n4 = n3;
                    this.theFileList = new String[n4];
                    this.theIsDirectory = new boolean[n4];
                    this.theFileLength = new Long[n4];
                    this.theLastModified = new Long[n4];
                }
            } else if (stringArray[n2].equals(FILEITEM_tag) && (string = (String)objectArray[n2]) != null) {
                Long l;
                this.theFileList[n] = string;
                if (stringArray[n2 + 1].equals(ISDIR_tag) && (string = (String)objectArray[++n2]) != null) {
                    this.theIsDirectory[n] = string.equals("t");
                }
                if (stringArray[n2 + 1].equals(FLENGTH_tag) && (string = (String)objectArray[++n2]) != null) {
                    this.theFileLength[n] = l = Long.valueOf(string);
                }
                if (stringArray[n2 + 1].equals(LASTMODIFIED_tag) && (string = (String)objectArray[++n2]) != null) {
                    this.theLastModified[n] = l = Long.valueOf(string);
                }
                ++n;
            }
            ++n2;
        }
    }

    private void fillFileInfo(String string) {
        FTPFilename fTPFilename = null;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MM/dd/yy hh:mmaaa");
        TimeZone timeZone = TimeZone.getDefault();
        Date date = null;
        simpleDateFormat.setTimeZone(timeZone);
        if (this.theFileList != null) {
            this.theFileInfo = new FileInfo[this.theFileList.length];
            int n = 0;
            while (n < this.theFileList.length) {
                fTPFilename = new FTPFilename(string, this.theFileList[n]);
                fTPFilename.setDirectory(this.theIsDirectory[n]);
                date = new Date(this.theLastModified[n]);
                this.theFileInfo[n] = new FileInfo(fTPFilename, this.theFileLength[n].longValue(), simpleDateFormat.format(date));
                ++n;
            }
            return;
        }
        System.out.println("theFileList = null in fillFileInfo");
    }

    private void fillFromFile(File file) {
        try {
            if (file.isDirectory()) {
                this.theFileList = file.list();
                if (this.theFileList != null) {
                    String string = file.getPath();
                    File file2 = null;
                    this.theIsDirectory = new boolean[this.theFileList.length];
                    this.theFileLength = new Long[this.theFileList.length];
                    this.theLastModified = new Long[this.theFileList.length];
                    int n = 0;
                    while (n < this.theFileList.length) {
                        file2 = new File(String.valueOf(string) + File.separator + this.theFileList[n]);
                        if (file2 != null) {
                            this.theIsDirectory[n] = file2.isDirectory();
                            this.theFileLength[n] = new Long(file2.length());
                            this.theLastModified[n] = new Long(file2.lastModified());
                        }
                        ++n;
                    }
                    return;
                }
            }
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
        }
    }
}

