/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.ddnssgui.common;

import COM.ibm.raleigh.ddnssgui.common.ChildNameServer;
import COM.ibm.raleigh.ddnssgui.common.ConfigurationManager;
import COM.ibm.raleigh.ddnssgui.common.DomainObject;
import COM.ibm.raleigh.ddnssgui.common.DynamicOptionsObject;
import COM.ibm.raleigh.ddnssgui.common.NameAndIpAddressList;
import COM.ibm.raleigh.ddnssgui.common.NameServerObject;
import COM.ibm.raleigh.ddnssgui.common.ParsedObject;
import COM.ibm.raleigh.ddnssgui.common.ParsedVector;
import java.util.Enumeration;
import java.util.Vector;

public class PrimaryDomain
extends DomainObject {
    private static final String cStmt1 = "(c) Copyright IBM Corp 1997. All rights reserved.\n";
    public static final String PDOM_tag = "PDOM";
    public static final String EPDOM_tag = "EPDOM";
    private static final String pMode_tag = "PMode";
    private static final String noKey_tag = "NoKey";
    private static final String updT_tag = "UpdT";
    private static final String maxUpdt_tag = "MaxUpdt";
    private static final String backup_tag = "Backup";
    private static final String sepDyn_tag = "SepDyn";
    private static final String delSig_tag = "DelSig";
    private static final String whenDel_tag = "WhenDel";
    private static final String clTimeSync_tag = "ClTimeSync";
    private static final String fwdTime_tag = "FwdTime";
    private static final String oTTL_tag = "OTTL";
    private static final String tTLVal_tag = "TTLVal";
    private static final String dynDom_tag = "DynDom";
    private static final String admin_tag = "Admin";
    private static final String staticFile_tag = "StaticFile";
    private static final String base_tag = "super";
    private static final String rMap_tag = "RMap";
    private static final String cNS_tag = "CNS";
    private static final String iHostKey_tag = "iHostKey";
    private static final String iHostList_tag = "iHostList";
    private boolean presecuredMode;
    private boolean doNotSendKeysToSec;
    private int updateTime;
    private int maximumNumberOfUpdates;
    private boolean backupDynData;
    private boolean separateDynAndStatic;
    private boolean deleteSigRecords;
    private int whenToDeleteSigRecords;
    private boolean clientTimeSync;
    private boolean forwardTime;
    private boolean overrideTTL;
    private int tTLOverrideValue;
    private boolean dynamicDomain;
    private String staticFileName;
    private boolean createReverseMapping;
    private String initialAdminEmail;
    private int initialRefreshRate;
    private int initialRetryInterval;
    private int initialExpirationTime;
    private int initialTimeToLive;
    private NameAndIpAddressList initialNameServersForDomain;
    private String[] initialMailExchange;
    private boolean initialSeparateDynAndStatic;
    private boolean readFromFile;
    private String initialSepFileName;
    private Vector reInitHostKeys = new Vector();

    public static String handlePrimaryDomainActions(ParsedVector parsedVector, ParsedObject parsedObject, String string, ConfigurationManager configurationManager) {
        StringBuffer stringBuffer = new StringBuffer(string);
        boolean bl = false;
        if (parsedObject.getValue().equals("ADD")) {
            PrimaryDomain primaryDomain = new PrimaryDomain(parsedVector);
            configurationManager.giveADomain(primaryDomain);
            if (primaryDomain.isDynamic()) {
                configurationManager.createDomainAdminKey(primaryDomain.getDomName());
            }
            bl = true;
        } else if (parsedObject.getValue().equals("MOD")) {
            PrimaryDomain primaryDomain = new PrimaryDomain(parsedVector);
            bl = configurationManager.updateADomain(primaryDomain.getDomName(), parsedVector);
        } else if (parsedObject.getValue().equals("DEL")) {
            parsedObject = parsedVector.getElement("name");
            if (parsedObject != null) {
                bl = configurationManager.deleteADomain((String)parsedObject.getValue());
            }
        } else if (parsedObject.getValue().equals("LNK")) {
            ParsedObject parsedObject2 = parsedVector.getElement("NameServ");
            String string2 = parsedObject2 != null ? new String((String)parsedObject2.getValue()) : new String("");
            NameServerObject nameServerObject = configurationManager.getANameServer(string2);
            PrimaryDomain primaryDomain = new PrimaryDomain(parsedVector);
            if (nameServerObject != null) {
                configurationManager.linkDomain(primaryDomain, nameServerObject);
                bl = true;
            }
        } else if (parsedObject.getValue().equals("GET")) {
            PrimaryDomain primaryDomain;
            parsedObject = parsedVector.getElement("name");
            if (parsedObject != null && (primaryDomain = (PrimaryDomain)configurationManager.getADomain((String)parsedObject.getValue())) != null) {
                stringBuffer = new StringBuffer(primaryDomain.toString("GET"));
                bl = true;
            }
        } else if (parsedObject.getValue().equals("GENKEY")) {
            String[] stringArray = configurationManager.doGenerateKeys(parsedVector);
            if (stringArray != null) {
                bl = false;
                StringBuffer stringBuffer2 = new StringBuffer("PDOM=GENKEY,");
                int n = 0;
                while (n < stringArray.length) {
                    stringBuffer2.append("host=" + stringArray[n] + ",");
                    ++n;
                }
                stringBuffer2.append(EPDOM_tag);
            } else {
                bl = true;
            }
        }
        if (bl) {
            try {
                stringBuffer.insert(0, "RC=ACK,");
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {}
        } else {
            try {
                stringBuffer.insert(0, "RC=NACK,");
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {}
        }
        return stringBuffer.toString();
    }

    public PrimaryDomain() {
        this.setDefaults();
    }

    public PrimaryDomain(ParsedVector parsedVector) {
        this.setDefaults();
        this.fromString(parsedVector);
    }

    public DynamicOptionsObject getDynOpts() {
        return new DynamicOptionsObject(this.presecuredMode, this.doNotSendKeysToSec, this.backupDynData, this.deleteSigRecords, this.whenToDeleteSigRecords, this.clientTimeSync, this.forwardTime, this.overrideTTL, this.tTLOverrideValue);
    }

    public void setDynOpts(DynamicOptionsObject dynamicOptionsObject) {
        this.presecuredMode = dynamicOptionsObject.Dy_PresecuredMode;
        this.doNotSendKeysToSec = dynamicOptionsObject.Dy_DoNotSendKeysToSec;
        this.backupDynData = dynamicOptionsObject.Dy_BackupDynData;
        this.deleteSigRecords = dynamicOptionsObject.Dy_DeleteSigRecords;
        this.whenToDeleteSigRecords = dynamicOptionsObject.Dy_WhenToDeleteSigRecords;
        this.clientTimeSync = dynamicOptionsObject.Dy_ClientTimeSync;
        this.forwardTime = dynamicOptionsObject.Dy_ForwardTime;
        this.overrideTTL = dynamicOptionsObject.Dy_OverrideTTL;
        this.tTLOverrideValue = dynamicOptionsObject.Dy_TTLOverrideValue;
    }

    public void setUpdateTime(int n) {
        this.updateTime = n;
    }

    public int getUpdateTime() {
        return this.updateTime;
    }

    public boolean getTimeSync() {
        return this.clientTimeSync;
    }

    public void setTimeSync(boolean bl) {
        this.clientTimeSync = bl;
    }

    public boolean getForwardTime() {
        return this.forwardTime;
    }

    public void setForwardTime(boolean bl) {
        this.forwardTime = bl;
    }

    public boolean getBackupData() {
        return this.backupDynData;
    }

    public void setBackupData(boolean bl) {
        this.backupDynData = bl;
    }

    public boolean getDeleteSigs() {
        return this.deleteSigRecords;
    }

    public void setDeleteSigs(boolean bl) {
        this.deleteSigRecords = bl;
    }

    public boolean getOverwriteTTL() {
        return this.overrideTTL;
    }

    public void setOverwriteTTL(boolean bl) {
        this.overrideTTL = bl;
    }

    public boolean getSendKeyToSec() {
        return this.doNotSendKeysToSec;
    }

    public void setSendKeyToSec(boolean bl) {
        this.doNotSendKeysToSec = bl;
    }

    public int getTTLOverwriteValue() {
        return this.tTLOverrideValue;
    }

    public void setTTLOverwriteValue(int n) {
        this.tTLOverrideValue = n;
    }

    public int getSigDeletionTime() {
        return this.whenToDeleteSigRecords;
    }

    public void setSigDeletionTime(int n) {
        this.whenToDeleteSigRecords = n;
    }

    public int getNoOfUpds() {
        return this.maximumNumberOfUpdates;
    }

    public void setNoOfUpds(int n) {
        this.maximumNumberOfUpdates = n;
    }

    public void setPresecured() {
        this.presecuredMode = true;
    }

    public boolean isPresecured() {
        return this.presecuredMode;
    }

    public void setSecured() {
        this.presecuredMode = false;
    }

    public void setStaticFileName(String string) {
        this.staticFileName = new String(string);
    }

    public String getStaticFileName() {
        return this.staticFileName;
    }

    public void setHostKeys(Vector vector) {
        this.reInitHostKeys = vector;
    }

    public String[] getHostKeys() {
        Object[] objectArray = new String[this.reInitHostKeys.size()];
        this.reInitHostKeys.copyInto(objectArray);
        return objectArray;
    }

    public void setHostKey(String string) {
        this.reInitHostKeys.addElement(string);
    }

    public void removeHostKeys() {
        this.reInitHostKeys = new Vector();
    }

    public void setSeparateDynStatData(boolean bl) {
        this.separateDynAndStatic = bl;
    }

    public boolean getSeparateDynStatData() {
        return this.separateDynAndStatic;
    }

    public void makeDynamic() {
        this.dynamicDomain = true;
    }

    public boolean isDynamic() {
        return this.dynamicDomain;
    }

    public void makeStatic() {
        this.dynamicDomain = false;
    }

    public void setAdminEmail(String string) {
        if (string != null) {
            this.administratorEmail = string;
            return;
        }
        this.administratorEmail = new String("");
    }

    public String getAdminEmail() {
        return this.administratorEmail;
    }

    public void setReverseMappingState(boolean bl) {
        this.createReverseMapping = bl;
    }

    public boolean getReverseMappingState() {
        return this.createReverseMapping;
    }

    public void copyInto(PrimaryDomain primaryDomain) {
        primaryDomain.setUpdateTime(this.updateTime);
        primaryDomain.setTimeSync(this.clientTimeSync);
        primaryDomain.setForwardTime(this.forwardTime);
        primaryDomain.setBackupData(this.backupDynData);
        primaryDomain.setDeleteSigs(this.deleteSigRecords);
        primaryDomain.setOverwriteTTL(this.overrideTTL);
        primaryDomain.setSendKeyToSec(this.doNotSendKeysToSec);
        primaryDomain.setTTLOverwriteValue(this.tTLOverrideValue);
        primaryDomain.setSigDeletionTime(this.whenToDeleteSigRecords);
        primaryDomain.setNoOfUpds(this.maximumNumberOfUpdates);
        if (this.presecuredMode) {
            primaryDomain.setPresecured();
        } else {
            primaryDomain.setSecured();
        }
        primaryDomain.setStaticFileName(this.staticFileName);
        primaryDomain.setSeparateDynStatData(this.separateDynAndStatic);
        if (this.dynamicDomain) {
            primaryDomain.makeDynamic();
        } else {
            primaryDomain.makeStatic();
        }
        primaryDomain.setAdminEmail(this.administratorEmail);
        primaryDomain.setReverseMappingState(this.createReverseMapping);
        primaryDomain.setOverwriteTTL(this.overrideTTL);
        primaryDomain.setDomName(this.fQDomainName);
        primaryDomain.setNameServerSetforDomain(new NameAndIpAddressList(this.nameServersForDomain));
        Object[] objectArray = new String[this.notifySetForDomain.size()];
        this.notifySetForDomain.copyInto(objectArray);
        primaryDomain.setNotifySetforDomain((String[])objectArray);
        primaryDomain.setChildNameServers(this.childServers.elements());
        objectArray = new String[this.mailExchange.size()];
        this.mailExchange.copyInto(objectArray);
        primaryDomain.setMailExchange((String[])objectArray);
        primaryDomain.setNotify(this.notifyOrNot);
        primaryDomain.setNotifyDelayTime(this.notifyDelayTime);
        primaryDomain.setNotifyRetryTime(this.notifyRetryTime);
        primaryDomain.setNotifyRetryNum(this.notifyRetryNum);
        primaryDomain.setMailTTL(this.mailTTL);
        primaryDomain.setNameServerTTL(this.nameServerTTL);
        primaryDomain.setSoaTTL(this.domainSoaTTL);
        primaryDomain.setDataFileName(this.domainDataFile);
        primaryDomain.setRefreshRt(this.refreshRate);
        primaryDomain.setSerialNo(this.domainSerialNumber);
        primaryDomain.setRetryInterval(this.retryInterval);
        primaryDomain.setExpirationTime(this.expirationTime);
        primaryDomain.setHostKeys(this.reInitHostKeys);
    }

    public void Dump() {
    }

    public String toString(String string) {
        StringBuffer stringBuffer = new StringBuffer("PDOM=" + string);
        stringBuffer.append(",super," + super.toString());
        stringBuffer.append(this.buildRestOfString());
        stringBuffer.append(",EPDOM,");
        return stringBuffer.toString();
    }

    public String toString(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer("PDOM=" + string);
        stringBuffer.append("," + string2 + "," + base_tag + "," + super.toString());
        stringBuffer.append(this.buildRestOfString());
        stringBuffer.append(",EPDOM,");
        return stringBuffer.toString();
    }

    public void fromString(ParsedVector parsedVector) {
        String[] stringArray = parsedVector.getKeys();
        int n = 0;
        while (n < stringArray.length) {
            Integer n2;
            String string;
            ParsedVector parsedVector2;
            ParsedObject parsedObject;
            if (stringArray[n].equals(base_tag)) {
                parsedObject = parsedVector.getElement(base_tag);
                parsedVector2 = (ParsedVector)parsedObject.getValue();
                if (parsedVector2 != null) {
                    super.fromString(parsedVector2);
                }
            } else if (stringArray[n].equals(cNS_tag)) {
                parsedObject = parsedVector.getElement(cNS_tag);
                parsedVector2 = (ParsedVector)parsedObject.getValue();
                if (parsedVector2 != null) {
                    this.getChildNSList(parsedVector2);
                }
            } else if (stringArray[n].equals(pMode_tag)) {
                parsedObject = parsedVector.getElement(pMode_tag);
                string = (String)parsedObject.getValue();
                if (string != null) {
                    this.presecuredMode = this.isStringTrue(string);
                }
            } else if (stringArray[n].equals(noKey_tag)) {
                parsedObject = parsedVector.getElement(noKey_tag);
                string = (String)parsedObject.getValue();
                if (string != null) {
                    this.doNotSendKeysToSec = this.isStringTrue(string);
                }
            } else if (stringArray[n].equals(backup_tag)) {
                parsedObject = parsedVector.getElement(backup_tag);
                string = (String)parsedObject.getValue();
                if (string != null) {
                    this.backupDynData = this.isStringTrue(string);
                }
            } else if (stringArray[n].equals(sepDyn_tag)) {
                parsedObject = parsedVector.getElement(sepDyn_tag);
                string = (String)parsedObject.getValue();
                if (string != null) {
                    this.separateDynAndStatic = this.isStringTrue(string);
                }
            } else if (stringArray[n].equals(delSig_tag)) {
                parsedObject = parsedVector.getElement(delSig_tag);
                string = (String)parsedObject.getValue();
                if (string != null) {
                    this.deleteSigRecords = this.isStringTrue(string);
                }
            } else if (stringArray[n].equals(clTimeSync_tag)) {
                parsedObject = parsedVector.getElement(clTimeSync_tag);
                string = (String)parsedObject.getValue();
                if (string != null) {
                    this.clientTimeSync = this.isStringTrue(string);
                }
            } else if (stringArray[n].equals(fwdTime_tag)) {
                parsedObject = parsedVector.getElement(fwdTime_tag);
                string = (String)parsedObject.getValue();
                if (string != null) {
                    this.forwardTime = this.isStringTrue(string);
                }
            } else if (stringArray[n].equals(oTTL_tag)) {
                parsedObject = parsedVector.getElement(oTTL_tag);
                string = (String)parsedObject.getValue();
                if (string != null) {
                    this.overrideTTL = this.isStringTrue(string);
                }
            } else if (stringArray[n].equals(dynDom_tag)) {
                parsedObject = parsedVector.getElement(dynDom_tag);
                string = (String)parsedObject.getValue();
                if (string != null) {
                    this.dynamicDomain = this.isStringTrue(string);
                }
            } else if (stringArray[n].equals(rMap_tag)) {
                parsedObject = parsedVector.getElement(rMap_tag);
                string = (String)parsedObject.getValue();
                if (string != null) {
                    this.createReverseMapping = this.isStringTrue(string);
                }
            } else if (stringArray[n].equals(maxUpdt_tag)) {
                parsedObject = parsedVector.getElement(maxUpdt_tag);
                string = (String)parsedObject.getValue();
                if (string != null) {
                    n2 = Integer.valueOf(string);
                    this.maximumNumberOfUpdates = n2;
                }
            } else if (stringArray[n].equals(updT_tag)) {
                parsedObject = parsedVector.getElement(updT_tag);
                string = (String)parsedObject.getValue();
                if (string != null) {
                    n2 = Integer.valueOf(string);
                    this.updateTime = n2;
                }
            } else if (stringArray[n].equals(whenDel_tag)) {
                parsedObject = parsedVector.getElement(whenDel_tag);
                string = (String)parsedObject.getValue();
                if (string != null) {
                    n2 = Integer.valueOf(string);
                    this.whenToDeleteSigRecords = n2;
                }
            } else if (stringArray[n].equals(tTLVal_tag)) {
                parsedObject = parsedVector.getElement(tTLVal_tag);
                string = (String)parsedObject.getValue();
                if (string != null) {
                    n2 = Integer.valueOf(string);
                    this.tTLOverrideValue = n2;
                }
            } else if (stringArray[n].equals(admin_tag)) {
                parsedObject = parsedVector.getElement(admin_tag);
                string = (String)parsedObject.getValue();
                this.administratorEmail = string != null ? new String(string) : new String("");
            } else if (stringArray[n].equals(staticFile_tag)) {
                parsedObject = parsedVector.getElement(staticFile_tag);
                string = (String)parsedObject.getValue();
                this.staticFileName = string != null ? new String(string) : new String("");
            } else if (stringArray[n].equals(iHostList_tag) && (string = (String)(parsedObject = parsedVector.getElement(iHostList_tag)).getValue()) != null) {
                n2 = Integer.valueOf(string);
                if (n2 != 0) {
                    int n3 = n2;
                    this.reInitHostKeys = new Vector();
                    int n4 = 0;
                    while (n4 < n3) {
                        if (stringArray[n + 1].equals(iHostKey_tag)) {
                            parsedObject = parsedVector.get(++n);
                            this.reInitHostKeys.addElement((String)parsedObject.getValue());
                            ++n4;
                            continue;
                        }
                        break;
                    }
                } else {
                    this.reInitHostKeys = new Vector();
                }
            }
            ++n;
        }
    }

    public void saveInitialDynamicData() {
        this.initialAdminEmail = new String(this.administratorEmail);
        this.initialRefreshRate = this.refreshRate;
        this.initialRetryInterval = this.retryInterval;
        this.initialExpirationTime = this.expirationTime;
        this.initialTimeToLive = this.timeToLive;
        this.initialNameServersForDomain = new NameAndIpAddressList(this.nameServersForDomain);
        this.initialSeparateDynAndStatic = this.separateDynAndStatic;
        this.initialSepFileName = new String(this.staticFileName);
        this.initialMailExchange = new String[this.mailExchange.size()];
        this.mailExchange.copyInto(this.initialMailExchange);
    }

    public boolean soaDataHasChanged() {
        return !this.initialAdminEmail.equalsIgnoreCase(this.administratorEmail) || this.initialRefreshRate != this.refreshRate || this.initialRetryInterval != this.retryInterval || this.initialExpirationTime != this.expirationTime || this.initialTimeToLive != this.timeToLive;
    }

    public boolean nameServerDataHasChanged() {
        return !this.initialNameServersForDomain.equals(this.nameServersForDomain);
    }

    public boolean separateDynDataHasChanged() {
        return this.initialSeparateDynAndStatic != this.separateDynAndStatic || !this.initialSepFileName.equalsIgnoreCase(this.staticFileName);
    }

    public boolean mailExchangeDataHasChanged() {
        Object[] objectArray = new String[this.mailExchange.size()];
        this.mailExchange.copyInto(objectArray);
        int n = 0;
        boolean bl = false;
        if (objectArray.length == 0 && this.initialMailExchange.length == 0) {
            return false;
        }
        if (objectArray.length == 0 && this.initialMailExchange.length != 0) {
            return true;
        }
        if (objectArray.length != 0 && this.initialMailExchange.length == 0) {
            return true;
        }
        if (objectArray.length != this.initialMailExchange.length) {
            return true;
        }
        int n2 = 0;
        while (n2 < objectArray.length) {
            bl = false;
            while (n < this.initialMailExchange.length && !bl) {
                if (((String)objectArray[n2]).equals(this.initialMailExchange[n])) {
                    bl = true;
                }
                ++n;
            }
            if (!bl) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void setReadFromFile() {
        this.readFromFile = true;
    }

    public boolean didReadDataFromFile() {
        return this.readFromFile;
    }

    public String[] getReturnedList(ParsedVector parsedVector) {
        Vector<String> vector = new Vector<String>();
        String[] stringArray = parsedVector.getKeys();
        int n = 0;
        while (n < stringArray.length) {
            ParsedObject parsedObject;
            if (stringArray[n].equals("host") && (parsedObject = parsedVector.get(n)) != null) {
                vector.addElement((String)parsedObject.getValue());
            }
            ++n;
        }
        if (vector.isEmpty()) {
            this.reInitHostKeys = new Vector();
            return null;
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        this.reInitHostKeys = vector;
        return objectArray;
    }

    private void setDefaults() {
        this.presecuredMode = false;
        this.doNotSendKeysToSec = true;
        this.updateTime = 300;
        this.maximumNumberOfUpdates = 100;
        this.backupDynData = true;
        this.separateDynAndStatic = false;
        this.deleteSigRecords = false;
        this.whenToDeleteSigRecords = 2;
        this.clientTimeSync = true;
        this.forwardTime = true;
        this.overrideTTL = false;
        this.tTLOverrideValue = 0;
        this.dynamicDomain = true;
        this.administratorEmail = new String("");
        this.staticFileName = new String("");
        this.createReverseMapping = true;
        this.readFromFile = false;
    }

    private String buildRestOfString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.presecuredMode) {
            stringBuffer.append(",PMode=t");
        } else {
            stringBuffer.append(",PMode=f");
        }
        if (this.doNotSendKeysToSec) {
            stringBuffer.append(",NoKey=t");
        } else {
            stringBuffer.append(",NoKey=f");
        }
        if (this.backupDynData) {
            stringBuffer.append(",Backup=t");
        } else {
            stringBuffer.append(",Backup=f");
        }
        if (this.separateDynAndStatic) {
            stringBuffer.append(",SepDyn=t");
        } else {
            stringBuffer.append(",SepDyn=f");
        }
        if (this.deleteSigRecords) {
            stringBuffer.append(",DelSig=t");
        } else {
            stringBuffer.append(",DelSig=f");
        }
        if (this.clientTimeSync) {
            stringBuffer.append(",ClTimeSync=t");
        } else {
            stringBuffer.append(",ClTimeSync=f");
        }
        if (this.forwardTime) {
            stringBuffer.append(",FwdTime=t");
        } else {
            stringBuffer.append(",FwdTime=f");
        }
        if (this.overrideTTL) {
            stringBuffer.append(",OTTL=t");
        } else {
            stringBuffer.append(",OTTL=f");
        }
        if (this.dynamicDomain) {
            stringBuffer.append(",DynDom=t");
        } else {
            stringBuffer.append(",DynDom=f");
        }
        if (this.createReverseMapping) {
            stringBuffer.append(",RMap=t");
        } else {
            stringBuffer.append(",RMap=f");
        }
        stringBuffer.append(",UpdT=" + String.valueOf(this.updateTime));
        stringBuffer.append(",MaxUpdt=" + String.valueOf(this.maximumNumberOfUpdates));
        stringBuffer.append(",WhenDel=" + String.valueOf(this.whenToDeleteSigRecords));
        stringBuffer.append(",TTLVal=" + String.valueOf(this.tTLOverrideValue));
        stringBuffer.append(",StaticFile=" + this.staticFileName);
        stringBuffer.append(",Admin=" + this.administratorEmail);
        if (!this.reInitHostKeys.isEmpty()) {
            stringBuffer.append(",iHostList=" + String.valueOf(this.reInitHostKeys.size()));
            int n = 0;
            while (n < this.reInitHostKeys.size()) {
                stringBuffer.append(",iHostKey=" + (String)this.reInitHostKeys.elementAt(n));
                ++n;
            }
        } else {
            stringBuffer.append(",iHostList=" + 0);
        }
        Enumeration enumeration = this.getChildNameServers();
        if (enumeration != null) {
            stringBuffer.append(",CNS");
            stringBuffer.append(",CHILDL");
            while (enumeration.hasMoreElements()) {
                stringBuffer.append("," + ((ChildNameServer)enumeration.nextElement()).toString());
            }
            stringBuffer.append(",ECHILDL");
        }
        return stringBuffer.toString();
    }

    private boolean isStringTrue(String string) {
        return string.equals("t");
    }

    private void getChildNSList(ParsedVector parsedVector) {
        this.setChildNameServers(null);
        String[] stringArray = parsedVector.getKeys();
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equals("CHILD")) {
                ChildNameServer childNameServer = new ChildNameServer();
                childNameServer.fromString(stringArray, parsedVector.getValues(), n);
                this.addChildNameServer(childNameServer);
            }
            ++n;
        }
    }
}

