/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.ddnssgui.common;

import COM.ibm.raleigh.ddnssgui.common.DDNSStringTranslator;
import COM.ibm.raleigh.ddnssgui.common.ListPanel;
import COM.ibm.raleigh.ddnssgui.common.ListPanelUser;
import COM.ibm.raleigh.ddnssgui.common.Platform;
import COM.ibm.raleigh.ddnssgui.common.PlatformList;
import COM.ibm.raleigh.ddnssgui.common.msgBox;
import java.awt.Button;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.util.ResourceBundle;

public class PlatformListPanel
extends ListPanel {
    private static final String cStmt1 = "(c) Copyright IBM Corp 1997. All rights reserved.\n";
    private static final String EMPTY_QUOTED_STRING = "\"\"";
    private static final String PLATFORM_PANEL_LABEL = "";
    private static final String[] labels = new String[]{"", ""};
    private static final int NUM_LABELS = 2;
    private static final int CPU_FIELD = 0;
    private static final int OS_FIELD = 1;
    private ListPanelUser parent;
    private ResourceBundle resources;
    private PlatformList platformList;
    private msgBox requiredBox;

    public PlatformListPanel(ListPanelUser listPanelUser, ResourceBundle resourceBundle, int n) {
        super((Container)((Object)listPanelUser), resourceBundle, PLATFORM_PANEL_LABEL, labels, n, resourceBundle.getString("PLATFORM_EXPLANATION_LABEL"), null);
        this.parent = listPanelUser;
        this.resources = resourceBundle;
        this.platformList = new PlatformList();
        this.setFieldLabels();
    }

    public Platform getPlatform() {
        DDNSStringTranslator dDNSStringTranslator = new DDNSStringTranslator(this.getCPUField());
        DDNSStringTranslator dDNSStringTranslator2 = new DDNSStringTranslator(this.getOSField());
        Platform platform = new Platform(dDNSStringTranslator.toEscapedString(), dDNSStringTranslator2.toEscapedString());
        return platform;
    }

    public void setPlatform(Platform platform) {
        if (platform != null) {
            DDNSStringTranslator dDNSStringTranslator = new DDNSStringTranslator(platform.getCPU());
            DDNSStringTranslator dDNSStringTranslator2 = new DDNSStringTranslator(platform.getOS());
            this.setCPUField(dDNSStringTranslator.fromEscapedString());
            this.setOSField(dDNSStringTranslator2.fromEscapedString());
            this.platformList.addPlatform(platform);
        }
    }

    public PlatformList getPlatformList() {
        return this.platformList;
    }

    public void setPlatformList(PlatformList platformList) {
        this.clearPlatformList();
        if (platformList != null) {
            String string = null;
            Platform platform = null;
            DDNSStringTranslator dDNSStringTranslator = null;
            DDNSStringTranslator dDNSStringTranslator2 = null;
            int n = 0;
            while (n < platformList.size()) {
                platform = platformList.getPlatform(n);
                dDNSStringTranslator = new DDNSStringTranslator(platform.getCPU());
                dDNSStringTranslator2 = new DDNSStringTranslator(platform.getOS());
                string = new String(String.valueOf(dDNSStringTranslator.fromEscapedString()) + super.getTextSeparator() + dDNSStringTranslator2.fromEscapedString());
                super.addItem(string);
                ++n;
            }
        }
        this.platformList = new PlatformList(platformList);
    }

    public void clearPlatformList() {
        super.removeAll();
        this.platformList.clearPlatformList();
    }

    private void handleButton(Button button) {
        if (button == super.getAddButton()) {
            this.handleAdd();
            return;
        }
        if (button == super.getRemoveButton()) {
            this.handleRemove();
        }
    }

    protected void handleAdd() {
        boolean bl = true;
        String string = this.getCPUField();
        String string2 = this.getOSField();
        if (string != null && string.length() > 0) {
            this.setCPUField(string);
            bl = true;
        } else {
            this.setCPUField(string);
            this.setOSField(string2);
            this.requiredBox = new msgBox(this.resources, this.resources.getString("APP_TITLE"), this.resources.getString("CPU_REQUIRED_TEXT"), 1, true);
            this.selectAll(0);
            this.requestFocus(0);
            bl = false;
        }
        if (bl) {
            if (string2 != null && string2.length() > 0) {
                this.setOSField(string2);
                bl = true;
            } else {
                this.setCPUField(string);
                this.setOSField(string2);
                this.requiredBox = new msgBox(this.resources, this.resources.getString("APP_TITLE"), this.resources.getString("OS_REQUIRED_TEXT"), 1, true);
                this.selectAll(1);
                this.requestFocus(1);
                bl = false;
            }
        }
        if (bl) {
            this.platformList.addPlatform(this.getPlatform());
            super.handleAdd();
        }
    }

    protected void handleRemove() {
        int[] nArray = super.getSelectedIndexes();
        DDNSStringTranslator dDNSStringTranslator = null;
        DDNSStringTranslator dDNSStringTranslator2 = null;
        String string = null;
        Platform platform = null;
        String string2 = super.getTextSeparator();
        int n = string2.length();
        int n2 = -1;
        int n3 = nArray.length - 1;
        while (n3 >= 0) {
            string = new String(super.getItem(nArray[n3]));
            n2 = string.indexOf(string2);
            if (n2 != -1) {
                dDNSStringTranslator = new DDNSStringTranslator(string.substring(0, n2));
                dDNSStringTranslator2 = new DDNSStringTranslator(string.substring(n2 + n, string.length()));
                platform = new Platform(dDNSStringTranslator.toEscapedString(), dDNSStringTranslator2.toEscapedString());
                this.platformList.deletePlatform(platform);
            }
            --n3;
        }
        super.handleRemove();
    }

    private String getCPUField() {
        return super.getTextField(0);
    }

    private void setCPUField(String string) {
        super.setTextField(0, string);
    }

    private String getOSField() {
        return super.getTextField(1);
    }

    private void setOSField(String string) {
        super.setTextField(1, string);
    }

    private void setFieldLabels() {
        String[] stringArray = new String[]{new String(this.resources.getString("CPU_TYPE_LABEL")), new String(this.resources.getString("OP_SYS_LABEL"))};
        super.setFieldLabels(stringArray);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object instanceof Button) {
            this.handleButton((Button)object);
            this.parent.handleButton((Button)object);
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        Object object = keyEvent.getSource();
        if (keyEvent.getKeyCode() == 10 && object instanceof Button) {
            this.handleButton((Button)object);
            this.parent.handleButton((Button)object);
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }
}

