/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.ddnssgui.common;

import COM.ibm.raleigh.ddnssgui.common.ListPanel;
import COM.ibm.raleigh.ddnssgui.common.ListPanelGrid;
import COM.ibm.raleigh.ddnssgui.common.ListPanelUser;
import COM.ibm.raleigh.ddnssgui.common.NameAndIpAddress;
import COM.ibm.raleigh.ddnssgui.common.NameAndIpAddressList;
import COM.ibm.raleigh.ddnssgui.common.TcpipValidation;
import COM.ibm.raleigh.ddnssgui.common.msgBox;
import java.awt.Button;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ResourceBundle;
import java.util.StringTokenizer;

public class NameAndIPListPanel
extends ListPanel
implements ActionListener,
KeyListener {
    private static final String cStmt1 = "(c) Copyright IBM Corp 1997. All rights reserved.\n";
    public static final int HOST_FIELD = 0;
    public static final int IP_ADDR_FIELD = 1;
    private static final int NUM_LABELS = 2;
    private ListPanelUser parent;
    private ResourceBundle resources;
    private NameAndIpAddress removedNode;
    private msgBox invalidHostBox;
    private msgBox invalidAddrBox;

    public NameAndIPListPanel(ListPanelUser listPanelUser, ResourceBundle resourceBundle, String string, int n) {
        super((Container)((Object)listPanelUser), resourceBundle, string, "", "", n);
        this.parent = listPanelUser;
        this.resources = resourceBundle;
        this.setFieldLabels();
    }

    public NameAndIPListPanel(ListPanelUser listPanelUser, ResourceBundle resourceBundle, String string, int n, String string2) {
        super((Container)((Object)listPanelUser), resourceBundle, string, "", "", n, string2);
        this.parent = listPanelUser;
        this.resources = resourceBundle;
        this.setFieldLabels();
    }

    public NameAndIPListPanel(ListPanelUser listPanelUser, ResourceBundle resourceBundle, String string, int n, String string2, String string3) {
        super((Container)((Object)listPanelUser), resourceBundle, string, null, n, string2, null, string3);
        this.parent = listPanelUser;
        this.resources = resourceBundle;
        this.setFieldLabels();
    }

    public NameAndIPListPanel(ListPanelUser listPanelUser, ResourceBundle resourceBundle, String string, String[] stringArray, int n, String string2, ListPanelGrid listPanelGrid, String string3) {
        super((Container)((Object)listPanelUser), resourceBundle, string, stringArray, n, string2, listPanelGrid, string3);
        this.parent = listPanelUser;
        this.resources = resourceBundle;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object instanceof Button) {
            this.handleButton((Button)object);
            this.parent.handleButton((Button)object);
        }
    }

    public NameAndIpAddress getNameAndIP() {
        NameAndIpAddress nameAndIpAddress = new NameAndIpAddress(this.getHostName(), this.getIPAddr());
        return nameAndIpAddress;
    }

    public void setNameAndIP(NameAndIpAddress nameAndIpAddress) {
        this.setHostName(nameAndIpAddress.getFqName());
        this.setIPAddr(nameAndIpAddress.getIpAddress());
    }

    public NameAndIpAddress getNameAndIP(int n) {
        NameAndIpAddress nameAndIpAddress = null;
        NameAndIpAddressList nameAndIpAddressList = this.getNameAndIPList();
        if (!nameAndIpAddressList.isEmpty() && n <= nameAndIpAddressList.size() - 1) {
            nameAndIpAddress = new NameAndIpAddress(nameAndIpAddressList.getAPair(n).getFqName(), nameAndIpAddressList.getAPair(n).getIpAddress());
        }
        return nameAndIpAddress;
    }

    public NameAndIpAddressList getNameAndIPList() {
        NameAndIpAddressList nameAndIpAddressList = null;
        int n = this.getItemCount();
        if (n > 0) {
            nameAndIpAddressList = new NameAndIpAddressList();
            String[] stringArray = new String[n];
            stringArray = super.getItemList();
            int n2 = 0;
            while (n2 < n) {
                String string = null;
                String string2 = null;
                StringTokenizer stringTokenizer = new StringTokenizer(stringArray[n2], super.getTextSeparator());
                string = new String(stringTokenizer.nextToken().toLowerCase());
                string2 = new String(stringTokenizer.nextToken());
                nameAndIpAddressList.addAPair(string, string2);
                ++n2;
            }
        } else {
            nameAndIpAddressList = null;
        }
        return nameAndIpAddressList;
    }

    public void setNameAndIPList(NameAndIpAddressList nameAndIpAddressList) {
        NameAndIpAddress nameAndIpAddress = null;
        if (nameAndIpAddressList != null && !nameAndIpAddressList.isEmpty()) {
            int n = 0;
            while (n < nameAndIpAddressList.size()) {
                nameAndIpAddress = nameAndIpAddressList.getAPair(n);
                super.addItem(nameAndIpAddress.getNameAndIpAddr(super.getTextSeparator()));
                ++n;
            }
        }
    }

    public NameAndIpAddress getRemovedNameAndIP() {
        return this.removedNode;
    }

    private void handleButton(Button button) {
        if (button == super.getAddButton()) {
            this.handleAdd();
            return;
        }
        if (button == super.getRemoveButton()) {
            this.handleRemove();
        }
    }

    public int getNumDuplicateAddrs(NameAndIpAddress nameAndIpAddress) {
        int n = 0;
        if (nameAndIpAddress != null) {
            int n2 = 0;
            NameAndIpAddressList nameAndIpAddressList = this.getNameAndIPList();
            String string = nameAndIpAddress.getIpAddress();
            if (nameAndIpAddressList != null) {
                n2 = nameAndIpAddressList.size();
            }
            int n3 = 0;
            while (n3 < n2) {
                if (nameAndIpAddressList.getAPair(n3).getIpAddress().compareTo(string) == 0) {
                    ++n;
                }
                ++n3;
            }
        }
        return n;
    }

    protected void handleAdd() {
        boolean bl = true;
        String string = new String(this.getHostName().toLowerCase());
        String string2 = new String(this.getIPAddr());
        if (!TcpipValidation.IsValidFQTcpipName(string)) {
            this.invalidHostBox = new msgBox(this.resources, this.resources.getString("APP_TITLE"), this.resources.getString("INVALID_HOST_NAME_TEXT"), 1, true);
            this.selectAll(0);
            this.requestFocus(0);
            bl = false;
        } else if (!TcpipValidation.IsValidTcpipAddr(string2)) {
            this.invalidAddrBox = new msgBox(this.resources, this.resources.getString("APP_TITLE"), this.resources.getString("INVALID_IP_ADDR_TEXT"), 1, true);
            this.selectAll(1);
            this.requestFocus(1);
            bl = false;
        }
        if (bl) {
            super.handleAdd(string, string2);
        }
    }

    protected void handleRemove() {
        NameAndIpAddressList nameAndIpAddressList = this.getNameAndIPList();
        int n = super.getSelectedIndex();
        this.removedNode = n >= 0 && n < nameAndIpAddressList.size() ? nameAndIpAddressList.getAPair(n) : null;
        super.handleRemove();
    }

    private String getHostName() {
        return this.getFirstTextField().toLowerCase();
    }

    private void setHostName(String string) {
        this.setFirstTextField(string.toLowerCase());
    }

    private String getIPAddr() {
        return this.getSecondTextField();
    }

    private void setIPAddr(String string) {
        this.setSecondTextField(string);
    }

    private void setFieldLabels() {
        String[] stringArray = new String[]{new String(this.resources.getString("NAME_FIELD_LABEL")), new String(this.resources.getString("IP_ADDRESS_FIELD_LABEL"))};
        super.setFieldLabels(stringArray);
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        Object object = keyEvent.getSource();
        if (keyEvent.getKeyCode() == 10 && object instanceof Button) {
            this.handleButton((Button)object);
            this.parent.handleButton((Button)object);
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }
}

