/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.ddnssgui.common;

import COM.ibm.raleigh.ddnssgui.common.ListPanel;
import COM.ibm.raleigh.ddnssgui.common.ListPanelUser;
import COM.ibm.raleigh.ddnssgui.common.TcpipValidation;
import COM.ibm.raleigh.ddnssgui.common.msgBox;
import java.awt.Button;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.text.MessageFormat;
import java.util.ResourceBundle;

public class MailExchangeListPanel
extends ListPanel
implements ActionListener,
KeyListener {
    private static final String cStmt1 = "(c) Copyright IBM Corp 1997. All rights reserved.\n";
    private static final int MAX_MAIL_PREFERENCE = 65535;
    private static final int MIN_MAIL_PREFERENCE = 0;
    private static final int HOST_FIELD = 0;
    private static final int PREFERENCE_FIELD = 1;
    private ListPanelUser parent;
    private String parentFrameName;
    private ResourceBundle resources;
    private msgBox invalidBox;

    public MailExchangeListPanel(ListPanelUser listPanelUser, ResourceBundle resourceBundle, String string, int n) {
        super((Container)((Object)listPanelUser), resourceBundle, resourceBundle.getString("MAIL_PANEL_LABEL"), resourceBundle.getString("MAIL_HOST_LABEL"), resourceBundle.getString("MAIL_PREFERENCE_LABEL"), n, resourceBundle.getString("MAIL_PANEL_EXPLANATION_LABEL"));
        this.parent = listPanelUser;
        this.parentFrameName = string;
        this.resources = resourceBundle;
        Object[] objectArray = new Object[]{new Integer(0), new Integer(65535)};
        super.setExplanationText(MessageFormat.format(resourceBundle.getString("MAIL_PANEL_EXPLANATION_LABEL"), objectArray));
    }

    public MailExchangeListPanel(ListPanelUser listPanelUser, ResourceBundle resourceBundle, String string, String string2, int n) {
        super((Container)((Object)listPanelUser), resourceBundle, string2, resourceBundle.getString("MAIL_HOST_LABEL"), resourceBundle.getString("MAIL_PREFERENCE_LABEL"), n);
        this.parent = listPanelUser;
        this.parentFrameName = string;
        this.resources = resourceBundle;
    }

    public MailExchangeListPanel(ListPanelUser listPanelUser, ResourceBundle resourceBundle, String string, String string2, int n, String string3) {
        super((Container)((Object)listPanelUser), resourceBundle, string2, resourceBundle.getString("MAIL_HOST_LABEL"), resourceBundle.getString("MAIL_PREFERENCE_LABEL"), n, string3);
        this.parent = listPanelUser;
        this.parentFrameName = string;
        this.resources = resourceBundle;
    }

    public String getMailHost() {
        return this.getFirstTextField().toLowerCase();
    }

    public void setMailHost(String string) {
        this.setFirstTextField(string.toLowerCase());
    }

    public int getMailPreference() {
        String string = this.getSecondTextField();
        if (!string.equals("")) {
            if (TcpipValidation.IsLessThanMaxIntegerValue(string)) {
                try {
                    Integer n = new Integer(string);
                    return n;
                }
                catch (NumberFormatException numberFormatException) {
                    return Integer.MIN_VALUE;
                }
            }
            return Integer.MIN_VALUE;
        }
        return Integer.MIN_VALUE;
    }

    public void setMailPreference(String string) {
        this.setSecondTextField(string);
    }

    public String[] getMailList() {
        return this.getItemList();
    }

    public void setMailList(String[] stringArray) {
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                super.addItem(stringArray[n].toLowerCase());
                ++n;
            }
        }
    }

    private void handleButton(Button button) {
        if (button == super.getAddButton()) {
            this.handleAdd();
            return;
        }
        if (button == super.getRemoveButton()) {
            super.handleRemove();
        }
    }

    protected void handleAdd() {
        boolean bl = true;
        if (!TcpipValidation.IsValidFQTcpipName(this.getMailHost())) {
            this.invalidBox = new msgBox(this.resources, this.parentFrameName, this.resources.getString("INVALID_MAIL_HOST_TEXT"), 1, true);
            this.selectAll(0);
            this.requestFocus(0);
            bl = false;
        } else if (!this.validateMailPreference(this.getMailPreference())) {
            Object[] objectArray = new Object[]{new Integer(0), new Integer(65535)};
            this.invalidBox = new msgBox(this.resources, this.parentFrameName, MessageFormat.format(this.resources.getString("INVALID_MAIL_PREFERENCE_TEXT"), objectArray), 1, true);
            this.selectAll(1);
            this.requestFocus(1);
            bl = false;
        }
        if (bl) {
            super.handleAdd(Integer.toString(this.getMailPreference()), this.getMailHost());
        }
    }

    private boolean validateMailPreference(int n) {
        boolean bl = true;
        if (n == Integer.MIN_VALUE) {
            bl = false;
        } else if (n < 0 || n > 65535) {
            bl = false;
        }
        return bl;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object instanceof Button) {
            this.handleButton((Button)object);
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        Object object = keyEvent.getSource();
        if (keyEvent.getKeyCode() == 10 && object instanceof Button) {
            this.handleButton((Button)object);
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }
}

