/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.ddnssgui.common;

import COM.ibm.raleigh.ddnssgui.common.ListPanel;
import COM.ibm.raleigh.ddnssgui.common.ListPanelUser;
import COM.ibm.raleigh.ddnssgui.common.TcpipValidation;
import COM.ibm.raleigh.ddnssgui.common.msgBox;
import java.awt.Button;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.util.ResourceBundle;

public class IPListPanel
extends ListPanel {
    private static final String cStmt1 = "(c) Copyright IBM Corp 1997. All rights reserved.\n";
    private static final int NUM_LABELS = 1;
    private static final int IP_ADDR_FIELD = 0;
    private ListPanelUser parent;
    private ResourceBundle resources;
    private String invalidAddrText;
    private msgBox invalidAddrBox;

    public IPListPanel(ListPanelUser listPanelUser, ResourceBundle resourceBundle, String string, int n) {
        super((Container)((Object)listPanelUser), resourceBundle, string, "", n);
        this.parent = listPanelUser;
        this.resources = resourceBundle;
        this.setFieldLabels();
        this.setInvalidAddrText(null);
    }

    public IPListPanel(ListPanelUser listPanelUser, ResourceBundle resourceBundle, String string, int n, String string2) {
        super((Container)((Object)listPanelUser), resourceBundle, string, "", n, string2);
        this.parent = listPanelUser;
        this.resources = resourceBundle;
        this.setFieldLabels();
        this.setInvalidAddrText(null);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object instanceof Button) {
            this.handleButton((Button)object);
            this.parent.handleButton((Button)object);
        }
    }

    public String getIPAddr() {
        return this.getFirstTextField();
    }

    public void setIPAddr(String string) {
        this.setFirstTextField(string);
    }

    public String[] getIPAddrList() {
        return super.getItemList();
    }

    public void setIPAddrList(String[] stringArray) {
        if (stringArray != null && stringArray.length > 0) {
            int n = 0;
            while (n < stringArray.length) {
                super.addItem(stringArray[n]);
                ++n;
            }
        }
    }

    public void setInvalidAddrText(String string) {
        if (string != null && string.length() > 0) {
            this.invalidAddrText = new String(string);
            return;
        }
        this.invalidAddrText = new String(this.resources.getString("INVALID_IP_ADDR_TEXT"));
    }

    private void handleButton(Button button) {
        if (button == super.getAddButton()) {
            this.handleAdd();
            return;
        }
        if (button == super.getRemoveButton()) {
            super.handleRemove();
        }
    }

    protected void handleAdd() {
        boolean bl = true;
        String string = new String(this.getIPAddr());
        if (!TcpipValidation.IsValidTcpipAddr(string)) {
            this.invalidAddrBox = new msgBox(this.resources, this.resources.getString("APP_TITLE"), this.invalidAddrText, 1, true);
            this.selectAll(0);
            this.requestFocus(0);
            bl = false;
        }
        if (bl) {
            super.handleAdd();
        }
    }

    private void setFieldLabels() {
        String[] stringArray = new String[]{new String(this.resources.getString("IP_ADDRESS_FIELD_LABEL"))};
        super.setFieldLabels(stringArray);
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        Object object = keyEvent.getSource();
        if (keyEvent.getKeyCode() == 10 && object instanceof Button) {
            this.handleButton((Button)object);
            this.parent.handleButton((Button)object);
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }
}

