/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.ddnssgui.common;

import COM.ibm.raleigh.ddnssgui.common.ConfigurationManager;
import COM.ibm.raleigh.ddnssgui.common.ParsedObject;
import COM.ibm.raleigh.ddnssgui.common.ParsedVector;

public class GuiUserSettings {
    private static final String cStmt1 = "(c) Copyright IBM Corp 1997. All rights reserved.\n";
    public static final String SETTINGS_tag = "USRSET";
    public static final String ESETTINGS_tag = "EUSRSET";
    public static final int DEFAULT_SIGNATURE_TTL = 3600;
    public static final int DEFAULT_EXTENSION_TTL = 3110400;
    public static final int DEFAULT_NUM_OF_HOSTS = 100;
    private static final String warn_tag = "warn";
    private static final String write_tag = "write";
    private static final String num_tag = "num";
    private static final String lease_tag = "lease";
    private static final String pad_tag = "pad";
    private static final String reinit_tag = "reinit";
    private static final String sepdta_tag = "sepdata";
    public static final int REINIT_ALWAYS = 1;
    public static final int REINIT_NEVER = 2;
    public static final int REINIT_PROMPT = 3;
    public static final int SEPDATA_ALWAYS = 1;
    public static final int SEPDATA_NEVER = 2;
    public static final int SEPDATA_PROMPT = 3;
    boolean writeErrorsToFile = true;
    boolean warnBeforeOverwrite = true;
    int numberToShow = 100;
    int sigLease = 3600;
    int sigPad = 3110400;
    int reinitServer = 1;
    int sepData = 3;
    boolean areUserSettings = false;

    public static String handleActions(ParsedVector parsedVector, ParsedObject parsedObject, String string, ConfigurationManager configurationManager) {
        GuiUserSettings guiUserSettings;
        StringBuffer stringBuffer = new StringBuffer(string);
        boolean bl = false;
        if (parsedObject.getValue().equals("SAV")) {
            GuiUserSettings guiUserSettings2 = new GuiUserSettings(parsedVector);
            configurationManager.setUserSettings(guiUserSettings2);
            bl = true;
        } else if (parsedObject.getValue().equals("GET") && (guiUserSettings = configurationManager.getUserSettings()) != null) {
            stringBuffer = new StringBuffer(guiUserSettings.toString("GET"));
            bl = true;
        }
        if (bl) {
            try {
                stringBuffer.insert(0, "RC=ACK,");
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {}
        } else {
            try {
                stringBuffer.insert(0, "RC=NACK,");
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {}
        }
        return stringBuffer.toString();
    }

    public GuiUserSettings() {
    }

    public GuiUserSettings(ParsedVector parsedVector) {
        this();
        this.fromString(parsedVector);
    }

    public void setWriteErrorsToFile(boolean bl) {
        this.writeErrorsToFile = bl;
    }

    public boolean getWriteErrorsToFile() {
        return this.writeErrorsToFile;
    }

    public void setWarnBeforeOverwrite(boolean bl) {
        this.warnBeforeOverwrite = bl;
    }

    public boolean getWarnBeforeOverwrite() {
        return this.warnBeforeOverwrite;
    }

    public void setNumberToShow(int n) {
        this.numberToShow = n;
    }

    public int getNumberToShow() {
        return this.numberToShow;
    }

    public void setSigLease(int n) {
        this.sigLease = n;
    }

    public int getSigLease() {
        return this.sigLease;
    }

    public void setSigPad(int n) {
        this.sigPad = n;
    }

    public int getSigPad() {
        return this.sigPad;
    }

    public void setReinitServer(int n) {
        this.reinitServer = n;
    }

    public int getReinitServer() {
        return this.reinitServer;
    }

    public void setSepData(int n) {
        this.sepData = n;
    }

    public int getSepData() {
        return this.sepData;
    }

    public boolean doUserSettingsExist() {
        return this.areUserSettings;
    }

    public String toString(String string) {
        StringBuffer stringBuffer = new StringBuffer("USRSET=" + string);
        if (this.writeErrorsToFile) {
            stringBuffer.append(",write=t");
        } else {
            stringBuffer.append(",write=f");
        }
        if (this.warnBeforeOverwrite) {
            stringBuffer.append(",warn=t");
        } else {
            stringBuffer.append(",warn=f");
        }
        stringBuffer.append(",lease=" + this.sigLease);
        stringBuffer.append(",num=" + this.numberToShow);
        stringBuffer.append(",pad=" + this.sigPad);
        stringBuffer.append(",reinit=" + this.reinitServer);
        stringBuffer.append(",sepdata=" + this.sepData);
        stringBuffer.append(",EUSRSET,");
        return stringBuffer.toString();
    }

    public void fromString(ParsedVector parsedVector) {
        String[] stringArray = parsedVector.getKeys();
        int n = 0;
        while (n < stringArray.length) {
            Integer n2;
            String string;
            ParsedObject parsedObject;
            if (stringArray[n].equals("RC")) {
                parsedObject = parsedVector.getElement(SETTINGS_tag);
                string = (String)parsedObject.getValue();
                if (string != null) {
                    this.areUserSettings = !string.equals("NACK");
                }
            } else if (stringArray[n].equals(num_tag)) {
                parsedObject = parsedVector.getElement(num_tag);
                string = (String)parsedObject.getValue();
                if (string != null) {
                    n2 = Integer.valueOf(string);
                    this.numberToShow = n2;
                }
            } else if (stringArray[n].equals(lease_tag)) {
                parsedObject = parsedVector.getElement(lease_tag);
                string = (String)parsedObject.getValue();
                if (string != null) {
                    n2 = Integer.valueOf(string);
                    this.sigLease = n2;
                }
            } else if (stringArray[n].equals(pad_tag)) {
                parsedObject = parsedVector.getElement(pad_tag);
                string = (String)parsedObject.getValue();
                if (string != null) {
                    n2 = Integer.valueOf(string);
                    this.sigPad = n2;
                }
            } else if (stringArray[n].equals(reinit_tag)) {
                parsedObject = parsedVector.getElement(reinit_tag);
                string = (String)parsedObject.getValue();
                if (string != null) {
                    n2 = Integer.valueOf(string);
                    this.reinitServer = n2;
                }
            } else if (stringArray[n].equals(sepdta_tag)) {
                parsedObject = parsedVector.getElement(sepdta_tag);
                string = (String)parsedObject.getValue();
                if (string != null) {
                    n2 = Integer.valueOf(string);
                    this.sepData = n2;
                }
            } else if (stringArray[n].equals(warn_tag)) {
                parsedObject = parsedVector.getElement(warn_tag);
                string = (String)parsedObject.getValue();
                if (string != null) {
                    this.warnBeforeOverwrite = string.equals("t");
                }
            } else if (stringArray[n].equals(write_tag) && (string = (String)(parsedObject = parsedVector.getElement(write_tag)).getValue()) != null) {
                this.writeErrorsToFile = string.equals("t");
            }
            ++n;
        }
    }
}

