/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.ddnssgui.common;

import COM.ibm.raleigh.ddnssgui.common.ConfigurationManager;
import COM.ibm.raleigh.ddnssgui.common.DomainObject;
import COM.ibm.raleigh.ddnssgui.common.PrimaryDomain;
import java.io.File;
import java.util.Enumeration;
import java.util.Vector;

public class GenerateFileName {
    private static final String cStmt1 = "(c) Copyright IBM Corp 1997. All rights reserved.\n";
    protected static int lastDomFile;
    protected static int lastRevFile;
    protected static int lastStaticFile;
    protected static String filePrefix;
    protected static String domFilePostfix;
    protected static String revFilePostfix;
    protected static String staFilePostfix;
    protected String defaultDirectory;
    protected ConfigurationManager theMgr;

    public GenerateFileName(String string, ConfigurationManager configurationManager) {
        if (string != null) {
            this.defaultDirectory = new String(string);
        }
        this.theMgr = configurationManager;
    }

    public void setDefaultDirectory(String string) {
        this.defaultDirectory = new String(string);
    }

    public String getDomFileName() {
        String string = null;
        if (lastDomFile < 9999 && this.isAvailable(string = this.concatFileName(lastDomFile, domFilePostfix), this.getListOfUsedNames())) {
            ++lastDomFile;
            return new String(String.valueOf(this.defaultDirectory) + File.separator + string);
        }
        string = this.findAvailableFileName(lastDomFile, domFilePostfix);
        ++lastDomFile;
        return new String(String.valueOf(this.defaultDirectory) + File.separator + string);
    }

    public String getReverseFileName() {
        String string = null;
        if (lastRevFile < 9999 && this.isAvailable(string = this.concatFileName(lastRevFile, revFilePostfix), this.getListOfUsedNames())) {
            ++lastRevFile;
            return new String(String.valueOf(this.defaultDirectory) + File.separator + string);
        }
        string = this.findAvailableFileName(lastRevFile, revFilePostfix);
        ++lastRevFile;
        return new String(String.valueOf(this.defaultDirectory) + File.separator + string);
    }

    public String getStaticFileName() {
        String string = null;
        if (lastStaticFile < 9999 && this.isAvailable(string = this.concatFileName(lastStaticFile, staFilePostfix), this.getListOfUsedNames())) {
            ++lastStaticFile;
            return new String(String.valueOf(this.defaultDirectory) + File.separator + string);
        }
        string = this.findAvailableFileName(lastStaticFile, staFilePostfix);
        ++lastStaticFile;
        return new String(String.valueOf(this.defaultDirectory) + File.separator + string);
    }

    private String concatFileName(int n, String string) {
        if (n < 10) {
            return new String(String.valueOf(filePrefix) + "000" + n + string);
        }
        if (n < 100) {
            return new String(String.valueOf(filePrefix) + "00" + n + string);
        }
        if (n < 1000) {
            return new String(String.valueOf(filePrefix) + "0" + n + string);
        }
        return new String(String.valueOf(filePrefix) + n + string);
    }

    private boolean isAvailable(String string, String[] stringArray) {
        boolean bl = false;
        String string2 = new String(String.valueOf(this.defaultDirectory) + File.separator + string);
        int n = 0;
        while (n < stringArray.length) {
            if (string2.equalsIgnoreCase(stringArray[n])) {
                bl = true;
            }
            ++n;
        }
        if (!bl) {
            File file = new File(this.defaultDirectory, string);
            return !file.exists();
        }
        return false;
    }

    private String findAvailableFileName(int n, String string) {
        int n2 = n;
        int n3 = n2++;
        while (n2 < 9999 && n2 != n3) {
            String string2 = this.concatFileName(n2, string);
            if (this.isAvailable(string2, this.getListOfUsedNames())) {
                return string2;
            }
            ++n2;
        }
        return null;
    }

    private String[] getListOfUsedNames() {
        Object[] objectArray;
        Enumeration enumeration = this.theMgr.getAllDomains();
        Vector<String> vector = new Vector<String>();
        while (enumeration.hasMoreElements()) {
            objectArray = (DomainObject)enumeration.nextElement();
            vector.addElement(objectArray.getDataFileName());
            if (!(objectArray instanceof PrimaryDomain)) continue;
            vector.addElement(((PrimaryDomain)objectArray).getStaticFileName());
        }
        objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    static {
        filePrefix = new String("dnsf");
        domFilePostfix = new String(".dom");
        revFilePostfix = new String(".rev");
        staFilePostfix = new String(".sta");
    }
}

