/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.ddnssgui.common;

import COM.ibm.raleigh.ddnssgui.common.ParsedObject;
import COM.ibm.raleigh.ddnssgui.common.ParsedVector;
import COM.ibm.raleigh.ddnssgui.common.TraceClient;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Enumeration;
import java.util.ResourceBundle;
import java.util.Vector;

public class DDNSfile {
    private static final String cStmt1 = "(c) Copyright IBM Corp 1997. All rights reserved.\n";
    public static final String cmt_tag = "CMT";
    public static final String ign_tag = "IGN";
    public static final String err_tag = "ERR";
    public static String COMMENT_DELIMITER = ";";
    protected ParsedVector theFileData = new ParsedVector();
    private Vector inputStreamVector = new Vector();
    private Vector outputStreamVector = new Vector();
    private TraceClient outToTrace;
    private String fileNameToTrace = "DDNSfile";
    protected ResourceBundle theStrings;

    public DDNSfile(ResourceBundle resourceBundle) {
        this.theStrings = resourceBundle;
    }

    public final void setTrace(TraceClient traceClient, String string) {
        this.outToTrace = traceClient;
        this.fileNameToTrace = string;
    }

    public boolean readFile(String string) {
        return false;
    }

    public boolean writeFile(String string) {
        return false;
    }

    public final boolean addToFile(String string, String string2) {
        ParsedObject parsedObject = new ParsedObject(string, string2);
        this.theFileData.append(parsedObject);
        return true;
    }

    public final boolean addToFile(String string, Object object) {
        ParsedObject parsedObject = new ParsedObject(string, object);
        this.theFileData.append(parsedObject);
        return true;
    }

    public final BufferedWriter setOutputFile(String string) {
        Object object;
        if (string == null) {
            return null;
        }
        File file = new File(string);
        if (!file.exists()) {
            object = file.getParent();
            File file2 = new File((String)object);
            file2.mkdirs();
        }
        try {
            object = new BufferedWriter(new FileWriter(file));
            this.outputStreamVector.addElement(object);
            return object;
        }
        catch (IOException iOException) {
            this.outToTrace.traceTime(this.fileNameToTrace, this.theStrings.getString("FILE_OUTPUT_ERROR"));
            return null;
        }
    }

    public final BufferedReader setInputFile(String string) {
        if (string == null) {
            return null;
        }
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            this.inputStreamVector.addElement(bufferedReader);
            return bufferedReader;
        }
        catch (NullPointerException nullPointerException) {
            this.outToTrace.traceTime(this.fileNameToTrace, String.valueOf(this.theStrings.getString("FILE_NOT_FOUND_ERROR")) + string);
            return null;
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.outToTrace.traceTime(this.fileNameToTrace, String.valueOf(this.theStrings.getString("FILE_NOT_FOUND_ERROR")) + string);
            return null;
        }
    }

    public final void writeOutput(BufferedWriter bufferedWriter, String string) {
        if (string != null) {
            try {
                if (!string.endsWith("\n")) {
                    bufferedWriter.write(String.valueOf(string) + "\n");
                    return;
                }
                bufferedWriter.write(string);
                return;
            }
            catch (IOException iOException) {
                this.outToTrace.traceTime(this.fileNameToTrace, this.theStrings.getString("FILE_IO_ERROR"));
                return;
            }
        }
    }

    public final void writeOutput(BufferedWriter bufferedWriter, String[] stringArray) {
        if (stringArray != null) {
            try {
                int n = 0;
                while (n < stringArray.length) {
                    if (stringArray[n] != null) {
                        if (!stringArray[n].endsWith("\n")) {
                            bufferedWriter.write(String.valueOf(stringArray[n]) + "\n");
                        } else {
                            bufferedWriter.write(stringArray[n]);
                        }
                    }
                    ++n;
                }
                return;
            }
            catch (IOException iOException) {
                this.outToTrace.traceTime(this.fileNameToTrace, this.theStrings.getString("FILE_IO_ERROR"));
                return;
            }
        }
    }

    public final String getNextLine(BufferedReader bufferedReader) {
        try {
            return bufferedReader.readLine();
        }
        catch (IOException iOException) {
            this.outToTrace.traceTime(this.fileNameToTrace, this.theStrings.getString("FILE_READ_ERROR"));
            return null;
        }
    }

    public final void closeInput() {
        Enumeration enumeration = this.inputStreamVector.elements();
        while (enumeration.hasMoreElements()) {
            BufferedReader bufferedReader = (BufferedReader)enumeration.nextElement();
            try {
                bufferedReader.close();
            }
            catch (IOException iOException) {}
        }
    }

    public final void closeOutput() {
        Enumeration enumeration = this.outputStreamVector.elements();
        while (enumeration.hasMoreElements()) {
            BufferedWriter bufferedWriter = (BufferedWriter)enumeration.nextElement();
            try {
                bufferedWriter.close();
            }
            catch (IOException iOException) {}
        }
    }
}

