/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.ddnssgui.common;

import COM.ibm.raleigh.ddnssgui.common.FileItem;
import java.util.ResourceBundle;

public class ConfigFileEntry
extends FileItem {
    private static final String cStmt1 = "(c) Copyright IBM Corp 1997. All rights reserved.\n";
    public static final String fe_tag = "FE";
    public static final String COMMENT_REC = "CMT";
    public static final String DOMAIN_START = "DOM_ENTRY";
    public static final String DOMAIN_END = "DOM_END";
    public static final String USER_SETTINGS_START = "GUI_ENTRY";
    public static final String USER_SETTINGS_END = "DOM_END";
    public static final String IGNORED_REC = "IGN_ENTRY";
    public static final String ERROR_REC = "ERR_ENTRY";
    public static final String timeSync = "timeSync";
    public static final String toSecondaries = "timeSync.toSecondaries";
    public static final String notify = "notify";
    public static final String notifyAdd = "notify.add";
    public static final String notifyRem = "notify.remove";
    public static final String notifyDel = "notify.delayTime";
    public static final String notifyRet = "notify.retryTime";
    public static final String notifyNum = "notify.retryNumber";
    public static final String safeWrite = "safeWrite";
    public static final String sigDel = "sigDel";
    public static final String sigTime = "sigDel.time";
    public static final String ttlSet = "ttlSet";
    public static final String ttlVal = "ttlSet.value";
    public static final String defUpd = "deferUpdCnt";
    public static final String incrTime = "incrTime";
    public static final String keyToSec = "keyToSec";
    public static final String sepDyn = "sepDynStatic";
    public static final String userExit = "userExit";
    public static final String wins = "winsLookup";
    public static final String addReverse = "reverseMapping";
    public static final String YES = "yes";
    public static final String NO = "no";
    public static final String gui_warn = "gui.warn";
    public static final String gui_write = "gui.write";
    public static final String gui_num = "gui.num";
    public static final String gui_lease = "gui.lease";
    public static final String gui_pad = "gui.pad";
    public static final String gui_reinit = "gui.reinit";
    public static final String gui_sepdta = "gui.sepdata";
    public static final String theGUIentry = "DDNSAdministratorClient";
    public static final String ReInitHostKey = "ReInitHostKey";
    protected String theRecType;
    protected String recordData;
    private ResourceBundle theStrings;

    public ConfigFileEntry(String string, ResourceBundle resourceBundle) {
        this.theStrings = resourceBundle;
        String string2 = new String(string.trim());
        if (!this.isComment(string2)) {
            String string3 = this.stripComment(string2);
            this.parseLine(string3.trim());
        }
    }

    public String getRecType() {
        return this.theRecType;
    }

    public String getRecordData() {
        return this.recordData;
    }

    public void reSetRecordData() {
        if (!(this.theRecType.equals(IGNORED_REC) || this.theRecType.equals(COMMENT_REC) || this.theRecType.equals(ERROR_REC))) {
            this.recordData = new String(String.valueOf(this.theRecType) + "=" + this.recordData);
        }
    }

    private boolean isComment(String string) {
        if (string == null || string.equals("")) {
            this.theRecType = IGNORED_REC;
            this.recordData = "";
            return true;
        }
        try {
            if (string.charAt(0) == ';') {
                this.theRecType = COMMENT_REC;
                this.recordData = string.trim();
                return true;
            }
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            this.addError(String.valueOf(this.theStrings.getString("ERROR_PARSE_COMMENT")) + string);
        }
        return false;
    }

    private String stripComment(String string) {
        block2: {
            int n = string.indexOf(";");
            if (n <= 0) break block2;
            this.AddComment(new String(string.substring(n)));
            try {
                string = string.substring(0, n - 1);
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                this.addError(String.valueOf(this.theStrings.getString("ERROR_STRIP_COMMENT")) + string);
            }
        }
        return string;
    }

    private void parseLine(String string) {
        int n = string.indexOf("(");
        if (n < 0) {
            n = string.indexOf(")");
            if (n < 0) {
                n = string.indexOf("=");
                if (n > 0) {
                    try {
                        this.setRecType(string.substring(0, n).trim());
                        if (this.theRecType.equals(IGNORED_REC)) {
                            this.recordData = new String(string.trim());
                            return;
                        }
                        this.recordData = new String(string.substring(n + 1).trim());
                        return;
                    }
                    catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                        this.addError(String.valueOf(this.theStrings.getString("NO_KEY")) + string);
                        this.recordData = new String(string.trim());
                        return;
                    }
                }
                this.theRecType = new String(IGNORED_REC);
                this.recordData = new String(string.trim());
                return;
            }
            this.theRecType = "DOM_END";
            this.recordData = new String("");
            return;
        }
        if (n == 0) {
            this.theRecType = new String(IGNORED_REC);
            this.recordData = new String(string.trim());
            return;
        }
        this.recordData = new String(string.substring(0, n).trim());
        if (this.recordData.equals(theGUIentry)) {
            this.theRecType = USER_SETTINGS_START;
            return;
        }
        this.theRecType = DOMAIN_START;
    }

    public void setRecType(String string) {
        if (string.equalsIgnoreCase(timeSync)) {
            this.theRecType = new String(timeSync);
            return;
        }
        if (string.equalsIgnoreCase(toSecondaries)) {
            this.theRecType = new String(toSecondaries);
            return;
        }
        if (string.equalsIgnoreCase(notify)) {
            this.theRecType = new String(notify);
            return;
        }
        if (string.equalsIgnoreCase(notifyAdd)) {
            this.theRecType = new String(notifyAdd);
            return;
        }
        if (string.equalsIgnoreCase(notifyRem)) {
            this.theRecType = new String(notifyRem);
            return;
        }
        if (string.equalsIgnoreCase(notifyDel)) {
            this.theRecType = new String(notifyDel);
            return;
        }
        if (string.equalsIgnoreCase(notifyRet)) {
            this.theRecType = new String(notifyRet);
            return;
        }
        if (string.equalsIgnoreCase(notifyNum)) {
            this.theRecType = new String(notifyNum);
            return;
        }
        if (string.equalsIgnoreCase(safeWrite)) {
            this.theRecType = new String(safeWrite);
            return;
        }
        if (string.equalsIgnoreCase(sigDel)) {
            this.theRecType = new String(sigDel);
            return;
        }
        if (string.equalsIgnoreCase(sigTime)) {
            this.theRecType = new String(sigTime);
            return;
        }
        if (string.equalsIgnoreCase(ttlSet)) {
            this.theRecType = new String(ttlSet);
            return;
        }
        if (string.equalsIgnoreCase(ttlVal)) {
            this.theRecType = new String(ttlVal);
            return;
        }
        if (string.equalsIgnoreCase(defUpd)) {
            this.theRecType = new String(defUpd);
            return;
        }
        if (string.equalsIgnoreCase(incrTime)) {
            this.theRecType = new String(incrTime);
            return;
        }
        if (string.equalsIgnoreCase(keyToSec)) {
            this.theRecType = new String(keyToSec);
            return;
        }
        if (string.equalsIgnoreCase(sepDyn)) {
            this.theRecType = new String(sepDyn);
            return;
        }
        if (string.equalsIgnoreCase(addReverse)) {
            this.theRecType = new String(addReverse);
            return;
        }
        if (string.equalsIgnoreCase(gui_warn)) {
            this.theRecType = new String(gui_warn);
            return;
        }
        if (string.equalsIgnoreCase(gui_write)) {
            this.theRecType = new String(gui_write);
            return;
        }
        if (string.equalsIgnoreCase(gui_num)) {
            this.theRecType = new String(gui_num);
            return;
        }
        if (string.equalsIgnoreCase(gui_lease)) {
            this.theRecType = new String(gui_lease);
            return;
        }
        if (string.equalsIgnoreCase(gui_pad)) {
            this.theRecType = new String(gui_pad);
            return;
        }
        if (string.equalsIgnoreCase(gui_reinit)) {
            this.theRecType = new String(gui_reinit);
            return;
        }
        if (string.equalsIgnoreCase(gui_sepdta)) {
            this.theRecType = new String(gui_sepdta);
            return;
        }
        if (string.equalsIgnoreCase(ReInitHostKey)) {
            this.theRecType = new String(ReInitHostKey);
            return;
        }
        this.theRecType = new String(IGNORED_REC);
    }
}

