/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.ddnssgui.common;

import COM.ibm.raleigh.ddnssgui.common.ConfigurationManager;
import COM.ibm.raleigh.ddnssgui.common.DDNSNetworkStringParser;
import COM.ibm.raleigh.ddnssgui.common.NetworkHandler;
import COM.ibm.raleigh.ddnssgui.common.ParsedObject;
import COM.ibm.raleigh.ddnssgui.common.ParsedVector;

public class CommandServer {
    private static final String cStmt1 = "(c) Copyright IBM Corp 1997. All rights reserved.\n";
    public static final String CMDS_tag = "CMDSRVR";
    public static final String ECMDS_tag = "ECMDSRVR";
    public static final String reqtype_tag = "ReqTyp";
    public static final String boolVal_tag = "Val";
    public static final String intVal1_tag = "Val1";
    public static final String intVal2_tag = "Val2";
    public static final String fName_tag = "fname";
    public static final String dName_tag = "dname";
    public static final int c_WriteErrorsToFile = 1;
    public static final int c_StartNewConfig = 2;
    public static final int c_SetDynamicOpts = 3;
    public static final int c_writeConfig = 4;
    public static final int c_StopServer = 5;
    public static final int c_StartServer = 6;
    public static final int c_ReinitServer = 7;
    public static final int c_importDomainFile = 8;
    public static final int c_SeparateDynamicDomains = 9;
    private int requestNum;
    private boolean shouldDo;
    int number1;
    int number2;
    String fileName;
    String domName;

    public static String handleCommand(ParsedVector parsedVector, ParsedObject parsedObject, String string, ConfigurationManager configurationManager) {
        String string2;
        int n = 0;
        ParsedObject parsedObject2 = parsedVector.getElement(reqtype_tag);
        if (parsedObject2 != null && (string2 = (String)parsedObject2.getValue()) != null) {
            Integer n2 = Integer.valueOf(string2);
            n = n2;
        }
        CommandServer commandServer = new CommandServer(n, true);
        switch (n) {
            case 1: {
                configurationManager.setWriteErrorsToFile(commandServer.fromString(parsedVector));
                break;
            }
            case 2: {
                configurationManager.clearConfig();
                break;
            }
            case 5: {
                configurationManager.stopServer(false);
                break;
            }
            case 6: {
                configurationManager.restartServer(true);
                break;
            }
            case 7: {
                configurationManager.reinitServer();
                break;
            }
            case 4: {
                configurationManager.writeConfig(commandServer.fromString(parsedVector));
                break;
            }
            case 3: {
                configurationManager.setDynamicValues(commandServer.getVal1(parsedVector), commandServer.getVal2(parsedVector));
                break;
            }
            case 9: {
                configurationManager.separateDynamicDomains();
                break;
            }
            case 8: {
                String string3 = commandServer.getfName(parsedVector);
                String string4 = commandServer.getdName(parsedVector);
                commandServer = new CommandServer(n, string3, string4);
                if (string3 == null || string4 == null) break;
                configurationManager.createNewDomainFromFile(string3, string4);
                break;
            }
        }
        return commandServer.toString();
    }

    public CommandServer(int n, boolean bl) {
        this.requestNum = n;
        this.shouldDo = bl;
    }

    public CommandServer(int n, int n2, int n3) {
        this.requestNum = n;
        this.number1 = n2;
        this.number2 = n3;
    }

    public CommandServer(int n, String string, String string2) {
        this.requestNum = n;
        this.fileName = string;
        this.domName = string2;
    }

    public CommandServer(ParsedVector parsedVector) {
        this.fromString(parsedVector);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(CMDS_tag);
        stringBuffer.append(this.buildRestOfString());
        stringBuffer.append(",ECMDSRVR,");
        return stringBuffer.toString();
    }

    private String buildRestOfString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(",ReqTyp=" + String.valueOf(this.requestNum));
        if (this.requestNum != 3 && this.requestNum != 8) {
            if (this.shouldDo) {
                stringBuffer.append(",Val=t");
            } else {
                stringBuffer.append(",Val=f");
            }
        } else if (this.requestNum == 3) {
            stringBuffer.append(",Val1=" + this.number1);
            stringBuffer.append(",Val2=" + this.number2);
        } else if (this.requestNum == 8) {
            stringBuffer.append(",fname=" + this.fileName);
            stringBuffer.append(",dname=" + this.domName);
        }
        return stringBuffer.toString();
    }

    public boolean fromString(ParsedVector parsedVector) {
        ParsedObject parsedObject = parsedVector.getElement(boolVal_tag);
        String string = (String)parsedObject.getValue();
        return string != null && string.equals("t");
    }

    public int getVal1(ParsedVector parsedVector) {
        ParsedObject parsedObject = parsedVector.getElement(intVal1_tag);
        String string = (String)parsedObject.getValue();
        if (string != null) {
            Integer n = Integer.valueOf(string);
            return n;
        }
        return 0;
    }

    public String getfName(ParsedVector parsedVector) {
        ParsedObject parsedObject = parsedVector.getElement(fName_tag);
        String string = (String)parsedObject.getValue();
        if (string != null) {
            return string;
        }
        return null;
    }

    public String getdName(ParsedVector parsedVector) {
        ParsedObject parsedObject = parsedVector.getElement(dName_tag);
        String string = (String)parsedObject.getValue();
        if (string != null) {
            return string;
        }
        return null;
    }

    public int getVal2(ParsedVector parsedVector) {
        ParsedObject parsedObject = parsedVector.getElement(intVal2_tag);
        String string = (String)parsedObject.getValue();
        if (string != null) {
            Integer n = Integer.valueOf(string);
            return n;
        }
        return 0;
    }

    public boolean executeCommand(NetworkHandler networkHandler) {
        networkHandler.sendToServer(this.toString());
        DDNSNetworkStringParser dDNSNetworkStringParser = networkHandler.receiveFromServer();
        return this.fromString(dDNSNetworkStringParser.getParsed());
    }

    public int executeIntCommand(NetworkHandler networkHandler) {
        networkHandler.sendToServer(this.toString());
        DDNSNetworkStringParser dDNSNetworkStringParser = networkHandler.receiveFromServer();
        return this.getVal1(dDNSNetworkStringParser.getParsed());
    }

    public String executeImportCommand(NetworkHandler networkHandler) {
        networkHandler.sendToServer(this.toString());
        DDNSNetworkStringParser dDNSNetworkStringParser = networkHandler.receiveFromServer();
        return this.getfName(dDNSNetworkStringParser.getParsed());
    }
}

