/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.ddnssgui.common;

import COM.ibm.raleigh.ddnssgui.common.DDNSUtility;
import COM.ibm.raleigh.ddnssgui.common.FileItem;
import COM.ibm.raleigh.ddnssgui.common.TcpipValidation;
import java.util.NoSuchElementException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;

public class BootFileEntry
extends FileItem {
    private static final String cStmt1 = "(c) Copyright IBM Corp 1997. All rights reserved.\n";
    public static final String COMMENT_REC = "CMT";
    public static final String PRIMARY_REC = "PRI";
    public static final String SECONDARY_REC = "SEC";
    public static final String CACHE_REC = "CAC";
    public static final String IGNORED_REC = "IGN";
    public static final String ERROR_REC = "ERR";
    public static final String DIRECTORY_REC = "DIR";
    public static final String FORWARDERS_REC = "FOR";
    public static final String SLAVE_REC = "SLA";
    public static final String SORTLIST_REC = "SOR";
    public static final String INCLUDE_REC = "INC";
    public static final String STUB_REC = "STU";
    public static final String OPTIONS_REC = "OPT";
    public static final String LIMIT_REC = "LIM";
    public static final String XFRNETS_REC = "XRF";
    public static final String BOGUSNS_REC = "BOG";
    public static final String CHECKNAME_REC = "CHE";
    protected String theDomain;
    protected String fileName;
    protected String pathName;
    protected boolean isDynamic = false;
    protected Vector aList = new Vector();
    protected String theRecType;
    protected String someData;
    protected boolean isPresecured = false;
    protected ResourceBundle theStrings;

    public BootFileEntry(String string, ResourceBundle resourceBundle) {
        this.theStrings = resourceBundle;
        this.someData = new String(string.trim());
        if (!this.isComment(this.someData)) {
            this.parseRecord(this.someData);
        }
    }

    public String getDomainName() {
        return this.theDomain;
    }

    public String getRecType() {
        return this.theRecType;
    }

    public void setRecType(String string) {
        this.theRecType = string;
    }

    public String getRecordData() {
        return this.someData;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getPathName() {
        return this.pathName;
    }

    public boolean isDomainDynamic() {
        return this.isDynamic;
    }

    public boolean isDomainPresecured() {
        return this.isPresecured;
    }

    public String[] getDataList() {
        if (this.aList != null && !this.aList.isEmpty()) {
            Object[] objectArray = new String[this.aList.size()];
            this.aList.copyInto(objectArray);
            return objectArray;
        }
        return null;
    }

    private boolean isComment(String string) {
        if (string == null || string.equals("")) {
            this.theRecType = COMMENT_REC;
            this.someData = ";";
            return true;
        }
        try {
            if (string.charAt(0) == ';') {
                this.theRecType = COMMENT_REC;
                return true;
            }
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            this.addError(String.valueOf(this.theStrings.getString("ERROR_PARSE_COMMENT")) + string);
        }
        return false;
    }

    private String stripComment(String string) {
        block2: {
            int n = string.indexOf(";");
            if (n <= 0) break block2;
            this.AddComment(new String(string.substring(n)));
            try {
                string = string.substring(0, n - 1);
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                this.addError(String.valueOf(this.theStrings.getString("ERROR_STRIP_COMMENT")) + string);
            }
        }
        return string;
    }

    private void parseRecord(String string) {
        String string2 = this.stripComment(string);
        this.setRecordType(string2);
        if (this.theRecType.equals(PRIMARY_REC)) {
            this.parsePrimary(string2);
            return;
        }
        if (this.theRecType.equals(SECONDARY_REC)) {
            this.parseSecondary(string2);
            return;
        }
        if (this.theRecType.equals(CACHE_REC)) {
            this.parseCache(string2);
            return;
        }
        if (this.theRecType.equals(DIRECTORY_REC)) {
            this.parseDirectory(string2);
            return;
        }
        if (this.theRecType.equals(FORWARDERS_REC)) {
            this.parseForwarders(string2);
        }
    }

    private void setRecordType(String string) {
        if (string.charAt(0) == ';') {
            this.theRecType = COMMENT_REC;
            return;
        }
        if (string.startsWith("primary")) {
            this.theRecType = PRIMARY_REC;
            return;
        }
        if (string.startsWith("secondary")) {
            this.theRecType = SECONDARY_REC;
            return;
        }
        if (string.startsWith("forwarders")) {
            this.theRecType = FORWARDERS_REC;
            return;
        }
        if (string.startsWith("cache")) {
            this.theRecType = CACHE_REC;
            return;
        }
        if (string.startsWith("slave")) {
            this.theRecType = SLAVE_REC;
            return;
        }
        if (string.startsWith("directory")) {
            this.theRecType = DIRECTORY_REC;
            return;
        }
        if (string.startsWith("sortlist")) {
            this.theRecType = SORTLIST_REC;
            return;
        }
        if (string.startsWith("include")) {
            this.theRecType = INCLUDE_REC;
            return;
        }
        if (string.startsWith("stub")) {
            this.theRecType = STUB_REC;
            return;
        }
        if (string.startsWith("options")) {
            this.theRecType = OPTIONS_REC;
            return;
        }
        if (string.startsWith("limit")) {
            this.theRecType = LIMIT_REC;
            return;
        }
        if (string.startsWith("xfrnets")) {
            this.theRecType = XFRNETS_REC;
            return;
        }
        if (string.startsWith("bogusns")) {
            this.theRecType = BOGUSNS_REC;
            return;
        }
        if (string.startsWith("check-names")) {
            this.theRecType = CHECKNAME_REC;
            return;
        }
        this.theRecType = IGNORED_REC;
    }

    private void parsePrimary(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        if (stringTokenizer.hasMoreElements()) {
            try {
                String string2 = (String)stringTokenizer.nextElement();
            }
            catch (NoSuchElementException noSuchElementException) {
                this.theRecType = ERROR_REC;
                this.someData = String.valueOf(this.theStrings.getString("BOOT_FILE_PRI_ERROR")) + string;
            }
        }
        if (stringTokenizer.hasMoreElements()) {
            try {
                this.theDomain = (String)stringTokenizer.nextElement();
                if (!TcpipValidation.IsValidFQTcpipName(this.theDomain)) {
                    this.theRecType = ERROR_REC;
                    this.someData = String.valueOf(this.theStrings.getString("BOOT_FILE_DOM_ERROR")) + string;
                } else {
                    this.theDomain = this.theDomain.toLowerCase();
                }
            }
            catch (NoSuchElementException noSuchElementException) {
                this.theRecType = ERROR_REC;
                this.someData = String.valueOf(this.theStrings.getString("BOOT_FILE_DOM_NAME_ERROR")) + string;
            }
        }
        if (stringTokenizer.hasMoreElements()) {
            try {
                this.fileName = DDNSUtility.stripFileName(((String)stringTokenizer.nextElement()).trim());
                if (this.fileName == null) {
                    this.theRecType = ERROR_REC;
                    this.someData = String.valueOf(this.theStrings.getString("BOOT_FILE_STRIP_DOM_NAME_ERROR")) + string;
                }
            }
            catch (NoSuchElementException noSuchElementException) {
                this.theRecType = ERROR_REC;
                this.someData = String.valueOf(this.theStrings.getString("BOOT_FILE_NAME_ERROR")) + string;
            }
        } else {
            this.theRecType = ERROR_REC;
            this.someData = String.valueOf(this.theStrings.getString("BOOT_FILE_DATA_ERROR")) + string;
        }
        if (stringTokenizer.hasMoreElements()) {
            try {
                String string3 = (String)stringTokenizer.nextElement();
                if (string3.equals("dynamic")) {
                    this.isDynamic = true;
                    if (stringTokenizer.hasMoreElements()) {
                        try {
                            string3 = (String)stringTokenizer.nextElement();
                            if (string3.equals("presecured")) {
                                this.isPresecured = true;
                                return;
                            }
                            this.isPresecured = false;
                            return;
                        }
                        catch (NoSuchElementException noSuchElementException) {
                            this.isPresecured = false;
                            return;
                        }
                    }
                }
            }
            catch (NoSuchElementException noSuchElementException) {
                this.theRecType = ERROR_REC;
                this.someData = String.valueOf(this.theStrings.getString("BOOT_FILE_DYNAMIC_ERROR")) + string;
                return;
            }
        }
    }

    public void parseSecondary(String string) {
        StringTokenizer stringTokenizer;
        block18: {
            stringTokenizer = new StringTokenizer(string);
            if (stringTokenizer.hasMoreElements()) {
                try {
                    String string2 = (String)stringTokenizer.nextElement();
                }
                catch (NoSuchElementException noSuchElementException) {
                    this.theRecType = ERROR_REC;
                    this.someData = String.valueOf(this.theStrings.getString("BOOT_FILE_SEC_ERROR")) + string;
                }
            }
            if (stringTokenizer.hasMoreElements()) {
                try {
                    this.theDomain = (String)stringTokenizer.nextElement();
                    if (!TcpipValidation.IsValidFQTcpipName(this.theDomain)) {
                        this.theRecType = ERROR_REC;
                        this.someData = String.valueOf(this.theStrings.getString("BOOT_FILE_DOM_ERROR")) + string;
                        break block18;
                    }
                    this.theDomain = this.theDomain.toLowerCase();
                }
                catch (NoSuchElementException noSuchElementException) {
                    this.theRecType = ERROR_REC;
                    this.someData = String.valueOf(this.theStrings.getString("BOOT_FILE_DOM_NAME_ERROR")) + string;
                }
            } else {
                this.theRecType = ERROR_REC;
                this.someData = String.valueOf(this.theStrings.getString("BOOT_FILE_SEC_DATA_ERROR")) + string;
            }
        }
        if (stringTokenizer.hasMoreElements()) {
            String string3 = new String("");
            try {
                string3 = (String)stringTokenizer.nextElement();
            }
            catch (NoSuchElementException noSuchElementException) {}
            while (TcpipValidation.IsValidTcpipAddr(string3)) {
                this.aList.addElement(string3);
                if (stringTokenizer.hasMoreElements()) {
                    try {
                        string3 = (String)stringTokenizer.nextElement();
                    }
                    catch (NoSuchElementException noSuchElementException) {}
                    continue;
                }
                this.theRecType = ERROR_REC;
                this.someData = String.valueOf(this.theStrings.getString("BOOT_FILE_NAME_ERROR")) + string;
                break;
            }
            if (this.aList.isEmpty()) {
                this.theRecType = ERROR_REC;
                this.someData = String.valueOf(this.theStrings.getString("BOOT_FILE_MASTER_ERROR")) + string;
            }
            if (!this.theRecType.equals(ERROR_REC)) {
                this.fileName = DDNSUtility.stripFileName(string3);
                return;
            }
        } else {
            this.theRecType = ERROR_REC;
            this.someData = String.valueOf(this.theStrings.getString("BOOT_FILE_SEC_DATA_ERROR")) + string;
        }
    }

    public void parseCache(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        if (stringTokenizer.hasMoreElements()) {
            try {
                String string2 = (String)stringTokenizer.nextElement();
            }
            catch (NoSuchElementException noSuchElementException) {
                this.theRecType = ERROR_REC;
                this.someData = String.valueOf(this.theStrings.getString("BOOT_FILE_PARSE_ERROR")) + string;
            }
        }
        if (stringTokenizer.hasMoreElements()) {
            try {
                String string3 = (String)stringTokenizer.nextElement();
                if (!string3.equals(".")) {
                    this.theRecType = ERROR_REC;
                    this.someData = String.valueOf(this.theStrings.getString("BOOT_FILE_CACHE_ERROR")) + string;
                }
            }
            catch (NoSuchElementException noSuchElementException) {
                this.theRecType = ERROR_REC;
                this.someData = String.valueOf(this.theStrings.getString("BOOT_FILE_PARSE_ERROR")) + string;
            }
        }
        if (stringTokenizer.hasMoreElements()) {
            try {
                this.fileName = new String((String)stringTokenizer.nextElement());
                return;
            }
            catch (NoSuchElementException noSuchElementException) {
                this.theRecType = ERROR_REC;
                this.someData = String.valueOf(this.theStrings.getString("BOOT_FILE_PARSE_ERROR")) + string;
                return;
            }
        }
        this.theRecType = ERROR_REC;
        this.someData = String.valueOf(this.theStrings.getString("BOOT_FILE_NO_CACHE_ERROR")) + string;
    }

    public void parseForwarders(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        if (stringTokenizer.hasMoreElements()) {
            try {
                String string2 = (String)stringTokenizer.nextElement();
            }
            catch (NoSuchElementException noSuchElementException) {
                this.theRecType = ERROR_REC;
                this.someData = String.valueOf(this.theStrings.getString("BOOT_FILE_FORWARD_ERROR")) + string;
            }
        }
        if (!stringTokenizer.hasMoreElements()) {
            this.theRecType = ERROR_REC;
            this.someData = String.valueOf(this.theStrings.getString("BOOT_FILE_FORWARD_ERROR")) + string;
        }
        while (stringTokenizer.hasMoreElements()) {
            try {
                String string3 = new String((String)stringTokenizer.nextElement());
                if (TcpipValidation.IsValidTcpipAddr(string3)) {
                    this.aList.addElement(string3);
                    continue;
                }
                this.theRecType = ERROR_REC;
                this.someData = String.valueOf(this.theStrings.getString("BOOT_FILE_INVALID_FORWARD_ERROR")) + string;
                return;
            }
            catch (NoSuchElementException noSuchElementException) {
                this.theRecType = ERROR_REC;
                this.someData = String.valueOf(this.theStrings.getString("BOOT_FILE_PARSE_ERROR")) + string;
            }
        }
    }

    public void parseDirectory(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        if (stringTokenizer.hasMoreElements()) {
            try {
                String string2 = (String)stringTokenizer.nextElement();
            }
            catch (NoSuchElementException noSuchElementException) {
                this.theRecType = ERROR_REC;
                this.someData = String.valueOf(this.theStrings.getString("BOOT_FILE_PARSE_ERROR")) + string;
            }
        }
        if (stringTokenizer.hasMoreElements()) {
            try {
                this.pathName = (String)stringTokenizer.nextElement();
                return;
            }
            catch (NoSuchElementException noSuchElementException) {
                this.theRecType = ERROR_REC;
                this.someData = String.valueOf(this.theStrings.getString("BOOT_FILE_PARSE_ERROR")) + string;
                return;
            }
        }
        this.theRecType = ERROR_REC;
        this.someData = String.valueOf(this.theStrings.getString("BOOT_FILE_PARSE_ERROR")) + string;
    }
}

