/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.ddnssgui.client;

import COM.ibm.eNetwork.jdi.gui.common.ColorsForCanvas;
import COM.ibm.eNetwork.jdi.gui.common.FontsForCanvas;
import COM.ibm.eNetwork.jdi.gui.common.ImagesForCanvas;
import COM.ibm.eNetwork.jdi.gui.treeView.TreeView;
import COM.ibm.eNetwork.jdi.gui.treeView.TreeViewEventListener;
import COM.ibm.eNetwork.jdi.gui.treeView.addableToTreeView;
import COM.ibm.raleigh.ddnssgui.client.HostRecordsFrame;
import COM.ibm.raleigh.ddnssgui.client.MainFrame;
import COM.ibm.raleigh.ddnssgui.common.DDNSNetworkStringParser;
import COM.ibm.raleigh.ddnssgui.common.DDNSTreeViewScheme;
import COM.ibm.raleigh.ddnssgui.common.MsgBoxListener;
import COM.ibm.raleigh.ddnssgui.common.Question;
import COM.ibm.raleigh.ddnssgui.common.Tree;
import COM.ibm.raleigh.ddnssgui.common.TreeNode;
import COM.ibm.raleigh.ddnssgui.common.msgBox;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.PopupMenu;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ResourceBundle;
import java.util.StringTokenizer;

class TreeViewFrame
extends Panel
implements TreeViewEventListener,
MsgBoxListener,
ActionListener {
    private static final String cStmt1 = "(c) Copyright IBM Corp 1997. All rights reserved.\n";
    ImagesForCanvas gfcImage;
    FontsForCanvas ffcFont = new FontsForCanvas(new Font("Helvetica", 0, 12), new Font("Helvetica", 0, 12));
    ColorsForCanvas cfcColor = new ColorsForCanvas(Color.white, Color.black, Color.yellow);
    TreeView tv;
    String Root;
    addableToTreeView RootTreeNode;
    MainFrame myParent;
    Applet myApplet;
    private ResourceBundle resources;
    static String LastSelected = new String();
    static final int WIDTH = 200;
    static final int HEIGHT = 200;
    DDNSTreeViewScheme tvnStatPriDom;
    DDNSTreeViewScheme tvnRStatPriDom;
    DDNSTreeViewScheme tvnSecDom;
    DDNSTreeViewScheme tvnDynPriDom;
    DDNSTreeViewScheme tvnRDynPriDom;
    DDNSTreeViewScheme tvnPDomLabel;
    DDNSTreeViewScheme tvnSDomLabel;
    PopupMenu pDomOptions;
    PopupMenu rpDomOptions;
    PopupMenu sDomOptions;
    PopupMenu sDomFolderOptions;
    PopupMenu pDomFolderOptions;
    PopupMenu NSOptions;
    msgBox yesNoBox;
    static final String NAMESERV = "nameserver";
    static final String STATPRIMARYDOM = "staticprimarydomain";
    static final String SECONDARYDOM = "secondarydomain";
    static final String SDOMLABEL = "sdomainlabel";
    static final String PDOMLABEL = "pdomainlabel";
    static final String DYNPRIMARYDOM = "dynamicprimarydomain";
    static final String revSTATPRIMARYDOM = "REVstaticprimarydomain";
    static final String revDYNPRIMARYDOM = "REVdynamicprimarydomain";
    Image image1;
    Image image2;
    Image image3;
    Image image4;
    Image image8;
    Image image9;
    Image image10;
    Image image11;
    Image image12;
    private MenuItem POP_EDIT;
    private MenuItem POP_VIEW_REC_PRI;
    private MenuItem POP_VIEW_REC_SEC;
    private MenuItem POP_VIEW_REC_R_PRI;
    private MenuItem POP_VIEW_BOOT;
    private MenuItem POP_DELETE_PRI;
    private MenuItem POP_DELETE_SEC;
    private MenuItem POP_DELETE_R_PRI;
    private MenuItem POP_ADD_P_1;
    private MenuItem POP_ADD_S_1;
    private MenuItem POP_ADD_P_2;
    private MenuItem POP_ADD_S_2;
    private MenuItem POP_VIEW_CACH;
    private MenuItem POP_MOD_SEC;
    private MenuItem POP_MOD_PRI;
    private MenuItem POP_MOD_R_PRI;
    private MenuItem POP_ADD_H;
    private MenuItem POP_ADD_A;
    private MenuItem POP_ADD_R;
    DDNSTreeViewScheme tvnNameServ;

    public TreeViewFrame(String string, MainFrame mainFrame, Applet applet) {
        this.Root = string;
        this.myParent = mainFrame;
        this.myApplet = applet;
        this.resources = this.myParent.clientResources;
    }

    public void addComponents() {
        this.addImages();
        this.gfcImage = new ImagesForCanvas(this.image1, this.image1);
        ImagesForCanvas imagesForCanvas = new ImagesForCanvas(this.image1, this.image1);
        this.tvnNameServ = new DDNSTreeViewScheme(NAMESERV);
        this.tvnNameServ.registerPosition(0);
        this.tvnNameServ.setFolders(imagesForCanvas);
        this.tvnNameServ.setColors(0, this.cfcColor);
        this.tvnNameServ.setFonts(0, this.ffcFont);
        this.tvnNameServ.setImages(0, this.gfcImage);
        this.RootTreeNode = new TreeNode(this.Root, this.tvnNameServ);
        imagesForCanvas = new ImagesForCanvas(this.image11, this.image10);
        this.tv = new TreeView(this.RootTreeNode, new Dimension(200, 200), this.cfcColor, null, null, this.image8, this.image9);
        this.CreatePopupMenus();
        this.CreateSchemes();
        this.createTrees(this.RootTreeNode);
        this.tv.addTreeViewEventListener((TreeViewEventListener)this);
        this.tv.setNodeLineDrawing(true);
        this.tv.committ(true);
        this.setLayout(new BorderLayout());
        this.add("Center", (Component)this.tv);
    }

    protected void createTrees(addableToTreeView addableToTreeView2) {
        TreeNode treeNode = new TreeNode(this.resources.getString("PRIMARY_LABEL"), this.tvnPDomLabel);
        TreeNode treeNode2 = new TreeNode(this.resources.getString("SECONDARY_LABEL"), this.tvnSDomLabel);
        Tree tree = new Tree((TreeNode)addableToTreeView2);
        new Tree(treeNode);
        new Tree(treeNode2);
        tree.addNode(treeNode);
        tree.addNode(treeNode2);
    }

    public void AddAllPrimaryDomains(String[] stringArray) {
        TreeNode treeNode = (TreeNode)this.RootTreeNode;
        TreeNode treeNode2 = null;
        if (stringArray == null) {
            return;
        }
        Tree tree = treeNode.FindImmediateChild(this.resources.getString("PRIMARY_LABEL"));
        if (tree != null) {
            int n = 0;
            while (n < stringArray.length) {
                Question question = new Question(5, stringArray[n]);
                this.myParent.dataOut.sendToServer(question.toString());
                DDNSNetworkStringParser dDNSNetworkStringParser = this.myParent.dataOut.receiveFromServer();
                treeNode2 = question.fromString(dDNSNetworkStringParser.getParsed()) ? (stringArray[n].endsWith("in-addr.arpa") ? new TreeNode(stringArray[n], this.tvnRStatPriDom) : new TreeNode(stringArray[n], this.tvnStatPriDom)) : (stringArray[n].endsWith("in-addr.arpa") ? new TreeNode(stringArray[n], this.tvnRDynPriDom) : new TreeNode(stringArray[n], this.tvnDynPriDom));
                tree.addNode(treeNode2);
                ++n;
            }
        }
        this.tv.committ(true);
    }

    public void AddAllSecondaryDomains(String[] stringArray) {
        TreeNode treeNode = (TreeNode)this.RootTreeNode;
        if (stringArray == null) {
            return;
        }
        Tree tree = treeNode.FindImmediateChild(this.resources.getString("SECONDARY_LABEL"));
        if (tree != null) {
            int n = 0;
            while (n < stringArray.length) {
                TreeNode treeNode2 = new TreeNode(stringArray[n], this.tvnSecDom);
                tree.addNode(treeNode2);
                ++n;
            }
        }
        this.tv.committ(true);
    }

    public void AddPrimaryDomain(String string) {
        TreeNode treeNode = (TreeNode)this.RootTreeNode;
        TreeNode treeNode2 = null;
        Question question = new Question(5, string);
        this.myParent.dataOut.sendToServer(question.toString());
        DDNSNetworkStringParser dDNSNetworkStringParser = this.myParent.dataOut.receiveFromServer();
        treeNode2 = question.fromString(dDNSNetworkStringParser.getParsed()) ? (string.endsWith("in-addr.arpa") ? new TreeNode(string, this.tvnRStatPriDom) : new TreeNode(string, this.tvnStatPriDom)) : (string.endsWith("in-addr.arpa") ? new TreeNode(string, this.tvnRDynPriDom) : new TreeNode(string, this.tvnDynPriDom));
        Tree tree = treeNode.FindImmediateChild(this.resources.getString("PRIMARY_LABEL"));
        if (tree != null) {
            tree.addNode(treeNode2);
        }
        this.tv.committ(true);
    }

    public void AddSecondaryDomain(String string) {
        TreeNode treeNode = new TreeNode(string, this.tvnSecDom);
        TreeNode treeNode2 = (TreeNode)this.RootTreeNode;
        Tree tree = treeNode2.FindImmediateChild(this.resources.getString("SECONDARY_LABEL"));
        if (tree != null) {
            tree.addNode(treeNode);
        }
        this.tv.committ(true);
    }

    public boolean IsNewToTree(String string) {
        TreeNode treeNode = null;
        TreeNode treeNode2 = (TreeNode)this.RootTreeNode;
        Tree tree = treeNode2.FindImmediateChild(this.resources.getString("PRIMARY_LABEL"));
        if (tree != null) {
            treeNode = tree.getNode(string);
        }
        if (treeNode != null) {
            return false;
        }
        tree = treeNode2.FindImmediateChild(this.resources.getString("SECONDARY_LABEL"));
        if (tree != null) {
            treeNode = tree.getNode(string);
        }
        return treeNode == null;
    }

    public String getRootName() {
        TreeNode treeNode = (TreeNode)this.RootTreeNode;
        return treeNode.sText;
    }

    public void setRootName(String string) {
        TreeNode treeNode = (TreeNode)this.RootTreeNode;
        treeNode.sText = string;
        this.tv.committ(false);
    }

    public boolean entryIsPrimary(String string) {
        TreeNode treeNode = (TreeNode)this.RootTreeNode;
        Tree tree = treeNode.FindImmediateChild(this.resources.getString("PRIMARY_LABEL"));
        TreeNode treeNode2 = null;
        if (tree != null) {
            treeNode2 = tree.getNode(string);
        }
        return treeNode2 != null;
    }

    public void unSelectItem() {
        if (LastSelected != null) {
            TreeNode treeNode = (TreeNode)this.RootTreeNode;
            Tree tree = treeNode.FindImmediateChild(this.resources.getString("PRIMARY_LABEL"));
            TreeNode treeNode2 = null;
            if (tree != null) {
                treeNode2 = tree.getNode(LastSelected);
            }
            if (treeNode2 == null && (tree = treeNode.FindImmediateChild(this.resources.getString("SECONDARY_LABEL"))) != null) {
                treeNode2 = tree.getNode(LastSelected);
            }
            if (treeNode2 != null || LastSelected.equals(this.resources.getString("SECONDARY_LABEL")) || LastSelected.equals(this.resources.getString("PRIMARY_LABEL")) || LastSelected.equals(this.getRootName())) {
                this.tv.unSelectTreeViewNode();
                this.tv.committ(true);
            }
        }
    }

    public void expandAllTree() {
        this.tv.expandAllNodes();
    }

    public void collapseAllTree() {
        this.tv.collapseAllNodes();
    }

    public void msgBoxSelection(int n, int n2) {
        if (n2 == 2) {
            this.deleteDomain();
        }
    }

    public String getSelected() {
        return LastSelected;
    }

    private void CreatePopupMenus() {
        this.pDomOptions = new PopupMenu();
        this.POP_MOD_PRI = new MenuItem(this.resources.getString("SPOPMOD"));
        this.POP_ADD_H = new MenuItem(this.resources.getString("SPOPADDH"));
        this.POP_ADD_A = new MenuItem(this.resources.getString("SPOPADDA"));
        this.POP_DELETE_PRI = new MenuItem(this.resources.getString("SPOPDELETE"));
        this.POP_VIEW_REC_PRI = new MenuItem(this.resources.getString("SPOPVIEWREC"));
        this.pDomOptions.add(this.POP_MOD_PRI);
        this.pDomOptions.addSeparator();
        this.pDomOptions.add(this.POP_ADD_H);
        this.pDomOptions.add(this.POP_ADD_A);
        this.pDomOptions.addSeparator();
        this.pDomOptions.add(this.POP_DELETE_PRI);
        this.pDomOptions.addSeparator();
        this.pDomOptions.add(this.POP_VIEW_REC_PRI);
        this.rpDomOptions = new PopupMenu();
        this.POP_ADD_R = new MenuItem(this.resources.getString("SPOPADDR"));
        this.POP_MOD_R_PRI = new MenuItem(this.resources.getString("SPOPMOD"));
        this.POP_DELETE_R_PRI = new MenuItem(this.resources.getString("SPOPDELETE"));
        this.POP_VIEW_REC_R_PRI = new MenuItem(this.resources.getString("SPOPVIEWREC"));
        this.rpDomOptions.add(this.POP_MOD_R_PRI);
        this.rpDomOptions.addSeparator();
        this.rpDomOptions.add(this.POP_ADD_R);
        this.rpDomOptions.addSeparator();
        this.rpDomOptions.add(this.POP_DELETE_R_PRI);
        this.rpDomOptions.addSeparator();
        this.rpDomOptions.add(this.POP_VIEW_REC_R_PRI);
        this.pDomFolderOptions = new PopupMenu();
        this.POP_ADD_P_1 = new MenuItem(this.resources.getString("SPOPADDP"));
        this.pDomFolderOptions.add(this.POP_ADD_P_1);
        this.sDomFolderOptions = new PopupMenu();
        this.POP_ADD_S_1 = new MenuItem(this.resources.getString("SPOPADDS"));
        this.sDomFolderOptions.add(this.POP_ADD_S_1);
        this.sDomOptions = new PopupMenu();
        this.POP_MOD_SEC = new MenuItem(this.resources.getString("SPOPMOD"));
        this.POP_DELETE_SEC = new MenuItem(this.resources.getString("SPOPDELETE"));
        this.POP_VIEW_REC_SEC = new MenuItem(this.resources.getString("SPOPVIEWREC"));
        this.sDomOptions.add(this.POP_MOD_SEC);
        this.sDomOptions.addSeparator();
        this.sDomOptions.add(this.POP_DELETE_SEC);
        this.sDomOptions.addSeparator();
        this.sDomOptions.add(this.POP_VIEW_REC_SEC);
        this.NSOptions = new PopupMenu();
        this.POP_VIEW_CACH = new MenuItem(this.resources.getString("SCACHEALL"));
        this.POP_VIEW_BOOT = new MenuItem(this.resources.getString("SPOPBOOT"));
        this.POP_EDIT = new MenuItem(this.resources.getString("SPOPEDIT"));
        this.POP_ADD_S_2 = new MenuItem(this.resources.getString("SPOPADDS"));
        this.POP_ADD_P_2 = new MenuItem(this.resources.getString("SPOPADDP"));
        this.NSOptions.add(this.POP_EDIT);
        this.NSOptions.addSeparator();
        this.NSOptions.add(this.POP_ADD_P_2);
        this.NSOptions.add(this.POP_ADD_S_2);
        this.NSOptions.addSeparator();
        this.NSOptions.add(this.POP_VIEW_BOOT);
        this.NSOptions.add(this.POP_VIEW_CACH);
        this.POP_EDIT.addActionListener(this);
        this.POP_VIEW_REC_PRI.addActionListener(this);
        this.POP_VIEW_REC_R_PRI.addActionListener(this);
        this.POP_VIEW_REC_SEC.addActionListener(this);
        this.POP_VIEW_BOOT.addActionListener(this);
        this.POP_DELETE_PRI.addActionListener(this);
        this.POP_DELETE_R_PRI.addActionListener(this);
        this.POP_DELETE_SEC.addActionListener(this);
        this.POP_ADD_P_1.addActionListener(this);
        this.POP_ADD_S_1.addActionListener(this);
        this.POP_ADD_P_2.addActionListener(this);
        this.POP_ADD_S_2.addActionListener(this);
        this.POP_VIEW_CACH.addActionListener(this);
        this.POP_MOD_PRI.addActionListener(this);
        this.POP_MOD_R_PRI.addActionListener(this);
        this.POP_MOD_SEC.addActionListener(this);
        this.POP_ADD_H.addActionListener(this);
        this.POP_ADD_A.addActionListener(this);
        this.POP_ADD_R.addActionListener(this);
    }

    protected void handlePopupMenu(MenuItem menuItem) {
        if (menuItem == this.POP_EDIT) {
            this.myParent.NameServerSelected(LastSelected);
            return;
        }
        if (menuItem == this.POP_MOD_PRI || menuItem == this.POP_MOD_R_PRI) {
            this.myParent.PrimaryDomainSelected(LastSelected);
            return;
        }
        if (menuItem == this.POP_MOD_SEC) {
            this.myParent.SecondaryDomainSelected(LastSelected);
            return;
        }
        if (menuItem == this.POP_ADD_P_1 || menuItem == this.POP_ADD_P_2) {
            this.myParent.DoPrimaryDomain();
            return;
        }
        if (menuItem == this.POP_ADD_S_1 || menuItem == this.POP_ADD_S_2) {
            this.myParent.DoSecondaryDomain();
            return;
        }
        if (menuItem == this.POP_ADD_H) {
            this.myParent.AddHost();
            return;
        }
        if (menuItem == this.POP_ADD_A) {
            this.myParent.AddAliasHost();
            return;
        }
        if (menuItem == this.POP_ADD_R) {
            this.myParent.AddReverseHost(LastSelected);
            return;
        }
        if (menuItem == this.POP_DELETE_PRI || menuItem == this.POP_DELETE_R_PRI || menuItem == this.POP_DELETE_SEC) {
            this.yesNoBox = new msgBox(this.resources, this.resources.getString("APP_TITLE"), this.resources.getString("SDELETEMSG"), 2, true, this);
            return;
        }
        if (menuItem == this.POP_VIEW_REC_PRI || menuItem == this.POP_VIEW_REC_R_PRI) {
            HostRecordsFrame hostRecordsFrame = new HostRecordsFrame(this.resources);
            hostRecordsFrame.showPrimarySOAData(LastSelected, this.myParent, this.getRootName());
            return;
        }
        if (menuItem == this.POP_VIEW_REC_SEC) {
            HostRecordsFrame hostRecordsFrame = new HostRecordsFrame(this.resources);
            hostRecordsFrame.showSecondarySOAData(LastSelected, this.myParent, this.getRootName());
            return;
        }
        if (menuItem == this.POP_VIEW_BOOT) {
            TreeNode treeNode = (TreeNode)this.RootTreeNode;
            HostRecordsFrame hostRecordsFrame = new HostRecordsFrame(this.resources);
            hostRecordsFrame.showBootFileData(treeNode.sText, this.myParent);
            return;
        }
        if (menuItem == this.POP_VIEW_CACH) {
            TreeNode treeNode = (TreeNode)this.RootTreeNode;
            HostRecordsFrame hostRecordsFrame = new HostRecordsFrame(this.resources);
            hostRecordsFrame.showCacheFileData(treeNode.sText, this.myParent);
        }
    }

    private void addImages() {
        URL uRL = null;
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        MediaTracker mediaTracker = new MediaTracker(this);
        if (this.myApplet == null) {
            String string = this.getDirectory();
            this.image1 = toolkit.getImage(String.valueOf(string) + MainFrame.theFileSeparator + ".." + MainFrame.theFileSeparator + "java" + MainFrame.theFileSeparator + "ddnsserv.gif");
            this.image2 = toolkit.getImage(String.valueOf(string) + MainFrame.theFileSeparator + ".." + MainFrame.theFileSeparator + "java" + MainFrame.theFileSeparator + "domprimd.gif");
            this.image3 = toolkit.getImage(String.valueOf(string) + MainFrame.theFileSeparator + ".." + MainFrame.theFileSeparator + "java" + MainFrame.theFileSeparator + "domprims.gif");
            this.image4 = toolkit.getImage(String.valueOf(string) + MainFrame.theFileSeparator + ".." + MainFrame.theFileSeparator + "java" + MainFrame.theFileSeparator + "domsec.gif");
            this.image8 = toolkit.getImage(String.valueOf(string) + MainFrame.theFileSeparator + ".." + MainFrame.theFileSeparator + "java" + MainFrame.theFileSeparator + "plus.gif");
            this.image9 = toolkit.getImage(String.valueOf(string) + MainFrame.theFileSeparator + ".." + MainFrame.theFileSeparator + "java" + MainFrame.theFileSeparator + "minus.gif");
            this.image10 = toolkit.getImage(String.valueOf(string) + MainFrame.theFileSeparator + ".." + MainFrame.theFileSeparator + "java" + MainFrame.theFileSeparator + "open.gif");
            this.image11 = toolkit.getImage(String.valueOf(string) + MainFrame.theFileSeparator + ".." + MainFrame.theFileSeparator + "java" + MainFrame.theFileSeparator + "closed.gif");
        } else {
            URL uRL2;
            try {
                uRL2 = this.myApplet.getCodeBase();
                uRL = new URL(String.valueOf(uRL2.toString()) + ".." + MainFrame.theFileSeparator + "ddnsserv.gif");
            }
            catch (MalformedURLException malformedURLException) {
                this.myParent.tracer.traceTime("Bad URL: " + uRL);
            }
            this.image1 = toolkit.getImage(uRL);
            try {
                uRL2 = this.myApplet.getCodeBase();
                uRL = new URL(String.valueOf(uRL2.toString()) + ".." + MainFrame.theFileSeparator + "domprimd.gif");
            }
            catch (MalformedURLException malformedURLException) {
                this.myParent.tracer.traceTime("Bad URL: " + uRL);
            }
            this.image2 = toolkit.getImage(uRL);
            try {
                uRL2 = this.myApplet.getCodeBase();
                uRL = new URL(String.valueOf(uRL2.toString()) + ".." + MainFrame.theFileSeparator + "domprims.gif");
            }
            catch (MalformedURLException malformedURLException) {
                this.myParent.tracer.traceTime("Bad URL: " + uRL);
            }
            this.image3 = toolkit.getImage(uRL);
            try {
                uRL2 = this.myApplet.getCodeBase();
                uRL = new URL(String.valueOf(uRL2.toString()) + ".." + MainFrame.theFileSeparator + "domsec.gif");
            }
            catch (MalformedURLException malformedURLException) {
                this.myParent.tracer.traceTime("Bad URL: " + uRL);
            }
            this.image4 = toolkit.getImage(uRL);
            try {
                uRL2 = this.myApplet.getCodeBase();
                uRL = new URL(String.valueOf(uRL2.toString()) + ".." + MainFrame.theFileSeparator + "plus.gif");
            }
            catch (MalformedURLException malformedURLException) {
                this.myParent.tracer.traceTime("Bad URL: " + uRL);
            }
            this.image8 = toolkit.getImage(uRL);
            try {
                uRL2 = this.myApplet.getCodeBase();
                uRL = new URL(String.valueOf(uRL2.toString()) + ".." + MainFrame.theFileSeparator + "minus.gif");
            }
            catch (MalformedURLException malformedURLException) {
                this.myParent.tracer.traceTime("Bad URL: " + uRL);
            }
            this.image9 = toolkit.getImage(uRL);
            try {
                uRL2 = this.myApplet.getCodeBase();
                uRL = new URL(String.valueOf(uRL2.toString()) + ".." + MainFrame.theFileSeparator + "open.gif");
            }
            catch (MalformedURLException malformedURLException) {
                this.myParent.tracer.traceTime("Bad URL: " + uRL);
            }
            this.image10 = toolkit.getImage(uRL);
            try {
                uRL2 = this.myApplet.getCodeBase();
                uRL = new URL(String.valueOf(uRL2.toString()) + ".." + MainFrame.theFileSeparator + "closed.gif");
            }
            catch (MalformedURLException malformedURLException) {
                this.myParent.tracer.traceTime("Bad URL: " + uRL);
            }
            this.image11 = toolkit.getImage(uRL);
        }
        mediaTracker.addImage(this.image1, 1);
        mediaTracker.addImage(this.image2, 1);
        mediaTracker.addImage(this.image3, 1);
        mediaTracker.addImage(this.image4, 1);
        mediaTracker.addImage(this.image8, 1);
        mediaTracker.addImage(this.image9, 1);
        mediaTracker.addImage(this.image10, 1);
        mediaTracker.addImage(this.image11, 1);
        try {
            mediaTracker.waitForID(1);
            return;
        }
        catch (InterruptedException interruptedException) {
            this.myParent.tracer.traceTime("Error: images not loaded ");
            return;
        }
    }

    private void CreateSchemes() {
        this.gfcImage = new ImagesForCanvas(this.image3, this.image3);
        ImagesForCanvas imagesForCanvas = new ImagesForCanvas(this.image11, this.image10);
        this.tvnStatPriDom = new DDNSTreeViewScheme(STATPRIMARYDOM);
        this.tvnStatPriDom.registerPosition(0);
        this.tvnStatPriDom.setFolders(imagesForCanvas);
        this.tvnStatPriDom.setColors(0, this.cfcColor);
        this.tvnStatPriDom.setFonts(0, this.ffcFont);
        this.tvnStatPriDom.setImages(0, this.gfcImage);
        this.tvnStatPriDom.setPopupMenu(0, this.pDomOptions);
        this.gfcImage = new ImagesForCanvas(this.image3, this.image3);
        imagesForCanvas = new ImagesForCanvas(this.image11, this.image10);
        this.tvnRStatPriDom = new DDNSTreeViewScheme(revSTATPRIMARYDOM);
        this.tvnRStatPriDom.registerPosition(0);
        this.tvnRStatPriDom.setFolders(imagesForCanvas);
        this.tvnRStatPriDom.setColors(0, this.cfcColor);
        this.tvnRStatPriDom.setFonts(0, this.ffcFont);
        this.tvnRStatPriDom.setImages(0, this.gfcImage);
        this.tvnRStatPriDom.setPopupMenu(0, this.rpDomOptions);
        this.gfcImage = new ImagesForCanvas(this.image4, this.image4);
        imagesForCanvas = new ImagesForCanvas(this.image11, this.image10);
        this.tvnSecDom = new DDNSTreeViewScheme(SECONDARYDOM);
        this.tvnSecDom.registerPosition(0);
        this.tvnSecDom.setFolders(imagesForCanvas);
        this.tvnSecDom.setColors(0, this.cfcColor);
        this.tvnSecDom.setFonts(0, this.ffcFont);
        this.tvnSecDom.setImages(0, this.gfcImage);
        this.tvnSecDom.setPopupMenu(0, this.sDomOptions);
        this.gfcImage = new ImagesForCanvas(this.image2, this.image2);
        imagesForCanvas = new ImagesForCanvas(this.image11, this.image10);
        this.tvnDynPriDom = new DDNSTreeViewScheme(DYNPRIMARYDOM);
        this.tvnDynPriDom.registerPosition(0);
        this.tvnDynPriDom.setFolders(imagesForCanvas);
        this.tvnDynPriDom.setColors(0, this.cfcColor);
        this.tvnDynPriDom.setFonts(0, this.ffcFont);
        this.tvnDynPriDom.setImages(0, this.gfcImage);
        this.tvnDynPriDom.setPopupMenu(0, this.pDomOptions);
        this.gfcImage = new ImagesForCanvas(this.image2, this.image2);
        imagesForCanvas = new ImagesForCanvas(this.image11, this.image10);
        this.tvnRDynPriDom = new DDNSTreeViewScheme(revDYNPRIMARYDOM);
        this.tvnRDynPriDom.registerPosition(0);
        this.tvnRDynPriDom.setFolders(imagesForCanvas);
        this.tvnRDynPriDom.setColors(0, this.cfcColor);
        this.tvnRDynPriDom.setFonts(0, this.ffcFont);
        this.tvnRDynPriDom.setImages(0, this.gfcImage);
        this.tvnRDynPriDom.setPopupMenu(0, this.rpDomOptions);
        this.gfcImage = new ImagesForCanvas(this.image11, this.image10);
        imagesForCanvas = new ImagesForCanvas(this.image11, this.image10);
        this.tvnPDomLabel = new DDNSTreeViewScheme(PDOMLABEL);
        this.tvnPDomLabel.registerPosition(0);
        this.tvnPDomLabel.setFolders(imagesForCanvas);
        this.tvnPDomLabel.setColors(0, this.cfcColor);
        this.tvnPDomLabel.setFonts(0, this.ffcFont);
        this.tvnPDomLabel.setImages(0, this.gfcImage);
        this.tvnPDomLabel.setPopupMenu(0, this.pDomFolderOptions);
        this.gfcImage = new ImagesForCanvas(this.image11, this.image10);
        imagesForCanvas = new ImagesForCanvas(this.image11, this.image10);
        this.tvnSDomLabel = new DDNSTreeViewScheme(SDOMLABEL);
        this.tvnSDomLabel.registerPosition(0);
        this.tvnSDomLabel.setFolders(imagesForCanvas);
        this.tvnSDomLabel.setColors(0, this.cfcColor);
        this.tvnSDomLabel.setFonts(0, this.ffcFont);
        this.tvnSDomLabel.setImages(0, this.gfcImage);
        this.tvnSDomLabel.setPopupMenu(0, this.sDomFolderOptions);
        this.tvnNameServ.setPopupMenu(0, this.NSOptions);
    }

    public void deleteSelectedObject() {
        if (!(LastSelected.equals(this.getRootName()) || LastSelected.equals(this.resources.getString("SECONDARY_LABEL")) || LastSelected.equals(this.resources.getString("PRIMARY_LABEL")))) {
            this.yesNoBox = new msgBox(this.resources, this.resources.getString("APP_TITLE"), this.resources.getString("SDELETEMSG"), 2, true, this);
        }
    }

    private void deleteDomain() {
        DDNSNetworkStringParser dDNSNetworkStringParser;
        TreeNode treeNode;
        boolean bl = false;
        TreeNode treeNode2 = (TreeNode)this.RootTreeNode;
        Tree tree = treeNode2.FindImmediateChild(this.resources.getString("SECONDARY_LABEL"));
        if (tree != null && (treeNode = tree.getNode(LastSelected)) != null) {
            this.myParent.dataOut.sendToServer("SDOM=DEL,name=" + LastSelected + "," + "ESDOM" + ",");
            dDNSNetworkStringParser = this.myParent.dataOut.receiveFromServer();
            tree.removeNode(LastSelected);
            bl = true;
        }
        if (!bl && (tree = treeNode2.FindImmediateChild(this.resources.getString("PRIMARY_LABEL"))) != null && (treeNode = tree.getNode(LastSelected)) != null) {
            this.myParent.dataOut.sendToServer("PDOM=DEL,name=" + LastSelected + "," + "EPDOM" + ",");
            dDNSNetworkStringParser = this.myParent.dataOut.receiveFromServer();
            tree.removeNode(LastSelected);
            bl = true;
        }
        if (bl) {
            this.tv.committ(true);
            this.myParent.changed(this, LastSelected);
        }
    }

    public boolean preNodeSelected(TreeView treeView, addableToTreeView addableToTreeView2) {
        return true;
    }

    public boolean preNodeExpanded(TreeView treeView, addableToTreeView addableToTreeView2) {
        return true;
    }

    public boolean preNodeCollapsed(TreeView treeView, addableToTreeView addableToTreeView2) {
        return true;
    }

    public void postNodeSelected(TreeView treeView, addableToTreeView addableToTreeView2) {
        TreeNode treeNode = (TreeNode)addableToTreeView2;
        TreeNode treeNode2 = treeNode.getParentTreeNode();
        if (treeNode2 != null && (treeNode2.sText.equals(this.resources.getString("PRIMARY_LABEL")) || treeNode2.sText.equals(this.resources.getString("SECONDARY_LABEL")))) {
            this.myParent.NewDomainSelected(treeNode.sText);
        }
        LastSelected = treeNode.sText;
        this.myParent.mainTreeItemSelected(LastSelected);
    }

    public void postNodeExpanded(TreeView treeView, addableToTreeView addableToTreeView2) {
    }

    public void postNodeCollapsed(TreeView treeView, addableToTreeView addableToTreeView2) {
    }

    public void nodeDoubleClicked(TreeView treeView, addableToTreeView addableToTreeView2) {
        TreeNode treeNode = (TreeNode)addableToTreeView2;
        TreeNode treeNode2 = treeNode.getParentTreeNode();
        if (treeNode2 == null) {
            this.myParent.NameServerSelected(treeNode.sText);
        } else if (treeNode2.sText.equals(this.resources.getString("PRIMARY_LABEL"))) {
            this.myParent.PrimaryDomainSelected(treeNode.sText);
        } else if (treeNode2.sText.equals(this.resources.getString("SECONDARY_LABEL"))) {
            this.myParent.SecondaryDomainSelected(treeNode.sText);
        } else if (treeNode.sText.equals(this.resources.getString("PRIMARY_LABEL"))) {
            this.myParent.DoPrimaryDomain();
        } else if (treeNode.sText.equals(this.resources.getString("SECONDARY_LABEL"))) {
            this.myParent.DoSecondaryDomain();
        }
        LastSelected = treeNode.sText;
    }

    private String getDirectory() {
        try {
            String string = System.getProperty("java.class.path");
            string = string.toLowerCase();
            String string2 = System.getProperty("path.separator");
            StringTokenizer stringTokenizer = new StringTokenizer(string, string2, false);
            while (stringTokenizer.hasMoreElements()) {
                String string3 = (String)stringTokenizer.nextElement();
                if (!string3.endsWith("ddnssgui.jar")) continue;
                int n = string3.lastIndexOf("ddnssgui.jar");
                try {
                    return string3.substring(0, n - 1);
                }
                catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                    return ".";
                }
            }
        }
        catch (SecurityException securityException) {
            return ".";
        }
        return ".";
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object instanceof MenuItem) {
            this.handlePopupMenu((MenuItem)object);
        }
    }
}

