/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.ddnssgui.client;

import COM.ibm.raleigh.ddnssgui.common.DDNSStringTranslator;
import COM.ibm.raleigh.ddnssgui.common.WrappedTextPanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Panel;
import java.awt.TextArea;
import java.util.StringTokenizer;
import java.util.Vector;

class RecordsPanel
extends Panel {
    public static final String cStmt1 = "Licensed Materials - Property of IBM \n IBM TCP/IP for OS/2 \n (c) Copyright IBM Corp 1997. All rights reserved.\n";
    public static final String cStmt2 = "US Government Users Restricted Rights - Use, Duplication or\n disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String appVersion = "Dynamic IP Version 1.0";
    public static final String modVersion = "This Class Version 1.0";
    private String[] txtData;
    private TextArea txtArea;
    private WrappedTextPanel explainPanel;
    private String SingletxtData;
    private GridBagLayout gridBag;
    private GridBagConstraints constraints;
    private GridBagLayout gridBagPanel;
    private GridBagConstraints constraintsPanel;

    public RecordsPanel(String string) {
        this.initComponents(string);
        this.addComponentsToGrid();
    }

    public RecordsPanel() {
        this("");
    }

    public RecordsPanel(String[] stringArray, String string) {
        this.txtData = stringArray;
        this.initComponents(string);
        this.addComponentsToGrid();
    }

    public RecordsPanel(String string, String string2) {
        this.SingletxtData = string;
        this.initComponents(string2);
        this.addComponentsToGrid();
    }

    public void addRecords(String[] stringArray) {
        String string = null;
        DDNSStringTranslator dDNSStringTranslator = null;
        int n = 0;
        while (n < stringArray.length) {
            dDNSStringTranslator = new DDNSStringTranslator(stringArray[n]);
            string = dDNSStringTranslator.fromEscapedString();
            if (!string.equals("\n")) {
                if (string.endsWith("\n")) {
                    this.txtArea.append(string);
                } else {
                    this.txtArea.append(String.valueOf(string) + "\n");
                }
            }
            ++n;
        }
    }

    public void addRecords(String string) {
        if (string.endsWith("\n")) {
            this.txtArea.append(string);
            return;
        }
        this.txtArea.append(String.valueOf(string) + "\n");
    }

    public void setRecords(String[] stringArray) {
        this.txtArea.setText("");
        if (stringArray != null) {
            this.addRecords(stringArray);
        }
    }

    public String[] getRecords() {
        Vector<String> vector = new Vector<String>();
        String string = this.txtArea.getText();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n", false);
        if (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            string2 = string2.trim();
            while (string2 != null && !string2.equals("") && !string2.equals("\n")) {
                string2 = new DDNSStringTranslator(string2).toEscapedString();
                vector.addElement(string2);
                if (stringTokenizer.hasMoreTokens()) {
                    string2 = stringTokenizer.nextToken();
                    string2 = string2.trim();
                    continue;
                }
                string2 = null;
            }
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public boolean isEmpty() {
        boolean bl = false;
        String string = this.txtArea.getText().trim();
        if (string.compareTo("") == 0 || string.length() <= 0) {
            bl = true;
        }
        return bl;
    }

    public void setEnabled(boolean bl) {
        if (bl) {
            this.explainPanel.setEnabled(true);
            this.txtArea.setEnabled(true);
            this.txtArea.setEditable(true);
            return;
        }
        this.explainPanel.setEnabled(false);
        this.txtArea.setEditable(false);
    }

    private void initComponents(String string) {
        this.explainPanel = new WrappedTextPanel(string);
        this.txtArea = new TextArea();
        if (this.txtData != null) {
            this.addRecords(this.txtData);
        }
        if (this.SingletxtData != null) {
            this.txtArea.setText(this.SingletxtData);
        }
        this.gridBag = new GridBagLayout();
        this.constraints = new GridBagConstraints();
        this.gridBagPanel = new GridBagLayout();
        this.constraintsPanel = new GridBagConstraints();
        this.setEnabled(true);
    }

    private void addComponentsToGrid() {
        int n = this.explainPanel.getNumDividedTextLines();
        this.setLayout(this.gridBag);
        this.constraints.fill = 2;
        this.constraints.anchor = 17;
        this.constraints.weightx = 1.0;
        this.constraints.weighty = 1.0;
        this.add(this.explainPanel, this.gridBag, this.constraints, 0, 0, 0, n);
        this.add(this.txtArea, this.gridBag, this.constraints, 0, 1 + n, 0, 0);
    }

    private void add(Component component, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagLayout.setConstraints(component, gridBagConstraints);
        this.add(component);
    }

    private void constrain(Component component, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagLayout.setConstraints(component, gridBagConstraints);
    }
}

