/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.ddnssgui.client;

import COM.ibm.raleigh.ddnssgui.common.DDNSUtility;
import COM.ibm.raleigh.ddnssgui.common.IPListPanel;
import COM.ibm.raleigh.ddnssgui.common.ListPanelUser;
import COM.ibm.raleigh.ddnssgui.common.TcpipValidation;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.ItemSelectable;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ResourceBundle;

class NotifyServersPanel
extends Panel
implements ListPanelUser,
ItemListener,
KeyListener {
    public static final String cStmt1 = "Licensed Materials - Property of IBM \n IBM TCP/IP for OS/2 \n (c) Copyright IBM Corp 1997. All rights reserved.\n";
    public static final String cStmt2 = "US Government Users Restricted Rights - Use, Duplication or\n disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String appVersion = "Dynamic IP Version 1.0";
    public static final String modVersion = "This Class Version 1.0";
    public static final int FIRST_FIELD = 0;
    public static final int NOTIFY_FIELD = 0;
    public static final int IP_ADDR_FIELD = 1;
    public static final int RETRY_TIME_FIELD = 2;
    public static final int NUM_RETRIES_FIELD = 3;
    public static final int DELAY_TIME_FIELD = 4;
    public static final int LAST_FIELD = 4;
    private static final int NUM_LIST_ROWS = 4;
    private static final int NUM_TEXT_COLUMNS = 10;
    private ResourceBundle resources;
    private IPListPanel serverPanel;
    private Label retryTimeLabel;
    private TextField retryTime;
    private Label retryTimeRangeLabel;
    private Label numRetriesLabel;
    private TextField numRetries;
    private Label delayTimeLabel;
    private TextField delayTime;
    private Label delayTimeRangeLabel;
    protected Checkbox notifyServer;
    protected GridBagLayout gridBag;
    protected GridBagConstraints constraints;
    protected int lastGridPositionY;

    public NotifyServersPanel(ResourceBundle resourceBundle) {
        this.resources = resourceBundle;
        this.setBackground(DDNSUtility.BACKGROUND_COLOR);
        this.initComponents();
        this.addComponentsToGrid();
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        ItemSelectable itemSelectable = itemEvent.getItemSelectable();
        if (itemSelectable instanceof Checkbox) {
            this.handleCheckbox((Checkbox)itemSelectable);
        }
    }

    public void requestFocus(int n) {
        switch (n) {
            case 0: {
                this.notifyServer.requestFocus();
                return;
            }
            case 1: {
                this.serverPanel.requestFocus(0);
                return;
            }
            case 2: {
                this.retryTime.requestFocus();
                return;
            }
            case 3: {
                this.numRetries.requestFocus();
                return;
            }
            case 4: {
                this.delayTime.requestFocus();
                return;
            }
        }
    }

    public void selectAll(int n) {
        switch (n) {
            case 1: {
                this.serverPanel.selectAll(0);
                return;
            }
            case 2: {
                if (!this.retryTime.isEnabled()) break;
                this.retryTime.selectAll();
                return;
            }
            case 3: {
                if (!this.numRetries.isEnabled()) break;
                this.numRetries.selectAll();
                return;
            }
            case 4: {
                if (!this.delayTime.isEnabled()) break;
                this.delayTime.selectAll();
                return;
            }
        }
    }

    public boolean getNotifyState() {
        return this.notifyServer.getState();
    }

    public void setNotifyState(boolean bl) {
        this.notifyServer.setState(bl);
        boolean bl2 = this.getNotifyState();
        this.setEnabled(bl2);
    }

    public void setEnabled(boolean bl) {
        this.serverPanel.setEnabled(bl);
        this.retryTimeLabel.setEnabled(bl);
        this.retryTime.setEnabled(bl);
        this.retryTimeRangeLabel.setEnabled(bl);
        this.numRetriesLabel.setEnabled(bl);
        this.numRetries.setEnabled(bl);
        this.delayTimeLabel.setEnabled(bl);
        this.delayTime.setEnabled(bl);
        this.delayTimeRangeLabel.setEnabled(bl);
        if (!bl) {
            ((Component)this.retryTime).setBackground(DDNSUtility.TEXT_FIELD_DISABLE_COLOR);
            ((Component)this.numRetries).setBackground(DDNSUtility.TEXT_FIELD_DISABLE_COLOR);
            ((Component)this.delayTime).setBackground(DDNSUtility.TEXT_FIELD_DISABLE_COLOR);
            return;
        }
        ((Component)this.retryTime).setBackground(DDNSUtility.TEXT_FIELD_ENABLE_COLOR);
        ((Component)this.numRetries).setBackground(DDNSUtility.TEXT_FIELD_ENABLE_COLOR);
        ((Component)this.delayTime).setBackground(DDNSUtility.TEXT_FIELD_ENABLE_COLOR);
    }

    public String getNotifyServer() {
        return this.serverPanel.getIPAddr();
    }

    public void setNotifyServer(String string) {
        if (string != null) {
            this.serverPanel.setIPAddr(string);
        }
    }

    public String[] getNotifyServerList() {
        return this.serverPanel.getIPAddrList();
    }

    public void setNotifyServerList(String[] stringArray) {
        this.serverPanel.removeAll();
        if (stringArray != null) {
            this.serverPanel.setIPAddrList(stringArray);
        }
    }

    public void addNotifyServer(String string) {
        if (string != null && string.length() > 0) {
            boolean bl = false;
            int n = this.serverPanel.getItemCount();
            if (n > 0) {
                String[] stringArray = this.getNotifyServerList();
                int n2 = 0;
                while (n2 < n && !bl) {
                    if (string.compareTo(stringArray[n2]) == 0) {
                        bl = true;
                    }
                    ++n2;
                }
            }
            if (!bl) {
                this.serverPanel.addItem(string);
            }
        }
    }

    public void removeNotifyServer(String string) {
        int n;
        if (string != null && string.length() > 0 && (n = this.serverPanel.getItemCount()) > 0) {
            String[] stringArray = this.getNotifyServerList();
            int n2 = 0;
            while (n2 < n) {
                if (string.compareTo(stringArray[n2]) == 0) {
                    this.serverPanel.remove(n2);
                }
                ++n2;
            }
        }
    }

    public int getRetryTime() {
        return this.getNumber(this.retryTime.getText().trim());
    }

    public void setRetryTime(int n) {
        ((TextComponent)this.retryTime).setText(Integer.toString(n));
    }

    public int getNumRetries() {
        return this.getNumber(this.numRetries.getText().trim());
    }

    public void setNumRetries(int n) {
        ((TextComponent)this.numRetries).setText(Integer.toString(n));
    }

    public int getDelayTime() {
        return this.getNumber(this.delayTime.getText().trim());
    }

    public void setDelayTime(int n) {
        ((TextComponent)this.delayTime).setText(Integer.toString(n));
    }

    public boolean validateRetryTime() {
        return TcpipValidation.validateInteger(this.getRetryTime());
    }

    public boolean validateNumRetries() {
        return TcpipValidation.validateInteger(this.getNumRetries());
    }

    public boolean validateDelayTime() {
        return TcpipValidation.validateInteger(this.getDelayTime());
    }

    protected void add(Component component, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagLayout.setConstraints(component, gridBagConstraints);
        this.add(component);
    }

    private void initComponents() {
        this.notifyServer = new Checkbox(this.resources.getString("NOTIFY_SERVER_CHECKBOX_LABEL"));
        this.notifyServer.addItemListener(this);
        this.notifyServer.addKeyListener(this);
        this.serverPanel = new IPListPanel(this, this.resources, this.resources.getString("NOTIFY_SERVERS_TITLE"), 4);
        this.retryTimeLabel = new Label(this.resources.getString("RETRY_TIME_LABEL"), 0);
        this.retryTime = new TextField("", 10);
        this.retryTimeRangeLabel = new Label(this.resources.getString("SECONDS_LABEL"), 0);
        this.numRetriesLabel = new Label(this.resources.getString("NUM_RETRIES_LABEL"), 0);
        this.numRetries = new TextField("", 10);
        this.delayTimeLabel = new Label(this.resources.getString("DELAY_TIME_LABEL"), 0);
        this.delayTime = new TextField("", 10);
        this.delayTimeRangeLabel = new Label(this.resources.getString("SECONDS_LABEL"), 0);
        this.gridBag = new GridBagLayout();
        this.constraints = new GridBagConstraints();
    }

    private void addComponentsToGrid() {
        this.setLayout(this.gridBag);
        this.constraints.fill = 2;
        this.constraints.anchor = 17;
        this.constraints.weightx = 1.0;
        this.constraints.weighty = 1.0;
        this.constraints.fill = 0;
        this.add(this.notifyServer, this.gridBag, this.constraints, 0, 0, 0, 1);
        this.constraints.fill = 1;
        this.add(this.serverPanel, this.gridBag, this.constraints, 0, 1, 0, 2);
        this.constraints.fill = 0;
        this.add(this.retryTimeLabel, this.gridBag, this.constraints, 0, 3, 1, 1);
        this.add(this.retryTime, this.gridBag, this.constraints, 1, 3, 1, 1);
        this.add(this.retryTimeRangeLabel, this.gridBag, this.constraints, 2, 3, 0, 1);
        this.add(this.numRetriesLabel, this.gridBag, this.constraints, 0, 4, 1, 1);
        this.add(this.numRetries, this.gridBag, this.constraints, 1, 4, 0, 1);
        this.add(this.delayTimeLabel, this.gridBag, this.constraints, 0, 5, 1, 1);
        this.add(this.delayTime, this.gridBag, this.constraints, 1, 5, 1, 1);
        this.add(this.delayTimeRangeLabel, this.gridBag, this.constraints, 2, 5, 0, 1);
        this.lastGridPositionY = 6;
    }

    private void handleCheckbox(Checkbox checkbox) {
        boolean bl = checkbox.getState();
        if (checkbox == this.notifyServer) {
            if (bl) {
                this.setNotifyState(true);
                return;
            }
            this.setNotifyState(false);
        }
    }

    protected int getNumber(String string) {
        if (TcpipValidation.IsLessThanMaxIntegerValue(string)) {
            try {
                Integer n = new Integer(string);
                return n;
            }
            catch (NumberFormatException numberFormatException) {
                return Integer.MIN_VALUE;
            }
        }
        return Integer.MIN_VALUE;
    }

    public void handleButton(Button button) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        Object object = keyEvent.getSource();
        if (keyEvent.getKeyCode() == 10 && object instanceof Checkbox) {
            Checkbox checkbox;
            checkbox.setState(!(checkbox = (Checkbox)object).getState());
            this.handleCheckbox(checkbox);
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }
}

