/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.ddnssgui.client;

import COM.ibm.raleigh.ddnssgui.client.MainFrame;
import COM.ibm.raleigh.ddnssgui.client.NameServerFrame;
import COM.ibm.raleigh.ddnssgui.client.PromptForImport;
import COM.ibm.raleigh.ddnssgui.common.DDNSNetworkStringParser;
import COM.ibm.raleigh.ddnssgui.common.NameAndIpAddressList;
import COM.ibm.raleigh.ddnssgui.common.NameServerObject;
import COM.ibm.raleigh.ddnssgui.common.Question;
import COM.ibm.raleigh.ddnssgui.common.RequestList;
import COM.ibm.raleigh.ddnssgui.common.TcpipValidation;
import COM.ibm.raleigh.ddnssgui.common.msgBox;
import java.applet.Applet;
import java.awt.Component;
import java.awt.Dimension;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.StringTokenizer;

public class NameServerMgr {
    private static final String cStmt1 = "(c) Copyright IBM Corp 1997. All rights reserved.\n";
    private static final String URL_DELIMITER = "/";
    public static final String directoryName = "namedb";
    NameServerObject NameServ;
    boolean NewNameServer;
    NameServerFrame nameServPanel;
    public MainFrame MyParent;
    Applet myApplet;
    String OriginalhashedName;
    msgBox okBox;
    String ETCpathValue;
    PromptForImport pfi;
    String ETCplusNamedb;
    String passedNameServerName;

    public NameServerMgr(MainFrame mainFrame, Applet applet) {
        this.MyParent = mainFrame;
        this.myApplet = applet;
        this.nameServPanel = new NameServerFrame(this);
        this.NameServ = new NameServerObject("");
    }

    public NameServerMgr(MainFrame mainFrame, String string) {
        this.MyParent = mainFrame;
        this.myApplet = null;
        this.nameServPanel = new NameServerFrame(this);
        this.NameServ = new NameServerObject("");
        this.passedNameServerName = string;
    }

    public void exit() {
        this.nameServPanel.dispose();
    }

    public boolean isShowing() {
        return this.nameServPanel.isShowing();
    }

    public void setVisible(boolean bl) {
        ((Component)this.nameServPanel).setVisible(bl);
    }

    public void requestFocus() {
        if (this.nameServPanel.isShowing()) {
            this.nameServPanel.requestFocus();
        }
        this.nameServPanel.selectAll(0);
        this.nameServPanel.requestFocus(0);
    }

    public void CreateNameServer() {
        if (this.ETCpathValue == null) {
            this.ETCpathValue = this.getETCsetting();
            if (this.ETCpathValue != null) {
                this.ETCplusNamedb = this.ETCpathValue.endsWith(MainFrame.theFileSeparator) ? new String(String.valueOf(this.ETCpathValue) + directoryName) : new String(String.valueOf(this.ETCpathValue) + MainFrame.theFileSeparator + directoryName);
            }
        }
        this.NameServ = new NameServerObject(this.ETCpathValue);
        this.NewNameServer = true;
        this.InitNameServerFrame();
    }

    public void UpdateExistingNameServer(String string) {
        this.MyParent.dataOut.sendToServer("NSO=GET,name=" + string + "," + "ENSO" + ",");
        DDNSNetworkStringParser dDNSNetworkStringParser = this.MyParent.dataOut.receiveFromServer();
        this.NameServ = new NameServerObject(dDNSNetworkStringParser.getParsed());
        if (this.ETCpathValue == null) {
            this.ETCpathValue = this.getETCsetting();
            if (this.ETCpathValue != null) {
                this.ETCplusNamedb = this.ETCpathValue.endsWith(MainFrame.theFileSeparator) ? new String(String.valueOf(this.ETCpathValue) + directoryName) : new String(String.valueOf(this.ETCpathValue) + MainFrame.theFileSeparator + directoryName);
            }
        }
        this.NewNameServer = false;
        this.InitNameServerFrame();
        this.OriginalhashedName = new String(string);
    }

    private void InitNameServerFrame() {
        NameAndIpAddressList nameAndIpAddressList = null;
        if (this.NewNameServer) {
            if (this.myApplet != null) {
                nameAndIpAddressList = new NameAndIpAddressList();
                URL uRL = this.myApplet.getCodeBase();
                InetAddress[] inetAddressArray = null;
                try {
                    inetAddressArray = InetAddress.getAllByName(uRL.getHost());
                    String[] stringArray = new String[inetAddressArray.length];
                    String[] stringArray2 = new String[inetAddressArray.length];
                    StringTokenizer stringTokenizer = null;
                    int n = 0;
                    while (n < inetAddressArray.length) {
                        stringArray[n] = inetAddressArray[n].getHostName();
                        stringTokenizer = new StringTokenizer(inetAddressArray[n].toString(), URL_DELIMITER);
                        stringTokenizer.nextToken();
                        stringArray2[n] = stringTokenizer.nextToken();
                        if (TcpipValidation.IsValidFQTcpipName(stringArray[n])) {
                            nameAndIpAddressList.addAPair(stringArray[n], stringArray2[n]);
                        }
                        ++n;
                    }
                    this.nameServPanel.setServerList(nameAndIpAddressList);
                }
                catch (UnknownHostException unknownHostException) {
                    this.nameServPanel.setServerList(nameAndIpAddressList);
                }
            } else if (this.passedNameServerName == null) {
                nameAndIpAddressList = new NameAndIpAddressList();
                InetAddress[] inetAddressArray = null;
                try {
                    InetAddress inetAddress = InetAddress.getLocalHost();
                    String string = inetAddress.getHostAddress();
                    inetAddressArray = InetAddress.getAllByName(string);
                    int n = 0;
                    while (n < inetAddressArray.length) {
                        StringTokenizer stringTokenizer = new StringTokenizer(inetAddressArray[n].toString(), URL_DELIMITER);
                        String string2 = stringTokenizer.nextToken();
                        String string3 = stringTokenizer.nextToken();
                        if (TcpipValidation.IsValidFQTcpipName(string2)) {
                            nameAndIpAddressList.addAPair(string2, string3);
                        }
                        ++n;
                    }
                    this.nameServPanel.setServerList(nameAndIpAddressList);
                }
                catch (UnknownHostException unknownHostException) {
                    this.nameServPanel.setServerList(nameAndIpAddressList);
                }
            } else {
                nameAndIpAddressList = new NameAndIpAddressList();
                InetAddress[] inetAddressArray = null;
                try {
                    InetAddress inetAddress = InetAddress.getByName(this.passedNameServerName);
                    String string = inetAddress.getHostAddress();
                    inetAddressArray = InetAddress.getAllByName(string);
                    int n = 0;
                    while (n < inetAddressArray.length) {
                        StringTokenizer stringTokenizer = new StringTokenizer(inetAddressArray[n].toString(), URL_DELIMITER);
                        String string4 = stringTokenizer.nextToken();
                        String string5 = stringTokenizer.nextToken();
                        if (TcpipValidation.IsValidFQTcpipName(string4)) {
                            nameAndIpAddressList.addAPair(string4, string5);
                        }
                        ++n;
                    }
                    this.nameServPanel.setServerList(nameAndIpAddressList);
                }
                catch (UnknownHostException unknownHostException) {
                    this.nameServPanel.setServerList(nameAndIpAddressList);
                }
            }
        } else {
            this.nameServPanel.setServerList(this.NameServ.getFQNames());
        }
        this.nameServPanel.setRootServerList(this.NameServ.getRootServers());
        this.nameServPanel.setNumLogFiles(this.NameServ.getLogFileNum());
        this.nameServPanel.setLogFileSize(this.NameServ.getSizeOfLogFile());
        this.nameServPanel.setLogDebugMessagesState(this.NameServ.getDebugLevel());
        this.nameServPanel.setSlaveServerState(this.NameServ.getSlaveNameServer());
        this.nameServPanel.setForwardServerList(this.NameServ.getForwardIp());
        this.nameServPanel.setEtcPath(this.ETCplusNamedb);
        this.nameServPanel.setCacheFileName(this.NameServ.getCacheFileName());
        this.nameServPanel.setBootFileName(this.stripETCfromFileName(this.NameServ.getBootFileName()));
        this.nameServPanel.setLogFileName(this.NameServ.getNameOfLogFile());
        Dimension dimension = this.nameServPanel.getMinSize();
        ((Component)this.nameServPanel).setVisible(true);
        this.nameServPanel.setEnabled(true);
        this.nameServPanel.setEnabledButtons(true);
        this.nameServPanel.requestFocus();
        this.nameServPanel.selectFirstTab();
    }

    public void SaveAndExit() {
        this.nameServPanel.setEnabled(false);
        this.nameServPanel.setEnabledButtons(false);
        this.NameServ.setFQNames(this.nameServPanel.getServerList());
        this.NameServ.setRootNames(this.nameServPanel.getRootServerList());
        this.NameServ.setLogFileNum(this.nameServPanel.getNumLogFiles());
        this.NameServ.setSizeOfLogFile(this.nameServPanel.getLogFileSize());
        this.NameServ.setNameOfLogFile(this.nameServPanel.getLogFileName());
        this.NameServ.setDebugLevel(this.nameServPanel.getLogDebugMessagesState());
        this.NameServ.setSlaveNameServer(this.nameServPanel.getSlaveServerState());
        this.NameServ.setForwardIp(this.nameServPanel.getForwardServerList());
        this.NameServ.setBootFileName(this.appendETCtoFileName(this.nameServPanel.getBootFileName()));
        this.NameServ.setCacheFileName(this.nameServPanel.getCacheFileName());
        if (this.NewNameServer) {
            this.MyParent.dataOut.sendToServer(this.NameServ.toString("ADD"));
            this.MyParent.dataOut.receiveFromServer();
        } else if (!this.OriginalhashedName.equals(this.NameServ.firstName())) {
            this.MyParent.dataOut.sendToServer("NSO=DEL,name=" + this.OriginalhashedName + "," + "ENSO" + ",");
            this.MyParent.dataOut.receiveFromServer();
            this.MyParent.dataOut.sendToServer(this.NameServ.toString("ADD"));
            this.MyParent.dataOut.receiveFromServer();
        } else {
            this.MyParent.dataOut.sendToServer(this.NameServ.toString("MOD"));
            this.MyParent.dataOut.receiveFromServer();
        }
        ((Component)this.nameServPanel).setVisible(false);
        this.MyParent.changed(this, this.NameServ.firstName());
        this.MyParent.requestFocus();
    }

    public void CancelAndExit() {
        this.nameServPanel.setEnabled(false);
        this.nameServPanel.setEnabledButtons(false);
        NameAndIpAddressList nameAndIpAddressList = this.NameServ.getFQNames();
        if (nameAndIpAddressList == null) {
            this.okBox = new msgBox(this.MyParent.clientResources, this.MyParent.clientResources.getString("NSM_MSG_TITLE"), this.MyParent.clientResources.getString("NSM_MSG_STRING"), 1, true, this.MyParent.getFrame(), this.MyParent);
            this.MyParent.nothingConfigured();
        } else {
            this.MyParent.changed(this);
        }
        ((Component)this.nameServPanel).setVisible(false);
        this.MyParent.requestFocus();
    }

    public void requestImport() {
        this.nameServPanel.setEnabled(false);
        this.pfi = new PromptForImport(this, this.MyParent.clientResources.getString("NSM_CACHE_FILE_IMPORT_TEXT"));
        this.pfi.getMinSize();
        ((Component)this.pfi).setVisible(true);
        this.pfi.requestFocus();
    }

    public void doImport(String string) {
        RequestList requestList = new RequestList(15, string);
        String[] stringArray = requestList.getReturnedList(this.MyParent.clientResources, this.MyParent.dataOut);
        if (stringArray != null) {
            this.nameServPanel.setRootServerList(this.makeListFromArray(stringArray));
            this.pfi.dispose();
        } else {
            this.okBox = new msgBox(this.MyParent.clientResources, this.MyParent.clientResources.getString("NS_FRAME_NAME"), this.MyParent.clientResources.getString("NSM_NO_CACHE_DATA_FOUND_TEXT"), 1, true, this.MyParent.getFrame(), this.MyParent);
        }
        this.nameServPanel.setEnabled(true);
    }

    public void cancelImport() {
        this.nameServPanel.setEnabled(true);
        this.pfi.dispose();
    }

    private String getETCsetting() {
        Question question = new Question(10);
        return question.getStringFromString(this.MyParent.dataOut);
    }

    private String stripETCfromFileName(String string) {
        int n;
        String string2 = string.toLowerCase();
        String string3 = new String(string);
        if (string2.startsWith(this.ETCplusNamedb.toLowerCase()) && (n = this.ETCplusNamedb.length()) < string.length()) {
            string3 = string.substring(n);
        }
        if (string3.startsWith(MainFrame.theFileSeparator)) {
            return string3.substring(1);
        }
        return string3;
    }

    private String appendETCtoFileName(String string) {
        if (string.startsWith(MainFrame.theFileSeparator)) {
            return new String(String.valueOf(this.ETCplusNamedb) + string);
        }
        return new String(String.valueOf(this.ETCplusNamedb) + MainFrame.theFileSeparator + string);
    }

    private NameAndIpAddressList makeListFromArray(String[] stringArray) {
        if (stringArray == null) {
            return null;
        }
        NameAndIpAddressList nameAndIpAddressList = new NameAndIpAddressList();
        int n = 0;
        while (n < stringArray.length) {
            int n2 = stringArray[n].indexOf(";");
            String string = stringArray[n].substring(0, n2);
            String string2 = stringArray[n].substring(n2 + 1);
            nameAndIpAddressList.addAPair(string, string2);
            ++n;
        }
        return nameAndIpAddressList;
    }
}

