/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.ddnssgui.client;

import COM.ibm.raleigh.ddnssgui.client.DomainObjectMgr;
import COM.ibm.raleigh.ddnssgui.client.DynamicOptionsFrame;
import COM.ibm.raleigh.ddnssgui.client.MainFrame;
import COM.ibm.raleigh.ddnssgui.common.ButtonPanel;
import COM.ibm.raleigh.ddnssgui.common.DDNSUtility;
import COM.ibm.raleigh.ddnssgui.common.ListPanelUser;
import COM.ibm.raleigh.ddnssgui.common.Question;
import COM.ibm.raleigh.ddnssgui.common.RequestList;
import COM.ibm.raleigh.ddnssgui.common.UniqueListPanel;
import COM.ibm.raleigh.ddnssgui.common.WrappedTextPanel;
import java.awt.Button;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.Panel;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ResourceBundle;

class GenerateKeysFrame
extends Frame
implements WindowListener,
ActionListener,
ListPanelUser,
KeyListener {
    public static final String cStmt1 = "Licensed Materials - Property of IBM \n IBM TCP/IP for OS/2 \n (c) Copyright IBM Corp 1997. All rights reserved.\n";
    public static final String cStmt2 = "US Government Users Restricted Rights - Use, Duplication or\n disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String appVersion = "Dynamic Ip Version 1.0";
    public static final String modVersion = "This Class Version 1.0";
    public static final int FIRST_FIELD = 0;
    public static final int FILE_NAME_FIELD = 0;
    public static final int HOST_NAME_FIELD = 1;
    private UniqueListPanel theList;
    private GridBagLayout gridBag;
    private GridBagConstraints constraints;
    private GridBagLayout gridBagPanel;
    private GridBagConstraints constraintsPanel;
    private ButtonPanel buttonPanel;
    private String thisDomName;
    private static final int NUM_BUTTONS = 3;
    private static final int OK_BUTTON = 0;
    private static final int CANCEL_BUTTON = 1;
    private static final int HELP_BUTTON = 2;
    private Button[] buttons;
    private String[] buttonLabels;
    private String[] saveList;
    private String[] usedNames;
    private DomainObjectMgr myParent;
    private ResourceBundle resources;
    private WrappedTextPanel instructions;
    private WrappedTextPanel filePathLabel;
    private TextField filePath;
    private Panel theWholePanel;
    private String directoryName;
    private DynamicOptionsFrame myCaller;

    public GenerateKeysFrame(String string, DomainObjectMgr domainObjectMgr, DynamicOptionsFrame dynamicOptionsFrame) {
        this.myParent = domainObjectMgr;
        this.resources = this.myParent.MyParent.clientResources;
        this.setTitle(this.resources.getString("GKF_FRAME_NAME"));
        ((Component)this).setBackground(DDNSUtility.BACKGROUND_COLOR);
        this.thisDomName = new String(string);
        this.myCaller = dynamicOptionsFrame;
        this.initComponents();
        this.addComponentsToGrid();
    }

    public GenerateKeysFrame(String[] stringArray, String string, DomainObjectMgr domainObjectMgr, DynamicOptionsFrame dynamicOptionsFrame) {
        this(string, domainObjectMgr, dynamicOptionsFrame);
        this.theList.setNameList(stringArray);
    }

    public void reShow() {
        if (this.saveList != null) {
            this.theList.removeAll();
            this.theList.setNameList(this.saveList);
        }
        ((Component)this).setVisible(true);
    }

    public void requestFocus(int n) {
        switch (n) {
            case 0: {
                this.filePath.requestFocus();
                return;
            }
            case 1: {
                this.theList.requestFocus(0);
                return;
            }
        }
    }

    public void selectAll(int n) {
        switch (n) {
            case 0: {
                this.filePath.selectAll();
                return;
            }
            case 1: {
                this.theList.selectAll(0);
                return;
            }
        }
    }

    public String[] getListOfNames() {
        return this.theList.getNameList();
    }

    public void setListOfNames(String[] stringArray) {
        this.theList.setNameList(stringArray);
    }

    public String getDirectory() {
        return this.filePath.getText();
    }

    public void setDirectory(String string) {
        ((TextComponent)this.filePath).setText(string);
    }

    private void initComponents() {
        this.initButtonPanel();
        this.theList = new UniqueListPanel(this, this.resources, this.resources.getString("GKF_GENERATE_KEYS_LABEL"), 10);
        this.gridBag = new GridBagLayout();
        this.constraints = new GridBagConstraints();
        this.gridBagPanel = new GridBagLayout();
        this.constraintsPanel = new GridBagConstraints();
        RequestList requestList = new RequestList(6, this.thisDomName);
        this.theList.setStaticNameCheck(requestList.getReturnedList(this.resources, this.myParent.MyParent.dataOut));
        requestList = new RequestList(7, this.thisDomName);
        this.theList.setDynamicNameCheck(requestList.getReturnedList(this.resources, this.myParent.MyParent.dataOut));
        requestList = new RequestList(8, this.thisDomName);
        this.theList.setReservedNameCheck(requestList.getReturnedList(this.resources, this.myParent.MyParent.dataOut));
        this.instructions = new WrappedTextPanel(this.resources.getString("GKF_INSTRUCTIONS"));
        this.instructions.setFont(12);
        this.filePathLabel = new WrappedTextPanel(this.resources.getString("GKF_PATH_LABEL"));
        this.filePath = new TextField(30);
        this.theWholePanel = new Panel();
        Question question = new Question(10);
        StringBuffer stringBuffer = new StringBuffer(String.valueOf(question.getStringFromString(this.myParent.MyParent.dataOut)) + MainFrame.theFileSeparator + "namedb" + MainFrame.theFileSeparator);
        char[] cArray = this.thisDomName.toCharArray();
        int n = 0;
        int n2 = 0;
        while (n2 < 8 && n < cArray.length) {
            if (cArray[n] != '.') {
                stringBuffer.append(cArray[n]);
                ++n2;
            }
            ++n;
        }
        this.directoryName = stringBuffer.toString();
        if (this.directoryName != null) {
            ((TextComponent)this.filePath).setText(this.directoryName);
        }
        this.addWindowListener(this);
    }

    private void add(Component component, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagLayout.setConstraints(component, gridBagConstraints);
        this.add(component);
    }

    private void panelAdd(Component component, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagLayout.setConstraints(component, gridBagConstraints);
        this.theWholePanel.add(component);
    }

    private void constrain(Component component, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagLayout.setConstraints(component, gridBagConstraints);
    }

    private void addComponentsToGrid() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.theWholePanel.setLayout(gridBagLayout);
        this.constraints.fill = 1;
        this.constraints.anchor = 10;
        this.constraints.weightx = 1.0;
        this.constraints.weighty = 1.0;
        this.constraints.insets.top = 5;
        this.panelAdd(this.instructions, gridBagLayout, this.constraints, 0, 0, 0, 1);
        this.constraints.fill = 2;
        this.panelAdd(this.filePathLabel, gridBagLayout, this.constraints, 0, 1, 0, 1);
        this.panelAdd(this.filePath, gridBagLayout, this.constraints, 0, 2, 0, 1);
        this.constraints.fill = 1;
        this.panelAdd(this.theList, gridBagLayout, this.constraints, 0, 3, 0, 1);
        this.setLayout(this.gridBag);
        this.constraints.fill = 1;
        this.constraints.anchor = 10;
        this.constraints.weightx = 1.0;
        this.constraints.weighty = 1.0;
        this.add(this.theWholePanel, this.gridBag, this.constraints, 0, 0, 0, 1);
        this.constraints.fill = 0;
        this.constraints.anchor = 13;
        this.add(this.buttonPanel, this.gridBag, this.constraints, 0, 1, 0, 0);
    }

    public Dimension getMinSize() {
        this.pack();
        LayoutManager layoutManager = this.getLayout();
        return layoutManager.minimumLayoutSize(this);
    }

    private void initButtonPanel() {
        this.buttonLabels = new String[3];
        this.buttonLabels[0] = this.resources.getString("BUTTON_PANEL_OK");
        this.buttonLabels[1] = this.resources.getString("BUTTON_PANEL_CANCEL");
        this.buttonLabels[2] = this.resources.getString("BUTTON_PANEL_HELP");
        int n = this.buttonLabels.length;
        this.buttons = new Button[n];
        int n2 = 0;
        while (n2 < this.buttonLabels.length) {
            this.buttons[n2] = new Button(this.buttonLabels[n2]);
            this.buttons[n2].addActionListener(this);
            this.buttons[n2].addKeyListener(this);
            ++n2;
        }
        this.buttonPanel = new ButtonPanel(this, this.buttons);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object instanceof Button) {
            this.handleButton((Button)object);
        }
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.dispose();
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void handleButton(Button button) {
        if (button == this.buttons[0]) {
            this.saveList = this.theList.getNameList();
            if (this.filePath.getText().trim().equals("")) {
                ((TextComponent)this.filePath).setText(this.directoryName);
            }
            ((Component)this).setVisible(false);
            this.myCaller.requestFocus();
        }
        if (button == this.buttons[1]) {
            ((Component)this).setVisible(false);
            this.myCaller.requestFocus();
        }
        if (button == this.buttons[2]) {
            this.myParent.MyParent.handleHelp("ddscwng.htm#HDRWNG");
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        Object object = keyEvent.getSource();
        if (keyEvent.getKeyCode() == 10 && object instanceof Button) {
            this.handleButton((Button)object);
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }
}

