/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.ddnssgui.client;

import COM.ibm.raleigh.ddnssgui.client.MainFrame;
import COM.ibm.raleigh.ddnssgui.common.BorderPanel;
import COM.ibm.raleigh.ddnssgui.common.ButtonPanel;
import COM.ibm.raleigh.ddnssgui.common.DDNSUtility;
import COM.ibm.raleigh.ddnssgui.common.MsgBoxListener;
import COM.ibm.raleigh.ddnssgui.common.Question;
import COM.ibm.raleigh.ddnssgui.common.RequestList;
import COM.ibm.raleigh.ddnssgui.common.WrappedTextPanel;
import COM.ibm.raleigh.ddnssgui.common.msgBox;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.ItemSelectable;
import java.awt.Label;
import java.awt.LayoutManager;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.text.MessageFormat;

class FindObjectFrame
extends Frame
implements WindowListener,
ActionListener,
ItemListener,
MsgBoxListener,
KeyListener {
    private static final String cStmt1 = "(c) Copyright IBM Corp 1997. All rights reserved.\n";
    public static final int FIRST_FIELD = 0;
    public static final int HOST_FIELD = 0;
    public static final int ALIAS_FIELD = 1;
    public static final int DOMAIN_FIELD = 2;
    private static final int NUM_BUTTONS = 3;
    private final int OK_BUTTON = 0;
    private final int CANCEL_BUTTON = 1;
    private final int HELP_BUTTON = 2;
    private static final int NUM_TEXT_FIELD_COLUMNS = 10;
    private MainFrame parent;
    private TextField theName;
    private Panel wholePanel;
    private WrappedTextPanel panelExplanation;
    private BorderPanel objectTypePanel;
    private CheckboxGroup cbgForObjectType;
    private Checkbox host;
    private Checkbox alias;
    private Checkbox domain;
    private Choice domainName;
    private Label domainNameLabel;
    private Label nameLabel;
    private Button[] buttons;
    private String[] buttonLabels;
    private ButtonPanel buttonPanel;
    private msgBox okBox;
    private GridBagLayout gridBag;
    private GridBagConstraints constraints;
    private GridBagLayout gridBagPanel;
    private GridBagConstraints constraintsPanel;
    private msgBox invalidBox;

    public FindObjectFrame(MainFrame mainFrame) {
        this.setResizable(false);
        this.parent = mainFrame;
        this.setTitle(this.parent.clientResources.getString("FIND_OBJECT_FRAME_NAME"));
        ((Component)this).setBackground(DDNSUtility.BACKGROUND_COLOR);
        this.initComponents();
        this.addComponentsToGrid();
    }

    public void setFullyQualifiedDomainNameList(String[] stringArray) {
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                this.domainName.addItem(stringArray[n].trim().toLowerCase());
                ++n;
            }
            if (stringArray.length > 1) {
                this.domainName.setEnabled(true);
            }
        }
    }

    public Dimension getMinSize() {
        this.pack();
        LayoutManager layoutManager = this.getLayout();
        return layoutManager.minimumLayoutSize(this);
    }

    public void requestFocus(int n) {
        switch (n) {
            case 0: {
                this.host.requestFocus();
                return;
            }
            case 1: {
                this.alias.requestFocus();
                return;
            }
            case 2: {
                this.domain.requestFocus();
                return;
            }
        }
    }

    private void add(Component component, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagLayout.setConstraints(component, gridBagConstraints);
        this.add(component);
    }

    private void constrain(Component component, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagLayout.setConstraints(component, gridBagConstraints);
    }

    private void handleCheckbox() {
        if (this.cbgForObjectType.getSelectedCheckbox() == this.host) {
            this.theName.setEnabled(true);
            return;
        }
        if (this.cbgForObjectType.getSelectedCheckbox() == this.alias) {
            this.theName.setEnabled(true);
            return;
        }
        if (this.cbgForObjectType.getSelectedCheckbox() == this.domain) {
            this.theName.setEnabled(false);
        }
    }

    private void initComponents() {
        this.objectTypePanel = new BorderPanel(this.parent.clientResources.getString("OBJECT_TYPE_LABEL"));
        this.cbgForObjectType = new CheckboxGroup();
        this.host = new Checkbox(this.parent.clientResources.getString("HOST_LABEL"), this.cbgForObjectType, false);
        this.host.addItemListener(this);
        this.host.addKeyListener(this);
        this.alias = new Checkbox(this.parent.clientResources.getString("ALIAS_LABEL"), this.cbgForObjectType, false);
        this.alias.addItemListener(this);
        this.alias.addKeyListener(this);
        this.domain = new Checkbox(this.parent.clientResources.getString("FOF_DOMAIN_LABEL"), this.cbgForObjectType, false);
        this.domain.addItemListener(this);
        this.domain.addKeyListener(this);
        this.wholePanel = new Panel();
        this.panelExplanation = new WrappedTextPanel(this.parent.clientResources.getString("FIND_OBJECT_EXPLANATION_LABEL"));
        this.theName = new TextField("", 10);
        this.domainNameLabel = new Label(this.parent.clientResources.getString("DOMAIN_NAME_LABEL"), 0);
        this.domainName = new Choice();
        this.nameLabel = new Label(this.parent.clientResources.getString("NAME_LABEL"), 0);
        this.initButtonPanel();
        this.gridBag = new GridBagLayout();
        this.constraints = new GridBagConstraints();
        this.gridBagPanel = new GridBagLayout();
        this.constraintsPanel = new GridBagConstraints();
        this.cbgForObjectType.setSelectedCheckbox(this.host);
        RequestList requestList = new RequestList(1);
        this.setFullyQualifiedDomainNameList(requestList.getReturnedList(this.parent.clientResources, this.parent.dataOut));
        requestList = new RequestList(2);
        this.setFullyQualifiedDomainNameList(requestList.getReturnedList(this.parent.clientResources, this.parent.dataOut));
        this.addWindowListener(this);
    }

    private void addComponentsToGrid() {
        this.constraints.fill = 2;
        this.constraints.weightx = 1.0;
        this.constraints.weighty = 1.0;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.objectTypePanel.setLayout(gridBagLayout);
        gridBagConstraints.insets = new Insets(0, 25, 0, 0);
        this.constrain(this.host, gridBagLayout, gridBagConstraints, 0, 0, 0, 1);
        this.objectTypePanel.add(this.host);
        this.constrain(this.alias, gridBagLayout, gridBagConstraints, 0, 1, 0, 1);
        this.objectTypePanel.add(this.alias);
        this.constrain(this.domain, gridBagLayout, gridBagConstraints, 0, 2, 0, 1);
        this.objectTypePanel.add(this.domain);
        this.wholePanel.setLayout(this.gridBagPanel);
        this.constraintsPanel.fill = 2;
        this.constrain(this.panelExplanation, this.gridBagPanel, this.constraintsPanel, 0, 0, 6, 2);
        this.wholePanel.add(this.panelExplanation);
        this.constrain(this.objectTypePanel, this.gridBagPanel, this.constraintsPanel, 0, 2, 0, 4);
        this.wholePanel.add(this.objectTypePanel);
        this.constrain(this.nameLabel, this.gridBagPanel, this.constraintsPanel, 0, 7, 3, 1);
        this.wholePanel.add(this.nameLabel);
        this.constrain(this.theName, this.gridBagPanel, this.constraintsPanel, 3, 7, 0, 1);
        this.wholePanel.add(this.theName);
        this.constrain(this.domainNameLabel, this.gridBagPanel, this.constraintsPanel, 0, 8, 3, 1);
        this.wholePanel.add(this.domainNameLabel);
        this.constrain(this.domainName, this.gridBagPanel, this.constraintsPanel, 3, 8, 0, 1);
        this.wholePanel.add(this.domainName);
        this.setLayout(this.gridBag);
        this.add(this.wholePanel, this.gridBag, this.constraints, 0, 0, 0, 1);
        this.constraints.fill = 0;
        this.constraints.anchor = 13;
        this.add(this.buttonPanel, this.gridBag, this.constraints, 0, 1, 0, 0);
    }

    private void initButtonPanel() {
        this.buttonLabels = new String[3];
        this.buttonLabels[0] = this.parent.clientResources.getString("BUTTON_PANEL_OK");
        this.buttonLabels[1] = this.parent.clientResources.getString("BUTTON_PANEL_CANCEL");
        this.buttonLabels[2] = this.parent.clientResources.getString("BUTTON_PANEL_HELP");
        int n = this.buttonLabels.length;
        this.buttons = new Button[n];
        int n2 = 0;
        while (n2 < this.buttonLabels.length) {
            this.buttons[n2] = new Button(this.buttonLabels[n2]);
            this.buttons[n2].addActionListener(this);
            this.buttons[n2].addKeyListener(this);
            ++n2;
        }
        this.buttonPanel = new ButtonPanel(this, this.buttons);
    }

    private boolean checkRequiredFields() {
        boolean bl = true;
        String string = new String(this.theName.getText().trim().toLowerCase());
        if (this.cbgForObjectType.getSelectedCheckbox() == this.host || this.cbgForObjectType.getSelectedCheckbox() == this.alias) {
            if (string == null || string.length() <= 0) {
                this.okBox = new msgBox(this.parent.clientResources, this.parent.clientResources.getString("FIND_OBJECT_FRAME_NAME"), this.parent.clientResources.getString("FIND_NAME_REQUIRED_TEXT"), 1, true, this, this);
                bl = false;
            }
            String string2 = this.domainName.getSelectedItem().trim().toLowerCase();
            if (this.cbgForObjectType.getSelectedCheckbox() == this.host) {
                if (string2.endsWith("in-addr.arpa")) {
                    Question question = new Question(15, String.valueOf(string) + "." + string2);
                    if (question.getReturnedTrueOrFalse(this.parent.dataOut)) {
                        this.parent.ReverseHostSelected(string, string2);
                        return true;
                    }
                    Object[] objectArray = new Object[]{string, string2};
                    this.okBox = new msgBox(this.parent.clientResources, this.parent.clientResources.getString("FIND_OBJECT_FRAME_NAME"), MessageFormat.format(this.parent.clientResources.getString("HOST_NOT_FOUND_TEXT"), objectArray), 1, true, this, this);
                    return false;
                }
                Question question = new Question(13, String.valueOf(string) + "." + string2);
                if (question.getReturnedTrueOrFalse(this.parent.dataOut)) {
                    this.parent.HostSelected(string, string2);
                    return true;
                }
                Object[] objectArray = new Object[]{string, string2};
                this.okBox = new msgBox(this.parent.clientResources, this.parent.clientResources.getString("FIND_OBJECT_FRAME_NAME"), MessageFormat.format(this.parent.clientResources.getString("HOST_NOT_FOUND_TEXT"), objectArray), 1, true, this, this);
                return false;
            }
            Question question = new Question(14, String.valueOf(string) + "." + string2);
            if (question.getReturnedTrueOrFalse(this.parent.dataOut)) {
                this.parent.AliasSelected(string, string2);
                return true;
            }
            Object[] objectArray = new Object[]{string, string2};
            this.okBox = new msgBox(this.parent.clientResources, this.parent.clientResources.getString("FIND_OBJECT_FRAME_NAME"), MessageFormat.format(this.parent.clientResources.getString("ALIAS_NOT_FOUND_TEXT"), objectArray), 1, true, this, this);
            return false;
        }
        if (this.cbgForObjectType.getSelectedCheckbox() == this.domain) {
            String string3 = this.domainName.getSelectedItem().trim();
            Question question = new Question(1, string3);
            if (question.getReturnedTrueOrFalse(this.parent.dataOut)) {
                this.parent.PrimaryDomainSelected(string3);
                return true;
            }
            question = new Question(7, string3);
            if (question.getReturnedTrueOrFalse(this.parent.dataOut)) {
                this.parent.SecondaryDomainSelected(string3);
                return true;
            }
        }
        return bl;
    }

    private void handleButton(Button button) {
        if (button == this.buttons[0] && this.checkRequiredFields()) {
            this.dispose();
        }
        if (button == this.buttons[1]) {
            this.parent.requestFocus();
            this.dispose();
        }
        if (button == this.buttons[2]) {
            this.parent.handleHelp("ddscwnf.htm#HDRWNF");
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object instanceof Button) {
            this.handleButton((Button)object);
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        ItemSelectable itemSelectable = itemEvent.getItemSelectable();
        if (itemSelectable instanceof Checkbox) {
            this.handleCheckbox();
        }
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.parent.requestFocus();
        this.dispose();
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void msgBoxSelection(int n, int n2) {
        this.requestFocus();
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        Object object = keyEvent.getSource();
        if (keyEvent.getKeyCode() == 10) {
            if (object instanceof Button) {
                this.handleButton((Button)object);
            }
            if (object instanceof Checkbox) {
                Checkbox checkbox;
                checkbox.setState(!(checkbox = (Checkbox)object).getState());
                this.handleCheckbox();
            }
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }
}

