/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.ddnssgui.client;

import COM.ibm.eNetwork.jdi.gui.common.ColorsForCanvas;
import COM.ibm.eNetwork.jdi.gui.common.FontsForCanvas;
import COM.ibm.eNetwork.jdi.gui.tabView.TabView;
import COM.ibm.eNetwork.jdi.gui.tabView.TabViewNode;
import COM.ibm.raleigh.ddnssgui.client.DynamicChangesPanel;
import COM.ibm.raleigh.ddnssgui.client.MainFrame;
import COM.ibm.raleigh.ddnssgui.common.ButtonPanel;
import COM.ibm.raleigh.ddnssgui.common.DDNSUtility;
import COM.ibm.raleigh.ddnssgui.common.Question;
import COM.ibm.raleigh.ddnssgui.common.RequestList;
import COM.ibm.raleigh.ddnssgui.common.WrappedTextPanel;
import java.awt.Button;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.Panel;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Enumeration;
import java.util.ResourceBundle;
import java.util.Vector;

class DynamicFileSaveFrame
extends Frame
implements WindowListener,
ActionListener,
KeyListener {
    private static final String cStmt1 = "(c) Copyright IBM Corp 1997. All rights reserved.\n";
    private static final int TABVIEW_SAVE_INDEX = 0;
    private static final int TABVIEW_FIRST_INDEX = 0;
    private static final int NUM_TABS = 1;
    private static final int NUM_BUTTONS = 3;
    public static final int FIRST_BUTTON = 0;
    public static final int STOP_SERVER_BUTTON = 0;
    public static final int NO_STOP_BUTTON = 1;
    public static final int HELP_BUTTON = 2;
    private static final int NUM_TEXT_FIELD_COLUMNS = 40;
    private MainFrame parent;
    private ResourceBundle resources;
    private WrappedTextPanel saveExplanation;
    private Panel fileSavePanel;
    private String[] dynamicDomainNames;
    private Vector panelList;
    private Button[] buttons;
    private String[] buttonLabels;
    private ButtonPanel buttonPanel;
    private TabView tabView;
    private FontsForCanvas ffcFont = new FontsForCanvas(new Font("Helvetica", 0, 12), new Font("Helvetica", 1, 12));
    private ColorsForCanvas cfcColor = new ColorsForCanvas(DDNSUtility.BACKGROUND_COLOR, DDNSUtility.TEXT_COLOR, DDNSUtility.HIGHLIGHT_COLOR);
    private GridBagLayout gridBag;
    private GridBagConstraints constraints;
    private GridBagLayout gridBagPanel;
    private GridBagConstraints constraintsPanel;

    public DynamicFileSaveFrame(MainFrame mainFrame) {
        this.setResizable(false);
        this.parent = mainFrame;
        this.resources = this.parent.clientResources;
        this.setTitle(this.resources.getString("DYNAMIC_FILE_SAVE_FRAME_NAME"));
        ((Component)this).setBackground(DDNSUtility.BACKGROUND_COLOR);
        this.initComponents();
        this.addComponentsToGrid();
    }

    public Dimension getMinSize() {
        this.pack();
        LayoutManager layoutManager = this.getLayout();
        return layoutManager.minimumLayoutSize(this);
    }

    public boolean anyFilesToBeWritten() {
        return !this.panelList.isEmpty();
    }

    public void requestFocus(int n) {
        switch (n) {
            case 0: {
                this.buttonPanel.requestFocus(this.buttons[0]);
                return;
            }
            case 1: {
                this.buttonPanel.requestFocus(this.buttons[1]);
                return;
            }
            case 2: {
                this.buttonPanel.requestFocus(this.buttons[2]);
                return;
            }
        }
    }

    private void add(Component component, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagLayout.setConstraints(component, gridBagConstraints);
        this.add(component);
    }

    private void constrain(Component component, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagLayout.setConstraints(component, gridBagConstraints);
    }

    private void initComponents() {
        this.fileSavePanel = new Panel();
        this.saveExplanation = new WrappedTextPanel(this.resources.getString("DYNAMIC_FILE_SAVE_EXPLANATION_LABEL"));
        this.panelList = new Vector();
        RequestList requestList = new RequestList(14);
        this.dynamicDomainNames = requestList.getReturnedList(this.resources, this.parent.dataOut);
        Question question = new Question(17);
        boolean bl = question.getReturnedTrueOrFalse(this.parent.dataOut);
        if (this.dynamicDomainNames != null) {
            int n = 0;
            while (n < this.dynamicDomainNames.length) {
                question = new Question(16, this.dynamicDomainNames[n]);
                int n2 = question.getIntFromString(this.parent.dataOut);
                if (n2 > 0 || bl) {
                    this.panelList.addElement(new DynamicChangesPanel(this.resources, this.dynamicDomainNames[n], n2, bl));
                }
                ++n;
            }
        }
        this.initButtonPanel();
        this.tabView = new TabView(new Point(0, 0), new Dimension(Integer.parseInt(this.resources.getString("DFSF_TABVIEW_WIDTH")), Integer.parseInt(this.resources.getString("DFSF_TABVIEW_HEIGHT"))), this.ffcFont, this.cfcColor, null, 1);
        TabViewNode tabViewNode = this.createTabNode(this.resources.getString("TABVIEW_SAVE_LABEL"), this.fileSavePanel, 0);
        this.tabView.addTab(tabViewNode);
        this.gridBag = new GridBagLayout();
        this.constraints = new GridBagConstraints();
        this.gridBagPanel = new GridBagLayout();
        this.constraintsPanel = new GridBagConstraints();
        this.addWindowListener(this);
    }

    private void addComponentsToGrid() {
        this.setLayout(this.gridBag);
        this.constraints.fill = 2;
        this.constraints.anchor = 10;
        this.constraints.weightx = 1.0;
        this.constraints.weighty = 1.0;
        this.constraintsPanel.fill = 2;
        this.constraintsPanel.anchor = 10;
        this.constraintsPanel.weightx = 1.0;
        this.constraintsPanel.weighty = 1.0;
        this.fileSavePanel.setLayout(this.gridBagPanel);
        this.constrain(this.saveExplanation, this.gridBagPanel, this.constraintsPanel, 0, 0, 0, 1);
        this.fileSavePanel.add(this.saveExplanation);
        this.add((Component)this.tabView, this.gridBag, this.constraints, 0, 0, 0, 1);
        if (!this.panelList.isEmpty()) {
            Enumeration enumeration = this.panelList.elements();
            TabViewNode tabViewNode = null;
            int n = 1;
            while (enumeration.hasMoreElements()) {
                DynamicChangesPanel dynamicChangesPanel = (DynamicChangesPanel)enumeration.nextElement();
                tabViewNode = this.createTabNode(dynamicChangesPanel.getDomainName(), dynamicChangesPanel, n);
                ++n;
                this.tabView.addTab(tabViewNode);
            }
        }
        this.tabView.committ();
        this.constraints.fill = 0;
        this.constraints.anchor = 13;
        this.add(this.buttonPanel, this.gridBag, this.constraints, 0, 1, 0, 0);
    }

    private void initButtonPanel() {
        this.buttonLabels = new String[3];
        this.buttonLabels[0] = this.resources.getString("DFSF_STOP_SERVER_BUTTON");
        this.buttonLabels[1] = this.resources.getString("DFSF_NO_STOP_BUTTON");
        this.buttonLabels[2] = this.resources.getString("BUTTON_PANEL_HELP");
        int n = this.buttonLabels.length;
        this.buttons = new Button[n];
        int n2 = 0;
        while (n2 < this.buttonLabels.length) {
            this.buttons[n2] = new Button(this.buttonLabels[n2]);
            this.buttons[n2].addActionListener(this);
            this.buttons[n2].addKeyListener(this);
            ++n2;
        }
        this.buttonPanel = new ButtonPanel(this, this.buttons);
    }

    private void handleButton(Button button) {
        if (button == this.buttons[0]) {
            this.parent.requestFocus();
            this.parent.finallyDoTheSave(true);
            this.dispose();
        }
        if (button == this.buttons[1]) {
            this.parent.requestFocus();
            this.parent.finallyDoTheSave(false);
            this.dispose();
        }
        if (button == this.buttons[2]) {
            this.parent.handleHelp("ddscnbw.htm#HDRNBW");
        }
    }

    private TabViewNode createTabNode(String string, Panel panel, int n) {
        TabViewNode tabViewNode = new TabViewNode();
        tabViewNode.setColors(this.cfcColor);
        tabViewNode.setFonts(this.ffcFont);
        tabViewNode.setImage(null);
        tabViewNode.setId(n);
        tabViewNode.setText(string);
        tabViewNode.setPanel(panel);
        return tabViewNode;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object instanceof Button) {
            this.handleButton((Button)object);
        }
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.parent.requestFocus();
        this.dispose();
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        Object object = keyEvent.getSource();
        if (keyEvent.getKeyCode() == 10 && object instanceof Button) {
            this.handleButton((Button)object);
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }
}

