/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.ddnssgui.client;

import COM.ibm.raleigh.ddnssgui.client.DynamicOptionsFrame;
import COM.ibm.raleigh.ddnssgui.client.GenerateKeyFailed;
import COM.ibm.raleigh.ddnssgui.client.MainFrame;
import COM.ibm.raleigh.ddnssgui.client.PrimaryDomainFrame;
import COM.ibm.raleigh.ddnssgui.client.SecondaryDomainFrame;
import COM.ibm.raleigh.ddnssgui.common.AliasHostObject;
import COM.ibm.raleigh.ddnssgui.common.BusyWaitFrame;
import COM.ibm.raleigh.ddnssgui.common.DDNSNetworkStringParser;
import COM.ibm.raleigh.ddnssgui.common.DomainObject;
import COM.ibm.raleigh.ddnssgui.common.DynamicOptionsObject;
import COM.ibm.raleigh.ddnssgui.common.NameAndIpAddress;
import COM.ibm.raleigh.ddnssgui.common.NameAndIpAddressList;
import COM.ibm.raleigh.ddnssgui.common.NameServerObject;
import COM.ibm.raleigh.ddnssgui.common.ParsedVector;
import COM.ibm.raleigh.ddnssgui.common.PrimaryDomain;
import COM.ibm.raleigh.ddnssgui.common.Question;
import COM.ibm.raleigh.ddnssgui.common.SecondaryDomain;
import COM.ibm.raleigh.ddnssgui.common.msgBox;
import java.awt.Component;
import java.awt.Dimension;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.ResourceBundle;
import java.util.Vector;

public class DomainObjectMgr {
    private static final String cStmt1 = "(c) Copyright IBM Corp 1997. All rights reserved.\n";
    private ResourceBundle resources;
    private NameServerObject NameServ;
    public MainFrame MyParent;
    private PrimaryDomain PriDom;
    private SecondaryDomain SecDom;
    private boolean NewDomainObject;
    private DynamicOptionsObject DynOpts;
    private PrimaryDomainFrame myPriDomPanel;
    private SecondaryDomainFrame mySecDomPanel;
    private DynamicOptionsFrame dynOptsFrame;
    private boolean isDynamic;
    private msgBox optionsCheckBox;
    private String[] genKeyList;
    private String genKeyFileDirectory;
    private boolean haveFailures;

    public DomainObjectMgr(MainFrame mainFrame) {
        this.MyParent = mainFrame;
        this.resources = this.MyParent.clientResources;
        this.myPriDomPanel = new PrimaryDomainFrame(this);
        this.mySecDomPanel = new SecondaryDomainFrame(this);
    }

    public void exit() {
        this.myPriDomPanel.dispose();
        this.mySecDomPanel.dispose();
    }

    public boolean isShowing() {
        return this.mySecDomPanel.isShowing() || this.myPriDomPanel.isShowing();
    }

    public void requestFocus() {
        if (this.mySecDomPanel.isShowing()) {
            this.mySecDomPanel.requestFocus();
            this.mySecDomPanel.selectAll(0);
            this.mySecDomPanel.requestFocus(0);
            return;
        }
        this.myPriDomPanel.requestFocus();
        this.myPriDomPanel.selectAll(0);
        this.myPriDomPanel.requestFocus(0);
    }

    public void CreateNewPrimaryDomain(String string) {
        this.MyParent.dataOut.sendToServer("NSO=GET,name=" + string + "," + "ENSO" + ",");
        DDNSNetworkStringParser dDNSNetworkStringParser = this.MyParent.dataOut.receiveFromServer();
        this.NameServ = new NameServerObject(dDNSNetworkStringParser.getParsed());
        this.PriDom = new PrimaryDomain();
        Question question = new Question(11);
        this.PriDom.setDataFileName(question.getStringFromString(this.MyParent.dataOut));
        question = new Question(12);
        this.PriDom.setStaticFileName(question.getStringFromString(this.MyParent.dataOut));
        this.NewDomainObject = true;
        this.DynOpts = null;
        this.InitPrimaryDomainFrame();
        this.SecDom = null;
        this.genKeyList = null;
        this.genKeyFileDirectory = null;
        this.isDynamic = this.PriDom.isDynamic();
    }

    public void CreateNewSecondaryDomain(String string) {
        this.MyParent.dataOut.sendToServer("NSO=GET,name=" + string + "," + "ENSO" + ",");
        DDNSNetworkStringParser dDNSNetworkStringParser = this.MyParent.dataOut.receiveFromServer();
        this.NameServ = new NameServerObject(dDNSNetworkStringParser.getParsed());
        this.SecDom = new SecondaryDomain();
        Question question = new Question(11);
        this.SecDom.setDataFileName(question.getStringFromString(this.MyParent.dataOut));
        this.NewDomainObject = true;
        this.DynOpts = null;
        this.genKeyList = null;
        this.genKeyFileDirectory = null;
        this.InitSecondaryDomainFrame();
        this.PriDom = null;
    }

    public void UpdateExistingDomain(String string, String string2, boolean bl) {
        DomainObject domainObject;
        this.DynOpts = null;
        this.genKeyList = null;
        this.genKeyFileDirectory = null;
        this.MyParent.dataOut.sendToServer("NSO=GET,name=" + string + "," + "ENSO" + ",");
        DDNSNetworkStringParser dDNSNetworkStringParser = this.MyParent.dataOut.receiveFromServer();
        this.NameServ = new NameServerObject(dDNSNetworkStringParser.getParsed());
        if (bl) {
            this.MyParent.dataOut.sendToServer("PDOM=GET,name=" + string2 + "," + "EPDOM" + ",");
            dDNSNetworkStringParser = this.MyParent.dataOut.receiveFromServer();
            domainObject = new PrimaryDomain(dDNSNetworkStringParser.getParsed());
        } else {
            this.MyParent.dataOut.sendToServer("SDOM=GET,name=" + string2 + "," + "ESDOM" + ",");
            dDNSNetworkStringParser = this.MyParent.dataOut.receiveFromServer();
            domainObject = new SecondaryDomain(dDNSNetworkStringParser.getParsed());
        }
        if (domainObject != null) {
            this.NewDomainObject = false;
            if (domainObject instanceof PrimaryDomain) {
                this.PriDom = domainObject;
                this.SecDom = null;
                this.InitPrimaryDomainFrame();
                this.isDynamic = this.PriDom.isDynamic();
                this.genKeyList = this.PriDom.getHostKeys();
                return;
            }
            this.PriDom = null;
            this.SecDom = (SecondaryDomain)domainObject;
            this.InitSecondaryDomainFrame();
            return;
        }
        this.CreateNewPrimaryDomain(string);
    }

    public String getCurrentDomName() {
        return this.myPriDomPanel.getFullyQualifiedDomainName();
    }

    private void InitPrimaryDomainFrame() {
        this.myPriDomPanel.setFullyQualifiedDomainName(this.PriDom.getDomName());
        this.myPriDomPanel.setNotifyServerList(this.PriDom.getNotifySetforDomain());
        this.myPriDomPanel.setNotify(this.PriDom.getNotify());
        if (!this.NewDomainObject) {
            this.myPriDomPanel.setNameServerList(this.PriDom.getNameServerSetforDomain());
            this.myPriDomPanel.setSeparateDataState(this.PriDom.getSeparateDynStatData());
            this.myPriDomPanel.setStaticFileName(this.PriDom.getStaticFileName());
        } else {
            this.myPriDomPanel.setSeparateDataState(true);
            this.myPriDomPanel.setStaticFileName(this.PriDom.getStaticFileName());
            this.myPriDomPanel.setNameServerList(new NameAndIpAddressList());
        }
        if (this.PriDom.isDynamic()) {
            this.myPriDomPanel.setDomainType(1);
        } else {
            this.myPriDomPanel.setDomainType(2);
        }
        this.myPriDomPanel.setAdminMailAddress(this.PriDom.getAdminEmail());
        this.myPriDomPanel.setSerialNumber(this.PriDom.getSerialNo());
        this.myPriDomPanel.setRefreshRate(this.PriDom.getRefreshRt());
        this.myPriDomPanel.setRetryInterval(this.PriDom.getRetryInterval());
        this.myPriDomPanel.setDefaultTTL(this.PriDom.getTTL());
        this.myPriDomPanel.setExpireTime(this.PriDom.getExpirationTime());
        this.myPriDomPanel.setDomainFileName(this.PriDom.getDataFileName());
        this.myPriDomPanel.setNSTTL(this.PriDom.getNameServerTTL());
        this.myPriDomPanel.setSOATTL(this.PriDom.getSoaTTL());
        this.myPriDomPanel.setUpdateCount(this.PriDom.getNoOfUpds());
        this.myPriDomPanel.setUpdateTime(this.PriDom.getUpdateTime());
        this.myPriDomPanel.setAutoReverseMapState(this.PriDom.getReverseMappingState());
        this.myPriDomPanel.setMailList(this.PriDom.getMailExchange());
        this.myPriDomPanel.setMXTTL(this.PriDom.getMailTTL());
        this.myPriDomPanel.setNotifyRetryTime(this.PriDom.getNotifyRetryTime());
        this.myPriDomPanel.setNotifyNumRetries(this.PriDom.getNotifyRetryNum());
        this.myPriDomPanel.setNotifyDelayTime(this.PriDom.getNotifyDelayTime());
        this.myPriDomPanel.setChildNameServers(this.PriDom.getChildNameServers());
        Dimension dimension = this.myPriDomPanel.getMinSize();
        this.myPriDomPanel.selectFirstTab();
        this.myPriDomPanel.setEnabled(true);
        this.myPriDomPanel.setEnabledButtons(true);
        ((Component)this.myPriDomPanel).setVisible(true);
        this.myPriDomPanel.requestFocus();
    }

    public String getCurrentDomainName() {
        if (this.PriDom != null) {
            return this.myPriDomPanel.getFullyQualifiedDomainName();
        }
        if (this.SecDom != null) {
            return this.mySecDomPanel.getFullyQualifiedDomainName();
        }
        return null;
    }

    private void InitSecondaryDomainFrame() {
        this.mySecDomPanel.setFullyQualifiedDomainName(this.SecDom.getDomName());
        this.mySecDomPanel.setNotify(this.SecDom.getNotify());
        this.mySecDomPanel.setNotifyServerList(this.SecDom.getNotifySetforDomain());
        this.mySecDomPanel.setNotifyRetryTime(this.SecDom.getNotifyRetryTime());
        this.mySecDomPanel.setNotifyNumRetries(this.SecDom.getNotifyRetryNum());
        this.mySecDomPanel.setNotifyDelayTime(this.SecDom.getNotifyDelayTime());
        this.mySecDomPanel.setDomainFileName(this.SecDom.getDataFileName());
        this.mySecDomPanel.setMasterServerList(this.SecDom.getMasterServersforDomain());
        this.mySecDomPanel.setNotifyServerList(this.SecDom.getNotifySetforDomain());
        Dimension dimension = this.mySecDomPanel.getMinSize();
        this.mySecDomPanel.selectFirstTab();
        this.mySecDomPanel.setEnabled(true);
        this.mySecDomPanel.setEnabledButtons(true);
        ((Component)this.mySecDomPanel).setVisible(true);
        this.mySecDomPanel.requestFocus();
    }

    public void DynamicOptionsSelected() {
        this.myPriDomPanel.setEnabled(false);
        this.myPriDomPanel.setEnabledButtons(false);
        this.dynOptsFrame = new DynamicOptionsFrame(this);
        if (this.DynOpts == null) {
            this.DynOpts = this.PriDom.getDynOpts();
        }
        this.dynOptsFrame.setBackupState(this.DynOpts.GetShouldBackupData());
        this.dynOptsFrame.setExpireTimeState(this.DynOpts.GetDeleteSig());
        this.dynOptsFrame.setExpireTime(this.DynOpts.GetDeleteTime());
        if (this.DynOpts.GetPresecured()) {
            this.dynOptsFrame.setSecurityMode(1);
        } else {
            this.dynOptsFrame.setSecurityMode(0);
        }
        this.dynOptsFrame.setSendKeyState(this.DynOpts.GetSendKeysToSec());
        this.dynOptsFrame.setTimeSyncState(this.DynOpts.GetTimeSync());
        this.dynOptsFrame.setForwardTimeState(this.DynOpts.GetForwardTime());
        this.dynOptsFrame.setOverrideTTLState(this.DynOpts.GetOverrideTTL());
        this.dynOptsFrame.setOverrideTTL(this.DynOpts.GetOverrideVal());
        if (this.genKeyList != null) {
            this.dynOptsFrame.setGenKeyList(this.genKeyList);
        }
        if (this.genKeyFileDirectory != null) {
            this.dynOptsFrame.setDirectory(this.genKeyFileDirectory);
        }
        this.dynOptsFrame.getMinSize();
        ((Component)this.dynOptsFrame).setVisible(true);
        this.dynOptsFrame.requestFocus();
        this.dynOptsFrame.requestFocus(0);
    }

    private boolean SaveAllData() {
        this.haveFailures = false;
        if (this.PriDom != null) {
            Question question;
            if (this.NewDomainObject && !(question = new Question(2, this.myPriDomPanel.getFullyQualifiedDomainName().toLowerCase())).getReturnedTrueOrFalse(this.MyParent.dataOut)) {
                Object[] objectArray = new Object[]{this.myPriDomPanel.getFullyQualifiedDomainName().toLowerCase()};
                new msgBox(this.resources, this.resources.getString("APP_TITLE"), MessageFormat.format(this.resources.getString("MSG_TEXT"), objectArray), 1, false, this.myPriDomPanel);
                this.myPriDomPanel.setEnabled(true);
                this.myPriDomPanel.setEnabledButtons(true);
                return false;
            }
            if (this.DynOpts != null) {
                this.PriDom.setDynOpts(this.DynOpts);
            }
            if (this.myPriDomPanel.getDomainType() == 1) {
                this.PriDom.makeDynamic();
            } else {
                this.PriDom.makeStatic();
            }
            this.PriDom.setNameServerSetforDomain(this.myPriDomPanel.getNameServerList());
            this.PriDom.setDomName(this.myPriDomPanel.getFullyQualifiedDomainName().toLowerCase());
            this.PriDom.setNotify(this.myPriDomPanel.getNotify());
            if (this.PriDom.getNotify()) {
                this.PriDom.setNotifySetforDomain(this.myPriDomPanel.getNotifyServerList());
            } else {
                this.PriDom.setNotifySetforDomain(null);
            }
            this.PriDom.setAdminEmail(this.myPriDomPanel.getAdminMailAddress());
            this.PriDom.setRefreshRt(this.myPriDomPanel.getRefreshRate());
            this.PriDom.setRetryInterval(this.myPriDomPanel.getRetryInterval());
            this.PriDom.setTTL(this.myPriDomPanel.getDefaultTTL());
            this.PriDom.setExpirationTime(this.myPriDomPanel.getExpireTime());
            this.PriDom.setDataFileName(this.myPriDomPanel.getDomainFileName());
            this.PriDom.setSoaTTL(this.myPriDomPanel.getSOATTL());
            this.PriDom.setNameServerTTL(this.myPriDomPanel.getNSTTL());
            this.PriDom.setUpdateTime(this.myPriDomPanel.getUpdateTime());
            this.PriDom.setNoOfUpds(this.myPriDomPanel.getUpdateCount());
            this.PriDom.setSeparateDynStatData(this.myPriDomPanel.getSeparateDataState());
            this.PriDom.setStaticFileName(this.myPriDomPanel.getStaticFileName());
            this.PriDom.setMailExchange(this.myPriDomPanel.getMailList());
            this.PriDom.setReverseMappingState(this.myPriDomPanel.getAutoReverseMapState());
            this.PriDom.setMailTTL(this.myPriDomPanel.getMXTTL());
            this.PriDom.setNotifyRetryTime(this.myPriDomPanel.getNotifyRetryTime());
            this.PriDom.setNotifyRetryNum(this.myPriDomPanel.getNotifyNumRetries());
            this.PriDom.setNotifyDelayTime(this.myPriDomPanel.getNotifyDelayTime());
            this.PriDom.setChildNameServers(this.myPriDomPanel.getChildNameServers());
        } else {
            Question question;
            if (this.NewDomainObject && !(question = new Question(2, this.mySecDomPanel.getFullyQualifiedDomainName().toLowerCase())).getReturnedTrueOrFalse(this.MyParent.dataOut)) {
                Object[] objectArray = new Object[]{this.mySecDomPanel.getFullyQualifiedDomainName().toLowerCase()};
                new msgBox(this.resources, this.resources.getString("APP_TITLE"), MessageFormat.format(this.resources.getString("MSG_TEXT"), objectArray), 1, false, this.mySecDomPanel);
                this.mySecDomPanel.setEnabled(true);
                this.mySecDomPanel.setEnabledButtons(true);
                return false;
            }
            this.SecDom.setDomName(this.mySecDomPanel.getFullyQualifiedDomainName().toLowerCase());
            this.SecDom.setNotify(this.mySecDomPanel.getNotify());
            if (this.SecDom.getNotify()) {
                this.SecDom.setNotifySetforDomain(this.mySecDomPanel.getNotifyServerList());
            } else {
                this.SecDom.setNotifySetforDomain(null);
            }
            this.SecDom.setNotifyRetryTime(this.mySecDomPanel.getNotifyRetryTime());
            this.SecDom.setNotifyRetryNum(this.mySecDomPanel.getNotifyNumRetries());
            this.SecDom.setNotifyDelayTime(this.mySecDomPanel.getNotifyDelayTime());
            this.SecDom.setDataFileName(this.mySecDomPanel.getDomainFileName());
            this.SecDom.setMasterServersforDomain(this.mySecDomPanel.getMasterServerList());
        }
        return true;
    }

    public void SaveAndExit(Object object) {
        if (object instanceof PrimaryDomainFrame) {
            this.myPriDomPanel.setEnabled(false);
            this.myPriDomPanel.setEnabledButtons(false);
            if (this.SaveAllData()) {
                if (this.NewDomainObject) {
                    this.MyParent.dataOut.sendToServer(this.PriDom.toString("ADD"));
                    this.MyParent.dataOut.receiveFromServer();
                    this.MyParent.dataOut.sendToServer(this.PriDom.toString("LNK", "NameServ=" + this.NameServ.firstName()));
                    this.MyParent.dataOut.receiveFromServer();
                    if (!this.PriDom.getDomName().endsWith("in-addr.arpa")) {
                        AliasHostObject aliasHostObject = new AliasHostObject("ns-updates", this.NameServ.firstName());
                        this.MyParent.dataOut.sendToServer(aliasHostObject.toString("ADD", "dname=" + this.PriDom.getDomName()));
                        this.MyParent.dataOut.receiveFromServer();
                        this.MyParent.dataOut.sendToServer(aliasHostObject.toString("LNK", "dname=" + this.PriDom.getDomName()));
                        this.MyParent.dataOut.receiveFromServer();
                    }
                } else {
                    this.MyParent.dataOut.sendToServer(this.PriDom.toString("MOD"));
                    this.MyParent.dataOut.receiveFromServer();
                }
                if (this.genKeyList != null && !this.PriDom.getDomName().endsWith("in-addr.arpa") && this.genKeyList.length > 0 && this.myPriDomPanel.getDomainType() == 1) {
                    this.sendHostForKeys(this.PriDom.getDomName());
                }
                if (!this.haveFailures) {
                    this.completePrimaryExit();
                    return;
                }
                this.MyParent.dataOut.sendToServer(this.PriDom.toString("MOD"));
                this.MyParent.dataOut.receiveFromServer();
                return;
            }
        } else {
            if (object instanceof DynamicOptionsFrame) {
                this.dynOptsFrame.setEnabled(false);
                this.DynOpts.SetShouldBackupData(this.dynOptsFrame.getBackupState());
                this.DynOpts.SetDeleteSig(this.dynOptsFrame.getExpireTimeState());
                this.DynOpts.SetDeleteTime(this.dynOptsFrame.getExpireTime());
                if (this.dynOptsFrame.getSecurityMode() == 1) {
                    this.DynOpts.SetPresecured(true);
                    this.genKeyList = this.dynOptsFrame.getGenKeyList();
                    this.genKeyFileDirectory = this.dynOptsFrame.getDirectory();
                } else {
                    this.DynOpts.SetPresecured(false);
                    this.genKeyList = null;
                    this.genKeyFileDirectory = null;
                }
                this.DynOpts.SetSendKeysToSec(this.dynOptsFrame.getSendKeyState());
                this.DynOpts.SetTimeSync(this.dynOptsFrame.getTimeSyncState());
                this.DynOpts.SetForwardTime(this.dynOptsFrame.getForwardTimeState());
                this.DynOpts.SetOverrideTTL(this.dynOptsFrame.getOverrideTTLState());
                this.DynOpts.SetOverrideVal(this.dynOptsFrame.getOverrideTTL());
                this.dynOptsFrame.dispose();
                this.myPriDomPanel.setEnabled(true);
                this.myPriDomPanel.setEnabledButtons(true);
                this.myPriDomPanel.requestFocus();
                return;
            }
            if (object instanceof SecondaryDomainFrame) {
                this.mySecDomPanel.setEnabled(false);
                this.mySecDomPanel.setEnabledButtons(false);
                if (this.SaveAllData()) {
                    if (this.NewDomainObject) {
                        this.MyParent.dataOut.sendToServer(this.SecDom.toString("ADD"));
                        this.MyParent.dataOut.receiveFromServer();
                        this.MyParent.dataOut.sendToServer(this.SecDom.toString("LNK", "NameServ=" + this.NameServ.firstName()));
                        this.MyParent.dataOut.receiveFromServer();
                    } else {
                        this.MyParent.dataOut.sendToServer(this.SecDom.toString("MOD"));
                        this.MyParent.dataOut.receiveFromServer();
                    }
                    ((Component)this.mySecDomPanel).setVisible(false);
                    this.MyParent.changed(this, this.SecDom.getDomName());
                    this.MyParent.requestFocus();
                }
            }
        }
    }

    public void completePrimaryExit() {
        ((Component)this.myPriDomPanel).setVisible(false);
        if (this.isDynamic != this.PriDom.isDynamic()) {
            this.MyParent.changed((Object)this, this.PriDom.getDomName(), true);
        } else {
            this.MyParent.changed((Object)this, this.PriDom.getDomName(), false);
        }
        this.MyParent.requestFocus();
    }

    public void doneWithFailures(boolean bl) {
        if (bl) {
            this.haveFailures = false;
            this.NewDomainObject = false;
            this.myPriDomPanel.setEnabled(true);
            this.myPriDomPanel.setEnabledButtons(true);
            this.myPriDomPanel.setFullyQualifiedDomainName(this.myPriDomPanel.getFullyQualifiedDomainName());
            ((Component)this.myPriDomPanel).setVisible(true);
            this.myPriDomPanel.requestFocus();
            return;
        }
        this.completePrimaryExit();
    }

    public void CancelAndExit(Object object) {
        if (object instanceof PrimaryDomainFrame) {
            this.myPriDomPanel.setEnabled(false);
            this.myPriDomPanel.setEnabledButtons(false);
            this.DynOpts = null;
            ((Component)this.myPriDomPanel).setVisible(false);
            this.MyParent.changed(this);
            this.MyParent.requestFocus();
            return;
        }
        if (object instanceof DynamicOptionsFrame) {
            this.myPriDomPanel.setEnabled(true);
            this.dynOptsFrame.dispose();
            this.myPriDomPanel.requestFocus();
            this.myPriDomPanel.setEnabledButtons(true);
            return;
        }
        if (object instanceof SecondaryDomainFrame) {
            this.mySecDomPanel.setEnabled(false);
            this.mySecDomPanel.setEnabledButtons(false);
            ((Component)this.mySecDomPanel).setVisible(false);
            this.MyParent.changed(this);
            this.MyParent.requestFocus();
        }
    }

    public void setNotifyList() {
        Vector<String> vector = new Vector<String>();
        NameAndIpAddressList nameAndIpAddressList = this.myPriDomPanel.getNameServerList();
        if (nameAndIpAddressList != null) {
            Enumeration enumeration = nameAndIpAddressList.elements();
            while (enumeration.hasMoreElements()) {
                String string = ((NameAndIpAddress)enumeration.nextElement()).getIpAddress();
                if (string.equals("-")) continue;
                vector.addElement(string);
            }
            if (!vector.isEmpty()) {
                Object[] objectArray = new String[vector.size()];
                vector.copyInto(objectArray);
                this.myPriDomPanel.setNotifyServerList((String[])objectArray);
            }
        }
    }

    private void sendHostForKeys(String string) {
        this.PriDom.removeHostKeys();
        BusyWaitFrame busyWaitFrame = new BusyWaitFrame(this.resources, this.resources.getString("DOM_WAIT_MESSAGE"));
        ((Component)busyWaitFrame).setSize(300, 75);
        busyWaitFrame.doLayout();
        ((Component)busyWaitFrame).setVisible(true);
        StringBuffer stringBuffer = new StringBuffer("PDOM=GENKEY,dir=" + this.genKeyFileDirectory + "," + "name=" + string + ",");
        int n = 0;
        while (n < this.genKeyList.length) {
            stringBuffer.append("host=" + this.genKeyList[n] + ",");
            ++n;
        }
        stringBuffer.append("EPDOM,");
        this.MyParent.dataOut.sendToServer(stringBuffer.toString());
        DDNSNetworkStringParser dDNSNetworkStringParser = this.MyParent.dataOut.receiveFromServer();
        ParsedVector parsedVector = dDNSNetworkStringParser.getParsed();
        if (!this.PriDom.getReturnCode(dDNSNetworkStringParser.getReturnCode())) {
            this.genKeyList = this.PriDom.getReturnedList(parsedVector);
            GenerateKeyFailed generateKeyFailed = new GenerateKeyFailed(this, this.PriDom.getDomName(), this.NameServ.firstName(), this.genKeyList);
            generateKeyFailed.getMinSize();
            ((Component)generateKeyFailed).setVisible(true);
            generateKeyFailed.requestFocus();
            this.haveFailures = true;
        } else {
            this.PriDom.removeHostKeys();
            this.haveFailures = false;
            this.MyParent.dataOut.sendToServer(this.PriDom.toString("MOD"));
            this.MyParent.dataOut.receiveFromServer();
        }
        busyWaitFrame.dispose();
    }
}

