/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.ddnssgui.client;

import COM.ibm.raleigh.ddnssgui.client.AddHostFrame;
import COM.ibm.raleigh.ddnssgui.common.DomainNameAndIpAddress;
import COM.ibm.raleigh.ddnssgui.common.DomainNameAndIpAddressList;
import COM.ibm.raleigh.ddnssgui.common.ListPanel;
import COM.ibm.raleigh.ddnssgui.common.ListPanelGrid;
import COM.ibm.raleigh.ddnssgui.common.ListPanelUser;
import COM.ibm.raleigh.ddnssgui.common.TcpipValidation;
import COM.ibm.raleigh.ddnssgui.common.msgBox;
import java.awt.Button;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.util.ResourceBundle;
import java.util.StringTokenizer;

public class DomainNameAndIPListPanel
extends ListPanel {
    private static final String cStmt1 = "(c) Copyright IBM Corp 1997. All rights reserved.\n";
    public static final int NOT_FOUND = -1;
    public static final int CHECK_ALL = 0;
    public static final int NO_ADDRESS_CHECK = 1;
    private static final String[] labels = new String[]{"", "", ""};
    private static final int THREE_FIELDS = 3;
    private static final int NUM_LABELS = 3;
    public static final int DOMAIN_FIELD = 0;
    public static final int HOST_FIELD = 1;
    public static final int IP_ADDR_FIELD = 2;
    private ListPanelUser parent;
    private ResourceBundle resources;
    private msgBox invalidHostBox;
    private msgBox invalidAddrBox;

    public DomainNameAndIPListPanel(ListPanelUser listPanelUser, ResourceBundle resourceBundle, String string, int n, String string2, ListPanelGrid listPanelGrid, String string3) {
        super((Container)((Object)listPanelUser), resourceBundle, string, labels, n, string2, listPanelGrid, string3);
        this.parent = listPanelUser;
        this.resources = resourceBundle;
        this.setFieldLabels();
        super.setMultipleMode(false);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object instanceof Button) {
            this.handleButton((Button)object);
            this.parent.handleButton((Button)object);
        }
    }

    public DomainNameAndIpAddress getDomainNameAndIP() {
        DomainNameAndIpAddress domainNameAndIpAddress = new DomainNameAndIpAddress(this.getHostName(), this.getIPAddr(), this.getDomainName());
        return domainNameAndIpAddress;
    }

    public void setDomainNameAndIP(DomainNameAndIpAddress domainNameAndIpAddress) {
        this.setHostName(domainNameAndIpAddress.getFqName().toLowerCase());
        this.setIPAddr(domainNameAndIpAddress.getIpAddress());
        this.setDomainName(domainNameAndIpAddress.getDomainName().toLowerCase());
    }

    public DomainNameAndIpAddress getDomainNameAndIP(int n) {
        DomainNameAndIpAddress domainNameAndIpAddress = null;
        String string = null;
        String string2 = null;
        String string3 = null;
        StringTokenizer stringTokenizer = new StringTokenizer(super.getItem(n), super.getTextSeparator());
        string = new String(stringTokenizer.nextToken().toLowerCase());
        string2 = new String(stringTokenizer.nextToken().toLowerCase());
        string3 = stringTokenizer.hasMoreTokens() ? new String(stringTokenizer.nextToken()) : "";
        domainNameAndIpAddress = new DomainNameAndIpAddress(string, string3, string2);
        return domainNameAndIpAddress;
    }

    public DomainNameAndIpAddressList getDomainNameAndIPList() {
        DomainNameAndIpAddressList domainNameAndIpAddressList = null;
        int n = this.getItemCount();
        if (n > 0) {
            domainNameAndIpAddressList = new DomainNameAndIpAddressList();
            String[] stringArray = new String[n];
            stringArray = super.getItemList();
            int n2 = 0;
            while (n2 < n) {
                String string = null;
                String string2 = null;
                String string3 = null;
                StringTokenizer stringTokenizer = new StringTokenizer(stringArray[n2], super.getTextSeparator());
                string = new String(stringTokenizer.nextToken().toLowerCase());
                string3 = new String(stringTokenizer.nextToken().toLowerCase());
                string2 = stringTokenizer.hasMoreTokens() ? new String(stringTokenizer.nextToken()) : "";
                domainNameAndIpAddressList.add(string, string2, string3);
                ++n2;
            }
        } else {
            domainNameAndIpAddressList = null;
        }
        return domainNameAndIpAddressList;
    }

    public void setDomainNameAndIPList(DomainNameAndIpAddressList domainNameAndIpAddressList) {
        DomainNameAndIpAddress domainNameAndIpAddress = null;
        if (domainNameAndIpAddressList != null && !domainNameAndIpAddressList.isEmpty()) {
            int n = 0;
            while (n < domainNameAndIpAddressList.size()) {
                domainNameAndIpAddress = domainNameAndIpAddressList.get(n);
                super.addItem(domainNameAndIpAddress.getNameDomainAndIpAddr(super.getTextSeparator()));
                ++n;
            }
        }
    }

    public void addToDomainNameAndIPList(DomainNameAndIpAddress domainNameAndIpAddress) {
        super.addItem(domainNameAndIpAddress.getNameDomainAndIpAddr(super.getTextSeparator()));
        this.setDomainName("");
        this.setHostName("");
        this.setIPAddr("");
    }

    public void replaceHostInList(DomainNameAndIpAddress domainNameAndIpAddress) {
        int n = this.getHostListIndex(domainNameAndIpAddress);
        super.replaceItem(domainNameAndIpAddress.getNameDomainAndIpAddr(super.getTextSeparator()), n);
    }

    public boolean isHostNameEmpty() {
        return super.isTextFieldEmpty(1);
    }

    public boolean isDomainNameEmpty() {
        return super.isTextFieldEmpty(0);
    }

    public boolean isIPAddressEmpty() {
        return super.isTextFieldEmpty(2);
    }

    public int getHostListIndex(DomainNameAndIpAddress domainNameAndIpAddress) {
        int n = -1;
        if (domainNameAndIpAddress != null) {
            String string = domainNameAndIpAddress.getFqName().toLowerCase();
            String string2 = domainNameAndIpAddress.getDomainName().toLowerCase();
            int n2 = 0;
            DomainNameAndIpAddressList domainNameAndIpAddressList = this.getDomainNameAndIPList();
            if (domainNameAndIpAddressList != null) {
                n2 = domainNameAndIpAddressList.size();
            }
            int n3 = 0;
            while (n3 < n2 && n == -1) {
                if (domainNameAndIpAddressList.get(n3).getDomainName().toLowerCase().compareTo(string2) == 0 && domainNameAndIpAddressList.get(n3).getFqName().toLowerCase().compareTo(string) == 0) {
                    n = n3;
                }
                ++n3;
            }
        }
        return n;
    }

    public boolean isInList(DomainNameAndIpAddress domainNameAndIpAddress, int n) {
        boolean bl = false;
        if (domainNameAndIpAddress != null) {
            int n2 = 0;
            DomainNameAndIpAddressList domainNameAndIpAddressList = this.getDomainNameAndIPList();
            String string = domainNameAndIpAddress.getFqName().toLowerCase();
            String string2 = domainNameAndIpAddress.getDomainName().toLowerCase();
            if (domainNameAndIpAddressList != null) {
                n2 = domainNameAndIpAddressList.size();
            }
            int n3 = 0;
            while (n3 < n2 && !bl) {
                if (n == 0) {
                    if (domainNameAndIpAddressList.get(n3).equals(domainNameAndIpAddress)) {
                        bl = true;
                    }
                } else if (n == 1 && domainNameAndIpAddressList.get(n3).getDomainName().toLowerCase().compareTo(string2) == 0 && domainNameAndIpAddressList.get(n3).getFqName().toLowerCase().compareTo(string) == 0) {
                    bl = true;
                }
                ++n3;
            }
        }
        return bl;
    }

    public boolean validateFields(String string, String string2) {
        boolean bl = true;
        if (!TcpipValidation.IsValidFQTcpipName(string)) {
            this.invalidHostBox = new msgBox(this.resources, this.resources.getString("APP_TITLE"), this.resources.getString("INVALID_HOST_NAME_TEXT"), 1, true);
            this.selectAll(1);
            this.requestFocus(1);
            bl = false;
        } else if (!TcpipValidation.IsValidTcpipAddr(string2)) {
            this.invalidAddrBox = new msgBox(this.resources, this.resources.getString("APP_TITLE"), this.resources.getString("INVALID_IP_ADDR_TEXT"), 1, true);
            this.selectAll(2);
            this.requestFocus(2);
            bl = false;
        }
        return bl;
    }

    private void handleButton(Button button) {
        if (button == super.getAddButton()) {
            this.handleAdd();
            return;
        }
        if (button == super.getRemoveButton()) {
            super.handleRemove();
        }
    }

    protected void handleAdd() {
        boolean bl = true;
        boolean bl2 = true;
        boolean bl3 = true;
        String string = new String(this.getHostName().toLowerCase());
        String string2 = new String(this.getIPAddr());
        String string3 = null;
        bl = this.validateFields(string, string2);
        if (this.parent instanceof AddHostFrame) {
            this.setDomainName(((AddHostFrame)this.parent).getFullyQualifiedDomainName().toLowerCase());
            string3 = new String(this.getDomainName());
            bl3 = ((AddHostFrame)this.parent).isUniqueHostInDomain(string, string3);
        }
        if (bl3) {
            bl2 = this.isDuplicateHost(string, string3);
            if (!bl2) {
                if (bl) {
                    String[] stringArray = new String[]{new String(string), new String(string3), new String(string2)};
                    super.handleAdd(stringArray);
                    return;
                }
            } else {
                this.invalidHostBox = new msgBox(this.resources, this.resources.getString("APP_TITLE"), this.resources.getString("DUPLICATE_HOST_NAME_TEXT"), 1, true);
                this.selectAll(1);
                this.requestFocus(1);
            }
        }
    }

    private String getHostName() {
        return this.getTextField(1).toLowerCase();
    }

    private void setHostName(String string) {
        this.setTextField(1, string.toLowerCase());
    }

    private String getIPAddr() {
        return this.getTextField(2);
    }

    private void setIPAddr(String string) {
        this.setTextField(2, string);
    }

    private String getDomainName() {
        return this.getTextField(0).toLowerCase();
    }

    public void setDomainName(String string) {
        this.setTextField(0, string.toLowerCase());
    }

    private boolean isDuplicateHost(String string, String string2) {
        boolean bl = false;
        DomainNameAndIpAddressList domainNameAndIpAddressList = this.getDomainNameAndIPList();
        DomainNameAndIpAddress domainNameAndIpAddress = null;
        if (domainNameAndIpAddressList != null) {
            int n = 0;
            while (n < domainNameAndIpAddressList.size() && !bl) {
                domainNameAndIpAddress = domainNameAndIpAddressList.get(n);
                if (domainNameAndIpAddress != null && domainNameAndIpAddress.getFqName().toLowerCase().compareTo(string) == 0 && domainNameAndIpAddress.getDomainName().toLowerCase().compareTo(string2) == 0) {
                    bl = true;
                }
                ++n;
            }
        }
        return bl;
    }

    private void setFieldLabels() {
        String[] stringArray = new String[]{new String(this.resources.getString("DOMAIN_LABEL")), new String(this.resources.getString("NAME_FIELD_LABEL")), new String(this.resources.getString("IP_ADDRESS_FIELD_LABEL"))};
        super.setFieldLabels(stringArray);
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        Object object = keyEvent.getSource();
        if (keyEvent.getKeyCode() == 10 && object instanceof Button) {
            this.handleButton((Button)object);
            this.parent.handleButton((Button)object);
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }
}

