/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.ddnssgui.client;

import COM.ibm.raleigh.ddnssgui.client.PrimaryDomainFrame;
import COM.ibm.raleigh.ddnssgui.common.DDNSUtility;
import COM.ibm.raleigh.ddnssgui.common.WrappedTextPanel;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.ItemSelectable;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ResourceBundle;

class DomainCfgPanel
extends Panel
implements ActionListener,
ItemListener,
KeyListener {
    public static final String cStmt1 = "Licensed Materials - Property of IBM \n IBM TCP/IP for OS/2 \n (c) Copyright IBM Corp 1997. All rights reserved.\n";
    public static final String cStmt2 = "US Government Users Restricted Rights - Use, Duplication or\n disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String appVersion = "Dynamic IP Version 1.0";
    public static final String modVersion = "This Class Version 1.0";
    public static final int DYNAMIC = 1;
    public static final int STATIC = 2;
    public static final int FIRST_FIELD = 0;
    public static final int DOMAIN_NAME_FIELD = 0;
    private static final int NUM_TEXT_COLUMNS = 20;
    private PrimaryDomainFrame parent;
    private ResourceBundle resources;
    private WrappedTextPanel textPanel;
    private Label domainNameLabel;
    private TextField fullyQualifiedDomainName;
    private Label domainTypeLabel;
    private int domainType = 2;
    private CheckboxGroup cbg;
    private Checkbox dynamicBox;
    private Checkbox staticBox;
    private Button dynamicOptionsButton;
    private Label mailLabel;
    private TextField mail;

    public DomainCfgPanel(PrimaryDomainFrame primaryDomainFrame, ResourceBundle resourceBundle) {
        this.parent = primaryDomainFrame;
        this.resources = resourceBundle;
        this.setBackground(DDNSUtility.BACKGROUND_COLOR);
        this.initComponents();
        this.addComponentsToGrid();
    }

    public Insets getInsets() {
        return new Insets(3, 3, 3, 3);
    }

    public void requestFocus(int n) {
        switch (n) {
            case 0: {
                this.fullyQualifiedDomainName.requestFocus();
                return;
            }
        }
    }

    public void selectAll(int n) {
        switch (n) {
            case 0: {
                if (!this.fullyQualifiedDomainName.isEnabled()) break;
                this.fullyQualifiedDomainName.selectAll();
                return;
            }
        }
    }

    public String getFullyQualifiedDomainName() {
        return this.fullyQualifiedDomainName.getText().trim();
    }

    public void setFullyQualifiedDomainName(String string) {
        if (string != null) {
            ((TextComponent)this.fullyQualifiedDomainName).setText(string.trim());
            if (string.trim().compareTo("") != 0) {
                this.setEnabledDomainName(false);
                return;
            }
            this.setEnabledDomainName(true);
        }
    }

    public void setEnabledDomainName(boolean bl) {
        this.domainNameLabel.setEnabled(bl);
        this.fullyQualifiedDomainName.setEnabled(bl);
        if (bl) {
            ((Component)this.fullyQualifiedDomainName).setBackground(DDNSUtility.TEXT_FIELD_ENABLE_COLOR);
            return;
        }
        ((Component)this.fullyQualifiedDomainName).setBackground(DDNSUtility.TEXT_FIELD_DISABLE_COLOR);
    }

    public int getDomainType() {
        Checkbox checkbox = this.cbg.getSelectedCheckbox();
        this.domainType = checkbox == this.dynamicBox ? 1 : 2;
        return this.domainType;
    }

    public void setDomainType(int n) {
        this.domainType = n;
        if (this.domainType == 1) {
            this.cbg.setSelectedCheckbox(this.dynamicBox);
            this.dynamicOptionsButton.setEnabled(true);
            this.parent.handleDomainType();
            return;
        }
        this.cbg.setSelectedCheckbox(this.staticBox);
        this.dynamicOptionsButton.setEnabled(false);
        this.parent.handleDomainType();
    }

    public String getAdminMailAddress() {
        String string = this.mail.getText().trim();
        return string.replace('@', '.');
    }

    public void setAdminMailAddress(String string) {
        if (string != null) {
            ((TextComponent)this.mail).setText(string.trim());
        }
    }

    public Button getDynamicOptionsButton() {
        return this.dynamicOptionsButton;
    }

    private void add(Component component, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagLayout.setConstraints(component, gridBagConstraints);
        this.add(component);
    }

    private void initComponents() {
        this.textPanel = new WrappedTextPanel(this.resources.getString("DOMAIN_CONFIGURATION_TEXT"));
        this.domainNameLabel = new Label(this.resources.getString("DOMAIN_LABEL"), 0);
        this.fullyQualifiedDomainName = new TextField("", 20);
        this.domainTypeLabel = new Label(this.resources.getString("DOMAIN_TYPE_LABEL"), 0);
        this.domainType = 2;
        this.cbg = new CheckboxGroup();
        this.staticBox = new Checkbox(this.resources.getString("STATIC_LABEL"), this.cbg, true);
        this.staticBox.addItemListener(this);
        this.staticBox.addKeyListener(this);
        this.dynamicBox = new Checkbox(this.resources.getString("DYNAMIC_LABEL"), this.cbg, false);
        this.dynamicBox.addItemListener(this);
        this.dynamicBox.addKeyListener(this);
        this.dynamicOptionsButton = new Button(this.resources.getString("DYNAMIC_OPTIONS_LABEL"));
        this.dynamicOptionsButton.addActionListener(this);
        this.dynamicOptionsButton.addKeyListener(this);
        this.dynamicOptionsButton.setEnabled(false);
        this.mailLabel = new Label(this.resources.getString("ADMIN_E_MAIL_LABEL"), 0);
        this.mail = new TextField("", 20);
    }

    private void addComponentsToGrid() {
        int n = this.textPanel.getNumDividedTextLines();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        this.add(this.textPanel, gridBagLayout, gridBagConstraints, 0, 0, 2, n);
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        gridBagConstraints.fill = 0;
        this.add(this.domainNameLabel, gridBagLayout, gridBagConstraints, 0, 1 + n, 1, 1);
        gridBagConstraints.fill = 2;
        this.add(this.fullyQualifiedDomainName, gridBagLayout, gridBagConstraints, 1, 1 + n, 0, 1);
        gridBagConstraints.fill = 0;
        this.add(this.domainTypeLabel, gridBagLayout, gridBagConstraints, 0, 2 + n, 0, 1);
        gridBagConstraints.insets = new Insets(0, 50, 0, 0);
        this.add(this.staticBox, gridBagLayout, gridBagConstraints, 0, 3 + n, 0, 1);
        this.add(this.dynamicBox, gridBagLayout, gridBagConstraints, 0, 4 + n, 1, 1);
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add(this.dynamicOptionsButton, gridBagLayout, gridBagConstraints, 1, 4 + n, 0, 1);
        this.add(this.mailLabel, gridBagLayout, gridBagConstraints, 0, 5 + n, 1, 1);
        gridBagConstraints.fill = 2;
        this.add(this.mail, gridBagLayout, gridBagConstraints, 1, 5 + n, 0, 1);
    }

    private void handleCheckbox(Checkbox checkbox) {
        boolean bl = checkbox.getState();
        if (checkbox == this.dynamicBox && bl) {
            this.dynamicOptionsButton.setEnabled(true);
            this.domainType = 1;
            this.parent.handleDomainType();
            return;
        }
        if (checkbox == this.staticBox && bl) {
            this.dynamicOptionsButton.setEnabled(false);
            this.domainType = 2;
            this.parent.handleDomainType();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.dynamicOptionsButton) {
            this.parent.handleButton((Button)object);
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        ItemSelectable itemSelectable = itemEvent.getItemSelectable();
        if (itemSelectable instanceof Checkbox) {
            this.handleCheckbox((Checkbox)itemSelectable);
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        Object object = keyEvent.getSource();
        if (keyEvent.getKeyCode() == 10) {
            if (object == this.dynamicOptionsButton) {
                this.parent.handleButton((Button)object);
                return;
            }
            if (object instanceof Checkbox) {
                Checkbox checkbox;
                checkbox.setState(!(checkbox = (Checkbox)object).getState());
                this.handleCheckbox(checkbox);
            }
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }
}

